/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.serde;

import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.utils.serde.AbstractKafkaSerDe;
import io.apicurio.registry.utils.serde.SchemaCache;
import java.nio.ByteBuffer;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public abstract class AbstractKafkaDeserializer<T, U, S extends AbstractKafkaDeserializer<T, U, S>>
extends AbstractKafkaSerDe<S>
implements Deserializer<U> {
    private SchemaCache<T> cache;

    public AbstractKafkaDeserializer() {
    }

    public AbstractKafkaDeserializer(RegistryService client) {
        super(client);
    }

    private synchronized SchemaCache<T> getCache() {
        if (this.cache == null) {
            this.cache = new SchemaCache<T>(this.getClient()){

                @Override
                protected T toSchema(Response artifactResponse) {
                    return AbstractKafkaDeserializer.this.toSchema(artifactResponse);
                }
            };
        }
        return this.cache;
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        super.configure(configs, isKey);
    }

    @Override
    public void reset() {
        this.getCache().clear();
        super.reset();
    }

    protected abstract T toSchema(Response var1);

    protected abstract U readData(T var1, ByteBuffer var2, int var3, int var4);

    protected abstract U readData(Headers var1, T var2, ByteBuffer var3, int var4, int var5);

    public U deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        ByteBuffer buffer = AbstractKafkaDeserializer.getByteBuffer(data);
        long id = this.getIdHandler().readId(buffer);
        T schema = this.getCache().getSchema(id);
        int length = buffer.limit() - 1 - this.getIdHandler().idSize();
        int start = buffer.position() + buffer.arrayOffset();
        return this.readData(schema, buffer, start, length);
    }

    public U deserialize(String topic, Headers headers, byte[] data) {
        if (data == null) {
            return null;
        }
        if (data[0] == 0) {
            return this.deserialize(topic, data);
        }
        Long id = this.headerUtils.getGlobalId(headers);
        if (id == null) {
            String artifactId = this.headerUtils.getArtifactId(headers);
            Integer version = this.headerUtils.getVersion(headers);
            id = this.toGlobalId(artifactId, version);
        }
        T schema = this.getCache().getSchema(id);
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int length = buffer.limit();
        int start = buffer.position();
        return this.readData(headers, schema, buffer, start, length);
    }
}

