/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.StringValue;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class StringUtils {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String byteToHexString(byte[] bytes, int start, int end) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes == null");
        }
        int length = end - start;
        char[] out = new char[length * 2];
        int j = 0;
        for (int i = start; i < end; ++i) {
            out[j++] = HEX_CHARS[(0xF0 & bytes[i]) >>> 4];
            out[j++] = HEX_CHARS[0xF & bytes[i]];
        }
        return new String(out);
    }

    public static String byteToHexString(byte[] bytes) {
        return StringUtils.byteToHexString(bytes, 0, bytes.length);
    }

    public static byte[] hexStringToByte(String hex) {
        byte[] bts = new byte[hex.length() / 2];
        for (int i = 0; i < bts.length; ++i) {
            bts[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return bts;
    }

    public static String arrayAwareToString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o.getClass().isArray()) {
            return StringUtils.arrayToString(o);
        }
        return o.toString();
    }

    public static String arrayToString(Object array) {
        if (array == null) {
            throw new NullPointerException();
        }
        if (array instanceof int[]) {
            return Arrays.toString((int[])array);
        }
        if (array instanceof long[]) {
            return Arrays.toString((long[])array);
        }
        if (array instanceof Object[]) {
            return Arrays.toString((Object[])array);
        }
        if (array instanceof byte[]) {
            return Arrays.toString((byte[])array);
        }
        if (array instanceof double[]) {
            return Arrays.toString((double[])array);
        }
        if (array instanceof float[]) {
            return Arrays.toString((float[])array);
        }
        if (array instanceof boolean[]) {
            return Arrays.toString((boolean[])array);
        }
        if (array instanceof char[]) {
            return Arrays.toString((char[])array);
        }
        if (array instanceof short[]) {
            return Arrays.toString((short[])array);
        }
        if (array.getClass().isArray()) {
            return "<unknown array type>";
        }
        throw new IllegalArgumentException("The given argument is no array.");
    }

    public static String showControlCharacters(String str) {
        int len = str.length();
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\b': {
                    sb.append("\\b");
                    continue block7;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block7;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block7;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block7;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String getRandomString(Random rnd, int minLength, int maxLength) {
        int len = rnd.nextInt(maxLength - minLength + 1) + minLength;
        char[] data = new char[len];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (char)(rnd.nextInt(Short.MAX_VALUE) + 1);
        }
        return new String(data);
    }

    public static String getRandomString(Random rnd, int minLength, int maxLength, char minValue, char maxValue) {
        int len = rnd.nextInt(maxLength - minLength + 1) + minLength;
        char[] data = new char[len];
        int diff = maxValue - minValue + 1;
        for (int i = 0; i < data.length; ++i) {
            data[i] = (char)(rnd.nextInt(diff) + minValue);
        }
        return new String(data);
    }

    public static String generateRandomAlphanumericString(Random rnd, int length) {
        Preconditions.checkNotNull(rnd);
        Preconditions.checkArgument(length >= 0);
        StringBuilder buffer = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            buffer.append(StringUtils.nextAlphanumericChar(rnd));
        }
        return buffer.toString();
    }

    private static char nextAlphanumericChar(Random rnd) {
        int which = rnd.nextInt(62);
        char c = which < 10 ? (char)(48 + which) : (which < 36 ? (char)(55 + which) : (char)(61 + which));
        return c;
    }

    public static void writeString(@Nonnull String str, DataOutputView out) throws IOException {
        Preconditions.checkNotNull(str);
        StringValue.writeString(str, out);
    }

    public static String readString(DataInputView in) throws IOException {
        return StringValue.readString(in);
    }

    public static void writeNullableString(@Nullable String str, DataOutputView out) throws IOException {
        if (str != null) {
            out.writeBoolean(true);
            StringUtils.writeString(str, out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Nullable
    public static String readNullableString(DataInputView in) throws IOException {
        if (in.readBoolean()) {
            return StringUtils.readString(in);
        }
        return null;
    }

    public static boolean isNullOrWhitespaceOnly(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static String concatenateWithAnd(@Nullable String s1, @Nullable String s2) {
        if (s1 != null) {
            return s2 == null ? s1 : s1 + " and " + s2;
        }
        return s2;
    }

    public static String toQuotedListString(Object[] values) {
        return Arrays.stream(values).filter(Objects::nonNull).map(v -> v.toString().toLowerCase()).collect(Collectors.joining(", ", "\"", "\""));
    }

    private StringUtils() {
    }
}

