/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.io.VersionedIOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public abstract class PostVersionedIOReadableWritable
extends VersionedIOReadableWritable {
    private static final byte[] VERSIONED_IDENTIFIER = new byte[]{-15, -51, -123, -97};

    protected abstract void read(DataInputView var1, boolean var2) throws IOException;

    @Override
    public void write(DataOutputView out) throws IOException {
        out.write(VERSIONED_IDENTIFIER);
        super.write(out);
    }

    public final void read(InputStream inputStream) throws IOException {
        byte[] tmp = new byte[VERSIONED_IDENTIFIER.length];
        inputStream.read(tmp);
        if (Arrays.equals(tmp, VERSIONED_IDENTIFIER)) {
            DataInputViewStreamWrapper inputView = new DataInputViewStreamWrapper(inputStream);
            super.read(inputView);
            this.read(inputView, true);
        } else {
            PushbackInputStream resetStream = new PushbackInputStream(inputStream, VERSIONED_IDENTIFIER.length);
            resetStream.unread(tmp);
            this.read(new DataInputViewStreamWrapper(resetStream), false);
        }
    }

    @Override
    public final void read(DataInputView in) throws IOException {
        throw new UnsupportedOperationException("PostVersionedIOReadableWritable cannot read from a DataInputView.");
    }
}

