/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import com.esotericsoftware.kryo.Serializer;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.Archiveable;
import org.apache.flink.api.common.ArchivedExecutionConfig;
import org.apache.flink.api.common.CodeAnalysisMode;
import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.api.common.InputDependencyConstraint;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.util.Preconditions;

@Public
public class ExecutionConfig
implements Serializable,
Archiveable<ArchivedExecutionConfig> {
    private static final long serialVersionUID = 1L;
    @Deprecated
    public static final int PARALLELISM_AUTO_MAX = Integer.MAX_VALUE;
    public static final int PARALLELISM_DEFAULT = -1;
    public static final int PARALLELISM_UNKNOWN = -2;
    private static final long DEFAULT_RESTART_DELAY = 10000L;
    private ExecutionMode executionMode = ExecutionMode.PIPELINED;
    private ClosureCleanerLevel closureCleanerLevel = ClosureCleanerLevel.RECURSIVE;
    private int parallelism = CoreOptions.DEFAULT_PARALLELISM.defaultValue();
    private int maxParallelism = -1;
    @Deprecated
    private int numberOfExecutionRetries = -1;
    private boolean forceKryo = false;
    private boolean disableGenericTypes = false;
    private boolean enableAutoGeneratedUids = true;
    private boolean objectReuse = false;
    private boolean autoTypeRegistrationEnabled = true;
    private boolean forceAvro = false;
    private CodeAnalysisMode codeAnalysisMode = CodeAnalysisMode.DISABLE;
    private long autoWatermarkInterval = 0L;
    private long latencyTrackingInterval = MetricOptions.LATENCY_INTERVAL.defaultValue();
    private boolean isLatencyTrackingConfigured = false;
    @Deprecated
    private long executionRetryDelay = 10000L;
    private RestartStrategies.RestartStrategyConfiguration restartStrategyConfiguration = new RestartStrategies.FallbackRestartStrategyConfiguration();
    private long taskCancellationIntervalMillis = -1L;
    private long taskCancellationTimeoutMillis = -1L;
    private boolean useSnapshotCompression = false;
    @Deprecated
    private boolean failTaskOnCheckpointError = true;
    private InputDependencyConstraint defaultInputDependencyConstraint = InputDependencyConstraint.ANY;
    private GlobalJobParameters globalJobParameters = new GlobalJobParameters();
    private LinkedHashMap<Class<?>, SerializableSerializer<?>> registeredTypesWithKryoSerializers = new LinkedHashMap();
    private LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> registeredTypesWithKryoSerializerClasses = new LinkedHashMap();
    private LinkedHashMap<Class<?>, SerializableSerializer<?>> defaultKryoSerializers = new LinkedHashMap();
    private LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> defaultKryoSerializerClasses = new LinkedHashMap();
    private LinkedHashSet<Class<?>> registeredKryoTypes = new LinkedHashSet();
    private LinkedHashSet<Class<?>> registeredPojoTypes = new LinkedHashSet();

    public ExecutionConfig enableClosureCleaner() {
        this.closureCleanerLevel = ClosureCleanerLevel.RECURSIVE;
        return this;
    }

    public ExecutionConfig disableClosureCleaner() {
        this.closureCleanerLevel = ClosureCleanerLevel.NONE;
        return this;
    }

    public boolean isClosureCleanerEnabled() {
        return this.closureCleanerLevel != ClosureCleanerLevel.NONE;
    }

    public ExecutionConfig setClosureCleanerLevel(ClosureCleanerLevel level) {
        this.closureCleanerLevel = level;
        return this;
    }

    public ClosureCleanerLevel getClosureCleanerLevel() {
        return this.closureCleanerLevel;
    }

    @PublicEvolving
    public ExecutionConfig setAutoWatermarkInterval(long interval) {
        Preconditions.checkArgument(interval >= 0L, "Auto watermark interval must not be negative.");
        this.autoWatermarkInterval = interval;
        return this;
    }

    @PublicEvolving
    public long getAutoWatermarkInterval() {
        return this.autoWatermarkInterval;
    }

    @PublicEvolving
    public ExecutionConfig setLatencyTrackingInterval(long interval) {
        this.latencyTrackingInterval = interval;
        this.isLatencyTrackingConfigured = true;
        return this;
    }

    @PublicEvolving
    public long getLatencyTrackingInterval() {
        return this.latencyTrackingInterval;
    }

    @Deprecated
    @PublicEvolving
    public boolean isLatencyTrackingEnabled() {
        return this.isLatencyTrackingConfigured && this.latencyTrackingInterval > 0L;
    }

    @Internal
    public boolean isLatencyTrackingConfigured() {
        return this.isLatencyTrackingConfigured;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public ExecutionConfig setParallelism(int parallelism) {
        if (parallelism != -2) {
            if (parallelism < 1 && parallelism != -1) {
                throw new IllegalArgumentException("Parallelism must be at least one, or ExecutionConfig.PARALLELISM_DEFAULT (use system default).");
            }
            this.parallelism = parallelism;
        }
        return this;
    }

    @PublicEvolving
    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    @PublicEvolving
    public void setMaxParallelism(int maxParallelism) {
        Preconditions.checkArgument(maxParallelism > 0, "The maximum parallelism must be greater than 0.");
        this.maxParallelism = maxParallelism;
    }

    public long getTaskCancellationInterval() {
        return this.taskCancellationIntervalMillis;
    }

    public ExecutionConfig setTaskCancellationInterval(long interval) {
        this.taskCancellationIntervalMillis = interval;
        return this;
    }

    @PublicEvolving
    public long getTaskCancellationTimeout() {
        return this.taskCancellationTimeoutMillis;
    }

    @PublicEvolving
    public ExecutionConfig setTaskCancellationTimeout(long timeout) {
        Preconditions.checkArgument(timeout >= 0L, "Timeout needs to be >= 0.");
        this.taskCancellationTimeoutMillis = timeout;
        return this;
    }

    @PublicEvolving
    public void setRestartStrategy(RestartStrategies.RestartStrategyConfiguration restartStrategyConfiguration) {
        this.restartStrategyConfiguration = Preconditions.checkNotNull(restartStrategyConfiguration);
    }

    @PublicEvolving
    public RestartStrategies.RestartStrategyConfiguration getRestartStrategy() {
        if (this.restartStrategyConfiguration instanceof RestartStrategies.FallbackRestartStrategyConfiguration) {
            if (this.getNumberOfExecutionRetries() > 0 && this.getExecutionRetryDelay() >= 0L) {
                return RestartStrategies.fixedDelayRestart(this.getNumberOfExecutionRetries(), this.getExecutionRetryDelay());
            }
            if (this.getNumberOfExecutionRetries() == 0) {
                return RestartStrategies.noRestart();
            }
            return this.restartStrategyConfiguration;
        }
        return this.restartStrategyConfiguration;
    }

    @Deprecated
    public int getNumberOfExecutionRetries() {
        return this.numberOfExecutionRetries;
    }

    @Deprecated
    public long getExecutionRetryDelay() {
        return this.executionRetryDelay;
    }

    @Deprecated
    public ExecutionConfig setNumberOfExecutionRetries(int numberOfExecutionRetries) {
        if (numberOfExecutionRetries < -1) {
            throw new IllegalArgumentException("The number of execution retries must be non-negative, or -1 (use system default)");
        }
        this.numberOfExecutionRetries = numberOfExecutionRetries;
        return this;
    }

    @Deprecated
    public ExecutionConfig setExecutionRetryDelay(long executionRetryDelay) {
        if (executionRetryDelay < 0L) {
            throw new IllegalArgumentException("The delay between retries must be non-negative.");
        }
        this.executionRetryDelay = executionRetryDelay;
        return this;
    }

    public void setExecutionMode(ExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    @PublicEvolving
    public void setDefaultInputDependencyConstraint(InputDependencyConstraint inputDependencyConstraint) {
        this.defaultInputDependencyConstraint = inputDependencyConstraint != null ? inputDependencyConstraint : InputDependencyConstraint.ANY;
    }

    @PublicEvolving
    public InputDependencyConstraint getDefaultInputDependencyConstraint() {
        return this.defaultInputDependencyConstraint;
    }

    public void enableForceKryo() {
        this.forceKryo = true;
    }

    public void disableForceKryo() {
        this.forceKryo = false;
    }

    public boolean isForceKryoEnabled() {
        return this.forceKryo;
    }

    public void enableGenericTypes() {
        this.disableGenericTypes = false;
    }

    public void disableGenericTypes() {
        this.disableGenericTypes = true;
    }

    public boolean hasGenericTypesDisabled() {
        return this.disableGenericTypes;
    }

    public void enableAutoGeneratedUIDs() {
        this.enableAutoGeneratedUids = true;
    }

    public void disableAutoGeneratedUIDs() {
        this.enableAutoGeneratedUids = false;
    }

    public boolean hasAutoGeneratedUIDsEnabled() {
        return this.enableAutoGeneratedUids;
    }

    public void enableForceAvro() {
        this.forceAvro = true;
    }

    public void disableForceAvro() {
        this.forceAvro = false;
    }

    public boolean isForceAvroEnabled() {
        return this.forceAvro;
    }

    public ExecutionConfig enableObjectReuse() {
        this.objectReuse = true;
        return this;
    }

    public ExecutionConfig disableObjectReuse() {
        this.objectReuse = false;
        return this;
    }

    public boolean isObjectReuseEnabled() {
        return this.objectReuse;
    }

    @Deprecated
    @PublicEvolving
    public void setCodeAnalysisMode(CodeAnalysisMode codeAnalysisMode) {
    }

    @Deprecated
    @PublicEvolving
    public CodeAnalysisMode getCodeAnalysisMode() {
        return this.codeAnalysisMode;
    }

    @Deprecated
    public ExecutionConfig enableSysoutLogging() {
        return this;
    }

    @Deprecated
    public ExecutionConfig disableSysoutLogging() {
        return this;
    }

    @Deprecated
    public boolean isSysoutLoggingEnabled() {
        return false;
    }

    public GlobalJobParameters getGlobalJobParameters() {
        return this.globalJobParameters;
    }

    public void setGlobalJobParameters(GlobalJobParameters globalJobParameters) {
        Preconditions.checkNotNull(globalJobParameters, "globalJobParameters shouldn't be null");
        this.globalJobParameters = globalJobParameters;
    }

    public <T extends Serializer<?>> void addDefaultKryoSerializer(Class<?> type, T serializer) {
        if (type == null || serializer == null) {
            throw new NullPointerException("Cannot register null class or serializer.");
        }
        this.defaultKryoSerializers.put(type, new SerializableSerializer<T>(serializer));
    }

    public void addDefaultKryoSerializer(Class<?> type, Class<? extends Serializer<?>> serializerClass) {
        if (type == null || serializerClass == null) {
            throw new NullPointerException("Cannot register null class or serializer.");
        }
        this.defaultKryoSerializerClasses.put(type, serializerClass);
    }

    public <T extends Serializer<?>> void registerTypeWithKryoSerializer(Class<?> type, T serializer) {
        if (type == null || serializer == null) {
            throw new NullPointerException("Cannot register null class or serializer.");
        }
        this.registeredTypesWithKryoSerializers.put(type, new SerializableSerializer<T>(serializer));
    }

    public void registerTypeWithKryoSerializer(Class<?> type, Class<? extends Serializer> serializerClass) {
        if (type == null || serializerClass == null) {
            throw new NullPointerException("Cannot register null class or serializer.");
        }
        Class<? extends Serializer> castedSerializerClass = serializerClass;
        this.registeredTypesWithKryoSerializerClasses.put(type, castedSerializerClass);
    }

    public void registerPojoType(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("Cannot register null type class.");
        }
        if (!this.registeredPojoTypes.contains(type)) {
            this.registeredPojoTypes.add(type);
        }
    }

    public void registerKryoType(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("Cannot register null type class.");
        }
        this.registeredKryoTypes.add(type);
    }

    public LinkedHashMap<Class<?>, SerializableSerializer<?>> getRegisteredTypesWithKryoSerializers() {
        return this.registeredTypesWithKryoSerializers;
    }

    public LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> getRegisteredTypesWithKryoSerializerClasses() {
        return this.registeredTypesWithKryoSerializerClasses;
    }

    public LinkedHashMap<Class<?>, SerializableSerializer<?>> getDefaultKryoSerializers() {
        return this.defaultKryoSerializers;
    }

    public LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> getDefaultKryoSerializerClasses() {
        return this.defaultKryoSerializerClasses;
    }

    public LinkedHashSet<Class<?>> getRegisteredKryoTypes() {
        if (this.isForceKryoEnabled()) {
            LinkedHashSet result = new LinkedHashSet();
            result.addAll(this.registeredKryoTypes);
            for (Class clazz : this.registeredPojoTypes) {
                if (result.contains(clazz)) continue;
                result.add(clazz);
            }
            return result;
        }
        return this.registeredKryoTypes;
    }

    public LinkedHashSet<Class<?>> getRegisteredPojoTypes() {
        return this.registeredPojoTypes;
    }

    public boolean isAutoTypeRegistrationDisabled() {
        return !this.autoTypeRegistrationEnabled;
    }

    public void disableAutoTypeRegistration() {
        this.autoTypeRegistrationEnabled = false;
    }

    public boolean isUseSnapshotCompression() {
        return this.useSnapshotCompression;
    }

    public void setUseSnapshotCompression(boolean useSnapshotCompression) {
        this.useSnapshotCompression = useSnapshotCompression;
    }

    @Deprecated
    @Internal
    public boolean isFailTaskOnCheckpointError() {
        return this.failTaskOnCheckpointError;
    }

    @Deprecated
    @Internal
    public void setFailTaskOnCheckpointError(boolean failTaskOnCheckpointError) {
        this.failTaskOnCheckpointError = failTaskOnCheckpointError;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExecutionConfig) {
            ExecutionConfig other = (ExecutionConfig)obj;
            return other.canEqual(this) && Objects.equals((Object)this.executionMode, (Object)other.executionMode) && this.closureCleanerLevel == other.closureCleanerLevel && this.parallelism == other.parallelism && (this.restartStrategyConfiguration == null && other.restartStrategyConfiguration == null || null != this.restartStrategyConfiguration && this.restartStrategyConfiguration.equals(other.restartStrategyConfiguration)) && this.forceKryo == other.forceKryo && this.disableGenericTypes == other.disableGenericTypes && this.objectReuse == other.objectReuse && this.autoTypeRegistrationEnabled == other.autoTypeRegistrationEnabled && this.forceAvro == other.forceAvro && Objects.equals((Object)this.codeAnalysisMode, (Object)other.codeAnalysisMode) && Objects.equals(this.globalJobParameters, other.globalJobParameters) && this.autoWatermarkInterval == other.autoWatermarkInterval && this.registeredTypesWithKryoSerializerClasses.equals(other.registeredTypesWithKryoSerializerClasses) && this.defaultKryoSerializerClasses.equals(other.defaultKryoSerializerClasses) && this.registeredKryoTypes.equals(other.registeredKryoTypes) && this.registeredPojoTypes.equals(other.registeredPojoTypes) && this.taskCancellationIntervalMillis == other.taskCancellationIntervalMillis && this.useSnapshotCompression == other.useSnapshotCompression && this.defaultInputDependencyConstraint == other.defaultInputDependencyConstraint;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.executionMode, this.closureCleanerLevel, this.parallelism, this.restartStrategyConfiguration, this.forceKryo, this.disableGenericTypes, this.objectReuse, this.autoTypeRegistrationEnabled, this.forceAvro, this.codeAnalysisMode, this.globalJobParameters, this.autoWatermarkInterval, this.registeredTypesWithKryoSerializerClasses, this.defaultKryoSerializerClasses, this.registeredKryoTypes, this.registeredPojoTypes, this.taskCancellationIntervalMillis, this.useSnapshotCompression, this.defaultInputDependencyConstraint});
    }

    public String toString() {
        return "ExecutionConfig{executionMode=" + (Object)((Object)this.executionMode) + ", closureCleanerLevel=" + (Object)((Object)this.closureCleanerLevel) + ", parallelism=" + this.parallelism + ", maxParallelism=" + this.maxParallelism + ", numberOfExecutionRetries=" + this.numberOfExecutionRetries + ", forceKryo=" + this.forceKryo + ", disableGenericTypes=" + this.disableGenericTypes + ", enableAutoGeneratedUids=" + this.enableAutoGeneratedUids + ", objectReuse=" + this.objectReuse + ", autoTypeRegistrationEnabled=" + this.autoTypeRegistrationEnabled + ", forceAvro=" + this.forceAvro + ", codeAnalysisMode=" + (Object)((Object)this.codeAnalysisMode) + ", autoWatermarkInterval=" + this.autoWatermarkInterval + ", latencyTrackingInterval=" + this.latencyTrackingInterval + ", isLatencyTrackingConfigured=" + this.isLatencyTrackingConfigured + ", executionRetryDelay=" + this.executionRetryDelay + ", restartStrategyConfiguration=" + this.restartStrategyConfiguration + ", taskCancellationIntervalMillis=" + this.taskCancellationIntervalMillis + ", taskCancellationTimeoutMillis=" + this.taskCancellationTimeoutMillis + ", useSnapshotCompression=" + this.useSnapshotCompression + ", failTaskOnCheckpointError=" + this.failTaskOnCheckpointError + ", defaultInputDependencyConstraint=" + (Object)((Object)this.defaultInputDependencyConstraint) + ", globalJobParameters=" + this.globalJobParameters + ", registeredTypesWithKryoSerializers=" + this.registeredTypesWithKryoSerializers + ", registeredTypesWithKryoSerializerClasses=" + this.registeredTypesWithKryoSerializerClasses + ", defaultKryoSerializers=" + this.defaultKryoSerializers + ", defaultKryoSerializerClasses=" + this.defaultKryoSerializerClasses + ", registeredKryoTypes=" + this.registeredKryoTypes + ", registeredPojoTypes=" + this.registeredPojoTypes + '}';
    }

    public boolean canEqual(Object obj) {
        return obj instanceof ExecutionConfig;
    }

    @Override
    @Internal
    public ArchivedExecutionConfig archive() {
        return new ArchivedExecutionConfig(this);
    }

    public void configure(ReadableConfig configuration, ClassLoader classLoader) {
        configuration.getOptional(PipelineOptions.AUTO_TYPE_REGISTRATION).ifPresent(b -> {
            this.autoTypeRegistrationEnabled = b;
        });
        configuration.getOptional(PipelineOptions.AUTO_GENERATE_UIDS).ifPresent(b -> {
            this.enableAutoGeneratedUids = b;
        });
        configuration.getOptional(PipelineOptions.AUTO_WATERMARK_INTERVAL).ifPresent(i -> this.setAutoWatermarkInterval(i.toMillis()));
        configuration.getOptional(PipelineOptions.CLOSURE_CLEANER_LEVEL).ifPresent(this::setClosureCleanerLevel);
        configuration.getOptional(PipelineOptions.FORCE_AVRO).ifPresent(b -> {
            this.forceAvro = b;
        });
        configuration.getOptional(PipelineOptions.GENERIC_TYPES).ifPresent(b -> {
            this.disableGenericTypes = b == false;
        });
        configuration.getOptional(PipelineOptions.FORCE_KRYO).ifPresent(b -> {
            this.forceKryo = b;
        });
        configuration.getOptional(PipelineOptions.GLOBAL_JOB_PARAMETERS).map(x$0 -> new MapBasedJobParameters((Map)x$0)).ifPresent(this::setGlobalJobParameters);
        configuration.getOptional(MetricOptions.LATENCY_INTERVAL).ifPresent(this::setLatencyTrackingInterval);
        configuration.getOptional(PipelineOptions.MAX_PARALLELISM).ifPresent(this::setMaxParallelism);
        configuration.getOptional(CoreOptions.DEFAULT_PARALLELISM).ifPresent(this::setParallelism);
        configuration.getOptional(PipelineOptions.OBJECT_REUSE).ifPresent(o -> {
            this.objectReuse = o;
        });
        configuration.getOptional(TaskManagerOptions.TASK_CANCELLATION_INTERVAL).ifPresent(this::setTaskCancellationInterval);
        configuration.getOptional(TaskManagerOptions.TASK_CANCELLATION_TIMEOUT).ifPresent(this::setTaskCancellationTimeout);
        configuration.getOptional(ExecutionOptions.SNAPSHOT_COMPRESSION).ifPresent(this::setUseSnapshotCompression);
        RestartStrategies.fromConfiguration(configuration).ifPresent(this::setRestartStrategy);
        configuration.getOptional(PipelineOptions.KRYO_DEFAULT_SERIALIZERS).map(s -> this.parseKryoSerializersWithExceptionHandling(classLoader, (List<String>)s)).ifPresent(s -> {
            this.defaultKryoSerializerClasses = s;
        });
        configuration.getOptional(PipelineOptions.POJO_REGISTERED_CLASSES).map(c -> this.loadClasses((List<String>)c, classLoader, "Could not load pojo type to be registered.")).ifPresent(c -> {
            this.registeredPojoTypes = c;
        });
        configuration.getOptional(PipelineOptions.KRYO_REGISTERED_CLASSES).map(c -> this.loadClasses((List<String>)c, classLoader, "Could not load kryo type to be registered.")).ifPresent(c -> {
            this.registeredKryoTypes = c;
        });
    }

    private LinkedHashSet<Class<?>> loadClasses(List<String> classNames, ClassLoader classLoader, String errorMessage) {
        return classNames.stream().map(name -> this.loadClass((String)name, classLoader, errorMessage)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> parseKryoSerializersWithExceptionHandling(ClassLoader classLoader, List<String> kryoSerializers) {
        try {
            return this.parseKryoSerializers(classLoader, kryoSerializers);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not configure kryo serializers from " + kryoSerializers);
        }
    }

    private LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> parseKryoSerializers(ClassLoader classLoader, List<String> kryoSerializers) {
        return kryoSerializers.stream().map(v -> Arrays.stream(v.split(",")).map(p -> p.split(":")).collect(Collectors.toMap(arr -> arr[0], arr -> arr[1]))).collect(Collectors.toMap(m -> this.loadClass((String)m.get("class"), classLoader, "Could not load class for kryo serialization"), m -> this.loadClass((String)m.get("serializer"), classLoader, "Could not load serializer's class"), (m1, m2) -> {
            throw new IllegalArgumentException("Duplicated serializer for class: " + m1);
        }, LinkedHashMap::new));
    }

    private <T extends Class> T loadClass(String className, ClassLoader classLoader, String errorMessage) {
        try {
            return (T)Class.forName(className, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(errorMessage, e);
        }
    }

    private static class MapBasedJobParameters
    extends GlobalJobParameters {
        private final Map<String, String> properties;

        private MapBasedJobParameters(Map<String, String> properties) {
            this.properties = properties;
        }

        @Override
        public Map<String, String> toMap() {
            return this.properties;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GlobalJobParameters)) {
                return false;
            }
            GlobalJobParameters that = (GlobalJobParameters)o;
            return Objects.equals(this.properties, that.toMap());
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.properties);
        }
    }

    public static enum ClosureCleanerLevel {
        NONE,
        TOP_LEVEL,
        RECURSIVE;

    }

    public static class GlobalJobParameters
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public Map<String, String> toMap() {
            return Collections.emptyMap();
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass() == obj.getClass();
        }

        public int hashCode() {
            return Objects.hash(new Object[0]);
        }
    }

    public static class SerializableSerializer<T extends Serializer<?>>
    implements Serializable {
        private static final long serialVersionUID = 4687893502781067189L;
        private T serializer;

        public SerializableSerializer(T serializer) {
            this.serializer = serializer;
        }

        public T getSerializer() {
            return this.serializer;
        }
    }
}

