/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.functions;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.InvalidProgramException;

@Public
public class FunctionAnnotation {
    private FunctionAnnotation() {
    }

    @Internal
    public static Set<Annotation> readSingleForwardAnnotations(Class<?> udfClass) {
        ForwardedFields forwardedFields = udfClass.getAnnotation(ForwardedFields.class);
        NonForwardedFields nonForwardedFields = udfClass.getAnnotation(NonForwardedFields.class);
        ReadFields readSet = udfClass.getAnnotation(ReadFields.class);
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        if (forwardedFields != null) {
            annotations.add(forwardedFields);
        }
        if (nonForwardedFields != null) {
            if (!annotations.isEmpty()) {
                throw new InvalidProgramException("Either " + ForwardedFields.class.getSimpleName() + " or " + NonForwardedFields.class.getSimpleName() + " can be annotated to a function, not both.");
            }
            annotations.add(nonForwardedFields);
        }
        if (readSet != null) {
            annotations.add(readSet);
        }
        return !annotations.isEmpty() ? annotations : null;
    }

    @Internal
    public static Set<Annotation> readDualForwardAnnotations(Class<?> udfClass) {
        ForwardedFieldsFirst forwardedFields1 = udfClass.getAnnotation(ForwardedFieldsFirst.class);
        ForwardedFieldsSecond forwardedFields2 = udfClass.getAnnotation(ForwardedFieldsSecond.class);
        NonForwardedFieldsFirst nonForwardedFields1 = udfClass.getAnnotation(NonForwardedFieldsFirst.class);
        NonForwardedFieldsSecond nonForwardedFields2 = udfClass.getAnnotation(NonForwardedFieldsSecond.class);
        ReadFieldsFirst readSet1 = udfClass.getAnnotation(ReadFieldsFirst.class);
        ReadFieldsSecond readSet2 = udfClass.getAnnotation(ReadFieldsSecond.class);
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        if (nonForwardedFields1 != null && forwardedFields1 != null) {
            throw new InvalidProgramException("Either " + ForwardedFieldsFirst.class.getSimpleName() + " or " + NonForwardedFieldsFirst.class.getSimpleName() + " can be annotated to a function, not both.");
        }
        if (forwardedFields1 != null) {
            annotations.add(forwardedFields1);
        } else if (nonForwardedFields1 != null) {
            annotations.add(nonForwardedFields1);
        }
        if (forwardedFields2 != null && nonForwardedFields2 != null) {
            throw new InvalidProgramException("Either " + ForwardedFieldsSecond.class.getSimpleName() + " or " + NonForwardedFieldsSecond.class.getSimpleName() + " can be annotated to a function, not both.");
        }
        if (forwardedFields2 != null) {
            annotations.add(forwardedFields2);
        } else if (nonForwardedFields2 != null) {
            annotations.add(nonForwardedFields2);
        }
        if (readSet1 != null) {
            annotations.add(readSet1);
        }
        if (readSet2 != null) {
            annotations.add(readSet2);
        }
        return !annotations.isEmpty() ? annotations : null;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Deprecated
    @PublicEvolving
    public static @interface SkipCodeAnalysis {
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @PublicEvolving
    public static @interface ReadFieldsSecond {
        public String[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @PublicEvolving
    public static @interface ReadFieldsFirst {
        public String[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @PublicEvolving
    public static @interface ReadFields {
        public String[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NonForwardedFieldsSecond {
        public String[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NonForwardedFieldsFirst {
        public String[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NonForwardedFields {
        public String[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ForwardedFieldsSecond {
        public String[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ForwardedFieldsFirst {
        public String[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ForwardedFields {
        public String[] value();
    }
}

