/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.async;

import org.apache.flink.streaming.api.datastream.AsyncDataStream;
import org.apache.flink.streaming.api.functions.async.AsyncFunction;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.MailboxExecutor;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.YieldingOperatorFactory;
import org.apache.flink.streaming.api.operators.async.AsyncWaitOperator;
import org.apache.flink.streaming.runtime.tasks.StreamTask;

public class AsyncWaitOperatorFactory<IN, OUT>
implements OneInputStreamOperatorFactory<IN, OUT>,
YieldingOperatorFactory<OUT> {
    private final AsyncFunction<IN, OUT> asyncFunction;
    private final long timeout;
    private final int capacity;
    private final AsyncDataStream.OutputMode outputMode;
    private MailboxExecutor mailboxExecutor;
    private ChainingStrategy strategy = ChainingStrategy.HEAD;

    public AsyncWaitOperatorFactory(AsyncFunction<IN, OUT> asyncFunction, long timeout, int capacity, AsyncDataStream.OutputMode outputMode) {
        this.asyncFunction = asyncFunction;
        this.timeout = timeout;
        this.capacity = capacity;
        this.outputMode = outputMode;
    }

    @Override
    public void setMailboxExecutor(MailboxExecutor mailboxExecutor) {
        this.mailboxExecutor = mailboxExecutor;
    }

    @Override
    public StreamOperator createStreamOperator(StreamTask containingTask, StreamConfig config, Output output) {
        AsyncWaitOperator<IN, OUT> asyncWaitOperator = new AsyncWaitOperator<IN, OUT>(this.asyncFunction, this.timeout, this.capacity, this.outputMode, this.mailboxExecutor);
        asyncWaitOperator.setup(containingTask, config, output);
        return asyncWaitOperator;
    }

    @Override
    public void setChainingStrategy(ChainingStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public ChainingStrategy getChainingStrategy() {
        return this.strategy;
    }

    @Override
    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return AsyncWaitOperator.class;
    }
}

