/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.MailboxExecutor;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.YieldingOperatorFactory;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.streaming.runtime.tasks.mailbox.MailboxExecutorFactory;

public class StreamOperatorFactoryUtil {
    public static <OUT, OP extends StreamOperator<OUT>> OP createOperator(StreamOperatorFactory<OUT> operatorFactory, StreamTask<OUT, ?> containingTask, StreamConfig configuration, Output<StreamRecord<OUT>> output) {
        MailboxExecutorFactory mailboxExecutorFactory = containingTask.getMailboxExecutorFactory();
        if (operatorFactory instanceof YieldingOperatorFactory) {
            MailboxExecutor mailboxExecutor = mailboxExecutorFactory.createExecutor(configuration.getChainIndex());
            ((YieldingOperatorFactory)operatorFactory).setMailboxExecutor(mailboxExecutor);
        }
        return (OP)operatorFactory.createStreamOperator(containingTask, configuration, output);
    }
}

