/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import com.typesafe.sslconfig.ssl.KeyStoreBuilder;
import com.typesafe.sslconfig.ssl.KeystoreFormats$;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00054A!\u0001\u0002\u0001\u0017\tAb)\u001b7f\u0005\u0006\u001cX\rZ&fsN#xN]3Ck&dG-\u001a:\u000b\u0005\r!\u0011aA:tY*\u0011QAB\u0001\ngNd7m\u001c8gS\u001eT!a\u0002\u0005\u0002\u0011QL\b/Z:bM\u0016T\u0011!C\u0001\u0004G>l7\u0001A\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\ty1*Z=Ti>\u0014XMQ;jY\u0012,'\u000f\u0003\u0005\u0018\u0001\t\u0005\t\u0015!\u0003\u0019\u00031YW-_*u_J,G+\u001f9f!\tIBD\u0004\u0002\u000e5%\u00111DD\u0001\u0007!J,G-\u001a4\n\u0005uq\"AB*ue&twM\u0003\u0002\u001c\u001d!A\u0001\u0005\u0001B\u0001B\u0003%\u0001$\u0001\u0005gS2,\u0007+\u0019;i\u0011!\u0011\u0003A!A!\u0002\u0013\u0019\u0013\u0001\u00039bgN<xN\u001d3\u0011\u00075!c%\u0003\u0002&\u001d\t1q\n\u001d;j_:\u00042!D\u0014*\u0013\tAcBA\u0003BeJ\f\u0017\u0010\u0005\u0002\u000eU%\u00111F\u0004\u0002\u0005\u0007\"\f'\u000fC\u0003.\u0001\u0011\u0005a&\u0001\u0004=S:LGO\u0010\u000b\u0005_A\n$\u0007\u0005\u0002\u0014\u0001!)q\u0003\fa\u00011!)\u0001\u0005\fa\u00011!)!\u0005\fa\u0001G!)A\u0007\u0001C\u0001k\u0005)!-^5mIR\ta\u0007\u0005\u00028y5\t\u0001H\u0003\u0002:u\u0005A1/Z2ve&$\u0018PC\u0001<\u0003\u0011Q\u0017M^1\n\u0005uB$\u0001C&fsN#xN]3\t\u000b}\u0002A\u0011\u0001!\u0002+\t,\u0018\u000e\u001c3Ge>l7*Z=ti>\u0014XMR5mKR\u0019a'Q\"\t\u000b\ts\u0004\u0019\u0001\r\u0002\u0013M$xN]3UsB,\u0007\"\u0002#?\u0001\u0004)\u0015\u0001\u00024jY\u0016\u0004\"AR%\u000e\u0003\u001dS!\u0001\u0013\u001e\u0002\u0005%|\u0017B\u0001&H\u0005\u00111\u0015\u000e\\3\t\u000b1\u0003A\u0011A'\u0002!I,\u0017\rZ\"feRLg-[2bi\u0016\u001cHC\u0001(a!\ryuK\u0017\b\u0003!Vs!!\u0015+\u000e\u0003IS!a\u0015\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011B\u0001,\u000f\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001W-\u0003\u0011%#XM]1cY\u0016T!A\u0016\b\u0011\u0005msV\"\u0001/\u000b\u0005uC\u0014\u0001B2feRL!a\u0018/\u0003\u0017\r+'\u000f^5gS\u000e\fG/\u001a\u0005\u0006\t.\u0003\r!\u0012")
public class FileBasedKeyStoreBuilder
implements KeyStoreBuilder {
    private final String keyStoreType;
    public final String com$typesafe$sslconfig$ssl$FileBasedKeyStoreBuilder$$filePath;
    private final Option<char[]> password;

    @Override
    public KeyStore build() {
        KeyStore keyStore;
        File file = new File(this.com$typesafe$sslconfig$ssl$FileBasedKeyStoreBuilder$$filePath);
        Predef$.MODULE$.require(file.exists(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileBasedKeyStoreBuilder $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Key store file ", " does not exist!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$typesafe$sslconfig$ssl$FileBasedKeyStoreBuilder$$filePath}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(file.canRead(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileBasedKeyStoreBuilder $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot read from key store file ", "!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$typesafe$sslconfig$ssl$FileBasedKeyStoreBuilder$$filePath}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String string = this.keyStoreType;
        if ("PEM".equals(string)) {
            Iterable<Certificate> certs = this.readCertificates(file);
            keyStore = KeystoreFormats$.MODULE$.loadCertificates((TraversableOnce<Certificate>)certs);
        } else {
            keyStore = this.buildFromKeystoreFile(string, file);
        }
        return keyStore;
    }

    /*
     * WARNING - void declaration
     */
    public KeyStore buildFromKeystoreFile(String storeType, File file) {
        KeyStore keyStore;
        BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
        try {
            String storeType2 = this.keyStoreType;
            KeyStore store = KeyStore.getInstance(storeType2);
            store.load(inputStream, (char[])this.password.orNull(Predef$.MODULE$.$conforms()));
            keyStore = store;
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        inputStream.close();
        return keyStore;
    }

    public Iterable<Certificate> readCertificates(File file) {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);
        BufferedInputStream bis = new BufferedInputStream(fis);
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(cf.generateCertificates(bis)).asScala();
    }

    public FileBasedKeyStoreBuilder(String keyStoreType, String filePath, Option<char[]> password) {
        this.keyStoreType = keyStoreType;
        this.com$typesafe$sslconfig$ssl$FileBasedKeyStoreBuilder$$filePath = filePath;
        this.password = password;
    }
}

