/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.File;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ClusterEntrypointUtils {
    private ClusterEntrypointUtils() {
        throw new UnsupportedOperationException("This class should not be instantiated.");
    }

    public static Optional<File> tryFindUserLibDirectory() {
        File flinkHomeDirectory = ClusterEntrypointUtils.deriveFlinkHomeDirectoryFromLibDirectory();
        File usrLibDirectory = new File(flinkHomeDirectory, "usrlib");
        if (!usrLibDirectory.isDirectory()) {
            return Optional.empty();
        }
        return Optional.of(usrLibDirectory);
    }

    @Nullable
    private static File deriveFlinkHomeDirectoryFromLibDirectory() {
        String libDirectory = System.getenv().get("FLINK_LIB_DIR");
        if (libDirectory == null) {
            return null;
        }
        return new File(libDirectory).getParentFile();
    }
}

