/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.taskexecutor.BackPressureSampleableTask;
import org.apache.flink.util.Preconditions;

public class BackPressureSampleService {
    private final int numSamples;
    private final Time delayBetweenSamples;
    private final ScheduledExecutor scheduledExecutor;

    BackPressureSampleService(int numSamples, Time delayBetweenSamples, ScheduledExecutor scheduledExecutor) {
        Preconditions.checkArgument((numSamples >= 1 ? 1 : 0) != 0, (Object)("Illegal number of samples: " + numSamples));
        this.numSamples = numSamples;
        this.delayBetweenSamples = (Time)Preconditions.checkNotNull((Object)delayBetweenSamples);
        this.scheduledExecutor = (ScheduledExecutor)Preconditions.checkNotNull((Object)scheduledExecutor);
    }

    public CompletableFuture<Double> sampleTaskBackPressure(BackPressureSampleableTask task) {
        if (!task.isRunning()) {
            throw new IllegalStateException(String.format("Cannot sample task. Because the sampled task %s is not running.", task));
        }
        return this.sampleTaskBackPressure((BackPressureSampleableTask)Preconditions.checkNotNull((Object)task), this.numSamples, new ArrayList<Boolean>(this.numSamples), new CompletableFuture<Double>());
    }

    private CompletableFuture<Double> sampleTaskBackPressure(BackPressureSampleableTask task, int remainingNumSamples, List<Boolean> taskBackPressureSamples, CompletableFuture<Double> resultFuture) {
        taskBackPressureSamples.add(task.isBackPressured());
        if (task.isRunning() && remainingNumSamples > 1) {
            this.scheduledExecutor.schedule(() -> this.sampleTaskBackPressure(task, remainingNumSamples - 1, taskBackPressureSamples, resultFuture), this.delayBetweenSamples.getSize(), this.delayBetweenSamples.getUnit());
        } else {
            resultFuture.complete(this.calculateTaskBackPressureRatio(taskBackPressureSamples));
        }
        return resultFuture;
    }

    private double calculateTaskBackPressureRatio(List<Boolean> taskBackPressureSamples) {
        double backPressureCount = 0.0;
        for (Boolean isBackPressured : taskBackPressureSamples) {
            if (!isBackPressured.booleanValue()) continue;
            backPressureCount += 1.0;
        }
        return taskBackPressureSamples.isEmpty() ? 0.0 : backPressureCount / (double)taskBackPressureSamples.size();
    }
}

