/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.queryablestate.KvStateID;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.accumulators.AccumulatorSnapshot;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphBuilder;
import org.apache.flink.runtime.executiongraph.ExecutionGraphException;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.executiongraph.JobStatusListener;
import org.apache.flink.runtime.executiongraph.failover.FailoverStrategyLoader;
import org.apache.flink.runtime.executiongraph.failover.NoOpFailoverStrategy;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailoverTopology;
import org.apache.flink.runtime.executiongraph.failover.flip1.ResultPartitionAvailabilityChecker;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyResolving;
import org.apache.flink.runtime.io.network.partition.JobMasterPartitionTracker;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.runtime.jobmanager.PartitionProducerDisposedException;
import org.apache.flink.runtime.jobmaster.SerializedInputSplit;
import org.apache.flink.runtime.jobmaster.slotpool.SlotProvider;
import org.apache.flink.runtime.messages.FlinkJobNotFoundException;
import org.apache.flink.runtime.messages.checkpoint.AcknowledgeCheckpoint;
import org.apache.flink.runtime.messages.checkpoint.DeclineCheckpoint;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.runtime.query.KvStateLocation;
import org.apache.flink.runtime.query.KvStateLocationRegistry;
import org.apache.flink.runtime.query.UnknownKvStateLocation;
import org.apache.flink.runtime.rest.handler.legacy.backpressure.BackPressureStatsTracker;
import org.apache.flink.runtime.rest.handler.legacy.backpressure.OperatorBackPressureStats;
import org.apache.flink.runtime.scheduler.ExecutionGraphToInputsLocationsRetrieverAdapter;
import org.apache.flink.runtime.scheduler.ExecutionVertexVersion;
import org.apache.flink.runtime.scheduler.ExecutionVertexVersioner;
import org.apache.flink.runtime.scheduler.InputsLocationsRetriever;
import org.apache.flink.runtime.scheduler.SchedulerNG;
import org.apache.flink.runtime.scheduler.UpdateSchedulerNgOnInternalFailuresListener;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.topology.Vertex;
import org.apache.flink.runtime.webmonitor.WebMonitorUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.IterableUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.FunctionUtils;
import org.slf4j.Logger;

public abstract class SchedulerBase
implements SchedulerNG {
    private final Logger log;
    private final JobGraph jobGraph;
    private final ExecutionGraph executionGraph;
    private final SchedulingTopology<?, ?> schedulingTopology;
    private final FailoverTopology<?, ?> failoverTopology;
    private final InputsLocationsRetriever inputsLocationsRetriever;
    private final BackPressureStatsTracker backPressureStatsTracker;
    private final Executor ioExecutor;
    private final Configuration jobMasterConfiguration;
    private final SlotProvider slotProvider;
    private final ScheduledExecutorService futureExecutor;
    private final ClassLoader userCodeLoader;
    private final CheckpointRecoveryFactory checkpointRecoveryFactory;
    private final Time rpcTimeout;
    private final RestartStrategy restartStrategy;
    private final BlobWriter blobWriter;
    private final JobManagerJobMetricGroup jobManagerJobMetricGroup;
    private final Time slotRequestTimeout;
    private final boolean legacyScheduling;
    protected final ExecutionVertexVersioner executionVertexVersioner;
    private ComponentMainThreadExecutor mainThreadExecutor = new ComponentMainThreadExecutor.DummyComponentMainThreadExecutor("SchedulerBase is not initialized with proper main thread executor. Call to SchedulerBase.setMainThreadExecutor(...) required.");

    public SchedulerBase(Logger log, JobGraph jobGraph, BackPressureStatsTracker backPressureStatsTracker, Executor ioExecutor, Configuration jobMasterConfiguration, SlotProvider slotProvider, ScheduledExecutorService futureExecutor, ClassLoader userCodeLoader, CheckpointRecoveryFactory checkpointRecoveryFactory, Time rpcTimeout, RestartStrategyFactory restartStrategyFactory, BlobWriter blobWriter, JobManagerJobMetricGroup jobManagerJobMetricGroup, Time slotRequestTimeout, ShuffleMaster<?> shuffleMaster, JobMasterPartitionTracker partitionTracker, ExecutionVertexVersioner executionVertexVersioner, boolean legacyScheduling) throws Exception {
        this.log = (Logger)Preconditions.checkNotNull((Object)log);
        this.jobGraph = (JobGraph)Preconditions.checkNotNull((Object)jobGraph);
        this.backPressureStatsTracker = (BackPressureStatsTracker)Preconditions.checkNotNull((Object)backPressureStatsTracker);
        this.ioExecutor = (Executor)Preconditions.checkNotNull((Object)ioExecutor);
        this.jobMasterConfiguration = (Configuration)Preconditions.checkNotNull((Object)jobMasterConfiguration);
        this.slotProvider = (SlotProvider)Preconditions.checkNotNull((Object)slotProvider);
        this.futureExecutor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)futureExecutor);
        this.userCodeLoader = (ClassLoader)Preconditions.checkNotNull((Object)userCodeLoader);
        this.checkpointRecoveryFactory = (CheckpointRecoveryFactory)Preconditions.checkNotNull((Object)checkpointRecoveryFactory);
        this.rpcTimeout = (Time)Preconditions.checkNotNull((Object)rpcTimeout);
        RestartStrategies.RestartStrategyConfiguration restartStrategyConfiguration = ((ExecutionConfig)jobGraph.getSerializedExecutionConfig().deserializeValue(userCodeLoader)).getRestartStrategy();
        this.restartStrategy = RestartStrategyResolving.resolve(restartStrategyConfiguration, restartStrategyFactory, jobGraph.isCheckpointingEnabled());
        if (legacyScheduling) {
            log.info("Using restart strategy {} for {} ({}).", new Object[]{this.restartStrategy, jobGraph.getName(), jobGraph.getJobID()});
        }
        this.blobWriter = (BlobWriter)Preconditions.checkNotNull((Object)blobWriter);
        this.jobManagerJobMetricGroup = (JobManagerJobMetricGroup)Preconditions.checkNotNull((Object)jobManagerJobMetricGroup);
        this.slotRequestTimeout = (Time)Preconditions.checkNotNull((Object)slotRequestTimeout);
        this.executionVertexVersioner = (ExecutionVertexVersioner)Preconditions.checkNotNull((Object)executionVertexVersioner);
        this.legacyScheduling = legacyScheduling;
        this.executionGraph = this.createAndRestoreExecutionGraph(jobManagerJobMetricGroup, (ShuffleMaster)Preconditions.checkNotNull(shuffleMaster), (JobMasterPartitionTracker)Preconditions.checkNotNull((Object)partitionTracker));
        this.schedulingTopology = this.executionGraph.getSchedulingTopology();
        this.failoverTopology = this.executionGraph.getFailoverTopology();
        this.inputsLocationsRetriever = new ExecutionGraphToInputsLocationsRetrieverAdapter(this.executionGraph);
    }

    private ExecutionGraph createAndRestoreExecutionGraph(JobManagerJobMetricGroup currentJobManagerJobMetricGroup, ShuffleMaster<?> shuffleMaster, JobMasterPartitionTracker partitionTracker) throws Exception {
        ExecutionGraph newExecutionGraph = this.createExecutionGraph(currentJobManagerJobMetricGroup, shuffleMaster, partitionTracker);
        CheckpointCoordinator checkpointCoordinator = newExecutionGraph.getCheckpointCoordinator();
        if (checkpointCoordinator != null && !checkpointCoordinator.restoreLatestCheckpointedState(new HashSet<ExecutionJobVertex>(newExecutionGraph.getAllVertices().values()), false, false)) {
            this.tryRestoreExecutionGraphFromSavepoint(newExecutionGraph, this.jobGraph.getSavepointRestoreSettings());
        }
        return newExecutionGraph;
    }

    private ExecutionGraph createExecutionGraph(JobManagerJobMetricGroup currentJobManagerJobMetricGroup, ShuffleMaster<?> shuffleMaster, JobMasterPartitionTracker partitionTracker) throws JobExecutionException, JobException {
        NoOpFailoverStrategy.Factory failoverStrategy = this.legacyScheduling ? FailoverStrategyLoader.loadFailoverStrategy(this.jobMasterConfiguration, this.log) : new NoOpFailoverStrategy.Factory();
        return ExecutionGraphBuilder.buildGraph(null, this.jobGraph, this.jobMasterConfiguration, this.futureExecutor, this.ioExecutor, this.slotProvider, this.userCodeLoader, this.checkpointRecoveryFactory, this.rpcTimeout, this.restartStrategy, currentJobManagerJobMetricGroup, this.blobWriter, this.slotRequestTimeout, this.log, shuffleMaster, partitionTracker, failoverStrategy);
    }

    @Deprecated
    protected ExecutionGraph getExecutionGraph() {
        return this.executionGraph;
    }

    private void tryRestoreExecutionGraphFromSavepoint(ExecutionGraph executionGraphToRestore, SavepointRestoreSettings savepointRestoreSettings) throws Exception {
        CheckpointCoordinator checkpointCoordinator;
        if (savepointRestoreSettings.restoreSavepoint() && (checkpointCoordinator = executionGraphToRestore.getCheckpointCoordinator()) != null) {
            checkpointCoordinator.restoreSavepoint(savepointRestoreSettings.getRestorePath(), savepointRestoreSettings.allowNonRestoredState(), executionGraphToRestore.getAllVertices(), this.userCodeLoader);
        }
    }

    protected void resetForNewExecutions(Collection<ExecutionVertexID> vertices) {
        vertices.forEach(executionVertexId -> this.getExecutionVertex((ExecutionVertexID)executionVertexId).resetForNewExecution());
    }

    protected void restoreState(Set<ExecutionVertexID> vertices) throws Exception {
        if (this.executionGraph.getCheckpointCoordinator() != null) {
            this.executionGraph.getCheckpointCoordinator().abortPendingCheckpoints(new CheckpointException(CheckpointFailureReason.JOB_FAILOVER_REGION));
            this.executionGraph.getCheckpointCoordinator().restoreLatestCheckpointedState(this.getInvolvedExecutionJobVertices(vertices), false, true);
        }
    }

    private Set<ExecutionJobVertex> getInvolvedExecutionJobVertices(Set<ExecutionVertexID> executionVertices) {
        HashSet<ExecutionJobVertex> tasks = new HashSet<ExecutionJobVertex>();
        for (ExecutionVertexID executionVertexID : executionVertices) {
            ExecutionVertex executionVertex = this.getExecutionVertex(executionVertexID);
            tasks.add(executionVertex.getJobVertex());
        }
        return tasks;
    }

    protected void transitionToScheduled(List<ExecutionVertexID> verticesToDeploy) {
        verticesToDeploy.forEach(executionVertexId -> this.getExecutionVertex((ExecutionVertexID)executionVertexId).getCurrentExecutionAttempt().transitionState(ExecutionState.SCHEDULED));
    }

    protected void setGlobalFailureCause(@Nullable Throwable cause) {
        if (cause != null) {
            this.getExecutionGraph().initFailureCause(cause);
        }
    }

    protected ComponentMainThreadExecutor getMainThreadExecutor() {
        return this.mainThreadExecutor;
    }

    protected void failJob(Throwable cause) {
        this.incrementVersionsOfAllVertices();
        this.executionGraph.failJob(cause);
    }

    protected final FailoverTopology<?, ?> getFailoverTopology() {
        return this.failoverTopology;
    }

    protected final SchedulingTopology<?, ?> getSchedulingTopology() {
        return this.schedulingTopology;
    }

    protected final ResultPartitionAvailabilityChecker getResultPartitionAvailabilityChecker() {
        return this.getExecutionGraph().getResultPartitionAvailabilityChecker();
    }

    protected final InputsLocationsRetriever getInputsLocationsRetriever() {
        return this.inputsLocationsRetriever;
    }

    protected final void prepareExecutionGraphForNgScheduling() {
        this.executionGraph.enableNgScheduling(new UpdateSchedulerNgOnInternalFailuresListener(this, this.jobGraph.getJobID()));
        this.executionGraph.transitionToRunning();
    }

    protected Optional<ExecutionVertexID> getExecutionVertexId(ExecutionAttemptID executionAttemptId) {
        return Optional.ofNullable(this.executionGraph.getRegisteredExecutions().get((Object)executionAttemptId)).map(this::getExecutionVertexId);
    }

    protected ExecutionVertexID getExecutionVertexIdOrThrow(ExecutionAttemptID executionAttemptId) {
        return this.getExecutionVertexId(executionAttemptId).orElseThrow(() -> new IllegalStateException("Cannot find execution " + (Object)((Object)executionAttemptId)));
    }

    private ExecutionVertexID getExecutionVertexId(Execution execution) {
        return execution.getVertex().getID();
    }

    protected ExecutionVertex getExecutionVertex(ExecutionVertexID executionVertexId) {
        return this.executionGraph.getAllVertices().get(executionVertexId.getJobVertexId()).getTaskVertices()[executionVertexId.getSubtaskIndex()];
    }

    protected JobGraph getJobGraph() {
        return this.jobGraph;
    }

    protected abstract long getNumberOfRestarts();

    private Map<ExecutionVertexID, ExecutionVertexVersion> incrementVersionsOfAllVertices() {
        return this.executionVertexVersioner.recordVertexModifications(IterableUtils.toStream(this.schedulingTopology.getVertices()).map(Vertex::getId).collect(Collectors.toSet()));
    }

    protected void transitionExecutionGraphState(JobStatus current, JobStatus newState) {
        this.executionGraph.transitionState(current, newState);
    }

    @Override
    public void setMainThreadExecutor(ComponentMainThreadExecutor mainThreadExecutor) {
        this.mainThreadExecutor = (ComponentMainThreadExecutor)Preconditions.checkNotNull((Object)mainThreadExecutor);
        this.executionGraph.start(mainThreadExecutor);
    }

    @Override
    public void registerJobStatusListener(JobStatusListener jobStatusListener) {
        this.executionGraph.registerJobStatusListener(jobStatusListener);
    }

    @Override
    public final void startScheduling() {
        this.mainThreadExecutor.assertRunningInMainThread();
        this.registerJobMetrics();
        this.startSchedulingInternal();
    }

    private void registerJobMetrics() {
        this.jobManagerJobMetricGroup.gauge("numRestarts", this::getNumberOfRestarts);
        this.jobManagerJobMetricGroup.gauge("fullRestarts", this::getNumberOfRestarts);
    }

    protected abstract void startSchedulingInternal();

    @Override
    public void suspend(Throwable cause) {
        this.mainThreadExecutor.assertRunningInMainThread();
        this.incrementVersionsOfAllVertices();
        this.executionGraph.suspend(cause);
    }

    @Override
    public void cancel() {
        this.mainThreadExecutor.assertRunningInMainThread();
        this.incrementVersionsOfAllVertices();
        this.executionGraph.cancel();
    }

    @Override
    public CompletableFuture<Void> getTerminationFuture() {
        return this.executionGraph.getTerminationFuture().thenApply(FunctionUtils.nullFn());
    }

    @Override
    public final boolean updateTaskExecutionState(TaskExecutionState taskExecutionState) {
        Optional<ExecutionVertexID> executionVertexId = this.getExecutionVertexId(taskExecutionState.getID());
        boolean updateSuccess = this.executionGraph.updateState(taskExecutionState);
        if (updateSuccess) {
            Preconditions.checkState((boolean)executionVertexId.isPresent());
            if (this.isNotifiable(executionVertexId.get(), taskExecutionState)) {
                this.updateTaskExecutionStateInternal(executionVertexId.get(), taskExecutionState);
            }
            return true;
        }
        return false;
    }

    private boolean isNotifiable(ExecutionVertexID executionVertexId, TaskExecutionState taskExecutionState) {
        ExecutionVertex executionVertex = this.getExecutionVertex(executionVertexId);
        switch (taskExecutionState.getExecutionState()) {
            case FINISHED: 
            case FAILED: {
                if (executionVertex.getExecutionState() != taskExecutionState.getExecutionState()) break;
                return true;
            }
        }
        return false;
    }

    protected void updateTaskExecutionStateInternal(ExecutionVertexID executionVertexId, TaskExecutionState taskExecutionState) {
    }

    @Override
    public SerializedInputSplit requestNextInputSplit(JobVertexID vertexID, ExecutionAttemptID executionAttempt) throws IOException {
        this.mainThreadExecutor.assertRunningInMainThread();
        Execution execution = this.executionGraph.getRegisteredExecutions().get((Object)executionAttempt);
        if (execution == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Can not find Execution for attempt {}.", (Object)executionAttempt);
            }
            throw new IllegalArgumentException("Can not find Execution for attempt " + (Object)((Object)executionAttempt));
        }
        ExecutionJobVertex vertex = this.executionGraph.getJobVertex(vertexID);
        if (vertex == null) {
            throw new IllegalArgumentException("Cannot find execution vertex for vertex ID " + vertexID);
        }
        if (vertex.getSplitAssigner() == null) {
            throw new IllegalStateException("No InputSplitAssigner for vertex ID " + vertexID);
        }
        InputSplit nextInputSplit = execution.getNextInputSplit();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Send next input split {}.", (Object)nextInputSplit);
        }
        try {
            byte[] serializedInputSplit = InstantiationUtil.serializeObject((Object)nextInputSplit);
            return new SerializedInputSplit(serializedInputSplit);
        }
        catch (Exception ex) {
            IOException reason = new IOException("Could not serialize the next input split of class " + nextInputSplit.getClass() + ".", ex);
            vertex.fail(reason);
            throw reason;
        }
    }

    @Override
    public ExecutionState requestPartitionState(IntermediateDataSetID intermediateResultId, ResultPartitionID resultPartitionId) throws PartitionProducerDisposedException {
        this.mainThreadExecutor.assertRunningInMainThread();
        Execution execution = this.executionGraph.getRegisteredExecutions().get((Object)resultPartitionId.getProducerId());
        if (execution != null) {
            return execution.getState();
        }
        IntermediateResult intermediateResult = this.executionGraph.getAllIntermediateResults().get(intermediateResultId);
        if (intermediateResult != null) {
            Execution producerExecution = intermediateResult.getPartitionById(resultPartitionId.getPartitionId()).getProducer().getCurrentExecutionAttempt();
            if (producerExecution.getAttemptId().equals((Object)resultPartitionId.getProducerId())) {
                return producerExecution.getState();
            }
            throw new PartitionProducerDisposedException(resultPartitionId);
        }
        throw new IllegalArgumentException("Intermediate data set with ID " + intermediateResultId + " not found.");
    }

    @Override
    public final void scheduleOrUpdateConsumers(ResultPartitionID partitionId) {
        this.mainThreadExecutor.assertRunningInMainThread();
        try {
            this.executionGraph.scheduleOrUpdateConsumers(partitionId);
        }
        catch (ExecutionGraphException e) {
            throw new RuntimeException(e);
        }
        ExecutionVertexID producerVertexId = this.getExecutionVertexIdOrThrow(partitionId.getProducerId());
        this.scheduleOrUpdateConsumersInternal(producerVertexId, partitionId);
    }

    protected void scheduleOrUpdateConsumersInternal(ExecutionVertexID producerVertexId, ResultPartitionID resultPartitionId) {
    }

    @Override
    public ArchivedExecutionGraph requestJob() {
        this.mainThreadExecutor.assertRunningInMainThread();
        return ArchivedExecutionGraph.createFrom(this.executionGraph);
    }

    @Override
    public JobStatus requestJobStatus() {
        return this.executionGraph.getState();
    }

    @Override
    public JobDetails requestJobDetails() {
        this.mainThreadExecutor.assertRunningInMainThread();
        return WebMonitorUtils.createDetailsForJob(this.executionGraph);
    }

    @Override
    public KvStateLocation requestKvStateLocation(JobID jobId, String registrationName) throws UnknownKvStateLocation, FlinkJobNotFoundException {
        this.mainThreadExecutor.assertRunningInMainThread();
        if (this.jobGraph.getJobID().equals((Object)jobId)) {
            KvStateLocationRegistry registry;
            KvStateLocation location;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Lookup key-value state for job {} with registration name {}.", (Object)this.jobGraph.getJobID(), (Object)registrationName);
            }
            if ((location = (registry = this.executionGraph.getKvStateLocationRegistry()).getKvStateLocation(registrationName)) != null) {
                return location;
            }
            throw new UnknownKvStateLocation(registrationName);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Request of key-value state location for unknown job {} received.", (Object)jobId);
        }
        throw new FlinkJobNotFoundException(jobId);
    }

    @Override
    public void notifyKvStateRegistered(JobID jobId, JobVertexID jobVertexId, KeyGroupRange keyGroupRange, String registrationName, KvStateID kvStateId, InetSocketAddress kvStateServerAddress) throws FlinkJobNotFoundException {
        this.mainThreadExecutor.assertRunningInMainThread();
        if (this.jobGraph.getJobID().equals((Object)jobId)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Key value state registered for job {} under name {}.", (Object)this.jobGraph.getJobID(), (Object)registrationName);
            }
            try {
                this.executionGraph.getKvStateLocationRegistry().notifyKvStateRegistered(jobVertexId, keyGroupRange, registrationName, kvStateId, kvStateServerAddress);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new FlinkJobNotFoundException(jobId);
        }
    }

    @Override
    public void notifyKvStateUnregistered(JobID jobId, JobVertexID jobVertexId, KeyGroupRange keyGroupRange, String registrationName) throws FlinkJobNotFoundException {
        this.mainThreadExecutor.assertRunningInMainThread();
        if (this.jobGraph.getJobID().equals((Object)jobId)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Key value state unregistered for job {} under name {}.", (Object)this.jobGraph.getJobID(), (Object)registrationName);
            }
            try {
                this.executionGraph.getKvStateLocationRegistry().notifyKvStateUnregistered(jobVertexId, keyGroupRange, registrationName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new FlinkJobNotFoundException(jobId);
        }
    }

    @Override
    public void updateAccumulators(AccumulatorSnapshot accumulatorSnapshot) {
        this.mainThreadExecutor.assertRunningInMainThread();
        this.executionGraph.updateAccumulators(accumulatorSnapshot);
    }

    @Override
    public Optional<OperatorBackPressureStats> requestOperatorBackPressureStats(JobVertexID jobVertexId) throws FlinkException {
        ExecutionJobVertex jobVertex = this.executionGraph.getJobVertex(jobVertexId);
        if (jobVertex == null) {
            throw new FlinkException("JobVertexID not found " + jobVertexId);
        }
        return this.backPressureStatsTracker.getOperatorBackPressureStats(jobVertex);
    }

    @Override
    public CompletableFuture<String> triggerSavepoint(String targetDirectory, boolean cancelJob) {
        this.mainThreadExecutor.assertRunningInMainThread();
        CheckpointCoordinator checkpointCoordinator = this.executionGraph.getCheckpointCoordinator();
        if (checkpointCoordinator == null) {
            throw new IllegalStateException(String.format("Job %s is not a streaming job.", this.jobGraph.getJobID()));
        }
        if (targetDirectory == null && !checkpointCoordinator.getCheckpointStorage().hasDefaultSavepointLocation()) {
            this.log.info("Trying to cancel job {} with savepoint, but no savepoint directory configured.", (Object)this.jobGraph.getJobID());
            throw new IllegalStateException("No savepoint directory configured. You can either specify a directory while cancelling via -s :targetDirectory or configure a cluster-wide default via key '" + CheckpointingOptions.SAVEPOINT_DIRECTORY.key() + "'.");
        }
        if (cancelJob) {
            checkpointCoordinator.stopCheckpointScheduler();
        }
        return ((CompletableFuture)checkpointCoordinator.triggerSavepoint(System.currentTimeMillis(), targetDirectory).thenApply(CompletedCheckpoint::getExternalPointer)).handleAsync((path, throwable) -> {
            if (throwable != null) {
                if (cancelJob) {
                    this.startCheckpointScheduler(checkpointCoordinator);
                }
                throw new CompletionException((Throwable)throwable);
            }
            if (cancelJob) {
                this.log.info("Savepoint stored in {}. Now cancelling {}.", path, (Object)this.jobGraph.getJobID());
                this.cancel();
            }
            return path;
        }, (Executor)this.mainThreadExecutor);
    }

    private void startCheckpointScheduler(CheckpointCoordinator checkpointCoordinator) {
        this.mainThreadExecutor.assertRunningInMainThread();
        if (checkpointCoordinator.isPeriodicCheckpointingConfigured()) {
            try {
                checkpointCoordinator.startCheckpointScheduler();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public void acknowledgeCheckpoint(JobID jobID, ExecutionAttemptID executionAttemptID, long checkpointId, CheckpointMetrics checkpointMetrics, TaskStateSnapshot checkpointState) {
        this.mainThreadExecutor.assertRunningInMainThread();
        CheckpointCoordinator checkpointCoordinator = this.executionGraph.getCheckpointCoordinator();
        AcknowledgeCheckpoint ackMessage = new AcknowledgeCheckpoint(jobID, executionAttemptID, checkpointId, checkpointMetrics, checkpointState);
        String taskManagerLocationInfo = this.retrieveTaskManagerLocation(executionAttemptID);
        if (checkpointCoordinator != null) {
            this.ioExecutor.execute(() -> {
                try {
                    checkpointCoordinator.receiveAcknowledgeMessage(ackMessage, taskManagerLocationInfo);
                }
                catch (Throwable t) {
                    this.log.warn("Error while processing checkpoint acknowledgement message", t);
                }
            });
        } else {
            String errorMessage = "Received AcknowledgeCheckpoint message for job {} with no CheckpointCoordinator";
            if (this.executionGraph.getState() == JobStatus.RUNNING) {
                this.log.error(errorMessage, (Object)this.jobGraph.getJobID());
            } else {
                this.log.debug(errorMessage, (Object)this.jobGraph.getJobID());
            }
        }
    }

    @Override
    public void declineCheckpoint(DeclineCheckpoint decline) {
        this.mainThreadExecutor.assertRunningInMainThread();
        CheckpointCoordinator checkpointCoordinator = this.executionGraph.getCheckpointCoordinator();
        String taskManagerLocationInfo = this.retrieveTaskManagerLocation(decline.getTaskExecutionId());
        if (checkpointCoordinator != null) {
            this.ioExecutor.execute(() -> {
                try {
                    checkpointCoordinator.receiveDeclineMessage(decline, taskManagerLocationInfo);
                }
                catch (Exception e) {
                    this.log.error("Error in CheckpointCoordinator while processing {}", (Object)decline, (Object)e);
                }
            });
        } else {
            String errorMessage = "Received DeclineCheckpoint message for job {} with no CheckpointCoordinator";
            if (this.executionGraph.getState() == JobStatus.RUNNING) {
                this.log.error(errorMessage, (Object)this.jobGraph.getJobID());
            } else {
                this.log.debug(errorMessage, (Object)this.jobGraph.getJobID());
            }
        }
    }

    @Override
    public CompletableFuture<String> stopWithSavepoint(String targetDirectory, boolean advanceToEndOfEventTime) {
        this.mainThreadExecutor.assertRunningInMainThread();
        CheckpointCoordinator checkpointCoordinator = this.executionGraph.getCheckpointCoordinator();
        if (checkpointCoordinator == null) {
            return FutureUtils.completedExceptionally(new IllegalStateException(String.format("Job %s is not a streaming job.", this.jobGraph.getJobID())));
        }
        if (targetDirectory == null && !checkpointCoordinator.getCheckpointStorage().hasDefaultSavepointLocation()) {
            this.log.info("Trying to cancel job {} with savepoint, but no savepoint directory configured.", (Object)this.jobGraph.getJobID());
            return FutureUtils.completedExceptionally(new IllegalStateException("No savepoint directory configured. You can either specify a directory while cancelling via -s :targetDirectory or configure a cluster-wide default via key '" + CheckpointingOptions.SAVEPOINT_DIRECTORY.key() + "'."));
        }
        checkpointCoordinator.stopCheckpointScheduler();
        long now = System.currentTimeMillis();
        CompletionStage savepointFuture = checkpointCoordinator.triggerSynchronousSavepoint(now, advanceToEndOfEventTime, targetDirectory).thenApply(CompletedCheckpoint::getExternalPointer);
        CompletionStage terminationFuture = this.executionGraph.getTerminationFuture().handle((jobstatus, throwable) -> {
            if (throwable != null) {
                this.log.info("Failed during stopping job {} with a savepoint. Reason: {}", (Object)this.jobGraph.getJobID(), (Object)throwable.getMessage());
                throw new CompletionException((Throwable)throwable);
            }
            if (jobstatus != JobStatus.FINISHED) {
                this.log.info("Failed during stopping job {} with a savepoint. Reason: Reached state {} instead of FINISHED.", (Object)this.jobGraph.getJobID(), jobstatus);
                throw new CompletionException(new FlinkException("Reached state " + jobstatus + " instead of FINISHED."));
            }
            return jobstatus;
        });
        return ((CompletableFuture)((CompletableFuture)savepointFuture).thenCompose(arg_0 -> SchedulerBase.lambda$stopWithSavepoint$8((CompletableFuture)terminationFuture, arg_0))).handleAsync((path, throwable) -> {
            if (throwable != null) {
                this.startCheckpointScheduler(checkpointCoordinator);
                throw new CompletionException((Throwable)throwable);
            }
            return path;
        }, (Executor)this.mainThreadExecutor);
    }

    private String retrieveTaskManagerLocation(ExecutionAttemptID executionAttemptID) {
        Optional<Execution> currentExecution = Optional.ofNullable(this.executionGraph.getRegisteredExecutions().get((Object)executionAttemptID));
        return currentExecution.map(Execution::getAssignedResourceLocation).map(TaskManagerLocation::toString).orElse("Unknown location");
    }

    private static /* synthetic */ CompletionStage lambda$stopWithSavepoint$8(CompletableFuture terminationFuture, String path) {
        return terminationFuture.thenApply(jobStatus -> path);
    }
}

