/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.registration;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.registration.RetryingRegistrationConfiguration;
import org.apache.flink.runtime.rpc.FencedRpcGateway;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

public abstract class RetryingRegistration<F extends Serializable, G extends RpcGateway, S extends RegistrationResponse.Success> {
    private final Logger log;
    private final RpcService rpcService;
    private final String targetName;
    private final Class<G> targetType;
    private final String targetAddress;
    private final F fencingToken;
    private final CompletableFuture<Tuple2<G, S>> completionFuture;
    private final RetryingRegistrationConfiguration retryingRegistrationConfiguration;
    private volatile boolean canceled;

    public RetryingRegistration(Logger log, RpcService rpcService, String targetName, Class<G> targetType, String targetAddress, F fencingToken, RetryingRegistrationConfiguration retryingRegistrationConfiguration) {
        this.log = (Logger)Preconditions.checkNotNull((Object)log);
        this.rpcService = (RpcService)Preconditions.checkNotNull((Object)rpcService);
        this.targetName = (String)Preconditions.checkNotNull((Object)targetName);
        this.targetType = (Class)Preconditions.checkNotNull(targetType);
        this.targetAddress = (String)Preconditions.checkNotNull((Object)targetAddress);
        this.fencingToken = (Serializable)Preconditions.checkNotNull(fencingToken);
        this.retryingRegistrationConfiguration = (RetryingRegistrationConfiguration)Preconditions.checkNotNull((Object)retryingRegistrationConfiguration);
        this.completionFuture = new CompletableFuture();
    }

    public CompletableFuture<Tuple2<G, S>> getFuture() {
        return this.completionFuture;
    }

    public void cancel() {
        this.canceled = true;
        this.completionFuture.cancel(false);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected abstract CompletableFuture<RegistrationResponse> invokeRegistration(G var1, F var2, long var3) throws Exception;

    public void startRegistration() {
        if (this.canceled) {
            return;
        }
        try {
            CompletableFuture<Object> rpcGatewayFuture = FencedRpcGateway.class.isAssignableFrom(this.targetType) ? this.rpcService.connect(this.targetAddress, this.fencingToken, this.targetType.asSubclass(FencedRpcGateway.class)) : this.rpcService.connect(this.targetAddress, this.targetType);
            CompletionStage rpcGatewayAcceptFuture = rpcGatewayFuture.thenAcceptAsync(rpcGateway -> {
                this.log.info("Resolved {} address, beginning registration", (Object)this.targetName);
                this.register(rpcGateway, 1, this.retryingRegistrationConfiguration.getInitialRegistrationTimeoutMillis());
            }, this.rpcService.getExecutor());
            ((CompletableFuture)rpcGatewayAcceptFuture).whenCompleteAsync((v, failure) -> {
                if (failure != null && !this.canceled) {
                    Throwable strippedFailure = ExceptionUtils.stripCompletionException((Throwable)failure);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Could not resolve {} address {}, retrying in {} ms.", new Object[]{this.targetName, this.targetAddress, this.retryingRegistrationConfiguration.getErrorDelayMillis(), strippedFailure});
                    } else {
                        this.log.info("Could not resolve {} address {}, retrying in {} ms: {}.", new Object[]{this.targetName, this.targetAddress, this.retryingRegistrationConfiguration.getErrorDelayMillis(), strippedFailure.getMessage()});
                    }
                    this.startRegistrationLater(this.retryingRegistrationConfiguration.getErrorDelayMillis());
                }
            }, this.rpcService.getExecutor());
        }
        catch (Throwable t) {
            this.completionFuture.completeExceptionally(t);
            this.cancel();
        }
    }

    private void register(G gateway, int attempt, long timeoutMillis) {
        if (this.canceled) {
            return;
        }
        try {
            this.log.info("Registration at {} attempt {} (timeout={}ms)", new Object[]{this.targetName, attempt, timeoutMillis});
            CompletableFuture<RegistrationResponse> registrationFuture = this.invokeRegistration(gateway, this.fencingToken, timeoutMillis);
            CompletionStage registrationAcceptFuture = registrationFuture.thenAcceptAsync(result -> {
                if (!this.isCanceled()) {
                    if (result instanceof RegistrationResponse.Success) {
                        RegistrationResponse.Success success = (RegistrationResponse.Success)result;
                        this.completionFuture.complete(Tuple2.of((Object)gateway, (Object)success));
                    } else {
                        if (result instanceof RegistrationResponse.Decline) {
                            RegistrationResponse.Decline decline = (RegistrationResponse.Decline)result;
                            this.log.info("Registration at {} was declined: {}", (Object)this.targetName, (Object)decline.getReason());
                        } else {
                            this.log.error("Received unknown response to registration attempt: {}", result);
                        }
                        this.log.info("Pausing and re-attempting registration in {} ms", (Object)this.retryingRegistrationConfiguration.getRefusedDelayMillis());
                        this.registerLater(gateway, 1, this.retryingRegistrationConfiguration.getInitialRegistrationTimeoutMillis(), this.retryingRegistrationConfiguration.getRefusedDelayMillis());
                    }
                }
            }, this.rpcService.getExecutor());
            ((CompletableFuture)registrationAcceptFuture).whenCompleteAsync((v, failure) -> {
                if (failure != null && !this.isCanceled()) {
                    if (ExceptionUtils.stripCompletionException((Throwable)failure) instanceof TimeoutException) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Registration at {} ({}) attempt {} timed out after {} ms", new Object[]{this.targetName, this.targetAddress, attempt, timeoutMillis});
                        }
                        long newTimeoutMillis = Math.min(2L * timeoutMillis, this.retryingRegistrationConfiguration.getMaxRegistrationTimeoutMillis());
                        this.register(gateway, attempt + 1, newTimeoutMillis);
                    } else {
                        this.log.error("Registration at {} failed due to an error", (Object)this.targetName, failure);
                        this.log.info("Pausing and re-attempting registration in {} ms", (Object)this.retryingRegistrationConfiguration.getErrorDelayMillis());
                        this.registerLater(gateway, 1, this.retryingRegistrationConfiguration.getInitialRegistrationTimeoutMillis(), this.retryingRegistrationConfiguration.getErrorDelayMillis());
                    }
                }
            }, this.rpcService.getExecutor());
        }
        catch (Throwable t) {
            this.completionFuture.completeExceptionally(t);
            this.cancel();
        }
    }

    private void registerLater(G gateway, int attempt, long timeoutMillis, long delay) {
        this.rpcService.scheduleRunnable(new Runnable((RpcGateway)gateway, attempt, timeoutMillis){
            final /* synthetic */ RpcGateway val$gateway;
            final /* synthetic */ int val$attempt;
            final /* synthetic */ long val$timeoutMillis;
            {
                this.val$gateway = rpcGateway;
                this.val$attempt = n;
                this.val$timeoutMillis = l;
            }

            @Override
            public void run() {
                RetryingRegistration.this.register(this.val$gateway, this.val$attempt, this.val$timeoutMillis);
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    private void startRegistrationLater(long delay) {
        this.rpcService.scheduleRunnable(this::startRegistration, delay, TimeUnit.MILLISECONDS);
    }
}

