/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.io.FinalizeOnMaster;
import org.apache.flink.api.common.io.InitializeOnMaster;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.core.io.InputSplitSource;
import org.apache.flink.runtime.jobgraph.InputOutputFormatContainer;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.util.Preconditions;

public class InputOutputFormatVertex
extends JobVertex {
    private static final long serialVersionUID = 1L;
    private final Map<OperatorID, String> formatDescriptions = new HashMap<OperatorID, String>();

    public InputOutputFormatVertex(String name) {
        super(name);
    }

    public InputOutputFormatVertex(String name, JobVertexID id, List<JobVertexID> alternativeIds, List<OperatorID> operatorIds, List<OperatorID> alternativeOperatorIds) {
        super(name, id, alternativeIds, operatorIds, alternativeOperatorIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeOnMaster(ClassLoader loader) throws Exception {
        InputOutputFormatContainer formatContainer = this.initInputOutputformatContainer(loader);
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            Map<OperatorID, UserCodeWrapper<InputFormat<?, ?>>> inputFormats = formatContainer.getInputFormats();
            if (inputFormats.size() > 1) {
                throw new UnsupportedOperationException("Multiple input formats are not supported in a job vertex.");
            }
            for (Map.Entry<OperatorID, UserCodeWrapper<InputFormat<?, ?>>> entry : inputFormats.entrySet()) {
                InputFormat inputFormat;
                try {
                    inputFormat = (InputFormat)entry.getValue().getUserCodeObject();
                    inputFormat.configure(formatContainer.getParameters(entry.getKey()));
                }
                catch (Throwable t) {
                    throw new Exception("Configuring the input format (" + this.getFormatDescription(entry.getKey()) + ") failed: " + t.getMessage(), t);
                }
                this.setInputSplitSource((InputSplitSource<?>)inputFormat);
            }
            Map<OperatorID, UserCodeWrapper<OutputFormat<?>>> outputFormats = formatContainer.getOutputFormats();
            for (Map.Entry<OperatorID, UserCodeWrapper<OutputFormat<?>>> entry : outputFormats.entrySet()) {
                OutputFormat outputFormat;
                try {
                    outputFormat = (OutputFormat)entry.getValue().getUserCodeObject();
                    outputFormat.configure(formatContainer.getParameters(entry.getKey()));
                }
                catch (Throwable t) {
                    throw new Exception("Configuring the output format (" + this.getFormatDescription(entry.getKey()) + ") failed: " + t.getMessage(), t);
                }
                if (!(outputFormat instanceof InitializeOnMaster)) continue;
                ((InitializeOnMaster)outputFormat).initializeGlobal(this.getParallelism());
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finalizeOnMaster(ClassLoader loader) throws Exception {
        InputOutputFormatContainer formatContainer = this.initInputOutputformatContainer(loader);
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            Map<OperatorID, UserCodeWrapper<OutputFormat<?>>> outputFormats = formatContainer.getOutputFormats();
            for (Map.Entry<OperatorID, UserCodeWrapper<OutputFormat<?>>> entry : outputFormats.entrySet()) {
                OutputFormat outputFormat;
                try {
                    outputFormat = (OutputFormat)entry.getValue().getUserCodeObject();
                    outputFormat.configure(formatContainer.getParameters(entry.getKey()));
                }
                catch (Throwable t) {
                    throw new Exception("Configuring the output format (" + this.getFormatDescription(entry.getKey()) + ") failed: " + t.getMessage(), t);
                }
                if (!(outputFormat instanceof FinalizeOnMaster)) continue;
                ((FinalizeOnMaster)outputFormat).finalizeGlobal(this.getParallelism());
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public String getFormatDescription(OperatorID operatorID) {
        return this.formatDescriptions.get((Object)operatorID);
    }

    public void setFormatDescription(OperatorID operatorID, String formatDescription) {
        this.formatDescriptions.put((OperatorID)((Object)Preconditions.checkNotNull((Object)((Object)operatorID))), formatDescription);
    }

    private InputOutputFormatContainer initInputOutputformatContainer(ClassLoader classLoader) throws Exception {
        try {
            return new InputOutputFormatContainer(new TaskConfig(this.getConfiguration()), classLoader);
        }
        catch (Throwable t) {
            throw new Exception("Loading the input/output formats failed: " + String.join((CharSequence)",", this.formatDescriptions.values()), t);
        }
    }
}

