/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.transport.netty;

import akka.actor.ActorSystem;
import akka.annotation.ApiMayChange;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.MarkerLoggingAdapter;
import akka.remote.RemoteTransportException;
import akka.remote.artery.tcp.SecureRandomFactory$;
import akka.remote.transport.netty.SSLEngineProvider;
import akka.remote.transport.netty.SSLSettings;
import akka.stream.Client$;
import akka.stream.Server$;
import akka.stream.TLSRole;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0001\u0003\u0001-\u0011qcQ8oM&<7k\u0015'F]\u001eLg.\u001a)s_ZLG-\u001a:\u000b\u0005\r!\u0011!\u00028fiRL(BA\u0003\u0007\u0003%!(/\u00198ta>\u0014HO\u0003\u0002\b\u0011\u00051!/Z7pi\u0016T\u0011!C\u0001\u0005C.\\\u0017m\u0001\u0001\u0014\u0007\u0001a!\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011\u0011cU*M\u000b:<\u0017N\\3Qe>4\u0018\u000eZ3s\u0011!9\u0002A!b\u0001\n#A\u0012a\u00017pOV\t\u0011\u0004\u0005\u0002\u001b;5\t1D\u0003\u0002\u001d\u0011\u0005)QM^3oi&\u0011ad\u0007\u0002\u0015\u001b\u0006\u00148.\u001a:M_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\t\u0011\u0001\u0002!\u0011!Q\u0001\ne\tA\u0001\\8hA!A!\u0005\u0001BC\u0002\u0013%1%\u0001\u0005tKR$\u0018N\\4t+\u0005!\u0003CA\n&\u0013\t1#AA\u0006T'2\u001bV\r\u001e;j]\u001e\u001c\b\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002\u0013M,G\u000f^5oON\u0004\u0003\"\u0002\u0016\u0001\t\u0003Y\u0013A\u0002\u001fj]&$h\bF\u0002-[9\u0002\"a\u0005\u0001\t\u000b]I\u0003\u0019A\r\t\u000b\tJ\u0003\u0019\u0001\u0013\t\u000b)\u0002A\u0011\u0001\u0019\u0015\u00051\n\u0004\"\u0002\u001a0\u0001\u0004\u0019\u0014AB:zgR,W\u000e\u0005\u00025o5\tQG\u0003\u00027\u0011\u0005)\u0011m\u0019;pe&\u0011\u0001(\u000e\u0002\f\u0003\u000e$xN]*zgR,W\u000e\u0003\u0005;\u0001!\u0015\r\u0011\"\u0003<\u0003)\u00198\u000f\\\"p]R,\u0007\u0010^\u000b\u0002yA\u0011Q\bR\u0007\u0002})\u0011q\bQ\u0001\u0004gNd'BA!C\u0003\rqW\r\u001e\u0006\u0002\u0007\u0006)!.\u0019<bq&\u0011QI\u0010\u0002\u000b'Nc5i\u001c8uKb$\b\u0002C$\u0001\u0011\u0003\u0005\u000b\u0015\u0002\u001f\u0002\u0017M\u001cHnQ8oi\u0016DH\u000f\t\u0005\u0006\u0013\u0002!\tBS\u0001\rY>\fGmS3zgR|'/\u001a\u000b\u0004\u0017Nc\u0006C\u0001'R\u001b\u0005i%B\u0001(P\u0003!\u0019XmY;sSRL(\"\u0001)\u0002\t)\fg/Y\u0005\u0003%6\u0013\u0001bS3z'R|'/\u001a\u0005\u0006)\"\u0003\r!V\u0001\tM&dWM\\1nKB\u0011a+\u0017\b\u0003\u001b]K!\u0001\u0017\b\u0002\rA\u0013X\rZ3g\u0013\tQ6L\u0001\u0004TiJLgn\u001a\u0006\u00031:AQ!\u0018%A\u0002U\u000b\u0001\u0002]1tg^|'\u000f\u001a\u0005\u0006?\u0002!\t\u0002Y\u0001\fW\u0016LX*\u00198bO\u0016\u00148/F\u0001b!\ri!\rZ\u0005\u0003G:\u0011Q!\u0011:sCf\u0004\"!P3\n\u0005\u0019t$AC&fs6\u000bg.Y4fe\")\u0001\u000e\u0001C\tS\u0006iAO];ti6\u000bg.Y4feN,\u0012A\u001b\t\u0004\u001b\t\\\u0007CA\u001fm\u0013\tigH\u0001\u0007UeV\u001cH/T1oC\u001e,'\u000fC\u0003p\u0001\u0011\u0005\u0001/\u0001\nde\u0016\fG/Z*fGV\u0014XMU1oI>lG#A9\u0011\u00051\u0013\u0018BA:N\u00051\u0019VmY;sKJ\u000bg\u000eZ8n\u0011\u0015)\b\u0001\"\u0011w\u0003U\u0019'/Z1uKN+'O^3s'NcUI\\4j]\u0016$\u0012a\u001e\t\u0003{aL!!\u001f \u0003\u0013M\u001bF*\u00128hS:,\u0007\"B>\u0001\t\u00032\u0018!F2sK\u0006$Xm\u00117jK:$8k\u0015'F]\u001eLg.\u001a\u0005\u0006{\u0002!IA`\u0001\u0010GJ,\u0017\r^3T'2+enZ5oKR\u0011qo \u0005\b\u0003\u0003a\b\u0019AA\u0002\u0003\u0011\u0011x\u000e\\3\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003\t\u0003\u0019\u0019HO]3b[&!\u0011QBA\u0004\u0005\u001d!Fj\u0015*pY\u0016Da! \u0001\u0005\n\u0005EA#B<\u0002\u0014\u0005U\u0001B\u0002\u001e\u0002\u0010\u0001\u0007A\b\u0003\u0005\u0002\u0002\u0005=\u0001\u0019AA\u0002Q\r\u0001\u0011\u0011\u0004\t\u0005\u00037\t\t#\u0004\u0002\u0002\u001e)\u0019\u0011q\u0004\u0005\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002$\u0005u!\u0001D!qS6\u000b\u0017p\u00115b]\u001e,\u0007")
@ApiMayChange
public class ConfigSSLEngineProvider
implements SSLEngineProvider {
    private final MarkerLoggingAdapter log;
    private final SSLSettings settings;
    private SSLContext sslContext;
    private volatile boolean bitmap$0;

    private SSLContext sslContext$lzycompute() {
        ConfigSSLEngineProvider configSSLEngineProvider = this;
        synchronized (configSSLEngineProvider) {
            if (!this.bitmap$0) {
                this.sslContext = this.liftedTree1$1();
                this.bitmap$0 = true;
            }
            return this.sslContext;
        }
    }

    public MarkerLoggingAdapter log() {
        return this.log;
    }

    private SSLSettings settings() {
        return this.settings;
    }

    private SSLContext sslContext() {
        return this.bitmap$0 ? this.sslContext : this.sslContext$lzycompute();
    }

    /*
     * WARNING - void declaration
     */
    public KeyStore loadKeystore(String filename, String password) {
        void var3_3;
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream fin = Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]);
        try {
            keyStore.load(fin, password.toCharArray());
        }
        catch (Throwable throwable) {
            void var4_4;
            Try$.MODULE$.apply((Function0)new Serializable(this, (InputStream)var4_4){
                public static final long serialVersionUID = 0L;
                private final InputStream fin$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.fin$1.close();
                }
                {
                    this.fin$1 = fin$1;
                }
            });
            throw throwable;
        }
        Try$.MODULE$.apply((Function0)new /* invalid duplicate definition of identical inner class */);
        return var3_3;
    }

    public KeyManager[] keyManagers() {
        KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        factory.init(this.loadKeystore(this.settings().SSLKeyStore(), this.settings().SSLKeyStorePassword()), this.settings().SSLKeyPassword().toCharArray());
        return factory.getKeyManagers();
    }

    public TrustManager[] trustManagers() {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(this.loadKeystore(this.settings().SSLTrustStore(), this.settings().SSLTrustStorePassword()));
        return trustManagerFactory.getTrustManagers();
    }

    public SecureRandom createSecureRandom() {
        return SecureRandomFactory$.MODULE$.createSecureRandom(this.settings().SSLRandomNumberGenerator(), this.log());
    }

    @Override
    public SSLEngine createServerSSLEngine() {
        return this.createSSLEngine((TLSRole)Server$.MODULE$);
    }

    @Override
    public SSLEngine createClientSSLEngine() {
        return this.createSSLEngine((TLSRole)Client$.MODULE$);
    }

    private SSLEngine createSSLEngine(TLSRole role) {
        return this.createSSLEngine(this.sslContext(), role);
    }

    /*
     * WARNING - void declaration
     */
    private SSLEngine createSSLEngine(SSLContext sslContext, TLSRole role) {
        void var3_3;
        SSLEngine engine = sslContext.createSSLEngine();
        TLSRole tLSRole = role;
        Client$ client$ = Client$.MODULE$;
        engine.setUseClientMode(!(tLSRole != null ? !tLSRole.equals(client$) : client$ != null));
        engine.setEnabledCipherSuites((String[])this.settings().SSLEnabledAlgorithms().toArray(ClassTag$.MODULE$.apply(String.class)));
        engine.setEnabledProtocols((String[])((Object[])new String[]{this.settings().SSLProtocol()}));
        TLSRole tLSRole2 = role;
        Client$ client$2 = Client$.MODULE$;
        if ((tLSRole2 == null ? client$2 != null : !tLSRole2.equals(client$2)) && this.settings().SSLRequireMutualAuthentication()) {
            engine.setNeedClientAuth(true);
        }
        return var3_3;
    }

    private final SSLContext liftedTree1$1() {
        try {
            SecureRandom rng = this.createSecureRandom();
            SSLContext ctx = SSLContext.getInstance(this.settings().SSLProtocol());
            ctx.init(this.keyManagers(), this.trustManagers(), rng);
            return ctx;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RemoteTransportException("Server SSL connection could not be established because SSL context could not be constructed", generalSecurityException);
        }
        catch (IOException iOException) {
            throw new RemoteTransportException(new StringBuilder().append((Object)"Server SSL connection could not be established because: ").append((Object)iOException.getMessage()).toString(), iOException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RemoteTransportException("Server SSL connection could not be established because key store could not be loaded", fileNotFoundException);
        }
    }

    public ConfigSSLEngineProvider(MarkerLoggingAdapter log, SSLSettings settings) {
        this.log = log;
        this.settings = settings;
    }

    public ConfigSSLEngineProvider(ActorSystem system) {
        this(Logging$.MODULE$.withMarker(system, (Object)ConfigSSLEngineProvider.class.getName(), LogSource$.MODULE$.fromString()), new SSLSettings(system.settings().config().getConfig("akka.remote.netty.ssl.security")));
    }
}

