/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public final class MaskUtils {
    public static void writeMask(boolean[] mask, DataOutputView target) throws IOException {
        int len = mask.length;
        int b = 0;
        int bytePos = 0;
        int numPos = 0;
        for (int fieldPos = 0; fieldPos < len; fieldPos += numPos) {
            b = 0;
            numPos = Math.min(8, len - fieldPos);
            for (bytePos = 0; bytePos < numPos; ++bytePos) {
                b <<= 1;
                if (!mask[fieldPos + bytePos]) continue;
                b |= 1;
            }
            target.writeByte(b <<= 8 - bytePos);
        }
    }

    public static void readIntoMask(DataInputView source, boolean[] mask) throws IOException {
        int len = mask.length;
        int b = 0;
        int bytePos = 0;
        int numPos = 0;
        for (int fieldPos = 0; fieldPos < len; fieldPos += numPos) {
            b = source.readUnsignedByte();
            numPos = Math.min(8, len - fieldPos);
            for (bytePos = 0; bytePos < numPos; ++bytePos) {
                mask[fieldPos + bytePos] = (b & 0x80) > 0;
                b <<= 1;
            }
        }
    }

    public static void readIntoAndCopyMask(DataInputView source, DataOutputView target, boolean[] mask) throws IOException {
        int len = mask.length;
        int b = 0;
        int bytePos = 0;
        int numPos = 0;
        for (int fieldPos = 0; fieldPos < len; fieldPos += numPos) {
            b = source.readUnsignedByte();
            target.writeByte(b);
            numPos = Math.min(8, len - fieldPos);
            for (bytePos = 0; bytePos < numPos; ++bytePos) {
                mask[fieldPos + bytePos] = (b & 0x80) > 0;
                b <<= 1;
            }
        }
    }
}

