/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.serialization;

import java.util.function.Function;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.util.UserCodeClassLoader;

@Internal
public final class RuntimeContextInitializationContextAdapters {
    public static DeserializationSchema.InitializationContext deserializationAdapter(RuntimeContext runtimeContext) {
        return RuntimeContextInitializationContextAdapters.deserializationAdapter(runtimeContext, Function.identity());
    }

    public static DeserializationSchema.InitializationContext deserializationAdapter(RuntimeContext runtimeContext, Function<MetricGroup, MetricGroup> mapMetricGroup) {
        return new RuntimeContextDeserializationInitializationContextAdapter(runtimeContext, mapMetricGroup);
    }

    public static SerializationSchema.InitializationContext serializationAdapter(RuntimeContext runtimeContext) {
        return RuntimeContextInitializationContextAdapters.serializationAdapter(runtimeContext, Function.identity());
    }

    public static SerializationSchema.InitializationContext serializationAdapter(RuntimeContext runtimeContext, Function<MetricGroup, MetricGroup> mapMetricGroup) {
        return new RuntimeContextSerializationInitializationContextAdapter(runtimeContext, mapMetricGroup);
    }

    private static final class RuntimeContextUserCodeClassLoaderAdapter
    implements UserCodeClassLoader {
        private final RuntimeContext runtimeContext;

        private RuntimeContextUserCodeClassLoaderAdapter(RuntimeContext runtimeContext) {
            this.runtimeContext = runtimeContext;
        }

        @Override
        public ClassLoader asClassLoader() {
            return this.runtimeContext.getUserCodeClassLoader();
        }

        @Override
        public void registerReleaseHookIfAbsent(String releaseHookName, Runnable releaseHook) {
            this.runtimeContext.registerUserCodeClassLoaderReleaseHookIfAbsent(releaseHookName, releaseHook);
        }
    }

    private static final class RuntimeContextSerializationInitializationContextAdapter
    implements SerializationSchema.InitializationContext {
        private final RuntimeContext runtimeContext;
        private final Function<MetricGroup, MetricGroup> mapMetricGroup;

        private RuntimeContextSerializationInitializationContextAdapter(RuntimeContext runtimeContext, Function<MetricGroup, MetricGroup> mapMetricGroup) {
            this.runtimeContext = runtimeContext;
            this.mapMetricGroup = mapMetricGroup;
        }

        @Override
        public MetricGroup getMetricGroup() {
            return this.mapMetricGroup.apply(this.runtimeContext.getMetricGroup());
        }

        @Override
        public UserCodeClassLoader getUserCodeClassLoader() {
            return new RuntimeContextUserCodeClassLoaderAdapter(this.runtimeContext);
        }
    }

    private static final class RuntimeContextDeserializationInitializationContextAdapter
    implements DeserializationSchema.InitializationContext {
        private final RuntimeContext runtimeContext;
        private final Function<MetricGroup, MetricGroup> mapMetricGroup;

        private RuntimeContextDeserializationInitializationContextAdapter(RuntimeContext runtimeContext, Function<MetricGroup, MetricGroup> mapMetricGroup) {
            this.runtimeContext = runtimeContext;
            this.mapMetricGroup = mapMetricGroup;
        }

        @Override
        public MetricGroup getMetricGroup() {
            return this.mapMetricGroup.apply(this.runtimeContext.getMetricGroup());
        }

        @Override
        public UserCodeClassLoader getUserCodeClassLoader() {
            return new RuntimeContextUserCodeClassLoaderAdapter(this.runtimeContext);
        }
    }
}

