/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.async;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.datastream.AsyncDataStream;
import org.apache.flink.streaming.api.functions.async.AsyncFunction;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.MailboxExecutor;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.operators.async.queue.OrderedStreamElementQueue;
import org.apache.flink.streaming.api.operators.async.queue.StreamElementQueue;
import org.apache.flink.streaming.api.operators.async.queue.UnorderedStreamElementQueue;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamElementSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingRunnable;

@Internal
public class AsyncWaitOperator<IN, OUT>
extends AbstractUdfStreamOperator<OUT, AsyncFunction<IN, OUT>>
implements OneInputStreamOperator<IN, OUT>,
BoundedOneInput {
    private static final long serialVersionUID = 1L;
    private static final String STATE_NAME = "_async_wait_operator_state_";
    private final int capacity;
    private final AsyncDataStream.OutputMode outputMode;
    private final long timeout;
    private transient StreamElementSerializer<IN> inStreamElementSerializer;
    private transient ListState<StreamElement> recoveredStreamElements;
    private transient StreamElementQueue<OUT> queue;
    private final transient MailboxExecutor mailboxExecutor;
    private transient TimestampedCollector<OUT> timestampedCollector;

    public AsyncWaitOperator(@Nonnull AsyncFunction<IN, OUT> asyncFunction, long timeout, int capacity, @Nonnull AsyncDataStream.OutputMode outputMode, @Nonnull ProcessingTimeService processingTimeService, @Nonnull MailboxExecutor mailboxExecutor) {
        super(asyncFunction);
        this.setChainingStrategy(ChainingStrategy.ALWAYS);
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"The number of concurrent async operation should be greater than 0.");
        this.capacity = capacity;
        this.outputMode = (AsyncDataStream.OutputMode)((Object)Preconditions.checkNotNull((Object)((Object)outputMode), (String)"outputMode"));
        this.timeout = timeout;
        this.processingTimeService = (ProcessingTimeService)Preconditions.checkNotNull((Object)processingTimeService);
        this.mailboxExecutor = mailboxExecutor;
    }

    @Override
    public void setup(StreamTask<?, ?> containingTask, StreamConfig config, Output<StreamRecord<OUT>> output) {
        super.setup(containingTask, config, output);
        this.inStreamElementSerializer = new StreamElementSerializer(this.getOperatorConfig().getTypeSerializerIn1(this.getUserCodeClassloader()));
        switch (this.outputMode) {
            case ORDERED: {
                this.queue = new OrderedStreamElementQueue(this.capacity);
                break;
            }
            case UNORDERED: {
                this.queue = new UnorderedStreamElementQueue(this.capacity);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown async mode: " + (Object)((Object)this.outputMode) + '.');
            }
        }
        this.timestampedCollector = new TimestampedCollector(output);
    }

    @Override
    public void open() throws Exception {
        super.open();
        if (this.recoveredStreamElements != null) {
            for (StreamElement element : (Iterable)this.recoveredStreamElements.get()) {
                if (element.isRecord()) {
                    this.processElement(element.asRecord());
                    continue;
                }
                if (element.isWatermark()) {
                    this.processWatermark(element.asWatermark());
                    continue;
                }
                if (element.isLatencyMarker()) {
                    this.processLatencyMarker(element.asLatencyMarker());
                    continue;
                }
                throw new IllegalStateException("Unknown record type " + element.getClass() + " encountered while opening the operator.");
            }
            this.recoveredStreamElements = null;
        }
    }

    @Override
    public void processElement(StreamRecord<IN> element) throws Exception {
        ResultFuture<OUT> entry = this.addToWorkQueue(element);
        ResultHandler resultHandler = new ResultHandler(element, entry);
        if (this.timeout > 0L) {
            long timeoutTimestamp = this.timeout + this.getProcessingTimeService().getCurrentProcessingTime();
            ScheduledFuture<?> timeoutTimer = this.getProcessingTimeService().registerTimer(timeoutTimestamp, timestamp -> ((AsyncFunction)this.userFunction).timeout(element.getValue(), resultHandler));
            resultHandler.setTimeoutTimer(timeoutTimer);
        }
        ((AsyncFunction)this.userFunction).asyncInvoke(element.getValue(), resultHandler);
    }

    @Override
    public void processWatermark(Watermark mark) throws Exception {
        this.addToWorkQueue(mark);
        this.outputCompletedElement();
    }

    @Override
    public void snapshotState(StateSnapshotContext context) throws Exception {
        super.snapshotState(context);
        ListState partitionableState = this.getOperatorStateBackend().getListState(new ListStateDescriptor(STATE_NAME, this.inStreamElementSerializer));
        partitionableState.clear();
        try {
            partitionableState.addAll(this.queue.values());
        }
        catch (Exception e) {
            partitionableState.clear();
            throw new Exception("Could not add stream element queue entries to operator state backend of operator " + this.getOperatorName() + '.', e);
        }
    }

    @Override
    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        this.recoveredStreamElements = context.getOperatorStateStore().getListState(new ListStateDescriptor(STATE_NAME, this.inStreamElementSerializer));
    }

    @Override
    public void endInput() throws Exception {
        this.waitInFlightInputsFinished();
    }

    private ResultFuture<OUT> addToWorkQueue(StreamElement streamElement) throws InterruptedException {
        Optional<ResultFuture<OUT>> queueEntry;
        while (!(queueEntry = this.queue.tryPut(streamElement)).isPresent()) {
            this.mailboxExecutor.yield();
        }
        return queueEntry.get();
    }

    private void waitInFlightInputsFinished() throws InterruptedException {
        while (!this.queue.isEmpty()) {
            this.mailboxExecutor.yield();
        }
    }

    private void outputCompletedElement() {
        if (this.queue.hasCompletedElements()) {
            this.queue.emitCompletedElement(this.timestampedCollector);
            if (this.queue.hasCompletedElements()) {
                this.mailboxExecutor.execute((ThrowingRunnable<? extends Exception>)((ThrowingRunnable)this::outputCompletedElement), "AsyncWaitOperator#outputCompletedElement");
            }
        }
    }

    private class ResultHandler
    implements ResultFuture<OUT> {
        private ScheduledFuture<?> timeoutTimer;
        private final StreamRecord<IN> inputRecord;
        private final ResultFuture<OUT> resultFuture;
        private final AtomicBoolean completed = new AtomicBoolean(false);

        ResultHandler(StreamRecord<IN> inputRecord, ResultFuture<OUT> resultFuture) {
            this.inputRecord = inputRecord;
            this.resultFuture = resultFuture;
        }

        void setTimeoutTimer(ScheduledFuture<?> timeoutTimer) {
            this.timeoutTimer = timeoutTimer;
        }

        @Override
        public void complete(Collection<OUT> results) {
            Preconditions.checkNotNull(results, (String)"Results must not be null, use empty collection to emit nothing");
            if (!this.completed.compareAndSet(false, true)) {
                return;
            }
            this.processInMailbox(results);
        }

        private void processInMailbox(Collection<OUT> results) {
            AsyncWaitOperator.this.mailboxExecutor.execute((ThrowingRunnable<? extends Exception>)((ThrowingRunnable)() -> this.processResults(results)), "Result in AsyncWaitOperator of input %s", results);
        }

        private void processResults(Collection<OUT> results) {
            if (this.timeoutTimer != null) {
                this.timeoutTimer.cancel(true);
            }
            this.resultFuture.complete(results);
            AsyncWaitOperator.this.outputCompletedElement();
        }

        @Override
        public void completeExceptionally(Throwable error) {
            if (!this.completed.compareAndSet(false, true)) {
                return;
            }
            AsyncWaitOperator.this.getContainingTask().getEnvironment().failExternally((Throwable)new Exception("Could not complete the stream element: " + this.inputRecord + '.', error));
            this.processInMailbox(Collections.emptyList());
        }
    }
}

