/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.partition.consumer.CheckpointableInput;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;

public abstract class IndexedInputGate
extends InputGate
implements CheckpointableInput {
    public abstract int getGateIndex();

    @Override
    public void checkpointStarted(CheckpointBarrier barrier) throws CheckpointException {
        int numChannels = this.getNumberOfInputChannels();
        for (int index = 0; index < numChannels; ++index) {
            this.getChannel(index).checkpointStarted(barrier);
        }
    }

    @Override
    public void checkpointStopped(long cancelledCheckpointId) {
        int numChannels = this.getNumberOfInputChannels();
        for (int index = 0; index < numChannels; ++index) {
            this.getChannel(index).checkpointStopped(cancelledCheckpointId);
        }
    }

    @Override
    public int getInputGateIndex() {
        return this.getGateIndex();
    }

    @Override
    public void blockConsumption(InputChannelInfo channelInfo) {
    }

    @Override
    public void convertToPriorityEvent(int channelIndex, int sequenceNumber) throws IOException {
        this.getChannel(channelIndex).convertToPriorityEvent(sequenceNumber);
    }
}

