/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.LineNumberAware;
import org.apache.camel.NamedNode;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.processor.SendDynamicProcessor;
import org.apache.camel.spi.BootstrapCloseable;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.annotations.JdkService;

@JdkService(value="processor-factory")
public class DefaultProcessorFactory
implements ProcessorFactory,
BootstrapCloseable {
    public static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/model/";
    private FactoryFinder finder;

    public void close() throws IOException {
        if (this.finder instanceof BootstrapCloseable) {
            ((BootstrapCloseable)this.finder).close();
            this.finder = null;
        }
    }

    public Processor createChildProcessor(Route route, NamedNode definition, boolean mandatory) throws Exception {
        String name = definition.getClass().getSimpleName();
        if (this.finder == null) {
            this.finder = ((ExtendedCamelContext)route.getCamelContext().adapt(ExtendedCamelContext.class)).getFactoryFinderResolver().resolveBootstrapFactoryFinder(route.getCamelContext().getClassResolver(), RESOURCE_PATH);
        }
        try {
            Object object = this.finder.newInstance(name).orElse(null);
            if (object instanceof ProcessorFactory) {
                ProcessorFactory pc = object;
                Processor processor = pc.createChildProcessor(route, definition, mandatory);
                LineNumberAware.trySetLineNumberAware((Object)processor, (LineNumberAware)definition);
                return processor;
            }
        }
        catch (NoFactoryAvailableException noFactoryAvailableException) {
            // empty catch block
        }
        return null;
    }

    public Processor createProcessor(Route route, NamedNode definition) throws Exception {
        ProcessorFactory pc;
        String name = definition.getClass().getSimpleName();
        if (this.finder == null) {
            this.finder = ((ExtendedCamelContext)route.getCamelContext().adapt(ExtendedCamelContext.class)).getFactoryFinderResolver().resolveBootstrapFactoryFinder(route.getCamelContext().getClassResolver(), RESOURCE_PATH);
        }
        if ((pc = (ProcessorFactory)this.finder.newInstance(name, ProcessorFactory.class).orElse(null)) != null) {
            Processor processor = pc.createProcessor(route, definition);
            LineNumberAware.trySetLineNumberAware((Object)processor, (LineNumberAware)definition);
            return processor;
        }
        return null;
    }

    public Processor createProcessor(CamelContext camelContext, String definitionName, Object[] args) throws Exception {
        if ("SendDynamicProcessor".equals(definitionName)) {
            String uri = (String)args[0];
            Expression expression = (Expression)args[1];
            ExchangePattern exchangePattern = (ExchangePattern)args[2];
            SendDynamicProcessor processor = new SendDynamicProcessor(uri, expression);
            processor.setCamelContext(camelContext);
            if (exchangePattern != null) {
                processor.setPattern(exchangePattern);
            }
            return processor;
        }
        if ("MulticastProcessor".equals(definitionName)) {
            Collection processors = (Collection)args[0];
            ExecutorService executor = (ExecutorService)args[1];
            boolean shutdownExecutorService = (Boolean)args[2];
            return new MulticastProcessor(camelContext, null, processors, null, true, executor, shutdownExecutorService, false, false, 0L, null, false, false);
        }
        if ("Pipeline".equals(definitionName)) {
            List processors = (List)args[0];
            return Pipeline.newInstance(camelContext, processors);
        }
        return null;
    }
}

