/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.watch.constants;

import io.methvin.watcher.DirectoryChangeEvent;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;

public enum FileEventEnum {
    CREATE,
    DELETE,
    MODIFY;


    public static FileEventEnum valueOf(DirectoryChangeEvent directoryChangeEvent) {
        return FileEventEnum.valueOf(directoryChangeEvent.eventType());
    }

    public static FileEventEnum valueOf(DirectoryChangeEvent.EventType directoryChangeEventType) {
        switch (directoryChangeEventType) {
            case CREATE: {
                return CREATE;
            }
            case DELETE: {
                return DELETE;
            }
            case MODIFY: {
                return MODIFY;
            }
        }
        return null;
    }

    public static FileEventEnum valueOf(WatchEvent<?> watchEvent) {
        if (watchEvent.context() instanceof Path) {
            return FileEventEnum.valueOf(watchEvent.kind());
        }
        return null;
    }

    public static FileEventEnum valueOf(WatchEvent.Kind<?> watchEventKind) {
        if (watchEventKind == null) {
            return null;
        }
        if (watchEventKind.equals(StandardWatchEventKinds.ENTRY_CREATE)) {
            return CREATE;
        }
        if (watchEventKind.equals(StandardWatchEventKinds.ENTRY_DELETE)) {
            return DELETE;
        }
        if (watchEventKind.equals(StandardWatchEventKinds.ENTRY_MODIFY)) {
            return MODIFY;
        }
        return null;
    }

    public WatchEvent.Kind<Path> kind() {
        switch (this) {
            case CREATE: {
                return StandardWatchEventKinds.ENTRY_CREATE;
            }
            case MODIFY: {
                return StandardWatchEventKinds.ENTRY_MODIFY;
            }
            case DELETE: {
                return StandardWatchEventKinds.ENTRY_DELETE;
            }
        }
        return null;
    }

    public DirectoryChangeEvent.EventType eventType() {
        switch (this) {
            case CREATE: {
                return DirectoryChangeEvent.EventType.CREATE;
            }
            case MODIFY: {
                return DirectoryChangeEvent.EventType.MODIFY;
            }
            case DELETE: {
                return DirectoryChangeEvent.EventType.DELETE;
            }
        }
        return null;
    }
}

