/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.watch;

import io.methvin.watcher.hashing.FileHasher;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.file.watch.FileWatchEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="file-watch")
public class FileWatchComponent
extends DefaultComponent {
    public static final String EVENT_TYPE_HEADER = "CamelFileEventType";
    @Metadata(label="consumer", description="The number of concurrent consumers. Increase this value, if your route is slow to prevent buffering in queue.", defaultValue="1")
    private int concurrentConsumers = 1;
    @Metadata(label="consumer", description="Maximum size of queue between WatchService and consumer. Unbounded by default.", defaultValue="2147483647")
    private int queueSize = Integer.MAX_VALUE;
    @Metadata(label="consumer", description="The number of threads polling WatchService. Increase this value, if you see OVERFLOW messages in log.", defaultValue="1")
    private int pollThreads = 1;
    @Metadata(label="consumer", description="Reference to io.methvin.watcher.hashing.FileHasher. This prevents emitting duplicate events on some platforms. For working with large files and if you dont need detect multiple modifications per second per file, use #lastModifiedTimeFileHasher. You can also provide custom implementation in registry.", defaultValue="#murmur3FFileHasher")
    private FileHasher fileHasher = FileHasher.DEFAULT_FILE_HASHER;
    @Metadata(label="consumer", description="Enables or disables file hashing to detect duplicate events. If you disable this, you can get some events multiple times on some platforms and JDKs. Check java.nio.file.WatchService limitations for your target platform.", defaultValue="true")
    private boolean useFileHashing = true;

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getPollThreads() {
        return this.pollThreads;
    }

    public void setPollThreads(int pollThreads) {
        this.pollThreads = pollThreads;
    }

    public FileHasher getFileHasher() {
        return this.fileHasher;
    }

    public void setFileHasher(FileHasher fileHasher) {
        this.fileHasher = fileHasher;
    }

    public boolean isUseFileHashing() {
        return this.useFileHashing;
    }

    public void setUseFileHashing(boolean useFileHashing) {
        this.useFileHashing = useFileHashing;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        FileWatchEndpoint endpoint = new FileWatchEndpoint(uri, remaining, this);
        if (parameters.containsKey("events")) {
            endpoint.setEvents(parameters.get("events").toString());
            parameters.remove("events");
        }
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    protected void doInit() throws Exception {
        super.doInit();
        Registry registry = this.getCamelContext().getRegistry();
        registry.bind("murmur3FFileHasher", FileHasher.class, (Object)FileHasher.DEFAULT_FILE_HASHER);
        registry.bind("lastModifiedTimeFileHasher", FileHasher.class, (Object)FileHasher.LAST_MODIFIED_TIME);
    }
}

