/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterExists;
import org.apache.camel.TypeConverterExistsException;
import org.apache.camel.TypeConverters;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.impl.converter.EnumTypeConverter;
import org.apache.camel.spi.BulkTypeConverters;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.DoubleMap;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreTypeConverterRegistry
extends ServiceSupport
implements TypeConverter,
TypeConverterRegistry {
    protected static final TypeConverter MISS_CONVERTER = new TypeConverterSupport(){

        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            return (T)MISS_VALUE;
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(CoreTypeConverterRegistry.class);
    protected final List<BulkTypeConverters> bulkTypeConverters = new ArrayList<BulkTypeConverters>();
    protected final DoubleMap<Class<?>, Class<?>, TypeConverter> typeMappings = new DoubleMap(16);
    protected final List<FallbackTypeConverter> fallbackConverters = new CopyOnWriteArrayList<FallbackTypeConverter>();
    protected final TypeConverter enumTypeConverter = new EnumTypeConverter();
    protected final TypeConverterRegistry.Statistics statistics = new UtilizationStatistics();
    protected final LongAdder noopCounter = new LongAdder();
    protected final LongAdder attemptCounter = new LongAdder();
    protected final LongAdder missCounter = new LongAdder();
    protected final LongAdder hitCounter = new LongAdder();
    protected final LongAdder failedCounter = new LongAdder();
    protected TypeConverterExists typeConverterExists = TypeConverterExists.Override;
    protected LoggingLevel typeConverterExistsLoggingLevel = LoggingLevel.WARN;
    private int sumBulkTypeConverters;

    public CoreTypeConverterRegistry() {
    }

    public CoreTypeConverterRegistry(TypeConverterRegistry registry) {
        if (!(registry instanceof CoreTypeConverterRegistry)) {
            throw new UnsupportedOperationException();
        }
        CoreTypeConverterRegistry reg = (CoreTypeConverterRegistry)registry;
        reg.getTypeMappings().forEach((arg_0, arg_1, arg_2) -> this.typeMappings.put(arg_0, arg_1, arg_2));
        this.bulkTypeConverters.addAll(reg.getBulkTypeConverters());
        this.fallbackConverters.addAll(reg.getFallbackConverters());
        this.typeConverterExistsLoggingLevel = registry.getTypeConverterExistsLoggingLevel();
        this.typeConverterExists = registry.getTypeConverterExists();
    }

    public boolean allowNull() {
        return false;
    }

    public void setInjector(Injector injector) {
        throw new UnsupportedOperationException();
    }

    public Injector getInjector() {
        throw new UnsupportedOperationException();
    }

    public void setCamelContext(CamelContext camelContext) {
        throw new UnsupportedOperationException();
    }

    public CamelContext getCamelContext() {
        throw new UnsupportedOperationException();
    }

    public DoubleMap<Class<?>, Class<?>, TypeConverter> getTypeMappings() {
        return this.typeMappings;
    }

    public List<FallbackTypeConverter> getFallbackConverters() {
        return this.fallbackConverters;
    }

    public List<BulkTypeConverters> getBulkTypeConverters() {
        return this.bulkTypeConverters;
    }

    public <T> T convertTo(Class<T> type, Object value) {
        return this.convertTo(type, null, value);
    }

    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        if (value != null) {
            if (type.isInstance(value)) {
                return (T)value;
            }
            if (type == Boolean.TYPE) {
                Boolean answer = ObjectConverter.toBoolean(value);
                if (answer == null) {
                    throw new TypeConversionException(value, type, (Throwable)new IllegalArgumentException("Cannot convert type: " + value.getClass().getName() + " to boolean"));
                }
                return (T)answer;
            }
            if (type == Boolean.class && value instanceof String) {
                String str = (String)value;
                int len = str.length();
                if (len == 4 && "true".equals(str)) {
                    return (T)Boolean.TRUE;
                }
                if (len == 5 && "false".equals(str)) {
                    return (T)Boolean.FALSE;
                }
                str = str.toUpperCase();
                if (len == 4 && "TRUE".equals(str)) {
                    return (T)Boolean.TRUE;
                }
                if (len == 5 && "FALSE".equals(str)) {
                    return (T)Boolean.FALSE;
                }
            } else if (type.isPrimitive()) {
                Class<?> cls = value.getClass();
                if (cls == Integer.class || cls == Long.class) {
                    return (T)value;
                }
            } else if (type == String.class) {
                Class<?> cls = value.getClass();
                if (cls.isPrimitive() || cls == Boolean.class || cls == Integer.class || cls == Long.class) {
                    return (T)value.toString();
                }
            } else if (type.isEnum()) {
                try {
                    return (T)this.enumTypeConverter.convertTo(type, exchange, value);
                }
                catch (Exception e) {
                    throw this.createTypeConversionException(exchange, type, value, e);
                }
            }
        }
        return (T)this.doConvertTo(type, exchange, value, false, false);
    }

    public <T> T mandatoryConvertTo(Class<T> type, Object value) throws NoTypeConversionAvailableException {
        return this.mandatoryConvertTo(type, null, value);
    }

    public <T> T mandatoryConvertTo(Class<T> type, Exchange exchange, Object value) throws NoTypeConversionAvailableException {
        Object answer;
        if (value != null) {
            Class<?> cls;
            if (type.isInstance(value)) {
                return (T)value;
            }
            if (type == Boolean.TYPE) {
                Boolean answer2 = ObjectConverter.toBoolean(value);
                if (answer2 == null) {
                    throw new TypeConversionException(value, type, (Throwable)new IllegalArgumentException("Cannot convert type: " + value.getClass().getName() + " to boolean"));
                }
                return (T)answer2;
            }
            if (type == Boolean.class && value instanceof String) {
                String str = (String)value;
                int len = str.length();
                if (len == 4 && "true".equals(str)) {
                    return (T)Boolean.TRUE;
                }
                if (len == 5 && "false".equals(str)) {
                    return (T)Boolean.FALSE;
                }
                str = str.toUpperCase();
                if (len == 4 && "TRUE".equals(str)) {
                    return (T)Boolean.TRUE;
                }
                if (len == 5 && "FALSE".equals(str)) {
                    return (T)Boolean.FALSE;
                }
            } else if (type.isPrimitive()) {
                cls = value.getClass();
                if (cls == Integer.class || cls == Long.class) {
                    return (T)value;
                }
            } else if (type == String.class) {
                cls = value.getClass();
                if (cls.isPrimitive() || cls == Boolean.class || cls == Integer.class || cls == Long.class) {
                    return (T)value.toString();
                }
            } else if (type.isEnum()) {
                try {
                    return (T)this.enumTypeConverter.convertTo(type, exchange, value);
                }
                catch (Exception e) {
                    throw this.createTypeConversionException(exchange, type, value, e);
                }
            }
        }
        if ((answer = this.doConvertTo(type, exchange, value, true, false)) == null) {
            throw new NoTypeConversionAvailableException(value, type);
        }
        return (T)answer;
    }

    public <T> T tryConvertTo(Class<T> type, Object value) {
        return this.tryConvertTo(type, null, value);
    }

    public <T> T tryConvertTo(Class<T> type, Exchange exchange, Object value) {
        if (value != null) {
            if (type.isInstance(value)) {
                return (T)value;
            }
            if (type == Boolean.TYPE) {
                Boolean answer = ObjectConverter.toBoolean(value);
                if (answer == null) {
                    throw new TypeConversionException(value, type, (Throwable)new IllegalArgumentException("Cannot convert type: " + value.getClass().getName() + " to boolean"));
                }
                return (T)answer;
            }
            if (type == Boolean.class && value instanceof String) {
                String str = (String)value;
                int len = str.length();
                if (len == 4 && "true".equals(str)) {
                    return (T)Boolean.TRUE;
                }
                if (len == 5 && "false".equals(str)) {
                    return (T)Boolean.FALSE;
                }
                str = str.toUpperCase();
                if (len == 4 && "TRUE".equals(str)) {
                    return (T)Boolean.TRUE;
                }
                if (len == 5 && "FALSE".equals(str)) {
                    return (T)Boolean.FALSE;
                }
            } else if (type.isPrimitive()) {
                Class<?> cls = value.getClass();
                if (cls == Integer.class || cls == Long.class) {
                    return (T)value;
                }
            } else if (type == String.class) {
                Class<?> cls = value.getClass();
                if (cls.isPrimitive() || cls == Boolean.class || cls == Integer.class || cls == Long.class) {
                    return (T)value.toString();
                }
            } else if (type.isEnum()) {
                try {
                    return (T)this.enumTypeConverter.convertTo(type, exchange, value);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return (T)this.doConvertTo(type, exchange, value, false, true);
    }

    protected Object doConvertTo(Class<?> type, Exchange exchange, Object value, boolean mandatory, boolean tryConvert) {
        Object answer;
        try {
            answer = this.doConvertTo(type, exchange, value, tryConvert);
        }
        catch (Exception e) {
            boolean execution;
            if (this.statistics.isStatisticsEnabled()) {
                this.failedCounter.increment();
            }
            if (tryConvert) {
                return null;
            }
            boolean bl = execution = ObjectHelper.getException(ExecutionException.class, (Throwable)e) != null || ObjectHelper.getException(CamelExecutionException.class, (Throwable)e) != null;
            if (execution) {
                throw CamelExecutionException.wrapCamelExecutionException((Exchange)exchange, (Throwable)e);
            }
            throw this.createTypeConversionException(exchange, type, value, e);
        }
        if (answer == TypeConverter.MISS_VALUE) {
            if (this.statistics.isStatisticsEnabled()) {
                this.missCounter.increment();
            }
            return null;
        }
        if (this.statistics.isStatisticsEnabled()) {
            this.hitCounter.increment();
        }
        return answer;
    }

    protected Object doConvertTo(Class<?> type, Exchange exchange, Object value, boolean tryConvert) throws Exception {
        Object rc;
        Class<?> fromType;
        TypeConverter tc;
        Class primitiveType;
        boolean trace = LOG.isTraceEnabled();
        boolean statisticsEnabled = this.statistics.isStatisticsEnabled();
        if (trace) {
            LOG.trace("Finding type converter to convert {} -> {} with value: {}", new Object[]{value == null ? "null" : value.getClass().getCanonicalName(), type.getCanonicalName(), value});
        }
        if (value == null) {
            if (statisticsEnabled) {
                this.noopCounter.increment();
            }
            if (type.isPrimitive()) {
                if (Boolean.TYPE == type) {
                    return Boolean.FALSE;
                }
                if (Integer.TYPE == type) {
                    return 0;
                }
                if (Long.TYPE == type) {
                    return 0L;
                }
                if (Byte.TYPE == type) {
                    return (byte)0;
                }
                if (Short.TYPE == type) {
                    return (short)0;
                }
                if (Double.TYPE == type) {
                    return 0.0;
                }
                if (Float.TYPE == type) {
                    return Float.valueOf(0.0f);
                }
                if (Character.TYPE == type) {
                    return Character.valueOf('\u0000');
                }
            }
            return null;
        }
        if (type.isInstance(value)) {
            if (statisticsEnabled) {
                this.noopCounter.increment();
            }
            return value;
        }
        if (statisticsEnabled) {
            this.attemptCounter.increment();
        }
        for (BulkTypeConverters bulk : this.bulkTypeConverters) {
            Object rc2;
            if (trace) {
                LOG.trace("Using bulk converter: {} to convert [{}=>{}]", new Object[]{bulk.getClass().getSimpleName(), value.getClass(), type});
            }
            if ((rc2 = tryConvert ? bulk.convertTo(value.getClass(), type, exchange, value) : bulk.convertTo(value.getClass(), type, exchange, value)) == null) continue;
            return rc2;
        }
        TypeConverter converter = this.getOrFindTypeConverter(type, value.getClass());
        if (converter != null) {
            Object rc3;
            if (trace) {
                LOG.trace("Using converter: {} to convert [{}=>{}]", new Object[]{converter, value.getClass(), type});
            }
            if ((rc3 = tryConvert ? converter.tryConvertTo(type, exchange, value) : converter.convertTo(type, exchange, value)) != null) {
                return rc3;
            }
            if (converter.allowNull()) {
                return null;
            }
        }
        if (type.isPrimitive() && (primitiveType = ObjectHelper.convertPrimitiveTypeToWrapperType(type)) != type && (tc = this.getOrFindTypeConverter(primitiveType, fromType = value.getClass())) != null) {
            this.addTypeConverter(type, fromType, tc);
            rc = tryConvert ? tc.tryConvertTo(primitiveType, exchange, value) : tc.convertTo(primitiveType, exchange, value);
            if (rc == null && tc.allowNull()) {
                return null;
            }
            if (rc != null) {
                return rc;
            }
        }
        for (FallbackTypeConverter fallback : this.fallbackConverters) {
            tc = fallback.getFallbackTypeConverter();
            rc = tryConvert ? tc.tryConvertTo(type, exchange, value) : tc.convertTo(type, exchange, value);
            if (rc == null && tc.allowNull()) {
                return null;
            }
            if (rc == TypeConverter.MISS_VALUE) {
                return TypeConverter.MISS_VALUE;
            }
            if (rc == null) continue;
            if (fallback.isCanPromote()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Promoting fallback type converter as a known type converter to convert from: {} to: {} for the fallback converter: {}", new Object[]{type.getCanonicalName(), value.getClass().getCanonicalName(), fallback.getFallbackTypeConverter()});
                }
                this.addTypeConverter(type, value.getClass(), fallback.getFallbackTypeConverter());
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Fallback type converter {} converted type from: {} to: {}", new Object[]{fallback.getFallbackTypeConverter(), type.getCanonicalName(), value.getClass().getCanonicalName()});
            }
            return rc;
        }
        if (!tryConvert) {
            this.typeMappings.put(type, value.getClass(), (Object)MISS_CONVERTER);
        }
        return TypeConverter.MISS_VALUE;
    }

    public TypeConverter getTypeConverter(Class<?> toType, Class<?> fromType) {
        return (TypeConverter)this.typeMappings.get(toType, fromType);
    }

    public void addBulkTypeConverters(BulkTypeConverters bulkTypeConverters) {
        boolean exists = this.bulkTypeConverters.contains(bulkTypeConverters);
        if (!exists) {
            if (bulkTypeConverters.getOrder() == Integer.MIN_VALUE) {
                this.bulkTypeConverters.add(0, bulkTypeConverters);
            } else {
                this.bulkTypeConverters.add(bulkTypeConverters);
            }
            this.sumBulkTypeConverters += bulkTypeConverters.size();
        }
    }

    public void addTypeConverter(Class<?> toType, Class<?> fromType, TypeConverter typeConverter) {
        LOG.trace("Adding type converter: {}", (Object)typeConverter);
        TypeConverter converter = (TypeConverter)this.typeMappings.get(toType, fromType);
        if (typeConverter != converter) {
            boolean add = true;
            if (converter != null) {
                if (this.typeConverterExists == TypeConverterExists.Override) {
                    CamelLogger logger = new CamelLogger(LOG, this.typeConverterExistsLoggingLevel);
                    logger.log("Overriding type converter from: " + converter + " to: " + typeConverter);
                } else if (this.typeConverterExists == TypeConverterExists.Ignore) {
                    CamelLogger logger = new CamelLogger(LOG, this.typeConverterExistsLoggingLevel);
                    logger.log("Ignoring duplicate type converter from: " + converter + " to: " + typeConverter);
                    add = false;
                } else {
                    throw new TypeConverterExistsException(toType, fromType);
                }
            }
            if (add) {
                this.typeMappings.put(toType, fromType, (Object)typeConverter);
            }
        }
    }

    public boolean removeTypeConverter(Class<?> toType, Class<?> fromType) {
        LOG.trace("Removing type converter from: {} to: {}", fromType, toType);
        return this.typeMappings.remove(toType, fromType);
    }

    public void addTypeConverters(TypeConverters typeConverters) {
        throw new UnsupportedOperationException();
    }

    public void addFallbackTypeConverter(TypeConverter typeConverter, boolean canPromote) {
        LOG.trace("Adding fallback type converter: {} which can promote: {}", (Object)typeConverter, (Object)canPromote);
        this.fallbackConverters.add(0, new FallbackTypeConverter(typeConverter, canPromote));
    }

    public TypeConverter lookup(Class<?> toType, Class<?> fromType) {
        return this.doLookup(toType, fromType, false);
    }

    protected TypeConverter getOrFindTypeConverter(Class<?> toType, Class<?> fromType) {
        TypeConverter converter = (TypeConverter)this.typeMappings.get(toType, fromType);
        if (converter == null && (converter = this.lookup(toType, fromType)) != null) {
            this.typeMappings.put(toType, fromType, (Object)converter);
        }
        return converter;
    }

    protected TypeConverter doLookup(Class<?> toType, Class<?> fromType, boolean isSuper) {
        TypeConverter converter;
        if (fromType != null) {
            for (BulkTypeConverters base : this.bulkTypeConverters) {
                converter = base.lookup(toType, fromType);
                if (converter == null) continue;
                return converter;
            }
            converter = this.getTypeConverter(toType, fromType);
            if (converter != null) {
                return converter;
            }
            for (Class<?> type : fromType.getInterfaces()) {
                converter = this.getTypeConverter(toType, type);
                if (converter == null) continue;
                return converter;
            }
            Class<?> fromSuperClass = fromType.getSuperclass();
            if (fromSuperClass != null && !fromSuperClass.equals(Object.class) && (converter = this.doLookup(toType, fromSuperClass, true)) != null) {
                return converter;
            }
        }
        if (!isSuper && fromType != null && !fromType.equals(Object.class)) {
            converter = (TypeConverter)this.typeMappings.getFirst(toType::isAssignableFrom, from -> !from.equals(Object.class) && from.isAssignableFrom(fromType));
            if (converter != null) {
                return converter;
            }
            converter = this.getTypeConverter(toType, Object.class);
            if (converter != null) {
                return converter;
            }
        }
        return null;
    }

    protected TypeConversionException createTypeConversionException(Exchange exchange, Class<?> type, Object value, Throwable cause) {
        if (cause instanceof TypeConversionException && ((TypeConversionException)cause).getToType() == type) {
            return (TypeConversionException)cause;
        }
        Object body = exchange != null ? MessageHelper.extractValueForLogging((Object)value, (Message)exchange.getIn()) : value;
        return new TypeConversionException(body, type, cause);
    }

    public TypeConverterRegistry.Statistics getStatistics() {
        return this.statistics;
    }

    public int size() {
        return this.typeMappings.size() + this.sumBulkTypeConverters;
    }

    public LoggingLevel getTypeConverterExistsLoggingLevel() {
        return this.typeConverterExistsLoggingLevel;
    }

    public void setTypeConverterExistsLoggingLevel(LoggingLevel typeConverterExistsLoggingLevel) {
        this.typeConverterExistsLoggingLevel = typeConverterExistsLoggingLevel;
    }

    public TypeConverterExists getTypeConverterExists() {
        return this.typeConverterExists;
    }

    public void setTypeConverterExists(TypeConverterExists typeConverterExists) {
        this.typeConverterExists = typeConverterExists;
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.statistics.isStatisticsEnabled()) {
            String info = this.statistics.toString();
            AtomicInteger misses = new AtomicInteger();
            this.typeMappings.forEach((k1, k2, v) -> {
                if (v == MISS_CONVERTER) {
                    misses.incrementAndGet();
                }
            });
            info = info + String.format(" mappings[total=%s, misses=%s]", this.size(), misses);
            LOG.info(info);
        }
        this.typeMappings.clear();
        this.statistics.reset();
    }

    public static class FallbackTypeConverter {
        private final boolean canPromote;
        private final TypeConverter fallbackTypeConverter;

        FallbackTypeConverter(TypeConverter fallbackTypeConverter, boolean canPromote) {
            this.canPromote = canPromote;
            this.fallbackTypeConverter = fallbackTypeConverter;
        }

        public boolean isCanPromote() {
            return this.canPromote;
        }

        public TypeConverter getFallbackTypeConverter() {
            return this.fallbackTypeConverter;
        }
    }

    private final class UtilizationStatistics
    implements TypeConverterRegistry.Statistics {
        private boolean statisticsEnabled;

        private UtilizationStatistics() {
        }

        public long getNoopCounter() {
            return CoreTypeConverterRegistry.this.noopCounter.longValue();
        }

        public long getAttemptCounter() {
            return CoreTypeConverterRegistry.this.attemptCounter.longValue();
        }

        public long getHitCounter() {
            return CoreTypeConverterRegistry.this.hitCounter.longValue();
        }

        public long getMissCounter() {
            return CoreTypeConverterRegistry.this.missCounter.longValue();
        }

        public long getFailedCounter() {
            return CoreTypeConverterRegistry.this.failedCounter.longValue();
        }

        public void reset() {
            CoreTypeConverterRegistry.this.noopCounter.reset();
            CoreTypeConverterRegistry.this.attemptCounter.reset();
            CoreTypeConverterRegistry.this.hitCounter.reset();
            CoreTypeConverterRegistry.this.missCounter.reset();
            CoreTypeConverterRegistry.this.failedCounter.reset();
        }

        public boolean isStatisticsEnabled() {
            return this.statisticsEnabled;
        }

        public void setStatisticsEnabled(boolean statisticsEnabled) {
            this.statisticsEnabled = statisticsEnabled;
        }

        public String toString() {
            return String.format("TypeConverterRegistry utilization[noop=%s, attempts=%s, hits=%s, misses=%s, failures=%s]", this.getNoopCounter(), this.getAttemptCounter(), this.getHitCounter(), this.getMissCounter(), this.getFailedCounter());
        }
    }
}

