/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.StaticService;
import org.apache.camel.impl.engine.CompoundIterator;
import org.apache.camel.spi.RouteController;
import org.apache.camel.support.LRUCache;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.service.ServiceHelper;

public class AbstractDynamicRegistry<K, V>
extends AbstractMap<K, V>
implements StaticService {
    protected final ExtendedCamelContext context;
    protected final RouteController routeController;
    protected final int maxCacheSize;
    protected final Map<K, V> dynamicMap;
    protected final Map<K, V> staticMap;

    public AbstractDynamicRegistry(CamelContext context, int maxCacheSize) {
        this.context = (ExtendedCamelContext)context;
        this.routeController = context.getRouteController();
        this.maxCacheSize = maxCacheSize;
        this.dynamicMap = LRUCacheFactory.newLRUCache((int)this.maxCacheSize, (int)this.maxCacheSize, (boolean)false);
        this.staticMap = new ConcurrentHashMap();
    }

    public void start() {
        if (this.dynamicMap instanceof LRUCache) {
            ((LRUCache)this.dynamicMap).resetStatistics();
        }
    }

    @Override
    public V get(Object o) {
        V answer = this.staticMap.get(o);
        if (answer == null && (answer = this.dynamicMap.get(o)) != null && (this.context.isSetupRoutes() || this.routeController.isStartingRoutes())) {
            this.dynamicMap.remove(o);
            this.staticMap.put(o, answer);
        }
        return answer;
    }

    @Override
    public V put(K key, V transformer) {
        V answer = this.staticMap.remove(key);
        if (answer != null) {
            this.staticMap.put(key, transformer);
            return answer;
        }
        answer = this.dynamicMap.remove(key);
        if (answer != null) {
            this.dynamicMap.put(key, transformer);
            return answer;
        }
        answer = this.context.isSetupRoutes() || this.routeController.isStartingRoutes() ? this.staticMap.put(key, transformer) : this.dynamicMap.put(key, transformer);
        return answer;
    }

    @Override
    public boolean containsKey(Object o) {
        return this.staticMap.containsKey(o) || this.dynamicMap.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.staticMap.containsValue(o) || this.dynamicMap.containsValue(o);
    }

    @Override
    public int size() {
        return this.staticMap.size() + this.dynamicMap.size();
    }

    public int staticSize() {
        return this.staticMap.size();
    }

    public int dynamicSize() {
        return this.dynamicMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.staticMap.isEmpty() && this.dynamicMap.isEmpty();
    }

    @Override
    public V remove(Object o) {
        V answer = this.staticMap.remove(o);
        if (answer == null) {
            answer = this.dynamicMap.remove(o);
        }
        return answer;
    }

    @Override
    public void clear() {
        this.staticMap.clear();
        this.dynamicMap.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new CompoundIterator(Arrays.asList(AbstractDynamicRegistry.this.staticMap.entrySet().iterator(), AbstractDynamicRegistry.this.dynamicMap.entrySet().iterator()));
            }

            @Override
            public int size() {
                return AbstractDynamicRegistry.this.staticMap.size() + AbstractDynamicRegistry.this.dynamicMap.size();
            }
        };
    }

    public int getMaximumCacheSize() {
        return this.maxCacheSize;
    }

    public void purge() {
        this.dynamicMap.clear();
    }

    public void cleanUp() {
        if (this.dynamicMap instanceof LRUCache) {
            ((LRUCache)this.dynamicMap).cleanUp();
        }
    }

    public boolean isStatic(K key) {
        return this.staticMap.containsKey(key);
    }

    public boolean isDynamic(K key) {
        return this.dynamicMap.containsKey(key);
    }

    public void stop() {
        ServiceHelper.stopService((Object[])new Object[]{this.staticMap.values(), this.dynamicMap.values()});
        this.purge();
    }

    @Override
    public String toString() {
        return "Registry for " + this.context.getName() + ", capacity: " + this.maxCacheSize;
    }
}

