/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.serde;

import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.utils.serde.AbstractKafkaStrategyAwareSerDe;
import io.apicurio.registry.utils.serde.strategy.ArtifactIdStrategy;
import io.apicurio.registry.utils.serde.strategy.GlobalIdStrategy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;

public abstract class AbstractKafkaSerializer<T, U, S extends AbstractKafkaSerializer<T, U, S>>
extends AbstractKafkaStrategyAwareSerDe<T, S>
implements Serializer<U> {
    public AbstractKafkaSerializer() {
        this(null);
    }

    public AbstractKafkaSerializer(RegistryService client) {
        super(client);
    }

    public AbstractKafkaSerializer(RegistryService client, ArtifactIdStrategy<T> artifactIdStrategy, GlobalIdStrategy<T> globalIdStrategy) {
        super(client, artifactIdStrategy, globalIdStrategy);
    }

    protected abstract T toSchema(U var1);

    protected abstract ArtifactType artifactType();

    protected abstract void serializeData(T var1, U var2, OutputStream var3) throws IOException;

    protected abstract void serializeData(Headers var1, T var2, U var3, ByteArrayOutputStream var4) throws IOException;

    public byte[] serialize(String topic, U data) {
        return this.serialize(topic, null, data);
    }

    public byte[] serialize(String topic, Headers headers, U data) {
        if (data == null) {
            return null;
        }
        try {
            T schema = this.toSchema(data);
            String artifactId = this.getArtifactIdStrategy().artifactId(topic, this.isKey(), schema);
            long id = this.getGlobalIdStrategy().findId(this.getClient(), artifactId, this.artifactType(), schema);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (this.headerUtils != null) {
                this.headerUtils.addSchemaHeaders(headers, artifactId, id);
                this.serializeData(headers, schema, data, out);
            } else {
                out.write(0);
                this.getIdHandler().writeId(id, out);
                this.serializeData(schema, data, out);
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

