/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.watch;

import io.methvin.watcher.DirectoryChangeEvent;
import io.methvin.watcher.DirectoryChangeListener;
import io.methvin.watcher.DirectoryWatcher;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.file.watch.FileWatchEndpoint;
import org.apache.camel.component.file.watch.constants.FileEvent;
import org.apache.camel.component.file.watch.utils.PathUtils;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatchConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(FileWatchConsumer.class);
    private ExecutorService watchDirExecutorService;
    private ExecutorService pollExecutorService;
    private LinkedBlockingQueue<FileEvent> eventQueue = this.getEndpoint().getQueueSize() <= 0 ? new LinkedBlockingQueue() : new LinkedBlockingQueue(this.getEndpoint().getQueueSize());
    private Path baseDirectory;
    private AntPathMatcher antPathMatcher = new AntPathMatcher();
    private DirectoryWatcher watcher;

    public FileWatchConsumer(FileWatchEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.baseDirectory = Paths.get(this.getEndpoint().getPath(), new String[0]).toAbsolutePath();
    }

    protected void doStart() throws Exception {
        int i;
        super.doStart();
        if (!Files.exists(this.baseDirectory, new LinkOption[0])) {
            if (this.getEndpoint().isAutoCreate()) {
                this.baseDirectory = Files.createDirectories(this.baseDirectory, new FileAttribute[0]);
            } else {
                throw new IllegalArgumentException("Path must exists when autoCreate = false");
            }
        }
        if (!Files.isDirectory(this.baseDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Parameter path must be directory, %s given", this.baseDirectory.toString()));
        }
        DirectoryWatcher.Builder watcherBuilder = DirectoryWatcher.builder().path(this.baseDirectory).logger(LOG).listener((DirectoryChangeListener)new FileWatchDirectoryChangeListener());
        if (!System.getProperty("os.name").toLowerCase().contains("mac")) {
            watcherBuilder.watchService(this.baseDirectory.getFileSystem().newWatchService());
        }
        watcherBuilder.fileHashing(this.getEndpoint().isUseFileHashing());
        if (this.getEndpoint().getFileHasher() != null && this.getEndpoint().isUseFileHashing()) {
            watcherBuilder.fileHasher(this.getEndpoint().getFileHasher());
        }
        this.watcher = watcherBuilder.build();
        this.watchDirExecutorService = this.getEndpoint().getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, "CamelFileWatchService", this.getEndpoint().getPollThreads());
        this.pollExecutorService = this.getEndpoint().getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, "CamelFileWatchPoll", this.getEndpoint().getConcurrentConsumers());
        for (i = 0; i < this.getEndpoint().getPollThreads(); ++i) {
            this.watcher.watchAsync((Executor)this.watchDirExecutorService);
        }
        for (i = 0; i < this.getEndpoint().getConcurrentConsumers(); ++i) {
            this.pollExecutorService.submit(new PollRunnable());
        }
    }

    protected void doStop() throws Exception {
        if (this.watcher != null) {
            this.watcher.close();
        }
        if (this.watchDirExecutorService != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.watchDirExecutorService);
        }
        if (this.pollExecutorService != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.pollExecutorService);
        }
        super.doStop();
    }

    protected void doSuspend() throws Exception {
        this.doStop();
    }

    protected void doResume() throws Exception {
        this.doStart();
    }

    private Exchange prepareExchange(FileEvent event) {
        Exchange exchange = this.getEndpoint().createExchange();
        File file = event.getEventPath().toFile();
        Message message = exchange.getIn();
        message.setBody((Object)file);
        message.setHeader("CamelFileEventType", (Object)event.getEventType());
        message.setHeader("CamelFileNameOnly", (Object)event.getEventPath().getFileName().toString());
        message.setHeader("CamelFileAbsolute", (Object)true);
        String absolutePath = PathUtils.normalizeToString(event.getEventPath().toAbsolutePath());
        message.setHeader("CamelFileAbsolutePath", (Object)absolutePath);
        message.setHeader("CamelFilePath", (Object)absolutePath);
        String relativePath = PathUtils.normalizeToString(this.baseDirectory.relativize(event.getEventPath()));
        message.setHeader("CamelFileName", (Object)relativePath);
        message.setHeader("CamelFileRelativePath", (Object)relativePath);
        message.setHeader("CamelFileNameConsumed", (Object)relativePath);
        message.setHeader("CamelFileParent", (Object)PathUtils.normalizeToString(event.getEventPath().getParent().toAbsolutePath()));
        message.setHeader("CamelFileLastModified", (Object)event.getEventDate());
        return exchange;
    }

    private boolean matchFilters(FileEvent fileEvent) {
        String pattern;
        if (ObjectHelper.isNotEmpty(this.getEndpoint().getEvents()) && !this.getEndpoint().getEvents().contains((Object)fileEvent.getEventType())) {
            return false;
        }
        if (!this.getEndpoint().isRecursive()) {
            try {
                if (!Files.isSameFile(fileEvent.getEventPath().getParent(), this.baseDirectory)) {
                    return false;
                }
            }
            catch (IOException e) {
                LOG.warn(String.format("Exception occurred during executing filter. Filtering file %s out.", fileEvent.getEventPath()), (Throwable)e);
                return false;
            }
        }
        if ((pattern = this.getEndpoint().getAntInclude()) == null || pattern.trim().isEmpty()) {
            return true;
        }
        return this.antPathMatcher.match(this.getEndpoint().getAntInclude(), PathUtils.normalizeToString(this.baseDirectory.relativize(fileEvent.getEventPath())));
    }

    public FileWatchEndpoint getEndpoint() {
        return (FileWatchEndpoint)super.getEndpoint();
    }

    class PollRunnable
    implements Runnable {
        PollRunnable() {
        }

        @Override
        public void run() {
            while (!FileWatchConsumer.this.isStoppingOrStopped() && !FileWatchConsumer.this.isSuspendingOrSuspended()) {
                FileEvent event;
                try {
                    event = (FileEvent)FileWatchConsumer.this.eventQueue.poll(1000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    return;
                }
                if (event == null) continue;
                try {
                    Exchange exchange = FileWatchConsumer.this.prepareExchange(event);
                    FileWatchConsumer.this.getProcessor().process(exchange);
                }
                catch (Throwable t) {
                    FileWatchConsumer.this.handleException(t);
                }
            }
        }
    }

    class FileWatchDirectoryChangeListener
    implements DirectoryChangeListener {
        FileWatchDirectoryChangeListener() {
        }

        public void onEvent(DirectoryChangeEvent directoryChangeEvent) {
            if (directoryChangeEvent.eventType() == DirectoryChangeEvent.EventType.OVERFLOW) {
                LOG.warn("OVERFLOW occurred, some events may be lost. Consider increasing of option 'pollThreads'");
                return;
            }
            FileEvent fileEvent = new FileEvent(directoryChangeEvent);
            if (FileWatchConsumer.this.matchFilters(fileEvent)) {
                FileWatchConsumer.this.eventQueue.offer(fileEvent);
            }
        }

        public boolean isWatching() {
            return !FileWatchConsumer.this.isStoppingOrStopped() && !FileWatchConsumer.this.isSuspendingOrSuspended();
        }

        public void onException(Exception e) {
            FileWatchConsumer.this.handleException(e);
        }
    }
}

