/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.watch;

import io.methvin.watcher.hashing.FileHasher;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.file.watch.FileWatchComponent;
import org.apache.camel.component.file.watch.FileWatchConsumer;
import org.apache.camel.component.file.watch.constants.FileEventEnum;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="3.0.0", scheme="file-watch", title="File Watch", syntax="file-watch:path", label="file", consumerOnly=true)
public class FileWatchEndpoint
extends DefaultEndpoint
implements MultipleConsumersSupport {
    @UriPath(label="consumer", description="Path of directory to consume events from.")
    @Metadata(required=true)
    private String path;
    @UriParam(label="consumer", enums="CREATE,MODIFY,DELETE", description="Comma separated list of events to watch.", defaultValue="CREATE,MODIFY,DELETE")
    private Set<FileEventEnum> events = new HashSet<FileEventEnum>(Arrays.asList(FileEventEnum.values()));
    @UriParam(label="consumer", description="Auto create directory if does not exists.", defaultValue="true")
    private boolean autoCreate = true;
    @UriParam(label="consumer", description="Watch recursive in current and child directories (including newly created directories).", defaultValue="true")
    private boolean recursive = true;
    @UriParam(label="consumer", description="The number of concurrent consumers. Increase this value, if your route is slow to prevent buffering in queue.", defaultValue="1")
    private int concurrentConsumers;
    @UriParam(label="consumer", description="The number of threads polling WatchService. Increase this value, if you see OVERFLOW messages in log.", defaultValue="1")
    private int pollThreads;
    @UriParam(label="consumer", description="ANT style pattern to match files. The file is matched against path relative to endpoint path. Pattern must be also relative (not starting with slash)", defaultValue="**")
    private String antInclude;
    @UriParam(label="consumer", description="Maximum size of queue between WatchService and consumer. Unbounded by default.", defaultValue="2147483647")
    private int queueSize;
    @UriParam(label="consumer", description="Reference to io.methvin.watcher.hashing.FileHasher. This prevents emitting duplicate events on some platforms. For working with large files and if you dont need detect multiple modifications per second per file, use #lastModifiedTimeFileHasher. You can also provide custom implementation in registry.", defaultValue="#murmur3FFileHasher")
    private FileHasher fileHasher;
    @UriParam(label="consumer", description="Enables or disables file hashing to detect duplicate events. If you disable this, you can get some events multiple times on some platforms and JDKs. Check java.nio.file.WatchService limitations for your target platform.", defaultValue="true")
    private boolean useFileHashing;

    public FileWatchEndpoint() {
    }

    public FileWatchEndpoint(String uri, FileWatchComponent component) {
        super(uri, (Component)component);
        this.setFileHasher(component.getFileHasher());
        this.setConcurrentConsumers(component.getConcurrentConsumers());
        this.setPollThreads(component.getPollThreads());
        this.setQueueSize(component.getQueueSize());
        this.setUseFileHashing(component.isUseFileHashing());
    }

    public FileWatchEndpoint(String uri, String remaining, FileWatchComponent component) {
        this(uri, component);
        this.setPath(remaining);
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("This component does not support producer");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new FileWatchConsumer(this, processor);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    Set<FileEventEnum> getEvents() {
        return this.events;
    }

    public void setEvents(Set<FileEventEnum> events) {
        this.events = events;
    }

    public void setEvents(String commaSeparatedEvents) {
        String[] stringArray = commaSeparatedEvents.split(",");
        HashSet<FileEventEnum> eventsSet = new HashSet<FileEventEnum>();
        for (String event : stringArray) {
            eventsSet.add(FileEventEnum.valueOf(event.trim()));
        }
        this.events = eventsSet.isEmpty() ? new HashSet<FileEventEnum>(Arrays.asList(FileEventEnum.values())) : eventsSet;
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public int getPollThreads() {
        return this.pollThreads;
    }

    public void setPollThreads(int pollThreads) {
        this.pollThreads = pollThreads;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public String getAntInclude() {
        return this.antInclude;
    }

    public void setAntInclude(String antInclude) {
        this.antInclude = antInclude;
    }

    public FileHasher getFileHasher() {
        return this.fileHasher;
    }

    public void setFileHasher(FileHasher fileHasher) {
        this.fileHasher = fileHasher;
    }

    public boolean isUseFileHashing() {
        return this.useFileHashing;
    }

    public void setUseFileHashing(boolean useFileHashing) {
        this.useFileHashing = useFileHashing;
    }

    public FileWatchComponent getComponent() {
        return (FileWatchComponent)super.getComponent();
    }

    public boolean isMultipleConsumersSupported() {
        return true;
    }
}

