/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.PooledExchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.StreamCache;
import org.apache.camel.impl.engine.StreamCachingHelper;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.SynchronizationVetoable;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.UnitOfWorkHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUnitOfWork
implements UnitOfWork {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultUnitOfWork.class);
    final InflightRepository inflightRepository;
    final StreamCachingStrategy streamCachingStrategy;
    final boolean allowUseOriginalMessage;
    final boolean useBreadcrumb;
    private final CamelContext context;
    private final Deque<Route> routes = new ArrayDeque<Route>(8);
    private Logger log = LOG;
    private Exchange exchange;
    private List<Synchronization> synchronizations;
    private Message originalInMessage;
    private Set<Object> transactedBy;

    public DefaultUnitOfWork(Exchange exchange) {
        this(exchange, exchange.getContext().getInflightRepository(), exchange.getContext().isAllowUseOriginalMessage(), exchange.getContext().isUseBreadcrumb());
    }

    protected DefaultUnitOfWork(Exchange exchange, Logger logger, InflightRepository inflightRepository, boolean allowUseOriginalMessage, boolean useBreadcrumb) {
        this(exchange, inflightRepository, allowUseOriginalMessage, useBreadcrumb);
        this.log = logger;
    }

    public DefaultUnitOfWork(Exchange exchange, InflightRepository inflightRepository, boolean allowUseOriginalMessage, boolean useBreadcrumb) {
        this.allowUseOriginalMessage = allowUseOriginalMessage;
        this.useBreadcrumb = useBreadcrumb;
        this.context = exchange.getContext();
        this.inflightRepository = inflightRepository;
        this.streamCachingStrategy = exchange.getContext().getStreamCachingStrategy();
        this.doOnPrepare(exchange);
    }

    UnitOfWork newInstance(Exchange exchange) {
        return new DefaultUnitOfWork(exchange, this.inflightRepository, this.allowUseOriginalMessage, this.useBreadcrumb);
    }

    public boolean onPrepare(Exchange exchange) {
        if (this.exchange == null) {
            this.doOnPrepare(exchange);
            return true;
        }
        return false;
    }

    private boolean isStreamCacheInUse(Exchange exchange) {
        Route route;
        String rid;
        boolean inUse = this.streamCachingStrategy.isEnabled();
        if (inUse && (rid = exchange.getFromRouteId()) != null && (route = exchange.getContext().getRoute(rid)) != null) {
            inUse = route.isStreamCaching() != null && route.isStreamCaching() != false;
        }
        return inUse;
    }

    private void doOnPrepare(Exchange exchange) {
        String breadcrumbId;
        this.exchange = exchange;
        if (this.allowUseOriginalMessage) {
            StreamCache cache;
            this.originalInMessage = exchange.getIn().copy();
            if (this.isStreamCacheInUse(exchange) && (cache = StreamCachingHelper.convertToStreamCache(this.streamCachingStrategy, exchange, this.originalInMessage)) != null) {
                this.originalInMessage.setBody((Object)cache);
                this.exchange.getIn().setBody((Object)cache);
            }
        }
        if (this.useBreadcrumb && (breadcrumbId = (String)exchange.getIn().getHeader("breadcrumbId", String.class)) == null) {
            breadcrumbId = exchange.getExchangeId();
            exchange.getIn().setHeader("breadcrumbId", (Object)breadcrumbId);
        }
        if (this.context.getCamelContextExtension().isEventNotificationApplicable()) {
            try {
                EventHelper.notifyExchangeCreated((CamelContext)this.context, (Exchange)exchange);
            }
            catch (Throwable e) {
                this.log.warn("Exception occurred during event notification. This exception will be ignored.", e);
            }
        }
        this.inflightRepository.add(exchange);
    }

    public void reset() {
        this.exchange = null;
        this.routes.clear();
        if (this.synchronizations != null) {
            this.synchronizations.clear();
        }
        this.originalInMessage = null;
        if (this.transactedBy != null) {
            this.transactedBy.clear();
        }
    }

    public void setParentUnitOfWork(UnitOfWork parentUnitOfWork) {
    }

    public UnitOfWork createChildUnitOfWork(Exchange childExchange) {
        UnitOfWork answer = this.newInstance(childExchange);
        answer.setParentUnitOfWork((UnitOfWork)this);
        return answer;
    }

    public synchronized void addSynchronization(Synchronization synchronization) {
        if (this.synchronizations == null) {
            this.synchronizations = new ArrayList<Synchronization>(8);
        }
        this.log.trace("Adding synchronization {}", (Object)synchronization);
        this.synchronizations.add(synchronization);
    }

    public synchronized void removeSynchronization(Synchronization synchronization) {
        if (this.synchronizations != null) {
            this.synchronizations.remove(synchronization);
        }
    }

    public synchronized boolean containsSynchronization(Synchronization synchronization) {
        return this.synchronizations != null && this.synchronizations.contains(synchronization);
    }

    public void handoverSynchronization(Exchange target) {
        this.handoverSynchronization(target, null);
    }

    public void handoverSynchronization(Exchange target, Predicate<Synchronization> filter) {
        if (this.synchronizations == null || this.synchronizations.isEmpty()) {
            return;
        }
        Iterator<Synchronization> it = this.synchronizations.iterator();
        while (it.hasNext()) {
            Synchronization synchronization = it.next();
            boolean handover = true;
            SynchronizationVetoable veto = null;
            if (synchronization instanceof SynchronizationVetoable) {
                veto = (SynchronizationVetoable)synchronization;
                handover = veto.allowHandover();
            }
            if (handover && (filter == null || filter.test(synchronization))) {
                this.log.trace("Handover synchronization {} to: {}", (Object)synchronization, (Object)target);
                target.getExchangeExtension().addOnCompletion(synchronization);
                if (veto != null) {
                    veto.beforeHandover(target);
                }
                it.remove();
                continue;
            }
            this.log.trace("Handover not allow for synchronization {}", (Object)synchronization);
        }
    }

    public void done(Exchange exchange) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("UnitOfWork done for ExchangeId: {} with {}", (Object)exchange.getExchangeId(), (Object)exchange);
        }
        UnitOfWorkHelper.doneSynchronizations((Exchange)exchange, this.synchronizations);
        this.inflightRepository.remove(exchange);
        if (this.context.getCamelContextExtension().isEventNotificationApplicable()) {
            try {
                boolean failed = exchange.isFailed();
                if (failed) {
                    EventHelper.notifyExchangeFailed((CamelContext)exchange.getContext(), (Exchange)exchange);
                } else {
                    EventHelper.notifyExchangeDone((CamelContext)exchange.getContext(), (Exchange)exchange);
                }
            }
            catch (Throwable e) {
                this.log.warn("Exception occurred during event notification. This exception will be ignored.", e);
            }
        }
        if (exchange instanceof PooledExchange) {
            try {
                PooledExchange pooled = (PooledExchange)exchange;
                if (pooled.isAutoRelease()) {
                    ((PooledExchange)exchange).done();
                }
            }
            catch (Throwable e) {
                this.log.warn("Exception occurred during exchange done. This exception will be ignored.", e);
            }
        } else {
            this.onDone();
        }
    }

    protected void onDone() {
        this.exchange.getExchangeExtension().setUnitOfWork(null);
    }

    public void beforeRoute(Exchange exchange, Route route) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("UnitOfWork beforeRoute: {} for ExchangeId: {} with {}", new Object[]{route.getId(), exchange.getExchangeId(), exchange});
        }
        if (this.synchronizations != null && !this.synchronizations.isEmpty()) {
            UnitOfWorkHelper.beforeRouteSynchronizations((Route)route, (Exchange)exchange, this.synchronizations, (Logger)this.log);
        }
    }

    public void afterRoute(Exchange exchange, Route route) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("UnitOfWork afterRoute: {} for ExchangeId: {} with {}", new Object[]{route.getId(), exchange.getExchangeId(), exchange});
        }
        if (this.synchronizations != null && !this.synchronizations.isEmpty()) {
            UnitOfWorkHelper.afterRouteSynchronizations((Route)route, (Exchange)exchange, this.synchronizations, (Logger)this.log);
        }
    }

    public Message getOriginalInMessage() {
        if (this.originalInMessage == null && !this.context.isAllowUseOriginalMessage().booleanValue()) {
            throw new IllegalStateException("AllowUseOriginalMessage is disabled. Cannot access the original message.");
        }
        return this.originalInMessage;
    }

    public boolean isTransacted() {
        return this.transactedBy != null && !this.transactedBy.isEmpty();
    }

    public boolean isTransactedBy(Object key) {
        return this.transactedBy != null && this.getTransactedBy().contains(key);
    }

    public void beginTransactedBy(Object key) {
        this.exchange.getExchangeExtension().setTransacted(true);
        this.getTransactedBy().add(key);
    }

    public void endTransactedBy(Object key) {
        this.getTransactedBy().remove(key);
        boolean transacted = this.isTransacted();
        this.exchange.getExchangeExtension().setTransacted(transacted);
    }

    public Route getRoute() {
        return this.routes.peek();
    }

    public void pushRoute(Route route) {
        this.routes.push(route);
    }

    public Route popRoute() {
        return this.routes.poll();
    }

    public int routeStackLevel() {
        return this.routes.size();
    }

    public boolean isBeforeAfterProcess() {
        return false;
    }

    public AsyncCallback beforeProcess(Processor processor, Exchange exchange, AsyncCallback callback) {
        return this.isBeforeAfterProcess() ? new UnitOfWorkCallback(callback, processor) : callback;
    }

    public void afterProcess(Processor processor, Exchange exchange, AsyncCallback callback, boolean doneSync) {
    }

    private Set<Object> getTransactedBy() {
        if (this.transactedBy == null) {
            this.transactedBy = new HashSet<Object>(4);
        }
        return this.transactedBy;
    }

    public String toString() {
        return "DefaultUnitOfWork";
    }

    private final class UnitOfWorkCallback
    implements AsyncCallback {
        private final AsyncCallback delegate;
        private final Processor processor;

        private UnitOfWorkCallback(AsyncCallback delegate, Processor processor) {
            this.delegate = delegate;
            this.processor = processor;
        }

        public void done(boolean doneSync) {
            this.delegate.done(doneSync);
            DefaultUnitOfWork.this.afterProcess(this.processor, DefaultUnitOfWork.this.exchange, this.delegate, doneSync);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

