/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.language.simple.BaseSimpleParser;
import org.apache.camel.language.simple.ast.LiteralExpression;
import org.apache.camel.language.simple.ast.LiteralNode;
import org.apache.camel.language.simple.ast.SimpleFunctionEnd;
import org.apache.camel.language.simple.ast.SimpleFunctionStart;
import org.apache.camel.language.simple.ast.SimpleNode;
import org.apache.camel.language.simple.ast.UnaryExpression;
import org.apache.camel.language.simple.types.SimpleIllegalSyntaxException;
import org.apache.camel.language.simple.types.SimpleParserException;
import org.apache.camel.language.simple.types.SimpleToken;
import org.apache.camel.language.simple.types.TokenType;
import org.apache.camel.support.LanguageHelper;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.util.StringHelper;

public class SimpleExpressionParser
extends BaseSimpleParser {
    private final Map<String, Expression> cacheExpression;

    public SimpleExpressionParser(CamelContext camelContext, String expression, boolean allowEscape, Map<String, Expression> cacheExpression) {
        super(camelContext, expression, allowEscape);
        this.cacheExpression = cacheExpression;
    }

    public Expression parseExpression() {
        try {
            this.parseTokens();
            return this.doParseExpression();
        }
        catch (SimpleParserException e) {
            throw new SimpleIllegalSyntaxException(this.expression, e.getIndex(), e.getMessage(), (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new SimpleIllegalSyntaxException(this.expression, -1, e.getMessage(), e);
        }
    }

    public String parseCode() {
        try {
            this.parseTokens();
            return this.doParseCode();
        }
        catch (SimpleParserException e) {
            throw new SimpleIllegalSyntaxException(this.expression, e.getIndex(), e.getMessage(), (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new SimpleIllegalSyntaxException(this.expression, -1, e.getMessage(), e);
        }
    }

    protected List<SimpleNode> parseTokens() {
        this.clear();
        this.nextToken();
        while (!this.token.getType().isEol()) {
            this.templateText();
            this.functionText();
            this.unaryOperator();
            this.nextToken();
        }
        this.parseAndCreateAstModel();
        this.prepareBlocks();
        this.prepareUnaryExpressions();
        return this.nodes;
    }

    protected Expression doParseExpression() {
        List<Expression> expressions = this.createExpressions();
        if (expressions.isEmpty()) {
            return ExpressionBuilder.constantExpression((Object)"");
        }
        if (expressions.size() == 1) {
            return expressions.get(0);
        }
        return ExpressionBuilder.concatExpression(expressions, (String)this.expression);
    }

    protected void parseAndCreateAstModel() {
        SimpleToken token;
        AtomicInteger functions = new AtomicInteger();
        LiteralNode imageToken = null;
        Iterator iterator = this.tokens.iterator();
        while (iterator.hasNext() && !(token = (SimpleToken)iterator.next()).getType().isEol()) {
            SimpleNode node = this.createNode(token, functions);
            if (node != null) {
                if (imageToken != null) {
                    this.nodes.add(imageToken);
                    imageToken = null;
                }
                this.nodes.add(node);
                continue;
            }
            if (imageToken == null) {
                imageToken = new LiteralExpression(token);
            }
            imageToken.addText(token.getText());
        }
        if (imageToken != null) {
            this.nodes.add(imageToken);
        }
    }

    private SimpleNode createNode(SimpleToken token, AtomicInteger functions) {
        if (token.getType().isFunctionStart()) {
            functions.incrementAndGet();
            return new SimpleFunctionStart(token, this.cacheExpression);
        }
        if (functions.get() > 0 && token.getType().isFunctionEnd()) {
            functions.decrementAndGet();
            return new SimpleFunctionEnd(token);
        }
        if (token.getType().isUnary() && !this.nodes.isEmpty() && this.nodes.get(this.nodes.size() - 1) instanceof SimpleFunctionEnd) {
            return new UnaryExpression(token);
        }
        return null;
    }

    private List<Expression> createExpressions() {
        ArrayList<Expression> answer = new ArrayList<Expression>();
        for (SimpleNode token : this.nodes) {
            Expression exp = token.createExpression(this.camelContext, this.expression);
            if (exp == null) continue;
            answer.add(exp);
        }
        return answer;
    }

    protected String doParseCode() {
        StringBuilder sb = new StringBuilder();
        boolean firstIsLiteral = false;
        for (SimpleNode node : this.nodes) {
            Object exp = node.createCode(this.expression);
            if (exp == null) continue;
            if (sb.length() == 0 && node instanceof LiteralNode) {
                firstIsLiteral = true;
            }
            if (sb.length() > 0) {
                if (!firstIsLiteral) {
                    sb.insert(0, "\"\" + ");
                }
                sb.append(" + ");
            }
            if (node instanceof LiteralNode) {
                exp = StringHelper.removeLeadingAndEndingQuotes((String)exp);
                sb.append("\"");
                exp = LanguageHelper.escapeQuotes((String)exp);
                exp = ((String)exp).replaceAll("\n", "\\\\n");
                exp = ((String)exp).replaceAll("\t", "\\\\t");
                exp = ((String)exp).replaceAll("\r", "\\\\r");
                if (((String)exp).endsWith("\\") && !((String)exp).endsWith("\\\\")) {
                    exp = (String)exp + "\\";
                }
                sb.append((String)exp);
                sb.append("\"");
                continue;
            }
            sb.append((String)exp);
        }
        return sb.toString();
    }

    protected void templateText() {
        while (!(this.token.getType().isFunctionStart() || this.token.getType().isFunctionEnd() || this.token.getType().isEol())) {
            this.nextToken();
        }
    }

    protected boolean functionText() {
        if (this.accept(TokenType.functionStart)) {
            this.nextToken();
            while (!this.token.getType().isFunctionEnd() && !this.token.getType().isEol()) {
                if (this.token.getType().isFunctionStart()) {
                    this.functionText();
                }
                this.nextToken();
            }
            if (!this.token.getType().isFunctionStart()) {
                this.expect(TokenType.functionEnd);
            }
            return true;
        }
        return false;
    }

    protected boolean unaryOperator() {
        if (this.accept(TokenType.unaryOperator)) {
            this.nextToken();
            this.expect(TokenType.whiteSpace);
            return true;
        }
        return false;
    }
}

