/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum AccountStatusEnum {
    ACTIVE("active", "http://hl7.org/fhir/account-status"),
    INACTIVE("inactive", "http://hl7.org/fhir/account-status");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "AccountStatus";
    private static Map<String, AccountStatusEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, AccountStatusEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<AccountStatusEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static AccountStatusEnum forCode(String theCode) {
        AccountStatusEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private AccountStatusEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, AccountStatusEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, AccountStatusEnum>>();
        for (AccountStatusEnum next : AccountStatusEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<AccountStatusEnum>(){

            public String toCodeString(AccountStatusEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(AccountStatusEnum theEnum) {
                return theEnum.getSystem();
            }

            public AccountStatusEnum fromCodeString(String theCodeString) {
                return (AccountStatusEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public AccountStatusEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (AccountStatusEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

