/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.FilterOperator;

public class FilterOperatorEnumFactory
implements EnumFactory<FilterOperator> {
    @Override
    public FilterOperator fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("=".equals(codeString)) {
            return FilterOperator.EQUAL;
        }
        if ("is-a".equals(codeString)) {
            return FilterOperator.ISA;
        }
        if ("descendent-of".equals(codeString)) {
            return FilterOperator.DESCENDENTOF;
        }
        if ("is-not-a".equals(codeString)) {
            return FilterOperator.ISNOTA;
        }
        if ("regex".equals(codeString)) {
            return FilterOperator.REGEX;
        }
        if ("in".equals(codeString)) {
            return FilterOperator.IN;
        }
        if ("not-in".equals(codeString)) {
            return FilterOperator.NOTIN;
        }
        if ("generalizes".equals(codeString)) {
            return FilterOperator.GENERALIZES;
        }
        if ("exists".equals(codeString)) {
            return FilterOperator.EXISTS;
        }
        throw new IllegalArgumentException("Unknown FilterOperator code '" + codeString + "'");
    }

    @Override
    public String toCode(FilterOperator code) {
        if (code == FilterOperator.EQUAL) {
            return "=";
        }
        if (code == FilterOperator.ISA) {
            return "is-a";
        }
        if (code == FilterOperator.DESCENDENTOF) {
            return "descendent-of";
        }
        if (code == FilterOperator.ISNOTA) {
            return "is-not-a";
        }
        if (code == FilterOperator.REGEX) {
            return "regex";
        }
        if (code == FilterOperator.IN) {
            return "in";
        }
        if (code == FilterOperator.NOTIN) {
            return "not-in";
        }
        if (code == FilterOperator.GENERALIZES) {
            return "generalizes";
        }
        if (code == FilterOperator.EXISTS) {
            return "exists";
        }
        return "?";
    }

    @Override
    public String toSystem(FilterOperator code) {
        return code.getSystem();
    }
}

