/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ExtraActivityType {
    AGGREGATE,
    COMPOSE,
    LABEL,
    NULL;


    public static ExtraActivityType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("aggregate".equals(codeString)) {
            return AGGREGATE;
        }
        if ("compose".equals(codeString)) {
            return COMPOSE;
        }
        if ("label".equals(codeString)) {
            return LABEL;
        }
        throw new FHIRException("Unknown ExtraActivityType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case AGGREGATE: {
                return "aggregate";
            }
            case COMPOSE: {
                return "compose";
            }
            case LABEL: {
                return "label";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/extra-activity-type";
    }

    public String getDefinition() {
        switch (this) {
            case AGGREGATE: {
                return "Activity resulting in a structured collection of preexisting content that does not necessarily result in an integral object with semantic context making it more than the sum of component parts, from which components could be disaggregated without loss of semantic context, e.g., the assembly of multiple stand-alone documents.";
            }
            case COMPOSE: {
                return "Activity resulting in the structured compilation of new and preexisting content for the purposes of forming an integral object with  semantic context making it more than the sum of component parts, which would be lost if decomposed. For example, the composition of a document that includes in whole or part other documents along with new content that result in a new document that has unique semantic meaning.";
            }
            case LABEL: {
                return "The means used to associate a set of security attributes with a specific information object as part of the data structure for that object. [ISO-10181-3 Access Control]";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case AGGREGATE: {
                return "aggregate";
            }
            case COMPOSE: {
                return "compose";
            }
            case LABEL: {
                return "label";
            }
        }
        return "?";
    }
}

