/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum EventTiming {
    MORN,
    AFT,
    EVE,
    NIGHT,
    PHS,
    NULL;


    public static EventTiming fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("MORN".equals(codeString)) {
            return MORN;
        }
        if ("AFT".equals(codeString)) {
            return AFT;
        }
        if ("EVE".equals(codeString)) {
            return EVE;
        }
        if ("NIGHT".equals(codeString)) {
            return NIGHT;
        }
        if ("PHS".equals(codeString)) {
            return PHS;
        }
        throw new FHIRException("Unknown EventTiming code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case MORN: {
                return "MORN";
            }
            case AFT: {
                return "AFT";
            }
            case EVE: {
                return "EVE";
            }
            case NIGHT: {
                return "NIGHT";
            }
            case PHS: {
                return "PHS";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/event-timing";
    }

    public String getDefinition() {
        switch (this) {
            case MORN: {
                return "event occurs during the morning";
            }
            case AFT: {
                return "event occurs during the afternoon";
            }
            case EVE: {
                return "event occurs during the evening";
            }
            case NIGHT: {
                return "event occurs during the night";
            }
            case PHS: {
                return "event occurs [offset] after subject goes to sleep";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case MORN: {
                return "Morning";
            }
            case AFT: {
                return "Afternoon";
            }
            case EVE: {
                return "Evening";
            }
            case NIGHT: {
                return "Night";
            }
            case PHS: {
                return "After Sleep";
            }
        }
        return "?";
    }
}

