/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ContentType {
    XML,
    JSON,
    TTL,
    NONE,
    NULL;


    public static ContentType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("xml".equals(codeString)) {
            return XML;
        }
        if ("json".equals(codeString)) {
            return JSON;
        }
        if ("ttl".equals(codeString)) {
            return TTL;
        }
        if ("none".equals(codeString)) {
            return NONE;
        }
        throw new FHIRException("Unknown ContentType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case XML: {
                return "xml";
            }
            case JSON: {
                return "json";
            }
            case TTL: {
                return "ttl";
            }
            case NONE: {
                return "none";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/content-type";
    }

    public String getDefinition() {
        switch (this) {
            case XML: {
                return "XML content-type corresponding to the application/fhir+xml mime-type.";
            }
            case JSON: {
                return "JSON content-type corresponding to the application/fhir+json mime-type.";
            }
            case TTL: {
                return "RDF content-type corresponding to the text/turtle mime-type.";
            }
            case NONE: {
                return "Prevent the use of the corresponding http header.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case XML: {
                return "xml";
            }
            case JSON: {
                return "json";
            }
            case TTL: {
                return "ttl";
            }
            case NONE: {
                return "none";
            }
        }
        return "?";
    }
}

