/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum SupplydeliveryStatus {
    INPROGRESS,
    COMPLETED,
    ABANDONED,
    NULL;


    public static SupplydeliveryStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("in-progress".equals(codeString)) {
            return INPROGRESS;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("abandoned".equals(codeString)) {
            return ABANDONED;
        }
        throw new FHIRException("Unknown SupplydeliveryStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case INPROGRESS: {
                return "in-progress";
            }
            case COMPLETED: {
                return "completed";
            }
            case ABANDONED: {
                return "abandoned";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/supplydelivery-status";
    }

    public String getDefinition() {
        switch (this) {
            case INPROGRESS: {
                return "Supply has been requested, but not delivered.";
            }
            case COMPLETED: {
                return "Supply has been delivered (\"completed\").";
            }
            case ABANDONED: {
                return "Dispensing was not completed.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case INPROGRESS: {
                return "In Progress";
            }
            case COMPLETED: {
                return "Delivered";
            }
            case ABANDONED: {
                return "Abandoned";
            }
        }
        return "?";
    }
}

