/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ProcessPriority {
    STAT,
    NORMAL,
    DEFERRED,
    NULL;


    public static ProcessPriority fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("stat".equals(codeString)) {
            return STAT;
        }
        if ("normal".equals(codeString)) {
            return NORMAL;
        }
        if ("deferred".equals(codeString)) {
            return DEFERRED;
        }
        throw new FHIRException("Unknown ProcessPriority code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case STAT: {
                return "stat";
            }
            case NORMAL: {
                return "normal";
            }
            case DEFERRED: {
                return "deferred";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/processpriority";
    }

    public String getDefinition() {
        switch (this) {
            case STAT: {
                return "Immediately in real time.";
            }
            case NORMAL: {
                return "With best effort.";
            }
            case DEFERRED: {
                return "Later, when possible.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case STAT: {
                return "Immediate";
            }
            case NORMAL: {
                return "Normal";
            }
            case DEFERRED: {
                return "Deferred";
            }
        }
        return "?";
    }
}

