/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum NehtaImagingExaminationResultStat {
    _1,
    _2,
    _3,
    _4,
    _5,
    NULL;


    public static NehtaImagingExaminationResultStat fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("1".equals(codeString)) {
            return _1;
        }
        if ("2".equals(codeString)) {
            return _2;
        }
        if ("3".equals(codeString)) {
            return _3;
        }
        if ("4".equals(codeString)) {
            return _4;
        }
        if ("5".equals(codeString)) {
            return _5;
        }
        throw new FHIRException("Unknown NehtaImagingExaminationResultStat code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _1: {
                return "1";
            }
            case _2: {
                return "2";
            }
            case _3: {
                return "3";
            }
            case _4: {
                return "4";
            }
            case _5: {
                return "5";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/imaging-examination-result-stat";
    }

    public String getDefinition() {
        switch (this) {
            case _1: {
                return "No result yet available.";
            }
            case _2: {
                return "This is an initial or interim result: data may be missing or verification has not been performed.";
            }
            case _3: {
                return "The result is complete and verified by the responsible radiologist.";
            }
            case _4: {
                return "The result has been modified subsequent to being Final, and is complete and verified by the radiologist.";
            }
            case _5: {
                return "The result is not available because the examination was not started or completed.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _1: {
                return "Registered";
            }
            case _2: {
                return "Interim";
            }
            case _3: {
                return "Final";
            }
            case _4: {
                return "Amended";
            }
            case _5: {
                return "Cancelled/Aborted";
            }
        }
        return "?";
    }
}

