/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MapTransform {
    CREATE,
    COPY,
    TRUNCATE,
    ESCAPE,
    CAST,
    APPEND,
    TRANSLATE,
    REFERENCE,
    DATEOP,
    UUID,
    POINTER,
    EVALUATE,
    NULL;


    public static MapTransform fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("create".equals(codeString)) {
            return CREATE;
        }
        if ("copy".equals(codeString)) {
            return COPY;
        }
        if ("truncate".equals(codeString)) {
            return TRUNCATE;
        }
        if ("escape".equals(codeString)) {
            return ESCAPE;
        }
        if ("cast".equals(codeString)) {
            return CAST;
        }
        if ("append".equals(codeString)) {
            return APPEND;
        }
        if ("translate".equals(codeString)) {
            return TRANSLATE;
        }
        if ("reference".equals(codeString)) {
            return REFERENCE;
        }
        if ("dateOp".equals(codeString)) {
            return DATEOP;
        }
        if ("uuid".equals(codeString)) {
            return UUID;
        }
        if ("pointer".equals(codeString)) {
            return POINTER;
        }
        if ("evaluate".equals(codeString)) {
            return EVALUATE;
        }
        throw new FHIRException("Unknown MapTransform code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CREATE: {
                return "create";
            }
            case COPY: {
                return "copy";
            }
            case TRUNCATE: {
                return "truncate";
            }
            case ESCAPE: {
                return "escape";
            }
            case CAST: {
                return "cast";
            }
            case APPEND: {
                return "append";
            }
            case TRANSLATE: {
                return "translate";
            }
            case REFERENCE: {
                return "reference";
            }
            case DATEOP: {
                return "dateOp";
            }
            case UUID: {
                return "uuid";
            }
            case POINTER: {
                return "pointer";
            }
            case EVALUATE: {
                return "evaluate";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/map-transform";
    }

    public String getDefinition() {
        switch (this) {
            case CREATE: {
                return "create(type : string) - type is passed through to the application on the standard API, and must be known by it";
            }
            case COPY: {
                return "copy(source)";
            }
            case TRUNCATE: {
                return "truncate(source, length) - source must be stringy type";
            }
            case ESCAPE: {
                return "escape(source, fmt1, fmt2) - change source from one kind of escaping to another (plain, java, xml, json). note that this is for when the string itself is escaped";
            }
            case CAST: {
                return "cast(source, type?) - case source from one type to another. target type can be left as implicit if there is one and only one target type known";
            }
            case APPEND: {
                return "append(source...) - source is element or string";
            }
            case TRANSLATE: {
                return "translate(source, uri_of_map) - use the translate operation";
            }
            case REFERENCE: {
                return "reference(source : object) - return a string that references the provided tree properly";
            }
            case DATEOP: {
                return "something";
            }
            case UUID: {
                return "something";
            }
            case POINTER: {
                return "something";
            }
            case EVALUATE: {
                return "something";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CREATE: {
                return "create";
            }
            case COPY: {
                return "copy";
            }
            case TRUNCATE: {
                return "truncate";
            }
            case ESCAPE: {
                return "escape";
            }
            case CAST: {
                return "cast";
            }
            case APPEND: {
                return "append";
            }
            case TRANSLATE: {
                return "translate";
            }
            case REFERENCE: {
                return "reference";
            }
            case DATEOP: {
                return "dateOp";
            }
            case UUID: {
                return "uuid";
            }
            case POINTER: {
                return "pointer";
            }
            case EVALUATE: {
                return "evaluate";
            }
        }
        return "?";
    }
}

