/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum EncounterState {
    PLANNED,
    ARRIVED,
    INPROGRESS,
    ONLEAVE,
    FINISHED,
    CANCELLED,
    NULL;


    public static EncounterState fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("planned".equals(codeString)) {
            return PLANNED;
        }
        if ("arrived".equals(codeString)) {
            return ARRIVED;
        }
        if ("in-progress".equals(codeString)) {
            return INPROGRESS;
        }
        if ("onleave".equals(codeString)) {
            return ONLEAVE;
        }
        if ("finished".equals(codeString)) {
            return FINISHED;
        }
        if ("cancelled".equals(codeString)) {
            return CANCELLED;
        }
        throw new FHIRException("Unknown EncounterState code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PLANNED: {
                return "planned";
            }
            case ARRIVED: {
                return "arrived";
            }
            case INPROGRESS: {
                return "in-progress";
            }
            case ONLEAVE: {
                return "onleave";
            }
            case FINISHED: {
                return "finished";
            }
            case CANCELLED: {
                return "cancelled";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/encounter-state";
    }

    public String getDefinition() {
        switch (this) {
            case PLANNED: {
                return "The Encounter has not yet started.";
            }
            case ARRIVED: {
                return "The Patient is present for the encounter, however is not currently meeting with a practitioner.";
            }
            case INPROGRESS: {
                return "The Encounter has begun and the patient is present / the practitioner and the patient are meeting.";
            }
            case ONLEAVE: {
                return "The Encounter has begun, but the patient is temporarily on leave.";
            }
            case FINISHED: {
                return "The Encounter has ended.";
            }
            case CANCELLED: {
                return "The Encounter has ended before it has begun.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PLANNED: {
                return "Planned";
            }
            case ARRIVED: {
                return "Arrived";
            }
            case INPROGRESS: {
                return "in Progress";
            }
            case ONLEAVE: {
                return "On Leave";
            }
            case FINISHED: {
                return "Finished";
            }
            case CANCELLED: {
                return "Cancelled";
            }
        }
        return "?";
    }
}

