/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CdsRuleActionType {
    CREATE,
    UPDATE,
    REMOVE,
    FIREEVENT,
    NULL;


    public static CdsRuleActionType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("create".equals(codeString)) {
            return CREATE;
        }
        if ("update".equals(codeString)) {
            return UPDATE;
        }
        if ("remove".equals(codeString)) {
            return REMOVE;
        }
        if ("fire-event".equals(codeString)) {
            return FIREEVENT;
        }
        throw new FHIRException("Unknown CdsRuleActionType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CREATE: {
                return "create";
            }
            case UPDATE: {
                return "update";
            }
            case REMOVE: {
                return "remove";
            }
            case FIREEVENT: {
                return "fire-event";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/cds-rule-action-type";
    }

    public String getDefinition() {
        switch (this) {
            case CREATE: {
                return "The action is to create a new resource";
            }
            case UPDATE: {
                return "The action is to update an existing resource";
            }
            case REMOVE: {
                return "The action is to remove an existing resource";
            }
            case FIREEVENT: {
                return "The action is to fire a specific event";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CREATE: {
                return "Create";
            }
            case UPDATE: {
                return "Update";
            }
            case REMOVE: {
                return "Remove";
            }
            case FIREEVENT: {
                return "Fire Event";
            }
        }
        return "?";
    }
}

