/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CarePlanRelationship {
    INCLUDES,
    REPLACES,
    FULFILLS,
    NULL;


    public static CarePlanRelationship fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("includes".equals(codeString)) {
            return INCLUDES;
        }
        if ("replaces".equals(codeString)) {
            return REPLACES;
        }
        if ("fulfills".equals(codeString)) {
            return FULFILLS;
        }
        throw new FHIRException("Unknown CarePlanRelationship code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case INCLUDES: {
                return "includes";
            }
            case REPLACES: {
                return "replaces";
            }
            case FULFILLS: {
                return "fulfills";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/care-plan-relationship";
    }

    public String getDefinition() {
        switch (this) {
            case INCLUDES: {
                return "The referenced plan is considered to be part of this plan.";
            }
            case REPLACES: {
                return "This plan takes the places of the referenced plan.";
            }
            case FULFILLS: {
                return "This plan provides details about how to perform activities defined at a higher level by the referenced plan.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case INCLUDES: {
                return "Includes";
            }
            case REPLACES: {
                return "Replaces";
            }
            case FULFILLS: {
                return "Fulfills";
            }
        }
        return "?";
    }
}

