/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AssertOperatorCodes {
    EQUALS,
    NOTEQUALS,
    IN,
    NOTIN,
    GREATERTHAN,
    LESSTHAN,
    EMPTY,
    NOTEMPTY,
    CONTAINS,
    NOTCONTAINS,
    NULL;


    public static AssertOperatorCodes fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("equals".equals(codeString)) {
            return EQUALS;
        }
        if ("notEquals".equals(codeString)) {
            return NOTEQUALS;
        }
        if ("in".equals(codeString)) {
            return IN;
        }
        if ("notIn".equals(codeString)) {
            return NOTIN;
        }
        if ("greaterThan".equals(codeString)) {
            return GREATERTHAN;
        }
        if ("lessThan".equals(codeString)) {
            return LESSTHAN;
        }
        if ("empty".equals(codeString)) {
            return EMPTY;
        }
        if ("notEmpty".equals(codeString)) {
            return NOTEMPTY;
        }
        if ("contains".equals(codeString)) {
            return CONTAINS;
        }
        if ("notContains".equals(codeString)) {
            return NOTCONTAINS;
        }
        throw new FHIRException("Unknown AssertOperatorCodes code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case EQUALS: {
                return "equals";
            }
            case NOTEQUALS: {
                return "notEquals";
            }
            case IN: {
                return "in";
            }
            case NOTIN: {
                return "notIn";
            }
            case GREATERTHAN: {
                return "greaterThan";
            }
            case LESSTHAN: {
                return "lessThan";
            }
            case EMPTY: {
                return "empty";
            }
            case NOTEMPTY: {
                return "notEmpty";
            }
            case CONTAINS: {
                return "contains";
            }
            case NOTCONTAINS: {
                return "notContains";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/assert-operator-codes";
    }

    public String getDefinition() {
        switch (this) {
            case EQUALS: {
                return "Default value. Equals comparison.";
            }
            case NOTEQUALS: {
                return "Not equals comparison.";
            }
            case IN: {
                return "Compare value within a known set of values.";
            }
            case NOTIN: {
                return "Compare value not within a known set of values.";
            }
            case GREATERTHAN: {
                return "Compare value to be greater than a known value.";
            }
            case LESSTHAN: {
                return "Compare value to be less than a known value.";
            }
            case EMPTY: {
                return "Compare value is empty.";
            }
            case NOTEMPTY: {
                return "Compare value is not empty.";
            }
            case CONTAINS: {
                return "Compare value string contains a known value.";
            }
            case NOTCONTAINS: {
                return "Compare value string does not contain a known value.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case EQUALS: {
                return "equals";
            }
            case NOTEQUALS: {
                return "notEquals";
            }
            case IN: {
                return "in";
            }
            case NOTIN: {
                return "notIn";
            }
            case GREATERTHAN: {
                return "greaterThan";
            }
            case LESSTHAN: {
                return "lessThan";
            }
            case EMPTY: {
                return "empty";
            }
            case NOTEMPTY: {
                return "notEmpty";
            }
            case CONTAINS: {
                return "contains";
            }
            case NOTCONTAINS: {
                return "notContains";
            }
        }
        return "?";
    }
}

