/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="SearchParameter", profile="http://hl7.org/fhir/Profile/SearchParameter")
public class SearchParameter
extends DomainResource {
    @Child(name="url", type={UriType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Absolute URL used to reference this search parameter", formalDefinition="An absolute URL that is used to identify this search parameter when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this search parameter is (or will be) published.")
    protected UriType url;
    @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Informal name for this search parameter", formalDefinition="A free text natural language name identifying the search parameter.")
    protected StringType name;
    @Child(name="status", type={CodeType.class}, order=2, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired", formalDefinition="The status of this search parameter definition.")
    protected Enumeration<Enumerations.ConformanceResourceStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If for testing purposes, not real usage", formalDefinition="A flag to indicate that this search parameter definition is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Publication Date(/time)", formalDefinition="The date  (and optionally time) when the search parameter definition was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the search parameter changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (Organization or individual)", formalDefinition="The name of the individual or organization that published the search parameter.")
    protected StringType publisher;
    @Child(name="contact", type={}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details of the publisher", formalDefinition="Contacts to assist a user in finding and communicating with the publisher.")
    protected List<SearchParameterContactComponent> contact;
    @Child(name="useContext", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Content intends to support these contexts", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of search parameters.")
    protected List<CodeableConcept> useContext;
    @Child(name="requirements", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this search parameter is defined", formalDefinition="The Scope and Usage that this search parameter was created to meet.")
    protected StringType requirements;
    @Child(name="code", type={CodeType.class}, order=9, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Code used in URL", formalDefinition="The code used in the URL or the parameter name in a parameters resource for this search parameter.")
    protected CodeType code;
    @Child(name="base", type={CodeType.class}, order=10, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The resource type this search parameter applies to", formalDefinition="The base resource type that this search parameter refers to.")
    protected CodeType base;
    @Child(name="type", type={CodeType.class}, order=11, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="number | date | string | token | reference | composite | quantity | uri", formalDefinition="The type of value a search parameter refers to, and how the content is interpreted.")
    protected Enumeration<Enumerations.SearchParamType> type;
    @Child(name="description", type={StringType.class}, order=12, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Documentation for  search parameter", formalDefinition="A description of the search parameters and how it used.")
    protected StringType description;
    @Child(name="expression", type={StringType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="FluentPath expression that extracts the values", formalDefinition="A FluentPath expression that returns a set of elements for the search parameter.")
    protected StringType expression;
    @Child(name="xpath", type={StringType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="XPath that extracts the values", formalDefinition="An XPath expression that returns a set of elements for the search parameter.")
    protected StringType xpath;
    @Child(name="xpathUsage", type={CodeType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="normal | phonetic | nearby | distance | other", formalDefinition="How the search parameter relates to the set of elements returned by evaluating the xpath query.")
    protected Enumeration<XPathUsageType> xpathUsage;
    @Child(name="target", type={CodeType.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Types of resource (if a resource reference)", formalDefinition="Types of resource (if a resource is referenced).")
    protected List<CodeType> target;
    private static final long serialVersionUID = -310845178L;
    @SearchParamDefinition(name="description", path="SearchParameter.description", description="Documentation for  search parameter", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="name", path="SearchParameter.name", description="Informal name for this search parameter", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="context", path="SearchParameter.useContext", description="A use context assigned to the search parameter", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="target", path="SearchParameter.target", description="Types of resource (if a resource reference)", type="token")
    public static final String SP_TARGET = "target";
    public static final TokenClientParam TARGET = new TokenClientParam("target");
    @SearchParamDefinition(name="base", path="SearchParameter.base", description="The resource type this search parameter applies to", type="token")
    public static final String SP_BASE = "base";
    public static final TokenClientParam BASE = new TokenClientParam("base");
    @SearchParamDefinition(name="code", path="SearchParameter.code", description="Code used in URL", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="type", path="SearchParameter.type", description="number | date | string | token | reference | composite | quantity | uri", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="url", path="SearchParameter.url", description="Absolute URL used to reference this search parameter", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");

    public SearchParameter() {
    }

    public SearchParameter(UriType url, StringType name, CodeType code, CodeType base, Enumeration<Enumerations.SearchParamType> type, StringType description) {
        this.url = url;
        this.name = name;
        this.code = code;
        this.base = base;
        this.type = type;
        this.description = description;
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public SearchParameter setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public SearchParameter setUrl(String value) {
        if (this.url == null) {
            this.url = new UriType();
        }
        this.url.setValue(value);
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public SearchParameter setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public SearchParameter setName(String value) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(value);
        return this;
    }

    public Enumeration<Enumerations.ConformanceResourceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public SearchParameter setStatusElement(Enumeration<Enumerations.ConformanceResourceStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.ConformanceResourceStatus getStatus() {
        return this.status == null ? null : (Enumerations.ConformanceResourceStatus)((Object)this.status.getValue());
    }

    public SearchParameter setStatus(Enumerations.ConformanceResourceStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public SearchParameter setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    public SearchParameter setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public SearchParameter setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public SearchParameter setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public SearchParameter setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    public SearchParameter setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    public List<SearchParameterContactComponent> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<SearchParameterContactComponent>();
        }
        return this.contact;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (SearchParameterContactComponent item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SearchParameterContactComponent addContact() {
        SearchParameterContactComponent t = new SearchParameterContactComponent();
        if (this.contact == null) {
            this.contact = new ArrayList<SearchParameterContactComponent>();
        }
        this.contact.add(t);
        return t;
    }

    public SearchParameter addContact(SearchParameterContactComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<SearchParameterContactComponent>();
        }
        this.contact.add(t);
        return this;
    }

    public List<CodeableConcept> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        return this.useContext;
    }

    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (CodeableConcept item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addUseContext() {
        CodeableConcept t = new CodeableConcept();
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        this.useContext.add(t);
        return t;
    }

    public SearchParameter addUseContext(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        this.useContext.add(t);
        return this;
    }

    public StringType getRequirementsElement() {
        if (this.requirements == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.requirements");
            }
            if (Configuration.doAutoCreate()) {
                this.requirements = new StringType();
            }
        }
        return this.requirements;
    }

    public boolean hasRequirementsElement() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public boolean hasRequirements() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public SearchParameter setRequirementsElement(StringType value) {
        this.requirements = value;
        return this;
    }

    public String getRequirements() {
        return this.requirements == null ? null : (String)this.requirements.getValue();
    }

    public SearchParameter setRequirements(String value) {
        if (Utilities.noString((String)value)) {
            this.requirements = null;
        } else {
            if (this.requirements == null) {
                this.requirements = new StringType();
            }
            this.requirements.setValue(value);
        }
        return this;
    }

    public CodeType getCodeElement() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeType();
            }
        }
        return this.code;
    }

    public boolean hasCodeElement() {
        return this.code != null && !this.code.isEmpty();
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public SearchParameter setCodeElement(CodeType value) {
        this.code = value;
        return this;
    }

    public String getCode() {
        return this.code == null ? null : (String)this.code.getValue();
    }

    public SearchParameter setCode(String value) {
        if (this.code == null) {
            this.code = new CodeType();
        }
        this.code.setValue(value);
        return this;
    }

    public CodeType getBaseElement() {
        if (this.base == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.base");
            }
            if (Configuration.doAutoCreate()) {
                this.base = new CodeType();
            }
        }
        return this.base;
    }

    public boolean hasBaseElement() {
        return this.base != null && !this.base.isEmpty();
    }

    public boolean hasBase() {
        return this.base != null && !this.base.isEmpty();
    }

    public SearchParameter setBaseElement(CodeType value) {
        this.base = value;
        return this;
    }

    public String getBase() {
        return this.base == null ? null : (String)this.base.getValue();
    }

    public SearchParameter setBase(String value) {
        if (this.base == null) {
            this.base = new CodeType();
        }
        this.base.setValue(value);
        return this;
    }

    public Enumeration<Enumerations.SearchParamType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public SearchParameter setTypeElement(Enumeration<Enumerations.SearchParamType> value) {
        this.type = value;
        return this;
    }

    public Enumerations.SearchParamType getType() {
        return this.type == null ? null : (Enumerations.SearchParamType)((Object)this.type.getValue());
    }

    public SearchParameter setType(Enumerations.SearchParamType value) {
        if (this.type == null) {
            this.type = new Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public SearchParameter setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public SearchParameter setDescription(String value) {
        if (this.description == null) {
            this.description = new StringType();
        }
        this.description.setValue(value);
        return this;
    }

    public StringType getExpressionElement() {
        if (this.expression == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.expression");
            }
            if (Configuration.doAutoCreate()) {
                this.expression = new StringType();
            }
        }
        return this.expression;
    }

    public boolean hasExpressionElement() {
        return this.expression != null && !this.expression.isEmpty();
    }

    public boolean hasExpression() {
        return this.expression != null && !this.expression.isEmpty();
    }

    public SearchParameter setExpressionElement(StringType value) {
        this.expression = value;
        return this;
    }

    public String getExpression() {
        return this.expression == null ? null : (String)this.expression.getValue();
    }

    public SearchParameter setExpression(String value) {
        if (Utilities.noString((String)value)) {
            this.expression = null;
        } else {
            if (this.expression == null) {
                this.expression = new StringType();
            }
            this.expression.setValue(value);
        }
        return this;
    }

    public StringType getXpathElement() {
        if (this.xpath == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.xpath");
            }
            if (Configuration.doAutoCreate()) {
                this.xpath = new StringType();
            }
        }
        return this.xpath;
    }

    public boolean hasXpathElement() {
        return this.xpath != null && !this.xpath.isEmpty();
    }

    public boolean hasXpath() {
        return this.xpath != null && !this.xpath.isEmpty();
    }

    public SearchParameter setXpathElement(StringType value) {
        this.xpath = value;
        return this;
    }

    public String getXpath() {
        return this.xpath == null ? null : (String)this.xpath.getValue();
    }

    public SearchParameter setXpath(String value) {
        if (Utilities.noString((String)value)) {
            this.xpath = null;
        } else {
            if (this.xpath == null) {
                this.xpath = new StringType();
            }
            this.xpath.setValue(value);
        }
        return this;
    }

    public Enumeration<XPathUsageType> getXpathUsageElement() {
        if (this.xpathUsage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.xpathUsage");
            }
            if (Configuration.doAutoCreate()) {
                this.xpathUsage = new Enumeration<XPathUsageType>(new XPathUsageTypeEnumFactory());
            }
        }
        return this.xpathUsage;
    }

    public boolean hasXpathUsageElement() {
        return this.xpathUsage != null && !this.xpathUsage.isEmpty();
    }

    public boolean hasXpathUsage() {
        return this.xpathUsage != null && !this.xpathUsage.isEmpty();
    }

    public SearchParameter setXpathUsageElement(Enumeration<XPathUsageType> value) {
        this.xpathUsage = value;
        return this;
    }

    public XPathUsageType getXpathUsage() {
        return this.xpathUsage == null ? null : (XPathUsageType)((Object)this.xpathUsage.getValue());
    }

    public SearchParameter setXpathUsage(XPathUsageType value) {
        if (value == null) {
            this.xpathUsage = null;
        } else {
            if (this.xpathUsage == null) {
                this.xpathUsage = new Enumeration<XPathUsageType>(new XPathUsageTypeEnumFactory());
            }
            this.xpathUsage.setValue((Object)value);
        }
        return this;
    }

    public List<CodeType> getTarget() {
        if (this.target == null) {
            this.target = new ArrayList<CodeType>();
        }
        return this.target;
    }

    public boolean hasTarget() {
        if (this.target == null) {
            return false;
        }
        for (CodeType item : this.target) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeType addTargetElement() {
        CodeType t = new CodeType();
        if (this.target == null) {
            this.target = new ArrayList<CodeType>();
        }
        this.target.add(t);
        return t;
    }

    public SearchParameter addTarget(String value) {
        CodeType t = new CodeType();
        t.setValue(value);
        if (this.target == null) {
            this.target = new ArrayList<CodeType>();
        }
        this.target.add(t);
        return this;
    }

    public boolean hasTarget(String value) {
        if (this.target == null) {
            return false;
        }
        for (CodeType v : this.target) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_URL, "uri", "An absolute URL that is used to identify this search parameter when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this search parameter is (or will be) published.", 0, Integer.MAX_VALUE, this.url));
        childrenList.add(new Property(SP_NAME, "string", "A free text natural language name identifying the search parameter.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property("status", SP_CODE, "The status of this search parameter definition.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("experimental", "boolean", "A flag to indicate that this search parameter definition is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, Integer.MAX_VALUE, this.experimental));
        childrenList.add(new Property("date", "dateTime", "The date  (and optionally time) when the search parameter definition was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the search parameter changes.", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property("publisher", "string", "The name of the individual or organization that published the search parameter.", 0, Integer.MAX_VALUE, this.publisher));
        childrenList.add(new Property("contact", "", "Contacts to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        childrenList.add(new Property("useContext", "CodeableConcept", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of search parameters.", 0, Integer.MAX_VALUE, this.useContext));
        childrenList.add(new Property("requirements", "string", "The Scope and Usage that this search parameter was created to meet.", 0, Integer.MAX_VALUE, this.requirements));
        childrenList.add(new Property(SP_CODE, SP_CODE, "The code used in the URL or the parameter name in a parameters resource for this search parameter.", 0, Integer.MAX_VALUE, this.code));
        childrenList.add(new Property(SP_BASE, SP_CODE, "The base resource type that this search parameter refers to.", 0, Integer.MAX_VALUE, this.base));
        childrenList.add(new Property(SP_TYPE, SP_CODE, "The type of value a search parameter refers to, and how the content is interpreted.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property(SP_DESCRIPTION, "string", "A description of the search parameters and how it used.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("expression", "string", "A FluentPath expression that returns a set of elements for the search parameter.", 0, Integer.MAX_VALUE, this.expression));
        childrenList.add(new Property("xpath", "string", "An XPath expression that returns a set of elements for the search parameter.", 0, Integer.MAX_VALUE, this.xpath));
        childrenList.add(new Property("xpathUsage", SP_CODE, "How the search parameter relates to the set of elements returned by evaluating the xpath query.", 0, Integer.MAX_VALUE, this.xpathUsage));
        childrenList.add(new Property(SP_TARGET, SP_CODE, "Types of resource (if a resource is referenced).", 0, Integer.MAX_VALUE, this.target));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.name;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -1619874672: {
                Base[] baseArray;
                if (this.requirements == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.requirements;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.code;
                }
                return baseArray;
            }
            case 3016401: {
                Base[] baseArray;
                if (this.base == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.base;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.type;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.description;
                }
                return baseArray;
            }
            case -1795452264: {
                Base[] baseArray;
                if (this.expression == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.expression;
                }
                return baseArray;
            }
            case 114256029: {
                Base[] baseArray;
                if (this.xpath == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.xpath;
                }
                return baseArray;
            }
            case 1801322244: {
                Base[] baseArray;
                if (this.xpathUsage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.xpathUsage;
                }
                return baseArray;
            }
            case -880905839: {
                return this.target == null ? new Base[]{} : this.target.toArray(new Base[this.target.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                break;
            }
            case 3373707: {
                this.name = this.castToString(value);
                break;
            }
            case -892481550: {
                this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
                break;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                break;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                break;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                break;
            }
            case 951526432: {
                this.getContact().add((SearchParameterContactComponent)value);
                break;
            }
            case -669707736: {
                this.getUseContext().add(this.castToCodeableConcept(value));
                break;
            }
            case -1619874672: {
                this.requirements = this.castToString(value);
                break;
            }
            case 3059181: {
                this.code = this.castToCode(value);
                break;
            }
            case 3016401: {
                this.base = this.castToCode(value);
                break;
            }
            case 3575610: {
                this.type = new Enumerations.SearchParamTypeEnumFactory().fromType(value);
                break;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                break;
            }
            case -1795452264: {
                this.expression = this.castToString(value);
                break;
            }
            case 114256029: {
                this.xpath = this.castToString(value);
                break;
            }
            case 1801322244: {
                this.xpathUsage = new XPathUsageTypeEnumFactory().fromType(value);
                break;
            }
            case -880905839: {
                this.getTarget().add(this.castToCode(value));
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals("status")) {
            this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals("date")) {
            this.date = this.castToDateTime(value);
        } else if (name.equals("publisher")) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add((SearchParameterContactComponent)value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToCodeableConcept(value));
        } else if (name.equals("requirements")) {
            this.requirements = this.castToString(value);
        } else if (name.equals(SP_CODE)) {
            this.code = this.castToCode(value);
        } else if (name.equals(SP_BASE)) {
            this.base = this.castToCode(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = new Enumerations.SearchParamTypeEnumFactory().fromType(value);
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToString(value);
        } else if (name.equals("expression")) {
            this.expression = this.castToString(value);
        } else if (name.equals("xpath")) {
            this.xpath = this.castToString(value);
        } else if (name.equals("xpathUsage")) {
            this.xpathUsage = new XPathUsageTypeEnumFactory().fromType(value);
        } else if (name.equals(SP_TARGET)) {
            this.getTarget().add(this.castToCode(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                throw new FHIRException("Cannot make property url as it is not a complex type");
            }
            case 3373707: {
                throw new FHIRException("Cannot make property name as it is not a complex type");
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case -404562712: {
                throw new FHIRException("Cannot make property experimental as it is not a complex type");
            }
            case 3076014: {
                throw new FHIRException("Cannot make property date as it is not a complex type");
            }
            case 1447404028: {
                throw new FHIRException("Cannot make property publisher as it is not a complex type");
            }
            case 951526432: {
                return this.addContact();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -1619874672: {
                throw new FHIRException("Cannot make property requirements as it is not a complex type");
            }
            case 3059181: {
                throw new FHIRException("Cannot make property code as it is not a complex type");
            }
            case 3016401: {
                throw new FHIRException("Cannot make property base as it is not a complex type");
            }
            case 3575610: {
                throw new FHIRException("Cannot make property type as it is not a complex type");
            }
            case -1724546052: {
                throw new FHIRException("Cannot make property description as it is not a complex type");
            }
            case -1795452264: {
                throw new FHIRException("Cannot make property expression as it is not a complex type");
            }
            case 114256029: {
                throw new FHIRException("Cannot make property xpath as it is not a complex type");
            }
            case 1801322244: {
                throw new FHIRException("Cannot make property xpathUsage as it is not a complex type");
            }
            case -880905839: {
                throw new FHIRException("Cannot make property target as it is not a complex type");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.url");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.name");
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.experimental");
        }
        if (name.equals("date")) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.date");
        }
        if (name.equals("publisher")) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals("requirements")) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.requirements");
        }
        if (name.equals(SP_CODE)) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.code");
        }
        if (name.equals(SP_BASE)) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.base");
        }
        if (name.equals(SP_TYPE)) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.type");
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.description");
        }
        if (name.equals("expression")) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.expression");
        }
        if (name.equals("xpath")) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.xpath");
        }
        if (name.equals("xpathUsage")) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.xpathUsage");
        }
        if (name.equals(SP_TARGET)) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.target");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SearchParameter";
    }

    @Override
    public SearchParameter copy() {
        SearchParameter dst = new SearchParameter();
        this.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<SearchParameterContactComponent>();
            for (SearchParameterContactComponent searchParameterContactComponent : this.contact) {
                dst.contact.add(searchParameterContactComponent.copy());
            }
        }
        if (this.useContext != null) {
            dst.useContext = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.useContext) {
                dst.useContext.add(codeableConcept.copy());
            }
        }
        dst.requirements = this.requirements == null ? null : this.requirements.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.base = this.base == null ? null : this.base.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.description = this.description == null ? null : this.description.copy();
        dst.expression = this.expression == null ? null : this.expression.copy();
        dst.xpath = this.xpath == null ? null : this.xpath.copy();
        Enumeration<XPathUsageType> enumeration = dst.xpathUsage = this.xpathUsage == null ? null : this.xpathUsage.copy();
        if (this.target != null) {
            dst.target = new ArrayList<CodeType>();
            for (CodeType codeType : this.target) {
                dst.target.add(codeType.copy());
            }
        }
        return dst;
    }

    protected SearchParameter typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof SearchParameter)) {
            return false;
        }
        SearchParameter o = (SearchParameter)other;
        return SearchParameter.compareDeep(this.url, o.url, true) && SearchParameter.compareDeep(this.name, o.name, true) && SearchParameter.compareDeep(this.status, o.status, true) && SearchParameter.compareDeep(this.experimental, o.experimental, true) && SearchParameter.compareDeep(this.date, o.date, true) && SearchParameter.compareDeep(this.publisher, o.publisher, true) && SearchParameter.compareDeep(this.contact, o.contact, true) && SearchParameter.compareDeep(this.useContext, o.useContext, true) && SearchParameter.compareDeep(this.requirements, o.requirements, true) && SearchParameter.compareDeep(this.code, o.code, true) && SearchParameter.compareDeep(this.base, o.base, true) && SearchParameter.compareDeep(this.type, o.type, true) && SearchParameter.compareDeep(this.description, o.description, true) && SearchParameter.compareDeep(this.expression, o.expression, true) && SearchParameter.compareDeep(this.xpath, o.xpath, true) && SearchParameter.compareDeep(this.xpathUsage, o.xpathUsage, true) && SearchParameter.compareDeep(this.target, o.target, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof SearchParameter)) {
            return false;
        }
        SearchParameter o = (SearchParameter)other;
        return SearchParameter.compareValues(this.url, o.url, true) && SearchParameter.compareValues(this.name, o.name, true) && SearchParameter.compareValues(this.status, o.status, true) && SearchParameter.compareValues(this.experimental, o.experimental, true) && SearchParameter.compareValues(this.date, o.date, true) && SearchParameter.compareValues(this.publisher, o.publisher, true) && SearchParameter.compareValues(this.requirements, o.requirements, true) && SearchParameter.compareValues(this.code, o.code, true) && SearchParameter.compareValues(this.base, o.base, true) && SearchParameter.compareValues(this.type, o.type, true) && SearchParameter.compareValues(this.description, o.description, true) && SearchParameter.compareValues(this.expression, o.expression, true) && SearchParameter.compareValues(this.xpath, o.xpath, true) && SearchParameter.compareValues(this.xpathUsage, o.xpathUsage, true) && SearchParameter.compareValues(this.target, o.target, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.url != null && !this.url.isEmpty() || this.name != null && !this.name.isEmpty() || this.status != null && !this.status.isEmpty() || this.experimental != null && !this.experimental.isEmpty() || this.date != null && !this.date.isEmpty() || this.publisher != null && !this.publisher.isEmpty() || this.contact != null && !this.contact.isEmpty() || this.useContext != null && !this.useContext.isEmpty() || this.requirements != null && !this.requirements.isEmpty() || this.code != null && !this.code.isEmpty() || this.base != null && !this.base.isEmpty() || this.type != null && !this.type.isEmpty() || this.description != null && !this.description.isEmpty() || this.expression != null && !this.expression.isEmpty() || this.xpath != null && !this.xpath.isEmpty() || this.xpathUsage != null && !this.xpathUsage.isEmpty() || this.target != null && !this.target.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SearchParameter;
    }

    @Block
    public static class SearchParameterContactComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of an individual to contact", formalDefinition="The name of an individual to contact regarding the search parameter.")
        protected StringType name;
        @Child(name="telecom", type={ContactPoint.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Contact details for individual or publisher", formalDefinition="Contact details for individual (if a name was provided) or the publisher.")
        protected List<ContactPoint> telecom;
        private static final long serialVersionUID = -1179697803L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SearchParameterContactComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public SearchParameterContactComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public SearchParameterContactComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public SearchParameterContactComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(SearchParameter.SP_NAME, "string", "The name of an individual to contact regarding the search parameter.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("telecom", "ContactPoint", "Contact details for individual (if a name was provided) or the publisher.", 0, Integer.MAX_VALUE, this.telecom));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1429363305: {
                    return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1429363305: {
                    this.getTelecom().add(this.castToContactPoint(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(SearchParameter.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("telecom")) {
                this.getTelecom().add(this.castToContactPoint(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1429363305: {
                    return this.addTelecom();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(SearchParameter.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.name");
            }
            if (name.equals("telecom")) {
                return this.addTelecom();
            }
            return super.addChild(name);
        }

        @Override
        public SearchParameterContactComponent copy() {
            SearchParameterContactComponent dst = new SearchParameterContactComponent();
            this.copyValues(dst);
            StringType stringType = dst.name = this.name == null ? null : this.name.copy();
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint i : this.telecom) {
                    dst.telecom.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SearchParameterContactComponent)) {
                return false;
            }
            SearchParameterContactComponent o = (SearchParameterContactComponent)other;
            return SearchParameterContactComponent.compareDeep(this.name, o.name, true) && SearchParameterContactComponent.compareDeep(this.telecom, o.telecom, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SearchParameterContactComponent)) {
                return false;
            }
            SearchParameterContactComponent o = (SearchParameterContactComponent)other;
            return SearchParameterContactComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.telecom != null && !this.telecom.isEmpty());
        }

        @Override
        public String fhirType() {
            return "SearchParameter.contact";
        }
    }

    public static class XPathUsageTypeEnumFactory
    implements EnumFactory<XPathUsageType> {
        @Override
        public XPathUsageType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("normal".equals(codeString)) {
                return XPathUsageType.NORMAL;
            }
            if ("phonetic".equals(codeString)) {
                return XPathUsageType.PHONETIC;
            }
            if ("nearby".equals(codeString)) {
                return XPathUsageType.NEARBY;
            }
            if ("distance".equals(codeString)) {
                return XPathUsageType.DISTANCE;
            }
            if ("other".equals(codeString)) {
                return XPathUsageType.OTHER;
            }
            throw new IllegalArgumentException("Unknown XPathUsageType code '" + codeString + "'");
        }

        public Enumeration<XPathUsageType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("normal".equals(codeString)) {
                return new Enumeration<XPathUsageType>(this, XPathUsageType.NORMAL);
            }
            if ("phonetic".equals(codeString)) {
                return new Enumeration<XPathUsageType>(this, XPathUsageType.PHONETIC);
            }
            if ("nearby".equals(codeString)) {
                return new Enumeration<XPathUsageType>(this, XPathUsageType.NEARBY);
            }
            if ("distance".equals(codeString)) {
                return new Enumeration<XPathUsageType>(this, XPathUsageType.DISTANCE);
            }
            if ("other".equals(codeString)) {
                return new Enumeration<XPathUsageType>(this, XPathUsageType.OTHER);
            }
            throw new FHIRException("Unknown XPathUsageType code '" + codeString + "'");
        }

        @Override
        public String toCode(XPathUsageType code) {
            if (code == XPathUsageType.NORMAL) {
                return "normal";
            }
            if (code == XPathUsageType.PHONETIC) {
                return "phonetic";
            }
            if (code == XPathUsageType.NEARBY) {
                return "nearby";
            }
            if (code == XPathUsageType.DISTANCE) {
                return "distance";
            }
            if (code == XPathUsageType.OTHER) {
                return "other";
            }
            return "?";
        }

        @Override
        public String toSystem(XPathUsageType code) {
            return code.getSystem();
        }
    }

    public static enum XPathUsageType {
        NORMAL,
        PHONETIC,
        NEARBY,
        DISTANCE,
        OTHER,
        NULL;


        public static XPathUsageType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("normal".equals(codeString)) {
                return NORMAL;
            }
            if ("phonetic".equals(codeString)) {
                return PHONETIC;
            }
            if ("nearby".equals(codeString)) {
                return NEARBY;
            }
            if ("distance".equals(codeString)) {
                return DISTANCE;
            }
            if ("other".equals(codeString)) {
                return OTHER;
            }
            throw new FHIRException("Unknown XPathUsageType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case NORMAL: {
                    return "normal";
                }
                case PHONETIC: {
                    return "phonetic";
                }
                case NEARBY: {
                    return "nearby";
                }
                case DISTANCE: {
                    return "distance";
                }
                case OTHER: {
                    return "other";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case NORMAL: {
                    return "http://hl7.org/fhir/search-xpath-usage";
                }
                case PHONETIC: {
                    return "http://hl7.org/fhir/search-xpath-usage";
                }
                case NEARBY: {
                    return "http://hl7.org/fhir/search-xpath-usage";
                }
                case DISTANCE: {
                    return "http://hl7.org/fhir/search-xpath-usage";
                }
                case OTHER: {
                    return "http://hl7.org/fhir/search-xpath-usage";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case NORMAL: {
                    return "The search parameter is derived directly from the selected nodes based on the type definitions.";
                }
                case PHONETIC: {
                    return "The search parameter is derived by a phonetic transform from the selected nodes.";
                }
                case NEARBY: {
                    return "The search parameter is based on a spatial transform of the selected nodes.";
                }
                case DISTANCE: {
                    return "The search parameter is based on a spatial transform of the selected nodes, using physical distance from the middle.";
                }
                case OTHER: {
                    return "The interpretation of the xpath statement is unknown (and can't be automated).";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case NORMAL: {
                    return "Normal";
                }
                case PHONETIC: {
                    return "Phonetic";
                }
                case NEARBY: {
                    return "Nearby";
                }
                case DISTANCE: {
                    return "Distance";
                }
                case OTHER: {
                    return "Other";
                }
            }
            return "?";
        }
    }
}

