/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ProcessResponse", profile="http://hl7.org/fhir/Profile/ProcessResponse")
public class ProcessResponse
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier", formalDefinition="The Response business identifier.")
    protected List<Identifier> identifier;
    @Child(name="request", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Request reference", formalDefinition="Original request resource reference.")
    protected Type request;
    @Child(name="outcome", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Processing outcome", formalDefinition="Transaction status: error, complete, held.")
    protected Coding outcome;
    @Child(name="disposition", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Disposition Message", formalDefinition="A description of the status of the adjudication or processing.")
    protected StringType disposition;
    @Child(name="ruleset", type={Coding.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Resource version", formalDefinition="The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.")
    protected Coding ruleset;
    @Child(name="originalRuleset", type={Coding.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Original version", formalDefinition="The style (standard) and version of the original material which was converted into this resource.")
    protected Coding originalRuleset;
    @Child(name="created", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Creation date", formalDefinition="The date when the enclosed suite of services were performed or completed.")
    protected DateTimeType created;
    @Child(name="organization", type={Identifier.class, Organization.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Authoring Organization", formalDefinition="The organization who produced this adjudicated response.")
    protected Type organization;
    @Child(name="requestProvider", type={Identifier.class, Practitioner.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible Practitioner", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    protected Type requestProvider;
    @Child(name="requestOrganization", type={Identifier.class, Organization.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible organization", formalDefinition="The organization which is responsible for the services rendered to the patient.")
    protected Type requestOrganization;
    @Child(name="form", type={Coding.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Printed Form Identifier", formalDefinition="The form to be used for printing the content.")
    protected Coding form;
    @Child(name="notes", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Notes", formalDefinition="Suite of processing note or additional requirements is the processing has been held.")
    protected List<ProcessResponseNotesComponent> notes;
    @Child(name="error", type={Coding.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Error code", formalDefinition="Processing errors.")
    protected List<Coding> error;
    private static final long serialVersionUID = -501204073L;
    @SearchParamDefinition(name="requestorganizationreference", path="ProcessResponse.requestOrganization.as(Reference)", description="The Organization who is responsible the request transaction", type="reference")
    public static final String SP_REQUESTORGANIZATIONREFERENCE = "requestorganizationreference";
    public static final ReferenceClientParam REQUESTORGANIZATIONREFERENCE = new ReferenceClientParam("requestorganizationreference");
    public static final Include INCLUDE_REQUESTORGANIZATIONREFERENCE = new Include("ProcessResponse:requestorganizationreference").toLocked();
    @SearchParamDefinition(name="requestorganizationidentifier", path="ProcessResponse.requestOrganization.as(Identifier)", description="The Organization who is responsible the request transaction", type="token")
    public static final String SP_REQUESTORGANIZATIONIDENTIFIER = "requestorganizationidentifier";
    public static final TokenClientParam REQUESTORGANIZATIONIDENTIFIER = new TokenClientParam("requestorganizationidentifier");
    @SearchParamDefinition(name="requestprovideridentifier", path="ProcessResponse.requestProvider.as(Identifier)", description="The Provider who is responsible the request transaction", type="token")
    public static final String SP_REQUESTPROVIDERIDENTIFIER = "requestprovideridentifier";
    public static final TokenClientParam REQUESTPROVIDERIDENTIFIER = new TokenClientParam("requestprovideridentifier");
    @SearchParamDefinition(name="requestidentifier", path="ProcessResponse.request.as(Identifier)", description="The reference to the claim", type="token")
    public static final String SP_REQUESTIDENTIFIER = "requestidentifier";
    public static final TokenClientParam REQUESTIDENTIFIER = new TokenClientParam("requestidentifier");
    @SearchParamDefinition(name="requestreference", path="ProcessResponse.request.as(Reference)", description="The reference to the claim", type="reference")
    public static final String SP_REQUESTREFERENCE = "requestreference";
    public static final ReferenceClientParam REQUESTREFERENCE = new ReferenceClientParam("requestreference");
    public static final Include INCLUDE_REQUESTREFERENCE = new Include("ProcessResponse:requestreference").toLocked();
    @SearchParamDefinition(name="organizationidentifier", path="ProcessResponse.organization.as(Identifier)", description="The organization who generated this resource", type="token")
    public static final String SP_ORGANIZATIONIDENTIFIER = "organizationidentifier";
    public static final TokenClientParam ORGANIZATIONIDENTIFIER = new TokenClientParam("organizationidentifier");
    @SearchParamDefinition(name="requestproviderreference", path="ProcessResponse.requestProvider.as(Reference)", description="The Provider who is responsible the request transaction", type="reference")
    public static final String SP_REQUESTPROVIDERREFERENCE = "requestproviderreference";
    public static final ReferenceClientParam REQUESTPROVIDERREFERENCE = new ReferenceClientParam("requestproviderreference");
    public static final Include INCLUDE_REQUESTPROVIDERREFERENCE = new Include("ProcessResponse:requestproviderreference").toLocked();
    @SearchParamDefinition(name="organizationreference", path="ProcessResponse.organization.as(Reference)", description="The organization who generated this resource", type="reference")
    public static final String SP_ORGANIZATIONREFERENCE = "organizationreference";
    public static final ReferenceClientParam ORGANIZATIONREFERENCE = new ReferenceClientParam("organizationreference");
    public static final Include INCLUDE_ORGANIZATIONREFERENCE = new Include("ProcessResponse:organizationreference").toLocked();
    @SearchParamDefinition(name="identifier", path="ProcessResponse.identifier", description="The business identifier of the Explanation of Benefit", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ProcessResponse addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Type getRequest() {
        return this.request;
    }

    public Identifier getRequestIdentifier() throws FHIRException {
        if (!(this.request instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.request.getClass().getName() + " was encountered");
        }
        return (Identifier)this.request;
    }

    public boolean hasRequestIdentifier() {
        return this.request instanceof Identifier;
    }

    public Reference getRequestReference() throws FHIRException {
        if (!(this.request instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.request.getClass().getName() + " was encountered");
        }
        return (Reference)this.request;
    }

    public boolean hasRequestReference() {
        return this.request instanceof Reference;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public ProcessResponse setRequest(Type value) {
        this.request = value;
        return this;
    }

    public Coding getOutcome() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessResponse.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new Coding();
            }
        }
        return this.outcome;
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public ProcessResponse setOutcome(Coding value) {
        this.outcome = value;
        return this;
    }

    public StringType getDispositionElement() {
        if (this.disposition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessResponse.disposition");
            }
            if (Configuration.doAutoCreate()) {
                this.disposition = new StringType();
            }
        }
        return this.disposition;
    }

    public boolean hasDispositionElement() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public boolean hasDisposition() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public ProcessResponse setDispositionElement(StringType value) {
        this.disposition = value;
        return this;
    }

    public String getDisposition() {
        return this.disposition == null ? null : (String)this.disposition.getValue();
    }

    public ProcessResponse setDisposition(String value) {
        if (Utilities.noString((String)value)) {
            this.disposition = null;
        } else {
            if (this.disposition == null) {
                this.disposition = new StringType();
            }
            this.disposition.setValue(value);
        }
        return this;
    }

    public Coding getRuleset() {
        if (this.ruleset == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessResponse.ruleset");
            }
            if (Configuration.doAutoCreate()) {
                this.ruleset = new Coding();
            }
        }
        return this.ruleset;
    }

    public boolean hasRuleset() {
        return this.ruleset != null && !this.ruleset.isEmpty();
    }

    public ProcessResponse setRuleset(Coding value) {
        this.ruleset = value;
        return this;
    }

    public Coding getOriginalRuleset() {
        if (this.originalRuleset == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessResponse.originalRuleset");
            }
            if (Configuration.doAutoCreate()) {
                this.originalRuleset = new Coding();
            }
        }
        return this.originalRuleset;
    }

    public boolean hasOriginalRuleset() {
        return this.originalRuleset != null && !this.originalRuleset.isEmpty();
    }

    public ProcessResponse setOriginalRuleset(Coding value) {
        this.originalRuleset = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessResponse.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public ProcessResponse setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public ProcessResponse setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public Type getOrganization() {
        return this.organization;
    }

    public Identifier getOrganizationIdentifier() throws FHIRException {
        if (!(this.organization instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.organization.getClass().getName() + " was encountered");
        }
        return (Identifier)this.organization;
    }

    public boolean hasOrganizationIdentifier() {
        return this.organization instanceof Identifier;
    }

    public Reference getOrganizationReference() throws FHIRException {
        if (!(this.organization instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.organization.getClass().getName() + " was encountered");
        }
        return (Reference)this.organization;
    }

    public boolean hasOrganizationReference() {
        return this.organization instanceof Reference;
    }

    public boolean hasOrganization() {
        return this.organization != null && !this.organization.isEmpty();
    }

    public ProcessResponse setOrganization(Type value) {
        this.organization = value;
        return this;
    }

    public Type getRequestProvider() {
        return this.requestProvider;
    }

    public Identifier getRequestProviderIdentifier() throws FHIRException {
        if (!(this.requestProvider instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.requestProvider.getClass().getName() + " was encountered");
        }
        return (Identifier)this.requestProvider;
    }

    public boolean hasRequestProviderIdentifier() {
        return this.requestProvider instanceof Identifier;
    }

    public Reference getRequestProviderReference() throws FHIRException {
        if (!(this.requestProvider instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.requestProvider.getClass().getName() + " was encountered");
        }
        return (Reference)this.requestProvider;
    }

    public boolean hasRequestProviderReference() {
        return this.requestProvider instanceof Reference;
    }

    public boolean hasRequestProvider() {
        return this.requestProvider != null && !this.requestProvider.isEmpty();
    }

    public ProcessResponse setRequestProvider(Type value) {
        this.requestProvider = value;
        return this;
    }

    public Type getRequestOrganization() {
        return this.requestOrganization;
    }

    public Identifier getRequestOrganizationIdentifier() throws FHIRException {
        if (!(this.requestOrganization instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.requestOrganization.getClass().getName() + " was encountered");
        }
        return (Identifier)this.requestOrganization;
    }

    public boolean hasRequestOrganizationIdentifier() {
        return this.requestOrganization instanceof Identifier;
    }

    public Reference getRequestOrganizationReference() throws FHIRException {
        if (!(this.requestOrganization instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.requestOrganization.getClass().getName() + " was encountered");
        }
        return (Reference)this.requestOrganization;
    }

    public boolean hasRequestOrganizationReference() {
        return this.requestOrganization instanceof Reference;
    }

    public boolean hasRequestOrganization() {
        return this.requestOrganization != null && !this.requestOrganization.isEmpty();
    }

    public ProcessResponse setRequestOrganization(Type value) {
        this.requestOrganization = value;
        return this;
    }

    public Coding getForm() {
        if (this.form == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessResponse.form");
            }
            if (Configuration.doAutoCreate()) {
                this.form = new Coding();
            }
        }
        return this.form;
    }

    public boolean hasForm() {
        return this.form != null && !this.form.isEmpty();
    }

    public ProcessResponse setForm(Coding value) {
        this.form = value;
        return this;
    }

    public List<ProcessResponseNotesComponent> getNotes() {
        if (this.notes == null) {
            this.notes = new ArrayList<ProcessResponseNotesComponent>();
        }
        return this.notes;
    }

    public boolean hasNotes() {
        if (this.notes == null) {
            return false;
        }
        for (ProcessResponseNotesComponent item : this.notes) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProcessResponseNotesComponent addNotes() {
        ProcessResponseNotesComponent t = new ProcessResponseNotesComponent();
        if (this.notes == null) {
            this.notes = new ArrayList<ProcessResponseNotesComponent>();
        }
        this.notes.add(t);
        return t;
    }

    public ProcessResponse addNotes(ProcessResponseNotesComponent t) {
        if (t == null) {
            return this;
        }
        if (this.notes == null) {
            this.notes = new ArrayList<ProcessResponseNotesComponent>();
        }
        this.notes.add(t);
        return this;
    }

    public List<Coding> getError() {
        if (this.error == null) {
            this.error = new ArrayList<Coding>();
        }
        return this.error;
    }

    public boolean hasError() {
        if (this.error == null) {
            return false;
        }
        for (Coding item : this.error) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addError() {
        Coding t = new Coding();
        if (this.error == null) {
            this.error = new ArrayList<Coding>();
        }
        this.error.add(t);
        return t;
    }

    public ProcessResponse addError(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.error == null) {
            this.error = new ArrayList<Coding>();
        }
        this.error.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "The Response business identifier.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("request[x]", "Identifier|Reference(Any)", "Original request resource reference.", 0, Integer.MAX_VALUE, this.request));
        childrenList.add(new Property("outcome", "Coding", "Transaction status: error, complete, held.", 0, Integer.MAX_VALUE, this.outcome));
        childrenList.add(new Property("disposition", "string", "A description of the status of the adjudication or processing.", 0, Integer.MAX_VALUE, this.disposition));
        childrenList.add(new Property("ruleset", "Coding", "The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.", 0, Integer.MAX_VALUE, this.ruleset));
        childrenList.add(new Property("originalRuleset", "Coding", "The style (standard) and version of the original material which was converted into this resource.", 0, Integer.MAX_VALUE, this.originalRuleset));
        childrenList.add(new Property("created", "dateTime", "The date when the enclosed suite of services were performed or completed.", 0, Integer.MAX_VALUE, this.created));
        childrenList.add(new Property("organization[x]", "Identifier|Reference(Organization)", "The organization who produced this adjudicated response.", 0, Integer.MAX_VALUE, this.organization));
        childrenList.add(new Property("requestProvider[x]", "Identifier|Reference(Practitioner)", "The practitioner who is responsible for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.requestProvider));
        childrenList.add(new Property("requestOrganization[x]", "Identifier|Reference(Organization)", "The organization which is responsible for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.requestOrganization));
        childrenList.add(new Property("form", "Coding", "The form to be used for printing the content.", 0, Integer.MAX_VALUE, this.form));
        childrenList.add(new Property("notes", "", "Suite of processing note or additional requirements is the processing has been held.", 0, Integer.MAX_VALUE, this.notes));
        childrenList.add(new Property("error", "Coding", "Processing errors.", 0, Integer.MAX_VALUE, this.error));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 1095692943: {
                Base[] baseArray;
                if (this.request == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.request;
                }
                return baseArray;
            }
            case -1106507950: {
                Base[] baseArray;
                if (this.outcome == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.outcome;
                }
                return baseArray;
            }
            case 583380919: {
                Base[] baseArray;
                if (this.disposition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.disposition;
                }
                return baseArray;
            }
            case 1548678118: {
                Base[] baseArray;
                if (this.ruleset == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.ruleset;
                }
                return baseArray;
            }
            case 1089373397: {
                Base[] baseArray;
                if (this.originalRuleset == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.originalRuleset;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.created;
                }
                return baseArray;
            }
            case 1178922291: {
                Base[] baseArray;
                if (this.organization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.organization;
                }
                return baseArray;
            }
            case 1601527200: {
                Base[] baseArray;
                if (this.requestProvider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.requestProvider;
                }
                return baseArray;
            }
            case 599053666: {
                Base[] baseArray;
                if (this.requestOrganization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.requestOrganization;
                }
                return baseArray;
            }
            case 3148996: {
                Base[] baseArray;
                if (this.form == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.form;
                }
                return baseArray;
            }
            case 105008833: {
                return this.notes == null ? new Base[]{} : this.notes.toArray(new Base[this.notes.size()]);
            }
            case 96784904: {
                return this.error == null ? new Base[]{} : this.error.toArray(new Base[this.error.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case 1095692943: {
                this.request = (Type)value;
                break;
            }
            case -1106507950: {
                this.outcome = this.castToCoding(value);
                break;
            }
            case 583380919: {
                this.disposition = this.castToString(value);
                break;
            }
            case 1548678118: {
                this.ruleset = this.castToCoding(value);
                break;
            }
            case 1089373397: {
                this.originalRuleset = this.castToCoding(value);
                break;
            }
            case 1028554472: {
                this.created = this.castToDateTime(value);
                break;
            }
            case 1178922291: {
                this.organization = (Type)value;
                break;
            }
            case 1601527200: {
                this.requestProvider = (Type)value;
                break;
            }
            case 599053666: {
                this.requestOrganization = (Type)value;
                break;
            }
            case 3148996: {
                this.form = this.castToCoding(value);
                break;
            }
            case 105008833: {
                this.getNotes().add((ProcessResponseNotesComponent)value);
                break;
            }
            case 96784904: {
                this.getError().add(this.castToCoding(value));
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("request[x]")) {
            this.request = (Type)value;
        } else if (name.equals("outcome")) {
            this.outcome = this.castToCoding(value);
        } else if (name.equals("disposition")) {
            this.disposition = this.castToString(value);
        } else if (name.equals("ruleset")) {
            this.ruleset = this.castToCoding(value);
        } else if (name.equals("originalRuleset")) {
            this.originalRuleset = this.castToCoding(value);
        } else if (name.equals("created")) {
            this.created = this.castToDateTime(value);
        } else if (name.equals("organization[x]")) {
            this.organization = (Type)value;
        } else if (name.equals("requestProvider[x]")) {
            this.requestProvider = (Type)value;
        } else if (name.equals("requestOrganization[x]")) {
            this.requestOrganization = (Type)value;
        } else if (name.equals("form")) {
            this.form = this.castToCoding(value);
        } else if (name.equals("notes")) {
            this.getNotes().add((ProcessResponseNotesComponent)value);
        } else if (name.equals("error")) {
            this.getError().add(this.castToCoding(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 37106577: {
                return this.getRequest();
            }
            case -1106507950: {
                return this.getOutcome();
            }
            case 583380919: {
                throw new FHIRException("Cannot make property disposition as it is not a complex type");
            }
            case 1548678118: {
                return this.getRuleset();
            }
            case 1089373397: {
                return this.getOriginalRuleset();
            }
            case 1028554472: {
                throw new FHIRException("Cannot make property created as it is not a complex type");
            }
            case 1326483053: {
                return this.getOrganization();
            }
            case -1694784800: {
                return this.getRequestProvider();
            }
            case 818740190: {
                return this.getRequestOrganization();
            }
            case 3148996: {
                return this.getForm();
            }
            case 105008833: {
                return this.addNotes();
            }
            case 96784904: {
                return this.addError();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("requestIdentifier")) {
            this.request = new Identifier();
            return this.request;
        }
        if (name.equals("requestReference")) {
            this.request = new Reference();
            return this.request;
        }
        if (name.equals("outcome")) {
            this.outcome = new Coding();
            return this.outcome;
        }
        if (name.equals("disposition")) {
            throw new FHIRException("Cannot call addChild on a primitive type ProcessResponse.disposition");
        }
        if (name.equals("ruleset")) {
            this.ruleset = new Coding();
            return this.ruleset;
        }
        if (name.equals("originalRuleset")) {
            this.originalRuleset = new Coding();
            return this.originalRuleset;
        }
        if (name.equals("created")) {
            throw new FHIRException("Cannot call addChild on a primitive type ProcessResponse.created");
        }
        if (name.equals("organizationIdentifier")) {
            this.organization = new Identifier();
            return this.organization;
        }
        if (name.equals("organizationReference")) {
            this.organization = new Reference();
            return this.organization;
        }
        if (name.equals("requestProviderIdentifier")) {
            this.requestProvider = new Identifier();
            return this.requestProvider;
        }
        if (name.equals("requestProviderReference")) {
            this.requestProvider = new Reference();
            return this.requestProvider;
        }
        if (name.equals("requestOrganizationIdentifier")) {
            this.requestOrganization = new Identifier();
            return this.requestOrganization;
        }
        if (name.equals("requestOrganizationReference")) {
            this.requestOrganization = new Reference();
            return this.requestOrganization;
        }
        if (name.equals("form")) {
            this.form = new Coding();
            return this.form;
        }
        if (name.equals("notes")) {
            return this.addNotes();
        }
        if (name.equals("error")) {
            return this.addError();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ProcessResponse";
    }

    @Override
    public ProcessResponse copy() {
        ProcessResponse dst = new ProcessResponse();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.request = this.request == null ? null : this.request.copy();
        dst.outcome = this.outcome == null ? null : this.outcome.copy();
        dst.disposition = this.disposition == null ? null : this.disposition.copy();
        dst.ruleset = this.ruleset == null ? null : this.ruleset.copy();
        dst.originalRuleset = this.originalRuleset == null ? null : this.originalRuleset.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.organization = this.organization == null ? null : this.organization.copy();
        dst.requestProvider = this.requestProvider == null ? null : this.requestProvider.copy();
        dst.requestOrganization = this.requestOrganization == null ? null : this.requestOrganization.copy();
        Coding coding = dst.form = this.form == null ? null : this.form.copy();
        if (this.notes != null) {
            dst.notes = new ArrayList<ProcessResponseNotesComponent>();
            for (ProcessResponseNotesComponent processResponseNotesComponent : this.notes) {
                dst.notes.add(processResponseNotesComponent.copy());
            }
        }
        if (this.error != null) {
            dst.error = new ArrayList<Coding>();
            for (Coding coding2 : this.error) {
                dst.error.add(coding2.copy());
            }
        }
        return dst;
    }

    protected ProcessResponse typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof ProcessResponse)) {
            return false;
        }
        ProcessResponse o = (ProcessResponse)other;
        return ProcessResponse.compareDeep(this.identifier, o.identifier, true) && ProcessResponse.compareDeep(this.request, o.request, true) && ProcessResponse.compareDeep(this.outcome, o.outcome, true) && ProcessResponse.compareDeep(this.disposition, o.disposition, true) && ProcessResponse.compareDeep(this.ruleset, o.ruleset, true) && ProcessResponse.compareDeep(this.originalRuleset, o.originalRuleset, true) && ProcessResponse.compareDeep(this.created, o.created, true) && ProcessResponse.compareDeep(this.organization, o.organization, true) && ProcessResponse.compareDeep(this.requestProvider, o.requestProvider, true) && ProcessResponse.compareDeep(this.requestOrganization, o.requestOrganization, true) && ProcessResponse.compareDeep(this.form, o.form, true) && ProcessResponse.compareDeep(this.notes, o.notes, true) && ProcessResponse.compareDeep(this.error, o.error, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof ProcessResponse)) {
            return false;
        }
        ProcessResponse o = (ProcessResponse)other;
        return ProcessResponse.compareValues(this.disposition, o.disposition, true) && ProcessResponse.compareValues(this.created, o.created, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.request != null && !this.request.isEmpty() || this.outcome != null && !this.outcome.isEmpty() || this.disposition != null && !this.disposition.isEmpty() || this.ruleset != null && !this.ruleset.isEmpty() || this.originalRuleset != null && !this.originalRuleset.isEmpty() || this.created != null && !this.created.isEmpty() || this.organization != null && !this.organization.isEmpty() || this.requestProvider != null && !this.requestProvider.isEmpty() || this.requestOrganization != null && !this.requestOrganization.isEmpty() || this.form != null && !this.form.isEmpty() || this.notes != null && !this.notes.isEmpty() || this.error != null && !this.error.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ProcessResponse;
    }

    @Block
    public static class ProcessResponseNotesComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={Coding.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="display | print | printoper", formalDefinition="The note purpose: Print/Display.")
        protected Coding type;
        @Child(name="text", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Notes text", formalDefinition="The note text.")
        protected StringType text;
        private static final long serialVersionUID = 129959202L;

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcessResponseNotesComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ProcessResponseNotesComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcessResponseNotesComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public ProcessResponseNotesComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public ProcessResponseNotesComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "Coding", "The note purpose: Print/Display.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("text", "string", "The note text.", 0, Integer.MAX_VALUE, this.text));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.text;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCoding(value);
                    break;
                }
                case 3556653: {
                    this.text = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals("text")) {
                this.text = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 3556653: {
                    throw new FHIRException("Cannot make property text as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type ProcessResponse.text");
            }
            return super.addChild(name);
        }

        @Override
        public ProcessResponseNotesComponent copy() {
            ProcessResponseNotesComponent dst = new ProcessResponseNotesComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.text = this.text == null ? null : this.text.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ProcessResponseNotesComponent)) {
                return false;
            }
            ProcessResponseNotesComponent o = (ProcessResponseNotesComponent)other;
            return ProcessResponseNotesComponent.compareDeep(this.type, o.type, true) && ProcessResponseNotesComponent.compareDeep(this.text, o.text, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ProcessResponseNotesComponent)) {
                return false;
            }
            ProcessResponseNotesComponent o = (ProcessResponseNotesComponent)other;
            return ProcessResponseNotesComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.text != null && !this.text.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ProcessResponse.notes";
        }
    }
}

