/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Attachment;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DataRequirement;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.ModuleDefinition;
import org.hl7.fhir.dstu2016may.model.ModuleMetadata;
import org.hl7.fhir.dstu2016may.model.ParameterDefinition;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Library", profile="http://hl7.org/fhir/Profile/Library")
public class Library
extends DomainResource {
    @Child(name="moduleMetadata", type={ModuleMetadata.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The metadata information for the library", formalDefinition="The metadata for the library, including publishing, life-cycle, version, documentation, and supporting evidence.")
    protected ModuleMetadata moduleMetadata;
    @Child(name="model", type={}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A model used by the library", formalDefinition="A model element describes the model and version used by the library.")
    protected List<LibraryModelComponent> model;
    @Child(name="library", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A library referenced by this library", formalDefinition="A library element describes a library referenced by this library.")
    protected List<LibraryLibraryComponent> library;
    @Child(name="codeSystem", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A code system used by the library", formalDefinition="A code system definition used within the library.")
    protected List<LibraryCodeSystemComponent> codeSystem;
    @Child(name="valueSet", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A value set used by the library", formalDefinition="A value set definition referenced by the library.")
    protected List<LibraryValueSetComponent> valueSet;
    @Child(name="parameter", type={ParameterDefinition.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Parameters defined by the library", formalDefinition="The parameter element defines parameters used by the library.")
    protected List<ParameterDefinition> parameter;
    @Child(name="dataRequirement", type={DataRequirement.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Data requirements of the library", formalDefinition="The dataRequirement element specifies a data requirement used by some expression within the library.")
    protected List<DataRequirement> dataRequirement;
    @Child(name="document", type={Attachment.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The content of the library", formalDefinition="The content of the library as an Attachment. The content may be a reference to a url, or may be directly embedded as a base-64 string. Either way, the content is expected to be a CQL or ELM document.")
    protected Attachment document;
    private static final long serialVersionUID = 36997599L;
    @SearchParamDefinition(name="topic", path="Library.moduleMetadata.topic", description="Topics associated with the module", type="token")
    public static final String SP_TOPIC = "topic";
    public static final TokenClientParam TOPIC = new TokenClientParam("topic");
    @SearchParamDefinition(name="title", path="Library.moduleMetadata.title", description="Text search against the title", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="status", path="Library.moduleMetadata.status", description="Status of the module", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="description", path="Library.moduleMetadata.description", description="Text search against the description", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="identifier", path="Library.moduleMetadata.identifier", description="Logical identifier for the module (e.g. CMS-143)", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="version", path="Library.moduleMetadata.version", description="Version of the module (e.g. 1.0.0)", type="string")
    public static final String SP_VERSION = "version";
    public static final StringClientParam VERSION = new StringClientParam("version");

    public Library() {
    }

    public Library(Attachment document) {
        this.document = document;
    }

    public ModuleMetadata getModuleMetadata() {
        if (this.moduleMetadata == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Library.moduleMetadata");
            }
            if (Configuration.doAutoCreate()) {
                this.moduleMetadata = new ModuleMetadata();
            }
        }
        return this.moduleMetadata;
    }

    public boolean hasModuleMetadata() {
        return this.moduleMetadata != null && !this.moduleMetadata.isEmpty();
    }

    public Library setModuleMetadata(ModuleMetadata value) {
        this.moduleMetadata = value;
        return this;
    }

    public List<LibraryModelComponent> getModel() {
        if (this.model == null) {
            this.model = new ArrayList<LibraryModelComponent>();
        }
        return this.model;
    }

    public boolean hasModel() {
        if (this.model == null) {
            return false;
        }
        for (LibraryModelComponent item : this.model) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public LibraryModelComponent addModel() {
        LibraryModelComponent t = new LibraryModelComponent();
        if (this.model == null) {
            this.model = new ArrayList<LibraryModelComponent>();
        }
        this.model.add(t);
        return t;
    }

    public Library addModel(LibraryModelComponent t) {
        if (t == null) {
            return this;
        }
        if (this.model == null) {
            this.model = new ArrayList<LibraryModelComponent>();
        }
        this.model.add(t);
        return this;
    }

    public List<LibraryLibraryComponent> getLibrary() {
        if (this.library == null) {
            this.library = new ArrayList<LibraryLibraryComponent>();
        }
        return this.library;
    }

    public boolean hasLibrary() {
        if (this.library == null) {
            return false;
        }
        for (LibraryLibraryComponent item : this.library) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public LibraryLibraryComponent addLibrary() {
        LibraryLibraryComponent t = new LibraryLibraryComponent();
        if (this.library == null) {
            this.library = new ArrayList<LibraryLibraryComponent>();
        }
        this.library.add(t);
        return t;
    }

    public Library addLibrary(LibraryLibraryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.library == null) {
            this.library = new ArrayList<LibraryLibraryComponent>();
        }
        this.library.add(t);
        return this;
    }

    public List<LibraryCodeSystemComponent> getCodeSystem() {
        if (this.codeSystem == null) {
            this.codeSystem = new ArrayList<LibraryCodeSystemComponent>();
        }
        return this.codeSystem;
    }

    public boolean hasCodeSystem() {
        if (this.codeSystem == null) {
            return false;
        }
        for (LibraryCodeSystemComponent item : this.codeSystem) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public LibraryCodeSystemComponent addCodeSystem() {
        LibraryCodeSystemComponent t = new LibraryCodeSystemComponent();
        if (this.codeSystem == null) {
            this.codeSystem = new ArrayList<LibraryCodeSystemComponent>();
        }
        this.codeSystem.add(t);
        return t;
    }

    public Library addCodeSystem(LibraryCodeSystemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.codeSystem == null) {
            this.codeSystem = new ArrayList<LibraryCodeSystemComponent>();
        }
        this.codeSystem.add(t);
        return this;
    }

    public List<LibraryValueSetComponent> getValueSet() {
        if (this.valueSet == null) {
            this.valueSet = new ArrayList<LibraryValueSetComponent>();
        }
        return this.valueSet;
    }

    public boolean hasValueSet() {
        if (this.valueSet == null) {
            return false;
        }
        for (LibraryValueSetComponent item : this.valueSet) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public LibraryValueSetComponent addValueSet() {
        LibraryValueSetComponent t = new LibraryValueSetComponent();
        if (this.valueSet == null) {
            this.valueSet = new ArrayList<LibraryValueSetComponent>();
        }
        this.valueSet.add(t);
        return t;
    }

    public Library addValueSet(LibraryValueSetComponent t) {
        if (t == null) {
            return this;
        }
        if (this.valueSet == null) {
            this.valueSet = new ArrayList<LibraryValueSetComponent>();
        }
        this.valueSet.add(t);
        return this;
    }

    public List<ParameterDefinition> getParameter() {
        if (this.parameter == null) {
            this.parameter = new ArrayList<ParameterDefinition>();
        }
        return this.parameter;
    }

    public boolean hasParameter() {
        if (this.parameter == null) {
            return false;
        }
        for (ParameterDefinition item : this.parameter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ParameterDefinition addParameter() {
        ParameterDefinition t = new ParameterDefinition();
        if (this.parameter == null) {
            this.parameter = new ArrayList<ParameterDefinition>();
        }
        this.parameter.add(t);
        return t;
    }

    public Library addParameter(ParameterDefinition t) {
        if (t == null) {
            return this;
        }
        if (this.parameter == null) {
            this.parameter = new ArrayList<ParameterDefinition>();
        }
        this.parameter.add(t);
        return this;
    }

    public List<DataRequirement> getDataRequirement() {
        if (this.dataRequirement == null) {
            this.dataRequirement = new ArrayList<DataRequirement>();
        }
        return this.dataRequirement;
    }

    public boolean hasDataRequirement() {
        if (this.dataRequirement == null) {
            return false;
        }
        for (DataRequirement item : this.dataRequirement) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DataRequirement addDataRequirement() {
        DataRequirement t = new DataRequirement();
        if (this.dataRequirement == null) {
            this.dataRequirement = new ArrayList<DataRequirement>();
        }
        this.dataRequirement.add(t);
        return t;
    }

    public Library addDataRequirement(DataRequirement t) {
        if (t == null) {
            return this;
        }
        if (this.dataRequirement == null) {
            this.dataRequirement = new ArrayList<DataRequirement>();
        }
        this.dataRequirement.add(t);
        return this;
    }

    public Attachment getDocument() {
        if (this.document == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Library.document");
            }
            if (Configuration.doAutoCreate()) {
                this.document = new Attachment();
            }
        }
        return this.document;
    }

    public boolean hasDocument() {
        return this.document != null && !this.document.isEmpty();
    }

    public Library setDocument(Attachment value) {
        this.document = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("moduleMetadata", "ModuleMetadata", "The metadata for the library, including publishing, life-cycle, version, documentation, and supporting evidence.", 0, Integer.MAX_VALUE, this.moduleMetadata));
        childrenList.add(new Property("model", "", "A model element describes the model and version used by the library.", 0, Integer.MAX_VALUE, this.model));
        childrenList.add(new Property("library", "", "A library element describes a library referenced by this library.", 0, Integer.MAX_VALUE, this.library));
        childrenList.add(new Property("codeSystem", "", "A code system definition used within the library.", 0, Integer.MAX_VALUE, this.codeSystem));
        childrenList.add(new Property("valueSet", "", "A value set definition referenced by the library.", 0, Integer.MAX_VALUE, this.valueSet));
        childrenList.add(new Property("parameter", "ParameterDefinition", "The parameter element defines parameters used by the library.", 0, Integer.MAX_VALUE, this.parameter));
        childrenList.add(new Property("dataRequirement", "DataRequirement", "The dataRequirement element specifies a data requirement used by some expression within the library.", 0, Integer.MAX_VALUE, this.dataRequirement));
        childrenList.add(new Property("document", "Attachment", "The content of the library as an Attachment. The content may be a reference to a url, or may be directly embedded as a base-64 string. Either way, the content is expected to be a CQL or ELM document.", 0, Integer.MAX_VALUE, this.document));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 455891387: {
                Base[] baseArray;
                if (this.moduleMetadata == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.moduleMetadata;
                }
                return baseArray;
            }
            case 104069929: {
                return this.model == null ? new Base[]{} : this.model.toArray(new Base[this.model.size()]);
            }
            case 166208699: {
                return this.library == null ? new Base[]{} : this.library.toArray(new Base[this.library.size()]);
            }
            case -916511108: {
                return this.codeSystem == null ? new Base[]{} : this.codeSystem.toArray(new Base[this.codeSystem.size()]);
            }
            case -1410174671: {
                return this.valueSet == null ? new Base[]{} : this.valueSet.toArray(new Base[this.valueSet.size()]);
            }
            case 1954460585: {
                return this.parameter == null ? new Base[]{} : this.parameter.toArray(new Base[this.parameter.size()]);
            }
            case 629147193: {
                return this.dataRequirement == null ? new Base[]{} : this.dataRequirement.toArray(new Base[this.dataRequirement.size()]);
            }
            case 861720859: {
                Base[] baseArray;
                if (this.document == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.document;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 455891387: {
                this.moduleMetadata = this.castToModuleMetadata(value);
                break;
            }
            case 104069929: {
                this.getModel().add((LibraryModelComponent)value);
                break;
            }
            case 166208699: {
                this.getLibrary().add((LibraryLibraryComponent)value);
                break;
            }
            case -916511108: {
                this.getCodeSystem().add((LibraryCodeSystemComponent)value);
                break;
            }
            case -1410174671: {
                this.getValueSet().add((LibraryValueSetComponent)value);
                break;
            }
            case 1954460585: {
                this.getParameter().add(this.castToParameterDefinition(value));
                break;
            }
            case 629147193: {
                this.getDataRequirement().add(this.castToDataRequirement(value));
                break;
            }
            case 861720859: {
                this.document = this.castToAttachment(value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("moduleMetadata")) {
            this.moduleMetadata = this.castToModuleMetadata(value);
        } else if (name.equals("model")) {
            this.getModel().add((LibraryModelComponent)value);
        } else if (name.equals("library")) {
            this.getLibrary().add((LibraryLibraryComponent)value);
        } else if (name.equals("codeSystem")) {
            this.getCodeSystem().add((LibraryCodeSystemComponent)value);
        } else if (name.equals("valueSet")) {
            this.getValueSet().add((LibraryValueSetComponent)value);
        } else if (name.equals("parameter")) {
            this.getParameter().add(this.castToParameterDefinition(value));
        } else if (name.equals("dataRequirement")) {
            this.getDataRequirement().add(this.castToDataRequirement(value));
        } else if (name.equals("document")) {
            this.document = this.castToAttachment(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 455891387: {
                return this.getModuleMetadata();
            }
            case 104069929: {
                return this.addModel();
            }
            case 166208699: {
                return this.addLibrary();
            }
            case -916511108: {
                return this.addCodeSystem();
            }
            case -1410174671: {
                return this.addValueSet();
            }
            case 1954460585: {
                return this.addParameter();
            }
            case 629147193: {
                return this.addDataRequirement();
            }
            case 861720859: {
                return this.getDocument();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("moduleMetadata")) {
            this.moduleMetadata = new ModuleMetadata();
            return this.moduleMetadata;
        }
        if (name.equals("model")) {
            return this.addModel();
        }
        if (name.equals("library")) {
            return this.addLibrary();
        }
        if (name.equals("codeSystem")) {
            return this.addCodeSystem();
        }
        if (name.equals("valueSet")) {
            return this.addValueSet();
        }
        if (name.equals("parameter")) {
            return this.addParameter();
        }
        if (name.equals("dataRequirement")) {
            return this.addDataRequirement();
        }
        if (name.equals("document")) {
            this.document = new Attachment();
            return this.document;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Library";
    }

    @Override
    public Library copy() {
        Library dst = new Library();
        this.copyValues(dst);
        ModuleMetadata moduleMetadata = dst.moduleMetadata = this.moduleMetadata == null ? null : this.moduleMetadata.copy();
        if (this.model != null) {
            dst.model = new ArrayList<LibraryModelComponent>();
            for (LibraryModelComponent libraryModelComponent : this.model) {
                dst.model.add(libraryModelComponent.copy());
            }
        }
        if (this.library != null) {
            dst.library = new ArrayList<LibraryLibraryComponent>();
            for (LibraryLibraryComponent libraryLibraryComponent : this.library) {
                dst.library.add(libraryLibraryComponent.copy());
            }
        }
        if (this.codeSystem != null) {
            dst.codeSystem = new ArrayList<LibraryCodeSystemComponent>();
            for (LibraryCodeSystemComponent libraryCodeSystemComponent : this.codeSystem) {
                dst.codeSystem.add(libraryCodeSystemComponent.copy());
            }
        }
        if (this.valueSet != null) {
            dst.valueSet = new ArrayList<LibraryValueSetComponent>();
            for (LibraryValueSetComponent libraryValueSetComponent : this.valueSet) {
                dst.valueSet.add(libraryValueSetComponent.copy());
            }
        }
        if (this.parameter != null) {
            dst.parameter = new ArrayList<ParameterDefinition>();
            for (ParameterDefinition parameterDefinition : this.parameter) {
                dst.parameter.add(parameterDefinition.copy());
            }
        }
        if (this.dataRequirement != null) {
            dst.dataRequirement = new ArrayList<DataRequirement>();
            for (DataRequirement dataRequirement : this.dataRequirement) {
                dst.dataRequirement.add(dataRequirement.copy());
            }
        }
        dst.document = this.document == null ? null : this.document.copy();
        return dst;
    }

    protected Library typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Library)) {
            return false;
        }
        Library o = (Library)other;
        return Library.compareDeep(this.moduleMetadata, o.moduleMetadata, true) && Library.compareDeep(this.model, o.model, true) && Library.compareDeep(this.library, o.library, true) && Library.compareDeep(this.codeSystem, o.codeSystem, true) && Library.compareDeep(this.valueSet, o.valueSet, true) && Library.compareDeep(this.parameter, o.parameter, true) && Library.compareDeep(this.dataRequirement, o.dataRequirement, true) && Library.compareDeep(this.document, o.document, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Library)) {
            return false;
        }
        Library o = (Library)other;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.moduleMetadata != null && !this.moduleMetadata.isEmpty() || this.model != null && !this.model.isEmpty() || this.library != null && !this.library.isEmpty() || this.codeSystem != null && !this.codeSystem.isEmpty() || this.valueSet != null && !this.valueSet.isEmpty() || this.parameter != null && !this.parameter.isEmpty() || this.dataRequirement != null && !this.dataRequirement.isEmpty() || this.document != null && !this.document.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Library;
    }

    @Block
    public static class LibraryValueSetComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of the value set", formalDefinition="The name element specifies the local name of the value set used within the library.")
        protected StringType name;
        @Child(name="identifier", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The identifier of the value set", formalDefinition="The identifier element specifies the global, non-version-specific identifier for the value set.")
        protected StringType identifier;
        @Child(name="version", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The version of the value set", formalDefinition="The version element, if present, determines the specific version of the value set definition that is used by the library. If no version is specified, the latest published version of the value set definition is implied.")
        protected StringType version;
        @Child(name="codeSystem", type={StringType.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The code system binding for this value set definition", formalDefinition="The codeSystem element determines which code system binding to use to compute the expansion of the value set definition. The codeSystem element specified here will correspond to a code system element, which is used to determine the code system version.")
        protected List<StringType> codeSystem;
        private static final long serialVersionUID = 338950096L;

        public LibraryValueSetComponent() {
        }

        public LibraryValueSetComponent(StringType identifier) {
            this.identifier = identifier;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create LibraryValueSetComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public LibraryValueSetComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public LibraryValueSetComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getIdentifierElement() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create LibraryValueSetComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new StringType();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifierElement() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public LibraryValueSetComponent setIdentifierElement(StringType value) {
            this.identifier = value;
            return this;
        }

        public String getIdentifier() {
            return this.identifier == null ? null : (String)this.identifier.getValue();
        }

        public LibraryValueSetComponent setIdentifier(String value) {
            if (this.identifier == null) {
                this.identifier = new StringType();
            }
            this.identifier.setValue(value);
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create LibraryValueSetComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public LibraryValueSetComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public LibraryValueSetComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        public List<StringType> getCodeSystem() {
            if (this.codeSystem == null) {
                this.codeSystem = new ArrayList<StringType>();
            }
            return this.codeSystem;
        }

        public boolean hasCodeSystem() {
            if (this.codeSystem == null) {
                return false;
            }
            for (StringType item : this.codeSystem) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addCodeSystemElement() {
            StringType t = new StringType();
            if (this.codeSystem == null) {
                this.codeSystem = new ArrayList<StringType>();
            }
            this.codeSystem.add(t);
            return t;
        }

        public LibraryValueSetComponent addCodeSystem(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.codeSystem == null) {
                this.codeSystem = new ArrayList<StringType>();
            }
            this.codeSystem.add(t);
            return this;
        }

        public boolean hasCodeSystem(String value) {
            if (this.codeSystem == null) {
                return false;
            }
            for (StringType v : this.codeSystem) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("name", "string", "The name element specifies the local name of the value set used within the library.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property(Library.SP_IDENTIFIER, "string", "The identifier element specifies the global, non-version-specific identifier for the value set.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property(Library.SP_VERSION, "string", "The version element, if present, determines the specific version of the value set definition that is used by the library. If no version is specified, the latest published version of the value set definition is implied.", 0, Integer.MAX_VALUE, this.version));
            childrenList.add(new Property("codeSystem", "string", "The codeSystem element determines which code system binding to use to compute the expansion of the value set definition. The codeSystem element specified here will correspond to a code system element, which is used to determine the code system version.", 0, Integer.MAX_VALUE, this.codeSystem));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.version;
                    }
                    return baseArray;
                }
                case -916511108: {
                    return this.codeSystem == null ? new Base[]{} : this.codeSystem.toArray(new Base[this.codeSystem.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1618432855: {
                    this.identifier = this.castToString(value);
                    break;
                }
                case 351608024: {
                    this.version = this.castToString(value);
                    break;
                }
                case -916511108: {
                    this.getCodeSystem().add(this.castToString(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals(Library.SP_IDENTIFIER)) {
                this.identifier = this.castToString(value);
            } else if (name.equals(Library.SP_VERSION)) {
                this.version = this.castToString(value);
            } else if (name.equals("codeSystem")) {
                this.getCodeSystem().add(this.castToString(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1618432855: {
                    throw new FHIRException("Cannot make property identifier as it is not a complex type");
                }
                case 351608024: {
                    throw new FHIRException("Cannot make property version as it is not a complex type");
                }
                case -916511108: {
                    throw new FHIRException("Cannot make property codeSystem as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type Library.name");
            }
            if (name.equals(Library.SP_IDENTIFIER)) {
                throw new FHIRException("Cannot call addChild on a primitive type Library.identifier");
            }
            if (name.equals(Library.SP_VERSION)) {
                throw new FHIRException("Cannot call addChild on a primitive type Library.version");
            }
            if (name.equals("codeSystem")) {
                throw new FHIRException("Cannot call addChild on a primitive type Library.codeSystem");
            }
            return super.addChild(name);
        }

        @Override
        public LibraryValueSetComponent copy() {
            LibraryValueSetComponent dst = new LibraryValueSetComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            StringType stringType = dst.version = this.version == null ? null : this.version.copy();
            if (this.codeSystem != null) {
                dst.codeSystem = new ArrayList<StringType>();
                for (StringType i : this.codeSystem) {
                    dst.codeSystem.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof LibraryValueSetComponent)) {
                return false;
            }
            LibraryValueSetComponent o = (LibraryValueSetComponent)other;
            return LibraryValueSetComponent.compareDeep(this.name, o.name, true) && LibraryValueSetComponent.compareDeep(this.identifier, o.identifier, true) && LibraryValueSetComponent.compareDeep(this.version, o.version, true) && LibraryValueSetComponent.compareDeep(this.codeSystem, o.codeSystem, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof LibraryValueSetComponent)) {
                return false;
            }
            LibraryValueSetComponent o = (LibraryValueSetComponent)other;
            return LibraryValueSetComponent.compareValues(this.name, o.name, true) && LibraryValueSetComponent.compareValues(this.identifier, o.identifier, true) && LibraryValueSetComponent.compareValues(this.version, o.version, true) && LibraryValueSetComponent.compareValues(this.codeSystem, o.codeSystem, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.version != null && !this.version.isEmpty() || this.codeSystem != null && !this.codeSystem.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Library.valueSet";
        }
    }

    @Block
    public static class LibraryCodeSystemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of the code system", formalDefinition="The name element specifies the local name of the code system as used within the library. This name is also used when the code system is referenced from a value set element to determine the version of the code system to be used when computed the expansion of the value set definition.")
        protected StringType name;
        @Child(name="identifier", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The identifier of the code system", formalDefinition="The identifier element specifies the global, non-version-specific identifier for the code system.")
        protected StringType identifier;
        @Child(name="version", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The version of the code system, if any", formalDefinition="The version element, if present, identifies the specific version of the library to be used. If no code system is specified, the most recent published version of the code system is implied.")
        protected StringType version;
        private static final long serialVersionUID = -862601139L;

        public LibraryCodeSystemComponent() {
        }

        public LibraryCodeSystemComponent(StringType identifier) {
            this.identifier = identifier;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create LibraryCodeSystemComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public LibraryCodeSystemComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public LibraryCodeSystemComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getIdentifierElement() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create LibraryCodeSystemComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new StringType();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifierElement() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public LibraryCodeSystemComponent setIdentifierElement(StringType value) {
            this.identifier = value;
            return this;
        }

        public String getIdentifier() {
            return this.identifier == null ? null : (String)this.identifier.getValue();
        }

        public LibraryCodeSystemComponent setIdentifier(String value) {
            if (this.identifier == null) {
                this.identifier = new StringType();
            }
            this.identifier.setValue(value);
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create LibraryCodeSystemComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public LibraryCodeSystemComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public LibraryCodeSystemComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("name", "string", "The name element specifies the local name of the code system as used within the library. This name is also used when the code system is referenced from a value set element to determine the version of the code system to be used when computed the expansion of the value set definition.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property(Library.SP_IDENTIFIER, "string", "The identifier element specifies the global, non-version-specific identifier for the code system.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property(Library.SP_VERSION, "string", "The version element, if present, identifies the specific version of the library to be used. If no code system is specified, the most recent published version of the code system is implied.", 0, Integer.MAX_VALUE, this.version));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.version;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1618432855: {
                    this.identifier = this.castToString(value);
                    break;
                }
                case 351608024: {
                    this.version = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals(Library.SP_IDENTIFIER)) {
                this.identifier = this.castToString(value);
            } else if (name.equals(Library.SP_VERSION)) {
                this.version = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1618432855: {
                    throw new FHIRException("Cannot make property identifier as it is not a complex type");
                }
                case 351608024: {
                    throw new FHIRException("Cannot make property version as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type Library.name");
            }
            if (name.equals(Library.SP_IDENTIFIER)) {
                throw new FHIRException("Cannot call addChild on a primitive type Library.identifier");
            }
            if (name.equals(Library.SP_VERSION)) {
                throw new FHIRException("Cannot call addChild on a primitive type Library.version");
            }
            return super.addChild(name);
        }

        @Override
        public LibraryCodeSystemComponent copy() {
            LibraryCodeSystemComponent dst = new LibraryCodeSystemComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.version = this.version == null ? null : this.version.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof LibraryCodeSystemComponent)) {
                return false;
            }
            LibraryCodeSystemComponent o = (LibraryCodeSystemComponent)other;
            return LibraryCodeSystemComponent.compareDeep(this.name, o.name, true) && LibraryCodeSystemComponent.compareDeep(this.identifier, o.identifier, true) && LibraryCodeSystemComponent.compareDeep(this.version, o.version, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof LibraryCodeSystemComponent)) {
                return false;
            }
            LibraryCodeSystemComponent o = (LibraryCodeSystemComponent)other;
            return LibraryCodeSystemComponent.compareValues(this.name, o.name, true) && LibraryCodeSystemComponent.compareValues(this.identifier, o.identifier, true) && LibraryCodeSystemComponent.compareValues(this.version, o.version, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.version != null && !this.version.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Library.codeSystem";
        }
    }

    @Block
    public static class LibraryLibraryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of the library", formalDefinition="The name element defines the local name of the referenced library.")
        protected StringType name;
        @Child(name="identifier", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The identifier of the library", formalDefinition="The identifier element specifies the global, non-version-specific identifier for the library.")
        protected StringType identifier;
        @Child(name="version", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The version of the library, if any", formalDefinition="The version element, if present, identifies the specific version of the library to be used. If no version is specified, the most recent published version of the library is implied.")
        protected StringType version;
        @Child(name="document", type={Attachment.class, ModuleDefinition.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The content of the library", formalDefinition="The content of the referenced library as an Attachment, or a reference to the Library resource. If the document is an attachment, it may be a reference to a url from which the library document may be retrieved, or it may be directly embedded as a base-64 string. Either way, the content is expected to be a CQL or ELM document.")
        protected Type document;
        private static final long serialVersionUID = 1633488790L;

        public LibraryLibraryComponent() {
        }

        public LibraryLibraryComponent(StringType identifier) {
            this.identifier = identifier;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create LibraryLibraryComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public LibraryLibraryComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public LibraryLibraryComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getIdentifierElement() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create LibraryLibraryComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new StringType();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifierElement() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public LibraryLibraryComponent setIdentifierElement(StringType value) {
            this.identifier = value;
            return this;
        }

        public String getIdentifier() {
            return this.identifier == null ? null : (String)this.identifier.getValue();
        }

        public LibraryLibraryComponent setIdentifier(String value) {
            if (this.identifier == null) {
                this.identifier = new StringType();
            }
            this.identifier.setValue(value);
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create LibraryLibraryComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public LibraryLibraryComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public LibraryLibraryComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        public Type getDocument() {
            return this.document;
        }

        public Attachment getDocumentAttachment() throws FHIRException {
            if (!(this.document instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.document.getClass().getName() + " was encountered");
            }
            return (Attachment)this.document;
        }

        public boolean hasDocumentAttachment() {
            return this.document instanceof Attachment;
        }

        public Reference getDocumentReference() throws FHIRException {
            if (!(this.document instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.document.getClass().getName() + " was encountered");
            }
            return (Reference)this.document;
        }

        public boolean hasDocumentReference() {
            return this.document instanceof Reference;
        }

        public boolean hasDocument() {
            return this.document != null && !this.document.isEmpty();
        }

        public LibraryLibraryComponent setDocument(Type value) {
            this.document = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("name", "string", "The name element defines the local name of the referenced library.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property(Library.SP_IDENTIFIER, "string", "The identifier element specifies the global, non-version-specific identifier for the library.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property(Library.SP_VERSION, "string", "The version element, if present, identifies the specific version of the library to be used. If no version is specified, the most recent published version of the library is implied.", 0, Integer.MAX_VALUE, this.version));
            childrenList.add(new Property("document[x]", "Attachment|Reference(ModuleDefinition)", "The content of the referenced library as an Attachment, or a reference to the Library resource. If the document is an attachment, it may be a reference to a url from which the library document may be retrieved, or it may be directly embedded as a base-64 string. Either way, the content is expected to be a CQL or ELM document.", 0, Integer.MAX_VALUE, this.document));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.version;
                    }
                    return baseArray;
                }
                case 861720859: {
                    Base[] baseArray;
                    if (this.document == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.document;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1618432855: {
                    this.identifier = this.castToString(value);
                    break;
                }
                case 351608024: {
                    this.version = this.castToString(value);
                    break;
                }
                case 861720859: {
                    this.document = (Type)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals(Library.SP_IDENTIFIER)) {
                this.identifier = this.castToString(value);
            } else if (name.equals(Library.SP_VERSION)) {
                this.version = this.castToString(value);
            } else if (name.equals("document[x]")) {
                this.document = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1618432855: {
                    throw new FHIRException("Cannot make property identifier as it is not a complex type");
                }
                case 351608024: {
                    throw new FHIRException("Cannot make property version as it is not a complex type");
                }
                case 506673541: {
                    return this.getDocument();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type Library.name");
            }
            if (name.equals(Library.SP_IDENTIFIER)) {
                throw new FHIRException("Cannot call addChild on a primitive type Library.identifier");
            }
            if (name.equals(Library.SP_VERSION)) {
                throw new FHIRException("Cannot call addChild on a primitive type Library.version");
            }
            if (name.equals("documentAttachment")) {
                this.document = new Attachment();
                return this.document;
            }
            if (name.equals("documentReference")) {
                this.document = new Reference();
                return this.document;
            }
            return super.addChild(name);
        }

        @Override
        public LibraryLibraryComponent copy() {
            LibraryLibraryComponent dst = new LibraryLibraryComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.version = this.version == null ? null : this.version.copy();
            dst.document = this.document == null ? null : this.document.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof LibraryLibraryComponent)) {
                return false;
            }
            LibraryLibraryComponent o = (LibraryLibraryComponent)other;
            return LibraryLibraryComponent.compareDeep(this.name, o.name, true) && LibraryLibraryComponent.compareDeep(this.identifier, o.identifier, true) && LibraryLibraryComponent.compareDeep(this.version, o.version, true) && LibraryLibraryComponent.compareDeep(this.document, o.document, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof LibraryLibraryComponent)) {
                return false;
            }
            LibraryLibraryComponent o = (LibraryLibraryComponent)other;
            return LibraryLibraryComponent.compareValues(this.name, o.name, true) && LibraryLibraryComponent.compareValues(this.identifier, o.identifier, true) && LibraryLibraryComponent.compareValues(this.version, o.version, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.version != null && !this.version.isEmpty() || this.document != null && !this.document.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Library.library";
        }
    }

    @Block
    public static class LibraryModelComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of the model", formalDefinition="The name element defines the local name of the model as used within the library.")
        protected StringType name;
        @Child(name="identifier", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The identifier of the model", formalDefinition="The identifier element specifies the global, non-version-specific identifier for the model.")
        protected StringType identifier;
        @Child(name="version", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The version of the model, if any", formalDefinition="The version element, if present, identifies the specific version of the model to be used. If no version is specified, the most recent published version of the model is implied.")
        protected StringType version;
        private static final long serialVersionUID = -862601139L;

        public LibraryModelComponent() {
        }

        public LibraryModelComponent(StringType identifier) {
            this.identifier = identifier;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create LibraryModelComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public LibraryModelComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public LibraryModelComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getIdentifierElement() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create LibraryModelComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new StringType();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifierElement() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public LibraryModelComponent setIdentifierElement(StringType value) {
            this.identifier = value;
            return this;
        }

        public String getIdentifier() {
            return this.identifier == null ? null : (String)this.identifier.getValue();
        }

        public LibraryModelComponent setIdentifier(String value) {
            if (this.identifier == null) {
                this.identifier = new StringType();
            }
            this.identifier.setValue(value);
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create LibraryModelComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public LibraryModelComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public LibraryModelComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("name", "string", "The name element defines the local name of the model as used within the library.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property(Library.SP_IDENTIFIER, "string", "The identifier element specifies the global, non-version-specific identifier for the model.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property(Library.SP_VERSION, "string", "The version element, if present, identifies the specific version of the model to be used. If no version is specified, the most recent published version of the model is implied.", 0, Integer.MAX_VALUE, this.version));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.version;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1618432855: {
                    this.identifier = this.castToString(value);
                    break;
                }
                case 351608024: {
                    this.version = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals(Library.SP_IDENTIFIER)) {
                this.identifier = this.castToString(value);
            } else if (name.equals(Library.SP_VERSION)) {
                this.version = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1618432855: {
                    throw new FHIRException("Cannot make property identifier as it is not a complex type");
                }
                case 351608024: {
                    throw new FHIRException("Cannot make property version as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type Library.name");
            }
            if (name.equals(Library.SP_IDENTIFIER)) {
                throw new FHIRException("Cannot call addChild on a primitive type Library.identifier");
            }
            if (name.equals(Library.SP_VERSION)) {
                throw new FHIRException("Cannot call addChild on a primitive type Library.version");
            }
            return super.addChild(name);
        }

        @Override
        public LibraryModelComponent copy() {
            LibraryModelComponent dst = new LibraryModelComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.version = this.version == null ? null : this.version.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof LibraryModelComponent)) {
                return false;
            }
            LibraryModelComponent o = (LibraryModelComponent)other;
            return LibraryModelComponent.compareDeep(this.name, o.name, true) && LibraryModelComponent.compareDeep(this.identifier, o.identifier, true) && LibraryModelComponent.compareDeep(this.version, o.version, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof LibraryModelComponent)) {
                return false;
            }
            LibraryModelComponent o = (LibraryModelComponent)other;
            return LibraryModelComponent.compareValues(this.name, o.name, true) && LibraryModelComponent.compareValues(this.identifier, o.identifier, true) && LibraryModelComponent.compareValues(this.version, o.version, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.version != null && !this.version.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Library.model";
        }
    }
}

