/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Address;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.Claim;
import org.hl7.fhir.dstu2016may.model.ClaimResponse;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.Coverage;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DateType;
import org.hl7.fhir.dstu2016may.model.DecimalType;
import org.hl7.fhir.dstu2016may.model.Device;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Location;
import org.hl7.fhir.dstu2016may.model.MedicationOrder;
import org.hl7.fhir.dstu2016may.model.Money;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.PositiveIntType;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.Procedure;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ReferralRequest;
import org.hl7.fhir.dstu2016may.model.RelatedPerson;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.SimpleQuantity;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UnsignedIntType;
import org.hl7.fhir.dstu2016may.model.VisionPrescription;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ExplanationOfBenefit", profile="http://hl7.org/fhir/Profile/ExplanationOfBenefit")
public class ExplanationOfBenefit
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier", formalDefinition="The Response Business Identifier.")
    protected List<Identifier> identifier;
    @Child(name="claim", type={Identifier.class, Claim.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Claim reference", formalDefinition="The business identifier for the instance: invoice number, claim number, pre-determination or pre-authorization number.")
    protected Type claim;
    @Child(name="claimResponse", type={Identifier.class, ClaimResponse.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Claim response reference", formalDefinition="The business identifier for the instance: invoice number, claim number, pre-determination or pre-authorization number.")
    protected Type claimResponse;
    @Child(name="subType", type={Coding.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Finer grained claim type information", formalDefinition="A finer grained suite of claim subtype codes which may convey Inpatient vs Outpatient and/or a specialty service. In the US the BillType.")
    protected List<Coding> subType;
    @Child(name="ruleset", type={Coding.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Current specification followed", formalDefinition="The version of the specification on which this instance relies.")
    protected Coding ruleset;
    @Child(name="originalRuleset", type={Coding.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Original specification followed", formalDefinition="The version of the specification from which the original instance was created.")
    protected Coding originalRuleset;
    @Child(name="created", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Creation date", formalDefinition="The date when the EOB was created.")
    protected DateTimeType created;
    @Child(name="billablePeriod", type={Period.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Period for charge submission", formalDefinition="The billable period for which charges are being submitted.")
    protected Period billablePeriod;
    @Child(name="disposition", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Disposition Message", formalDefinition="A description of the status of the adjudication.")
    protected StringType disposition;
    @Child(name="provider", type={Identifier.class, Practitioner.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible provider for the claim", formalDefinition="The provider which is responsible for the claim.")
    protected Type provider;
    @Child(name="organization", type={Identifier.class, Organization.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible organization for the claim", formalDefinition="The provider which is responsible for the claim.")
    protected Type organization;
    @Child(name="facility", type={Identifier.class, Location.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Servicing Facility", formalDefinition="Facility where the services were provided.")
    protected Type facility;
    @Child(name="related", type={}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Related Claims which may be revelant to processing this claimn", formalDefinition="Other claims which are related to this claim such as prior claim versions or for related services.")
    protected List<RelatedClaimsComponent> related;
    @Child(name="prescription", type={Identifier.class, MedicationOrder.class, VisionPrescription.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Prescription", formalDefinition="Prescription to support the dispensing of Pharmacy or Vision products.")
    protected Type prescription;
    @Child(name="originalPrescription", type={Identifier.class, MedicationOrder.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Original Prescription", formalDefinition="Original prescription which has been superceded by this prescription to support the dispensing of pharmacy services, medications or products.")
    protected Type originalPrescription;
    @Child(name="payee", type={}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Payee", formalDefinition="The party to be reimbursed for the services.")
    protected PayeeComponent payee;
    @Child(name="referral", type={Identifier.class, ReferralRequest.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Treatment Referral", formalDefinition="The referral resource which lists the date, practitioner, reason and other supporting information.")
    protected Type referral;
    @Child(name="occurrenceCode", type={Coding.class}, order=17, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Occurrence Codes", formalDefinition="**Insert definition of Occurrence codes.")
    protected List<Coding> occurrenceCode;
    @Child(name="occurenceSpanCode", type={Coding.class}, order=18, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Occurrence Span Codes", formalDefinition="**Insert definition of Occurrence Span codes.")
    protected List<Coding> occurenceSpanCode;
    @Child(name="valueCode", type={Coding.class}, order=19, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Value Codes", formalDefinition="**Insert definition of Value codes.")
    protected List<Coding> valueCode;
    @Child(name="diagnosis", type={}, order=20, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Diagnosis", formalDefinition="Ordered list of patient diagnosis for which care is sought.")
    protected List<DiagnosisComponent> diagnosis;
    @Child(name="procedure", type={}, order=21, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Procedures performed", formalDefinition="Ordered list of patient procedures performed to support the adjudication.")
    protected List<ProcedureComponent> procedure;
    @Child(name="specialCondition", type={Coding.class}, order=22, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="List of special Conditions", formalDefinition="List of special conditions relating to the setting, treatment or patient  for which care is sought which may influence the adjudication.")
    protected List<Coding> specialCondition;
    @Child(name="patient", type={Identifier.class, Patient.class}, order=23, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The subject of the Products and Services", formalDefinition="Patient Resource.")
    protected Type patient;
    @Child(name="precedence", type={PositiveIntType.class}, order=24, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Precedence (primary, secondary, etc.)", formalDefinition="Precedence (primary, secondary, etc.).")
    protected PositiveIntType precedence;
    @Child(name="coverage", type={}, order=25, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Insurance or medical plan", formalDefinition="Financial instrument by which payment information for health care.")
    protected CoverageComponent coverage;
    @Child(name="accidentDate", type={DateType.class}, order=26, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the accident occurred", formalDefinition="Date of an accident which these services are addressing.")
    protected DateType accidentDate;
    @Child(name="accidentType", type={Coding.class}, order=27, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The nature of the accident", formalDefinition="Type of accident: work, auto, etc.")
    protected Coding accidentType;
    @Child(name="accidentLocation", type={Address.class, Location.class}, order=28, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Accident Place", formalDefinition="Accident Place.")
    protected Type accidentLocation;
    @Child(name="interventionException", type={Coding.class}, order=29, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intervention and exception code (Pharma)", formalDefinition="A list of intervention and exception codes which may influence the adjudication of the claim.")
    protected List<Coding> interventionException;
    @Child(name="onset", type={}, order=30, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Condition related Onset related dates and codes", formalDefinition="Period, start and last dates of aspects of the Condition or related services.")
    protected List<OnsetComponent> onset;
    @Child(name="employmentImpacted", type={Period.class}, order=31, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Period unable to work", formalDefinition="The start and optional end dates of when the patient was precluded from working due to the treatable condition(s).")
    protected Period employmentImpacted;
    @Child(name="hospitalization", type={Period.class}, order=32, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Period in hospital", formalDefinition="The start and optional end dates of when the patient was confined to a treatment center.")
    protected Period hospitalization;
    @Child(name="item", type={}, order=33, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Goods and Services", formalDefinition="First tier of goods and services.")
    protected List<ItemsComponent> item;
    @Child(name="addItem", type={}, order=34, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Insurer added line items", formalDefinition="The first tier service adjudications for payor added services.")
    protected List<AddedItemComponent> addItem;
    @Child(name="missingTeeth", type={}, order=35, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Only if type = oral", formalDefinition="A list of teeth which would be expected but are not found due to having been previously  extracted or for other reasons.")
    protected List<MissingTeethComponent> missingTeeth;
    @Child(name="totalCost", type={Money.class}, order=36, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Total Cost of service from the Claim", formalDefinition="The total cost of the services reported.")
    protected Money totalCost;
    @Child(name="unallocDeductable", type={Money.class}, order=37, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Unallocated deductable", formalDefinition="The amount of deductable applied which was not allocated to any particular service line.")
    protected Money unallocDeductable;
    @Child(name="totalBenefit", type={Money.class}, order=38, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Total benefit payable for the Claim", formalDefinition="Total amount of benefit payable (Equal to sum of the Benefit amounts from all detail lines and additions less the Unallocated Deductable).")
    protected Money totalBenefit;
    @Child(name="paymentAdjustment", type={Money.class}, order=39, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Payment adjustment for non-Claim issues", formalDefinition="Adjustment to the payment of this transaction which is not related to adjudication of this transaction.")
    protected Money paymentAdjustment;
    @Child(name="paymentAdjustmentReason", type={Coding.class}, order=40, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reason for Payment adjustment", formalDefinition="Reason for the payment adjustment.")
    protected Coding paymentAdjustmentReason;
    @Child(name="paymentDate", type={DateType.class}, order=41, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Expected data of Payment", formalDefinition="Estimated payment data.")
    protected DateType paymentDate;
    @Child(name="paymentAmount", type={Money.class}, order=42, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Payment amount", formalDefinition="Payable less any payment adjustment.")
    protected Money paymentAmount;
    @Child(name="paymentRef", type={Identifier.class}, order=43, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Payment identifier", formalDefinition="Payment identifer.")
    protected Identifier paymentRef;
    @Child(name="reserved", type={Coding.class}, order=44, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Funds reserved status", formalDefinition="Status of funds reservation (For provider, for Patient, None).")
    protected Coding reserved;
    @Child(name="form", type={Coding.class}, order=45, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Printed Form Identifier", formalDefinition="The form to be used for printing the content.")
    protected Coding form;
    @Child(name="note", type={}, order=46, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Processing notes", formalDefinition="Note text.")
    protected List<NotesComponent> note;
    @Child(name="benefitBalance", type={}, order=47, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Balance by Benefit Category", formalDefinition="Balance by Benefit Category.")
    protected List<BenefitBalanceComponent> benefitBalance;
    private static final long serialVersionUID = 1781852561L;
    @SearchParamDefinition(name="patientidentifier", path="ExplanationOfBenefit.patient.as(Identifier)", description="The reference to the patient", type="token")
    public static final String SP_PATIENTIDENTIFIER = "patientidentifier";
    public static final TokenClientParam PATIENTIDENTIFIER = new TokenClientParam("patientidentifier");
    @SearchParamDefinition(name="claimindentifier", path="ExplanationOfBenefit.claim.as(Identifier)", description="The reference to the claim", type="token")
    public static final String SP_CLAIMINDENTIFIER = "claimindentifier";
    public static final TokenClientParam CLAIMINDENTIFIER = new TokenClientParam("claimindentifier");
    @SearchParamDefinition(name="facilityreference", path="ExplanationOfBenefit.facility.as(Reference)", description="Facility responsible for the goods and services", type="reference")
    public static final String SP_FACILITYREFERENCE = "facilityreference";
    public static final ReferenceClientParam FACILITYREFERENCE = new ReferenceClientParam("facilityreference");
    public static final Include INCLUDE_FACILITYREFERENCE = new Include("ExplanationOfBenefit:facilityreference").toLocked();
    @SearchParamDefinition(name="providerreference", path="ExplanationOfBenefit.provider.as(Reference)", description="The reference to the provider", type="reference")
    public static final String SP_PROVIDERREFERENCE = "providerreference";
    public static final ReferenceClientParam PROVIDERREFERENCE = new ReferenceClientParam("providerreference");
    public static final Include INCLUDE_PROVIDERREFERENCE = new Include("ExplanationOfBenefit:providerreference").toLocked();
    @SearchParamDefinition(name="facilityidentifier", path="ExplanationOfBenefit.facility.as(Identifier)", description="Facility responsible for the goods and services", type="token")
    public static final String SP_FACILITYIDENTIFIER = "facilityidentifier";
    public static final TokenClientParam FACILITYIDENTIFIER = new TokenClientParam("facilityidentifier");
    @SearchParamDefinition(name="organizationidentifier", path="ExplanationOfBenefit.organization.as(Identifier)", description="The reference to the providing organization", type="token")
    public static final String SP_ORGANIZATIONIDENTIFIER = "organizationidentifier";
    public static final TokenClientParam ORGANIZATIONIDENTIFIER = new TokenClientParam("organizationidentifier");
    @SearchParamDefinition(name="patientreference", path="ExplanationOfBenefit.patient.as(Reference)", description="The reference to the patient", type="reference")
    public static final String SP_PATIENTREFERENCE = "patientreference";
    public static final ReferenceClientParam PATIENTREFERENCE = new ReferenceClientParam("patientreference");
    public static final Include INCLUDE_PATIENTREFERENCE = new Include("ExplanationOfBenefit:patientreference").toLocked();
    @SearchParamDefinition(name="created", path="ExplanationOfBenefit.created", description="The creation date for the EOB", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="organizationreference", path="ExplanationOfBenefit.organization.as(Reference)", description="The reference to the providing organization", type="reference")
    public static final String SP_ORGANIZATIONREFERENCE = "organizationreference";
    public static final ReferenceClientParam ORGANIZATIONREFERENCE = new ReferenceClientParam("organizationreference");
    public static final Include INCLUDE_ORGANIZATIONREFERENCE = new Include("ExplanationOfBenefit:organizationreference").toLocked();
    @SearchParamDefinition(name="identifier", path="ExplanationOfBenefit.identifier", description="The business identifier of the Explanation of Benefit", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="disposition", path="ExplanationOfBenefit.disposition", description="The contents of the disposition message", type="string")
    public static final String SP_DISPOSITION = "disposition";
    public static final StringClientParam DISPOSITION = new StringClientParam("disposition");
    @SearchParamDefinition(name="provideridentifier", path="ExplanationOfBenefit.provider.as(Identifier)", description="The reference to the provider", type="token")
    public static final String SP_PROVIDERIDENTIFIER = "provideridentifier";
    public static final TokenClientParam PROVIDERIDENTIFIER = new TokenClientParam("provideridentifier");
    @SearchParamDefinition(name="claimreference", path="ExplanationOfBenefit.claim.as(Reference)", description="The reference to the claim", type="reference")
    public static final String SP_CLAIMREFERENCE = "claimreference";
    public static final ReferenceClientParam CLAIMREFERENCE = new ReferenceClientParam("claimreference");
    public static final Include INCLUDE_CLAIMREFERENCE = new Include("ExplanationOfBenefit:claimreference").toLocked();

    public ExplanationOfBenefit() {
    }

    public ExplanationOfBenefit(Type patient, CoverageComponent coverage) {
        this.patient = patient;
        this.coverage = coverage;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ExplanationOfBenefit addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Type getClaim() {
        return this.claim;
    }

    public Identifier getClaimIdentifier() throws FHIRException {
        if (!(this.claim instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.claim.getClass().getName() + " was encountered");
        }
        return (Identifier)this.claim;
    }

    public boolean hasClaimIdentifier() {
        return this.claim instanceof Identifier;
    }

    public Reference getClaimReference() throws FHIRException {
        if (!(this.claim instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.claim.getClass().getName() + " was encountered");
        }
        return (Reference)this.claim;
    }

    public boolean hasClaimReference() {
        return this.claim instanceof Reference;
    }

    public boolean hasClaim() {
        return this.claim != null && !this.claim.isEmpty();
    }

    public ExplanationOfBenefit setClaim(Type value) {
        this.claim = value;
        return this;
    }

    public Type getClaimResponse() {
        return this.claimResponse;
    }

    public Identifier getClaimResponseIdentifier() throws FHIRException {
        if (!(this.claimResponse instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.claimResponse.getClass().getName() + " was encountered");
        }
        return (Identifier)this.claimResponse;
    }

    public boolean hasClaimResponseIdentifier() {
        return this.claimResponse instanceof Identifier;
    }

    public Reference getClaimResponseReference() throws FHIRException {
        if (!(this.claimResponse instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.claimResponse.getClass().getName() + " was encountered");
        }
        return (Reference)this.claimResponse;
    }

    public boolean hasClaimResponseReference() {
        return this.claimResponse instanceof Reference;
    }

    public boolean hasClaimResponse() {
        return this.claimResponse != null && !this.claimResponse.isEmpty();
    }

    public ExplanationOfBenefit setClaimResponse(Type value) {
        this.claimResponse = value;
        return this;
    }

    public List<Coding> getSubType() {
        if (this.subType == null) {
            this.subType = new ArrayList<Coding>();
        }
        return this.subType;
    }

    public boolean hasSubType() {
        if (this.subType == null) {
            return false;
        }
        for (Coding item : this.subType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addSubType() {
        Coding t = new Coding();
        if (this.subType == null) {
            this.subType = new ArrayList<Coding>();
        }
        this.subType.add(t);
        return t;
    }

    public ExplanationOfBenefit addSubType(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.subType == null) {
            this.subType = new ArrayList<Coding>();
        }
        this.subType.add(t);
        return this;
    }

    public Coding getRuleset() {
        if (this.ruleset == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.ruleset");
            }
            if (Configuration.doAutoCreate()) {
                this.ruleset = new Coding();
            }
        }
        return this.ruleset;
    }

    public boolean hasRuleset() {
        return this.ruleset != null && !this.ruleset.isEmpty();
    }

    public ExplanationOfBenefit setRuleset(Coding value) {
        this.ruleset = value;
        return this;
    }

    public Coding getOriginalRuleset() {
        if (this.originalRuleset == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.originalRuleset");
            }
            if (Configuration.doAutoCreate()) {
                this.originalRuleset = new Coding();
            }
        }
        return this.originalRuleset;
    }

    public boolean hasOriginalRuleset() {
        return this.originalRuleset != null && !this.originalRuleset.isEmpty();
    }

    public ExplanationOfBenefit setOriginalRuleset(Coding value) {
        this.originalRuleset = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public ExplanationOfBenefit setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public ExplanationOfBenefit setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public Period getBillablePeriod() {
        if (this.billablePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.billablePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.billablePeriod = new Period();
            }
        }
        return this.billablePeriod;
    }

    public boolean hasBillablePeriod() {
        return this.billablePeriod != null && !this.billablePeriod.isEmpty();
    }

    public ExplanationOfBenefit setBillablePeriod(Period value) {
        this.billablePeriod = value;
        return this;
    }

    public StringType getDispositionElement() {
        if (this.disposition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.disposition");
            }
            if (Configuration.doAutoCreate()) {
                this.disposition = new StringType();
            }
        }
        return this.disposition;
    }

    public boolean hasDispositionElement() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public boolean hasDisposition() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public ExplanationOfBenefit setDispositionElement(StringType value) {
        this.disposition = value;
        return this;
    }

    public String getDisposition() {
        return this.disposition == null ? null : (String)this.disposition.getValue();
    }

    public ExplanationOfBenefit setDisposition(String value) {
        if (Utilities.noString((String)value)) {
            this.disposition = null;
        } else {
            if (this.disposition == null) {
                this.disposition = new StringType();
            }
            this.disposition.setValue(value);
        }
        return this;
    }

    public Type getProvider() {
        return this.provider;
    }

    public Identifier getProviderIdentifier() throws FHIRException {
        if (!(this.provider instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.provider.getClass().getName() + " was encountered");
        }
        return (Identifier)this.provider;
    }

    public boolean hasProviderIdentifier() {
        return this.provider instanceof Identifier;
    }

    public Reference getProviderReference() throws FHIRException {
        if (!(this.provider instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.provider.getClass().getName() + " was encountered");
        }
        return (Reference)this.provider;
    }

    public boolean hasProviderReference() {
        return this.provider instanceof Reference;
    }

    public boolean hasProvider() {
        return this.provider != null && !this.provider.isEmpty();
    }

    public ExplanationOfBenefit setProvider(Type value) {
        this.provider = value;
        return this;
    }

    public Type getOrganization() {
        return this.organization;
    }

    public Identifier getOrganizationIdentifier() throws FHIRException {
        if (!(this.organization instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.organization.getClass().getName() + " was encountered");
        }
        return (Identifier)this.organization;
    }

    public boolean hasOrganizationIdentifier() {
        return this.organization instanceof Identifier;
    }

    public Reference getOrganizationReference() throws FHIRException {
        if (!(this.organization instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.organization.getClass().getName() + " was encountered");
        }
        return (Reference)this.organization;
    }

    public boolean hasOrganizationReference() {
        return this.organization instanceof Reference;
    }

    public boolean hasOrganization() {
        return this.organization != null && !this.organization.isEmpty();
    }

    public ExplanationOfBenefit setOrganization(Type value) {
        this.organization = value;
        return this;
    }

    public Type getFacility() {
        return this.facility;
    }

    public Identifier getFacilityIdentifier() throws FHIRException {
        if (!(this.facility instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.facility.getClass().getName() + " was encountered");
        }
        return (Identifier)this.facility;
    }

    public boolean hasFacilityIdentifier() {
        return this.facility instanceof Identifier;
    }

    public Reference getFacilityReference() throws FHIRException {
        if (!(this.facility instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.facility.getClass().getName() + " was encountered");
        }
        return (Reference)this.facility;
    }

    public boolean hasFacilityReference() {
        return this.facility instanceof Reference;
    }

    public boolean hasFacility() {
        return this.facility != null && !this.facility.isEmpty();
    }

    public ExplanationOfBenefit setFacility(Type value) {
        this.facility = value;
        return this;
    }

    public List<RelatedClaimsComponent> getRelated() {
        if (this.related == null) {
            this.related = new ArrayList<RelatedClaimsComponent>();
        }
        return this.related;
    }

    public boolean hasRelated() {
        if (this.related == null) {
            return false;
        }
        for (RelatedClaimsComponent item : this.related) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RelatedClaimsComponent addRelated() {
        RelatedClaimsComponent t = new RelatedClaimsComponent();
        if (this.related == null) {
            this.related = new ArrayList<RelatedClaimsComponent>();
        }
        this.related.add(t);
        return t;
    }

    public ExplanationOfBenefit addRelated(RelatedClaimsComponent t) {
        if (t == null) {
            return this;
        }
        if (this.related == null) {
            this.related = new ArrayList<RelatedClaimsComponent>();
        }
        this.related.add(t);
        return this;
    }

    public Type getPrescription() {
        return this.prescription;
    }

    public Identifier getPrescriptionIdentifier() throws FHIRException {
        if (!(this.prescription instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.prescription.getClass().getName() + " was encountered");
        }
        return (Identifier)this.prescription;
    }

    public boolean hasPrescriptionIdentifier() {
        return this.prescription instanceof Identifier;
    }

    public Reference getPrescriptionReference() throws FHIRException {
        if (!(this.prescription instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.prescription.getClass().getName() + " was encountered");
        }
        return (Reference)this.prescription;
    }

    public boolean hasPrescriptionReference() {
        return this.prescription instanceof Reference;
    }

    public boolean hasPrescription() {
        return this.prescription != null && !this.prescription.isEmpty();
    }

    public ExplanationOfBenefit setPrescription(Type value) {
        this.prescription = value;
        return this;
    }

    public Type getOriginalPrescription() {
        return this.originalPrescription;
    }

    public Identifier getOriginalPrescriptionIdentifier() throws FHIRException {
        if (!(this.originalPrescription instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.originalPrescription.getClass().getName() + " was encountered");
        }
        return (Identifier)this.originalPrescription;
    }

    public boolean hasOriginalPrescriptionIdentifier() {
        return this.originalPrescription instanceof Identifier;
    }

    public Reference getOriginalPrescriptionReference() throws FHIRException {
        if (!(this.originalPrescription instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.originalPrescription.getClass().getName() + " was encountered");
        }
        return (Reference)this.originalPrescription;
    }

    public boolean hasOriginalPrescriptionReference() {
        return this.originalPrescription instanceof Reference;
    }

    public boolean hasOriginalPrescription() {
        return this.originalPrescription != null && !this.originalPrescription.isEmpty();
    }

    public ExplanationOfBenefit setOriginalPrescription(Type value) {
        this.originalPrescription = value;
        return this;
    }

    public PayeeComponent getPayee() {
        if (this.payee == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.payee");
            }
            if (Configuration.doAutoCreate()) {
                this.payee = new PayeeComponent();
            }
        }
        return this.payee;
    }

    public boolean hasPayee() {
        return this.payee != null && !this.payee.isEmpty();
    }

    public ExplanationOfBenefit setPayee(PayeeComponent value) {
        this.payee = value;
        return this;
    }

    public Type getReferral() {
        return this.referral;
    }

    public Identifier getReferralIdentifier() throws FHIRException {
        if (!(this.referral instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.referral.getClass().getName() + " was encountered");
        }
        return (Identifier)this.referral;
    }

    public boolean hasReferralIdentifier() {
        return this.referral instanceof Identifier;
    }

    public Reference getReferralReference() throws FHIRException {
        if (!(this.referral instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.referral.getClass().getName() + " was encountered");
        }
        return (Reference)this.referral;
    }

    public boolean hasReferralReference() {
        return this.referral instanceof Reference;
    }

    public boolean hasReferral() {
        return this.referral != null && !this.referral.isEmpty();
    }

    public ExplanationOfBenefit setReferral(Type value) {
        this.referral = value;
        return this;
    }

    public List<Coding> getOccurrenceCode() {
        if (this.occurrenceCode == null) {
            this.occurrenceCode = new ArrayList<Coding>();
        }
        return this.occurrenceCode;
    }

    public boolean hasOccurrenceCode() {
        if (this.occurrenceCode == null) {
            return false;
        }
        for (Coding item : this.occurrenceCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addOccurrenceCode() {
        Coding t = new Coding();
        if (this.occurrenceCode == null) {
            this.occurrenceCode = new ArrayList<Coding>();
        }
        this.occurrenceCode.add(t);
        return t;
    }

    public ExplanationOfBenefit addOccurrenceCode(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.occurrenceCode == null) {
            this.occurrenceCode = new ArrayList<Coding>();
        }
        this.occurrenceCode.add(t);
        return this;
    }

    public List<Coding> getOccurenceSpanCode() {
        if (this.occurenceSpanCode == null) {
            this.occurenceSpanCode = new ArrayList<Coding>();
        }
        return this.occurenceSpanCode;
    }

    public boolean hasOccurenceSpanCode() {
        if (this.occurenceSpanCode == null) {
            return false;
        }
        for (Coding item : this.occurenceSpanCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addOccurenceSpanCode() {
        Coding t = new Coding();
        if (this.occurenceSpanCode == null) {
            this.occurenceSpanCode = new ArrayList<Coding>();
        }
        this.occurenceSpanCode.add(t);
        return t;
    }

    public ExplanationOfBenefit addOccurenceSpanCode(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.occurenceSpanCode == null) {
            this.occurenceSpanCode = new ArrayList<Coding>();
        }
        this.occurenceSpanCode.add(t);
        return this;
    }

    public List<Coding> getValueCode() {
        if (this.valueCode == null) {
            this.valueCode = new ArrayList<Coding>();
        }
        return this.valueCode;
    }

    public boolean hasValueCode() {
        if (this.valueCode == null) {
            return false;
        }
        for (Coding item : this.valueCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addValueCode() {
        Coding t = new Coding();
        if (this.valueCode == null) {
            this.valueCode = new ArrayList<Coding>();
        }
        this.valueCode.add(t);
        return t;
    }

    public ExplanationOfBenefit addValueCode(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.valueCode == null) {
            this.valueCode = new ArrayList<Coding>();
        }
        this.valueCode.add(t);
        return this;
    }

    public List<DiagnosisComponent> getDiagnosis() {
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        return this.diagnosis;
    }

    public boolean hasDiagnosis() {
        if (this.diagnosis == null) {
            return false;
        }
        for (DiagnosisComponent item : this.diagnosis) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DiagnosisComponent addDiagnosis() {
        DiagnosisComponent t = new DiagnosisComponent();
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        this.diagnosis.add(t);
        return t;
    }

    public ExplanationOfBenefit addDiagnosis(DiagnosisComponent t) {
        if (t == null) {
            return this;
        }
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        this.diagnosis.add(t);
        return this;
    }

    public List<ProcedureComponent> getProcedure() {
        if (this.procedure == null) {
            this.procedure = new ArrayList<ProcedureComponent>();
        }
        return this.procedure;
    }

    public boolean hasProcedure() {
        if (this.procedure == null) {
            return false;
        }
        for (ProcedureComponent item : this.procedure) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProcedureComponent addProcedure() {
        ProcedureComponent t = new ProcedureComponent();
        if (this.procedure == null) {
            this.procedure = new ArrayList<ProcedureComponent>();
        }
        this.procedure.add(t);
        return t;
    }

    public ExplanationOfBenefit addProcedure(ProcedureComponent t) {
        if (t == null) {
            return this;
        }
        if (this.procedure == null) {
            this.procedure = new ArrayList<ProcedureComponent>();
        }
        this.procedure.add(t);
        return this;
    }

    public List<Coding> getSpecialCondition() {
        if (this.specialCondition == null) {
            this.specialCondition = new ArrayList<Coding>();
        }
        return this.specialCondition;
    }

    public boolean hasSpecialCondition() {
        if (this.specialCondition == null) {
            return false;
        }
        for (Coding item : this.specialCondition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addSpecialCondition() {
        Coding t = new Coding();
        if (this.specialCondition == null) {
            this.specialCondition = new ArrayList<Coding>();
        }
        this.specialCondition.add(t);
        return t;
    }

    public ExplanationOfBenefit addSpecialCondition(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.specialCondition == null) {
            this.specialCondition = new ArrayList<Coding>();
        }
        this.specialCondition.add(t);
        return this;
    }

    public Type getPatient() {
        return this.patient;
    }

    public Identifier getPatientIdentifier() throws FHIRException {
        if (!(this.patient instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.patient.getClass().getName() + " was encountered");
        }
        return (Identifier)this.patient;
    }

    public boolean hasPatientIdentifier() {
        return this.patient instanceof Identifier;
    }

    public Reference getPatientReference() throws FHIRException {
        if (!(this.patient instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.patient.getClass().getName() + " was encountered");
        }
        return (Reference)this.patient;
    }

    public boolean hasPatientReference() {
        return this.patient instanceof Reference;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public ExplanationOfBenefit setPatient(Type value) {
        this.patient = value;
        return this;
    }

    public PositiveIntType getPrecedenceElement() {
        if (this.precedence == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.precedence");
            }
            if (Configuration.doAutoCreate()) {
                this.precedence = new PositiveIntType();
            }
        }
        return this.precedence;
    }

    public boolean hasPrecedenceElement() {
        return this.precedence != null && !this.precedence.isEmpty();
    }

    public boolean hasPrecedence() {
        return this.precedence != null && !this.precedence.isEmpty();
    }

    public ExplanationOfBenefit setPrecedenceElement(PositiveIntType value) {
        this.precedence = value;
        return this;
    }

    public int getPrecedence() {
        return this.precedence == null || this.precedence.isEmpty() ? 0 : (Integer)this.precedence.getValue();
    }

    public ExplanationOfBenefit setPrecedence(int value) {
        if (this.precedence == null) {
            this.precedence = new PositiveIntType();
        }
        this.precedence.setValue((Object)value);
        return this;
    }

    public CoverageComponent getCoverage() {
        if (this.coverage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.coverage");
            }
            if (Configuration.doAutoCreate()) {
                this.coverage = new CoverageComponent();
            }
        }
        return this.coverage;
    }

    public boolean hasCoverage() {
        return this.coverage != null && !this.coverage.isEmpty();
    }

    public ExplanationOfBenefit setCoverage(CoverageComponent value) {
        this.coverage = value;
        return this;
    }

    public DateType getAccidentDateElement() {
        if (this.accidentDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.accidentDate");
            }
            if (Configuration.doAutoCreate()) {
                this.accidentDate = new DateType();
            }
        }
        return this.accidentDate;
    }

    public boolean hasAccidentDateElement() {
        return this.accidentDate != null && !this.accidentDate.isEmpty();
    }

    public boolean hasAccidentDate() {
        return this.accidentDate != null && !this.accidentDate.isEmpty();
    }

    public ExplanationOfBenefit setAccidentDateElement(DateType value) {
        this.accidentDate = value;
        return this;
    }

    public Date getAccidentDate() {
        return this.accidentDate == null ? null : (Date)this.accidentDate.getValue();
    }

    public ExplanationOfBenefit setAccidentDate(Date value) {
        if (value == null) {
            this.accidentDate = null;
        } else {
            if (this.accidentDate == null) {
                this.accidentDate = new DateType();
            }
            this.accidentDate.setValue(value);
        }
        return this;
    }

    public Coding getAccidentType() {
        if (this.accidentType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.accidentType");
            }
            if (Configuration.doAutoCreate()) {
                this.accidentType = new Coding();
            }
        }
        return this.accidentType;
    }

    public boolean hasAccidentType() {
        return this.accidentType != null && !this.accidentType.isEmpty();
    }

    public ExplanationOfBenefit setAccidentType(Coding value) {
        this.accidentType = value;
        return this;
    }

    public Type getAccidentLocation() {
        return this.accidentLocation;
    }

    public Address getAccidentLocationAddress() throws FHIRException {
        if (!(this.accidentLocation instanceof Address)) {
            throw new FHIRException("Type mismatch: the type Address was expected, but " + this.accidentLocation.getClass().getName() + " was encountered");
        }
        return (Address)this.accidentLocation;
    }

    public boolean hasAccidentLocationAddress() {
        return this.accidentLocation instanceof Address;
    }

    public Reference getAccidentLocationReference() throws FHIRException {
        if (!(this.accidentLocation instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.accidentLocation.getClass().getName() + " was encountered");
        }
        return (Reference)this.accidentLocation;
    }

    public boolean hasAccidentLocationReference() {
        return this.accidentLocation instanceof Reference;
    }

    public boolean hasAccidentLocation() {
        return this.accidentLocation != null && !this.accidentLocation.isEmpty();
    }

    public ExplanationOfBenefit setAccidentLocation(Type value) {
        this.accidentLocation = value;
        return this;
    }

    public List<Coding> getInterventionException() {
        if (this.interventionException == null) {
            this.interventionException = new ArrayList<Coding>();
        }
        return this.interventionException;
    }

    public boolean hasInterventionException() {
        if (this.interventionException == null) {
            return false;
        }
        for (Coding item : this.interventionException) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addInterventionException() {
        Coding t = new Coding();
        if (this.interventionException == null) {
            this.interventionException = new ArrayList<Coding>();
        }
        this.interventionException.add(t);
        return t;
    }

    public ExplanationOfBenefit addInterventionException(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.interventionException == null) {
            this.interventionException = new ArrayList<Coding>();
        }
        this.interventionException.add(t);
        return this;
    }

    public List<OnsetComponent> getOnset() {
        if (this.onset == null) {
            this.onset = new ArrayList<OnsetComponent>();
        }
        return this.onset;
    }

    public boolean hasOnset() {
        if (this.onset == null) {
            return false;
        }
        for (OnsetComponent item : this.onset) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OnsetComponent addOnset() {
        OnsetComponent t = new OnsetComponent();
        if (this.onset == null) {
            this.onset = new ArrayList<OnsetComponent>();
        }
        this.onset.add(t);
        return t;
    }

    public ExplanationOfBenefit addOnset(OnsetComponent t) {
        if (t == null) {
            return this;
        }
        if (this.onset == null) {
            this.onset = new ArrayList<OnsetComponent>();
        }
        this.onset.add(t);
        return this;
    }

    public Period getEmploymentImpacted() {
        if (this.employmentImpacted == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.employmentImpacted");
            }
            if (Configuration.doAutoCreate()) {
                this.employmentImpacted = new Period();
            }
        }
        return this.employmentImpacted;
    }

    public boolean hasEmploymentImpacted() {
        return this.employmentImpacted != null && !this.employmentImpacted.isEmpty();
    }

    public ExplanationOfBenefit setEmploymentImpacted(Period value) {
        this.employmentImpacted = value;
        return this;
    }

    public Period getHospitalization() {
        if (this.hospitalization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.hospitalization");
            }
            if (Configuration.doAutoCreate()) {
                this.hospitalization = new Period();
            }
        }
        return this.hospitalization;
    }

    public boolean hasHospitalization() {
        return this.hospitalization != null && !this.hospitalization.isEmpty();
    }

    public ExplanationOfBenefit setHospitalization(Period value) {
        this.hospitalization = value;
        return this;
    }

    public List<ItemsComponent> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<ItemsComponent>();
        }
        return this.item;
    }

    public boolean hasItem() {
        if (this.item == null) {
            return false;
        }
        for (ItemsComponent item : this.item) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ItemsComponent addItem() {
        ItemsComponent t = new ItemsComponent();
        if (this.item == null) {
            this.item = new ArrayList<ItemsComponent>();
        }
        this.item.add(t);
        return t;
    }

    public ExplanationOfBenefit addItem(ItemsComponent t) {
        if (t == null) {
            return this;
        }
        if (this.item == null) {
            this.item = new ArrayList<ItemsComponent>();
        }
        this.item.add(t);
        return this;
    }

    public List<AddedItemComponent> getAddItem() {
        if (this.addItem == null) {
            this.addItem = new ArrayList<AddedItemComponent>();
        }
        return this.addItem;
    }

    public boolean hasAddItem() {
        if (this.addItem == null) {
            return false;
        }
        for (AddedItemComponent item : this.addItem) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AddedItemComponent addAddItem() {
        AddedItemComponent t = new AddedItemComponent();
        if (this.addItem == null) {
            this.addItem = new ArrayList<AddedItemComponent>();
        }
        this.addItem.add(t);
        return t;
    }

    public ExplanationOfBenefit addAddItem(AddedItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.addItem == null) {
            this.addItem = new ArrayList<AddedItemComponent>();
        }
        this.addItem.add(t);
        return this;
    }

    public List<MissingTeethComponent> getMissingTeeth() {
        if (this.missingTeeth == null) {
            this.missingTeeth = new ArrayList<MissingTeethComponent>();
        }
        return this.missingTeeth;
    }

    public boolean hasMissingTeeth() {
        if (this.missingTeeth == null) {
            return false;
        }
        for (MissingTeethComponent item : this.missingTeeth) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MissingTeethComponent addMissingTeeth() {
        MissingTeethComponent t = new MissingTeethComponent();
        if (this.missingTeeth == null) {
            this.missingTeeth = new ArrayList<MissingTeethComponent>();
        }
        this.missingTeeth.add(t);
        return t;
    }

    public ExplanationOfBenefit addMissingTeeth(MissingTeethComponent t) {
        if (t == null) {
            return this;
        }
        if (this.missingTeeth == null) {
            this.missingTeeth = new ArrayList<MissingTeethComponent>();
        }
        this.missingTeeth.add(t);
        return this;
    }

    public Money getTotalCost() {
        if (this.totalCost == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.totalCost");
            }
            if (Configuration.doAutoCreate()) {
                this.totalCost = new Money();
            }
        }
        return this.totalCost;
    }

    public boolean hasTotalCost() {
        return this.totalCost != null && !this.totalCost.isEmpty();
    }

    public ExplanationOfBenefit setTotalCost(Money value) {
        this.totalCost = value;
        return this;
    }

    public Money getUnallocDeductable() {
        if (this.unallocDeductable == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.unallocDeductable");
            }
            if (Configuration.doAutoCreate()) {
                this.unallocDeductable = new Money();
            }
        }
        return this.unallocDeductable;
    }

    public boolean hasUnallocDeductable() {
        return this.unallocDeductable != null && !this.unallocDeductable.isEmpty();
    }

    public ExplanationOfBenefit setUnallocDeductable(Money value) {
        this.unallocDeductable = value;
        return this;
    }

    public Money getTotalBenefit() {
        if (this.totalBenefit == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.totalBenefit");
            }
            if (Configuration.doAutoCreate()) {
                this.totalBenefit = new Money();
            }
        }
        return this.totalBenefit;
    }

    public boolean hasTotalBenefit() {
        return this.totalBenefit != null && !this.totalBenefit.isEmpty();
    }

    public ExplanationOfBenefit setTotalBenefit(Money value) {
        this.totalBenefit = value;
        return this;
    }

    public Money getPaymentAdjustment() {
        if (this.paymentAdjustment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.paymentAdjustment");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentAdjustment = new Money();
            }
        }
        return this.paymentAdjustment;
    }

    public boolean hasPaymentAdjustment() {
        return this.paymentAdjustment != null && !this.paymentAdjustment.isEmpty();
    }

    public ExplanationOfBenefit setPaymentAdjustment(Money value) {
        this.paymentAdjustment = value;
        return this;
    }

    public Coding getPaymentAdjustmentReason() {
        if (this.paymentAdjustmentReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.paymentAdjustmentReason");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentAdjustmentReason = new Coding();
            }
        }
        return this.paymentAdjustmentReason;
    }

    public boolean hasPaymentAdjustmentReason() {
        return this.paymentAdjustmentReason != null && !this.paymentAdjustmentReason.isEmpty();
    }

    public ExplanationOfBenefit setPaymentAdjustmentReason(Coding value) {
        this.paymentAdjustmentReason = value;
        return this;
    }

    public DateType getPaymentDateElement() {
        if (this.paymentDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.paymentDate");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentDate = new DateType();
            }
        }
        return this.paymentDate;
    }

    public boolean hasPaymentDateElement() {
        return this.paymentDate != null && !this.paymentDate.isEmpty();
    }

    public boolean hasPaymentDate() {
        return this.paymentDate != null && !this.paymentDate.isEmpty();
    }

    public ExplanationOfBenefit setPaymentDateElement(DateType value) {
        this.paymentDate = value;
        return this;
    }

    public Date getPaymentDate() {
        return this.paymentDate == null ? null : (Date)this.paymentDate.getValue();
    }

    public ExplanationOfBenefit setPaymentDate(Date value) {
        if (value == null) {
            this.paymentDate = null;
        } else {
            if (this.paymentDate == null) {
                this.paymentDate = new DateType();
            }
            this.paymentDate.setValue(value);
        }
        return this;
    }

    public Money getPaymentAmount() {
        if (this.paymentAmount == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.paymentAmount");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentAmount = new Money();
            }
        }
        return this.paymentAmount;
    }

    public boolean hasPaymentAmount() {
        return this.paymentAmount != null && !this.paymentAmount.isEmpty();
    }

    public ExplanationOfBenefit setPaymentAmount(Money value) {
        this.paymentAmount = value;
        return this;
    }

    public Identifier getPaymentRef() {
        if (this.paymentRef == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.paymentRef");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentRef = new Identifier();
            }
        }
        return this.paymentRef;
    }

    public boolean hasPaymentRef() {
        return this.paymentRef != null && !this.paymentRef.isEmpty();
    }

    public ExplanationOfBenefit setPaymentRef(Identifier value) {
        this.paymentRef = value;
        return this;
    }

    public Coding getReserved() {
        if (this.reserved == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.reserved");
            }
            if (Configuration.doAutoCreate()) {
                this.reserved = new Coding();
            }
        }
        return this.reserved;
    }

    public boolean hasReserved() {
        return this.reserved != null && !this.reserved.isEmpty();
    }

    public ExplanationOfBenefit setReserved(Coding value) {
        this.reserved = value;
        return this;
    }

    public Coding getForm() {
        if (this.form == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.form");
            }
            if (Configuration.doAutoCreate()) {
                this.form = new Coding();
            }
        }
        return this.form;
    }

    public boolean hasForm() {
        return this.form != null && !this.form.isEmpty();
    }

    public ExplanationOfBenefit setForm(Coding value) {
        this.form = value;
        return this;
    }

    public List<NotesComponent> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<NotesComponent>();
        }
        return this.note;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (NotesComponent item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public NotesComponent addNote() {
        NotesComponent t = new NotesComponent();
        if (this.note == null) {
            this.note = new ArrayList<NotesComponent>();
        }
        this.note.add(t);
        return t;
    }

    public ExplanationOfBenefit addNote(NotesComponent t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<NotesComponent>();
        }
        this.note.add(t);
        return this;
    }

    public List<BenefitBalanceComponent> getBenefitBalance() {
        if (this.benefitBalance == null) {
            this.benefitBalance = new ArrayList<BenefitBalanceComponent>();
        }
        return this.benefitBalance;
    }

    public boolean hasBenefitBalance() {
        if (this.benefitBalance == null) {
            return false;
        }
        for (BenefitBalanceComponent item : this.benefitBalance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public BenefitBalanceComponent addBenefitBalance() {
        BenefitBalanceComponent t = new BenefitBalanceComponent();
        if (this.benefitBalance == null) {
            this.benefitBalance = new ArrayList<BenefitBalanceComponent>();
        }
        this.benefitBalance.add(t);
        return t;
    }

    public ExplanationOfBenefit addBenefitBalance(BenefitBalanceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.benefitBalance == null) {
            this.benefitBalance = new ArrayList<BenefitBalanceComponent>();
        }
        this.benefitBalance.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "The Response Business Identifier.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("claim[x]", "Identifier|Reference(Claim)", "The business identifier for the instance: invoice number, claim number, pre-determination or pre-authorization number.", 0, Integer.MAX_VALUE, this.claim));
        childrenList.add(new Property("claimResponse[x]", "Identifier|Reference(ClaimResponse)", "The business identifier for the instance: invoice number, claim number, pre-determination or pre-authorization number.", 0, Integer.MAX_VALUE, this.claimResponse));
        childrenList.add(new Property("subType", "Coding", "A finer grained suite of claim subtype codes which may convey Inpatient vs Outpatient and/or a specialty service. In the US the BillType.", 0, Integer.MAX_VALUE, this.subType));
        childrenList.add(new Property("ruleset", "Coding", "The version of the specification on which this instance relies.", 0, Integer.MAX_VALUE, this.ruleset));
        childrenList.add(new Property("originalRuleset", "Coding", "The version of the specification from which the original instance was created.", 0, Integer.MAX_VALUE, this.originalRuleset));
        childrenList.add(new Property(SP_CREATED, "dateTime", "The date when the EOB was created.", 0, Integer.MAX_VALUE, this.created));
        childrenList.add(new Property("billablePeriod", "Period", "The billable period for which charges are being submitted.", 0, Integer.MAX_VALUE, this.billablePeriod));
        childrenList.add(new Property(SP_DISPOSITION, "string", "A description of the status of the adjudication.", 0, Integer.MAX_VALUE, this.disposition));
        childrenList.add(new Property("provider[x]", "Identifier|Reference(Practitioner)", "The provider which is responsible for the claim.", 0, Integer.MAX_VALUE, this.provider));
        childrenList.add(new Property("organization[x]", "Identifier|Reference(Organization)", "The provider which is responsible for the claim.", 0, Integer.MAX_VALUE, this.organization));
        childrenList.add(new Property("facility[x]", "Identifier|Reference(Location)", "Facility where the services were provided.", 0, Integer.MAX_VALUE, this.facility));
        childrenList.add(new Property("related", "", "Other claims which are related to this claim such as prior claim versions or for related services.", 0, Integer.MAX_VALUE, this.related));
        childrenList.add(new Property("prescription[x]", "Identifier|Reference(MedicationOrder|VisionPrescription)", "Prescription to support the dispensing of Pharmacy or Vision products.", 0, Integer.MAX_VALUE, this.prescription));
        childrenList.add(new Property("originalPrescription[x]", "Identifier|Reference(MedicationOrder)", "Original prescription which has been superceded by this prescription to support the dispensing of pharmacy services, medications or products.", 0, Integer.MAX_VALUE, this.originalPrescription));
        childrenList.add(new Property("payee", "", "The party to be reimbursed for the services.", 0, Integer.MAX_VALUE, this.payee));
        childrenList.add(new Property("referral[x]", "Identifier|Reference(ReferralRequest)", "The referral resource which lists the date, practitioner, reason and other supporting information.", 0, Integer.MAX_VALUE, this.referral));
        childrenList.add(new Property("occurrenceCode", "Coding", "**Insert definition of Occurrence codes.", 0, Integer.MAX_VALUE, this.occurrenceCode));
        childrenList.add(new Property("occurenceSpanCode", "Coding", "**Insert definition of Occurrence Span codes.", 0, Integer.MAX_VALUE, this.occurenceSpanCode));
        childrenList.add(new Property("valueCode", "Coding", "**Insert definition of Value codes.", 0, Integer.MAX_VALUE, this.valueCode));
        childrenList.add(new Property("diagnosis", "", "Ordered list of patient diagnosis for which care is sought.", 0, Integer.MAX_VALUE, this.diagnosis));
        childrenList.add(new Property("procedure", "", "Ordered list of patient procedures performed to support the adjudication.", 0, Integer.MAX_VALUE, this.procedure));
        childrenList.add(new Property("specialCondition", "Coding", "List of special conditions relating to the setting, treatment or patient  for which care is sought which may influence the adjudication.", 0, Integer.MAX_VALUE, this.specialCondition));
        childrenList.add(new Property("patient[x]", "Identifier|Reference(Patient)", "Patient Resource.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property("precedence", "positiveInt", "Precedence (primary, secondary, etc.).", 0, Integer.MAX_VALUE, this.precedence));
        childrenList.add(new Property("coverage", "", "Financial instrument by which payment information for health care.", 0, Integer.MAX_VALUE, this.coverage));
        childrenList.add(new Property("accidentDate", "date", "Date of an accident which these services are addressing.", 0, Integer.MAX_VALUE, this.accidentDate));
        childrenList.add(new Property("accidentType", "Coding", "Type of accident: work, auto, etc.", 0, Integer.MAX_VALUE, this.accidentType));
        childrenList.add(new Property("accidentLocation[x]", "Address|Reference(Location)", "Accident Place.", 0, Integer.MAX_VALUE, this.accidentLocation));
        childrenList.add(new Property("interventionException", "Coding", "A list of intervention and exception codes which may influence the adjudication of the claim.", 0, Integer.MAX_VALUE, this.interventionException));
        childrenList.add(new Property("onset", "", "Period, start and last dates of aspects of the Condition or related services.", 0, Integer.MAX_VALUE, this.onset));
        childrenList.add(new Property("employmentImpacted", "Period", "The start and optional end dates of when the patient was precluded from working due to the treatable condition(s).", 0, Integer.MAX_VALUE, this.employmentImpacted));
        childrenList.add(new Property("hospitalization", "Period", "The start and optional end dates of when the patient was confined to a treatment center.", 0, Integer.MAX_VALUE, this.hospitalization));
        childrenList.add(new Property("item", "", "First tier of goods and services.", 0, Integer.MAX_VALUE, this.item));
        childrenList.add(new Property("addItem", "", "The first tier service adjudications for payor added services.", 0, Integer.MAX_VALUE, this.addItem));
        childrenList.add(new Property("missingTeeth", "", "A list of teeth which would be expected but are not found due to having been previously  extracted or for other reasons.", 0, Integer.MAX_VALUE, this.missingTeeth));
        childrenList.add(new Property("totalCost", "Money", "The total cost of the services reported.", 0, Integer.MAX_VALUE, this.totalCost));
        childrenList.add(new Property("unallocDeductable", "Money", "The amount of deductable applied which was not allocated to any particular service line.", 0, Integer.MAX_VALUE, this.unallocDeductable));
        childrenList.add(new Property("totalBenefit", "Money", "Total amount of benefit payable (Equal to sum of the Benefit amounts from all detail lines and additions less the Unallocated Deductable).", 0, Integer.MAX_VALUE, this.totalBenefit));
        childrenList.add(new Property("paymentAdjustment", "Money", "Adjustment to the payment of this transaction which is not related to adjudication of this transaction.", 0, Integer.MAX_VALUE, this.paymentAdjustment));
        childrenList.add(new Property("paymentAdjustmentReason", "Coding", "Reason for the payment adjustment.", 0, Integer.MAX_VALUE, this.paymentAdjustmentReason));
        childrenList.add(new Property("paymentDate", "date", "Estimated payment data.", 0, Integer.MAX_VALUE, this.paymentDate));
        childrenList.add(new Property("paymentAmount", "Money", "Payable less any payment adjustment.", 0, Integer.MAX_VALUE, this.paymentAmount));
        childrenList.add(new Property("paymentRef", "Identifier", "Payment identifer.", 0, Integer.MAX_VALUE, this.paymentRef));
        childrenList.add(new Property("reserved", "Coding", "Status of funds reservation (For provider, for Patient, None).", 0, Integer.MAX_VALUE, this.reserved));
        childrenList.add(new Property("form", "Coding", "The form to be used for printing the content.", 0, Integer.MAX_VALUE, this.form));
        childrenList.add(new Property("note", "", "Note text.", 0, Integer.MAX_VALUE, this.note));
        childrenList.add(new Property("benefitBalance", "", "Balance by Benefit Category.", 0, Integer.MAX_VALUE, this.benefitBalance));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 94742588: {
                Base[] baseArray;
                if (this.claim == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.claim;
                }
                return baseArray;
            }
            case 689513629: {
                Base[] baseArray;
                if (this.claimResponse == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.claimResponse;
                }
                return baseArray;
            }
            case -1868521062: {
                return this.subType == null ? new Base[]{} : this.subType.toArray(new Base[this.subType.size()]);
            }
            case 1548678118: {
                Base[] baseArray;
                if (this.ruleset == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.ruleset;
                }
                return baseArray;
            }
            case 1089373397: {
                Base[] baseArray;
                if (this.originalRuleset == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.originalRuleset;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.created;
                }
                return baseArray;
            }
            case -332066046: {
                Base[] baseArray;
                if (this.billablePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.billablePeriod;
                }
                return baseArray;
            }
            case 583380919: {
                Base[] baseArray;
                if (this.disposition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.disposition;
                }
                return baseArray;
            }
            case -987494927: {
                Base[] baseArray;
                if (this.provider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.provider;
                }
                return baseArray;
            }
            case 1178922291: {
                Base[] baseArray;
                if (this.organization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.organization;
                }
                return baseArray;
            }
            case 501116579: {
                Base[] baseArray;
                if (this.facility == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.facility;
                }
                return baseArray;
            }
            case 1090493483: {
                return this.related == null ? new Base[]{} : this.related.toArray(new Base[this.related.size()]);
            }
            case 460301338: {
                Base[] baseArray;
                if (this.prescription == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.prescription;
                }
                return baseArray;
            }
            case -1814015861: {
                Base[] baseArray;
                if (this.originalPrescription == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.originalPrescription;
                }
                return baseArray;
            }
            case 106443592: {
                Base[] baseArray;
                if (this.payee == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.payee;
                }
                return baseArray;
            }
            case -722568291: {
                Base[] baseArray;
                if (this.referral == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.referral;
                }
                return baseArray;
            }
            case 1721744222: {
                return this.occurrenceCode == null ? new Base[]{} : this.occurrenceCode.toArray(new Base[this.occurrenceCode.size()]);
            }
            case -556690898: {
                return this.occurenceSpanCode == null ? new Base[]{} : this.occurenceSpanCode.toArray(new Base[this.occurenceSpanCode.size()]);
            }
            case -766209282: {
                return this.valueCode == null ? new Base[]{} : this.valueCode.toArray(new Base[this.valueCode.size()]);
            }
            case 1196993265: {
                return this.diagnosis == null ? new Base[]{} : this.diagnosis.toArray(new Base[this.diagnosis.size()]);
            }
            case -1095204141: {
                return this.procedure == null ? new Base[]{} : this.procedure.toArray(new Base[this.procedure.size()]);
            }
            case -481489822: {
                return this.specialCondition == null ? new Base[]{} : this.specialCondition.toArray(new Base[this.specialCondition.size()]);
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.patient;
                }
                return baseArray;
            }
            case 159695370: {
                Base[] baseArray;
                if (this.precedence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.precedence;
                }
                return baseArray;
            }
            case -351767064: {
                Base[] baseArray;
                if (this.coverage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.coverage;
                }
                return baseArray;
            }
            case -63170979: {
                Base[] baseArray;
                if (this.accidentDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.accidentDate;
                }
                return baseArray;
            }
            case -62671383: {
                Base[] baseArray;
                if (this.accidentType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.accidentType;
                }
                return baseArray;
            }
            case -1074014492: {
                Base[] baseArray;
                if (this.accidentLocation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray21 = new Base[1];
                    baseArray = baseArray21;
                    baseArray21[0] = this.accidentLocation;
                }
                return baseArray;
            }
            case 1753076536: {
                return this.interventionException == null ? new Base[]{} : this.interventionException.toArray(new Base[this.interventionException.size()]);
            }
            case 105901603: {
                return this.onset == null ? new Base[]{} : this.onset.toArray(new Base[this.onset.size()]);
            }
            case 1051487345: {
                Base[] baseArray;
                if (this.employmentImpacted == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray22 = new Base[1];
                    baseArray = baseArray22;
                    baseArray22[0] = this.employmentImpacted;
                }
                return baseArray;
            }
            case 1057894634: {
                Base[] baseArray;
                if (this.hospitalization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray23 = new Base[1];
                    baseArray = baseArray23;
                    baseArray23[0] = this.hospitalization;
                }
                return baseArray;
            }
            case 3242771: {
                return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
            }
            case -1148899500: {
                return this.addItem == null ? new Base[]{} : this.addItem.toArray(new Base[this.addItem.size()]);
            }
            case -1157130302: {
                return this.missingTeeth == null ? new Base[]{} : this.missingTeeth.toArray(new Base[this.missingTeeth.size()]);
            }
            case -577782479: {
                Base[] baseArray;
                if (this.totalCost == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray24 = new Base[1];
                    baseArray = baseArray24;
                    baseArray24[0] = this.totalCost;
                }
                return baseArray;
            }
            case 2096309753: {
                Base[] baseArray;
                if (this.unallocDeductable == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray25 = new Base[1];
                    baseArray = baseArray25;
                    baseArray25[0] = this.unallocDeductable;
                }
                return baseArray;
            }
            case 332332211: {
                Base[] baseArray;
                if (this.totalBenefit == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray26 = new Base[1];
                    baseArray = baseArray26;
                    baseArray26[0] = this.totalBenefit;
                }
                return baseArray;
            }
            case 856402963: {
                Base[] baseArray;
                if (this.paymentAdjustment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray27 = new Base[1];
                    baseArray = baseArray27;
                    baseArray27[0] = this.paymentAdjustment;
                }
                return baseArray;
            }
            case -1386508233: {
                Base[] baseArray;
                if (this.paymentAdjustmentReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray28 = new Base[1];
                    baseArray = baseArray28;
                    baseArray28[0] = this.paymentAdjustmentReason;
                }
                return baseArray;
            }
            case -1540873516: {
                Base[] baseArray;
                if (this.paymentDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray29 = new Base[1];
                    baseArray = baseArray29;
                    baseArray29[0] = this.paymentDate;
                }
                return baseArray;
            }
            case 909332990: {
                Base[] baseArray;
                if (this.paymentAmount == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray30 = new Base[1];
                    baseArray = baseArray30;
                    baseArray30[0] = this.paymentAmount;
                }
                return baseArray;
            }
            case 1612875949: {
                Base[] baseArray;
                if (this.paymentRef == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray31 = new Base[1];
                    baseArray = baseArray31;
                    baseArray31[0] = this.paymentRef;
                }
                return baseArray;
            }
            case -350385368: {
                Base[] baseArray;
                if (this.reserved == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray32 = new Base[1];
                    baseArray = baseArray32;
                    baseArray32[0] = this.reserved;
                }
                return baseArray;
            }
            case 3148996: {
                Base[] baseArray;
                if (this.form == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray33 = new Base[1];
                    baseArray = baseArray33;
                    baseArray33[0] = this.form;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 596003397: {
                return this.benefitBalance == null ? new Base[]{} : this.benefitBalance.toArray(new Base[this.benefitBalance.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case 94742588: {
                this.claim = (Type)value;
                break;
            }
            case 689513629: {
                this.claimResponse = (Type)value;
                break;
            }
            case -1868521062: {
                this.getSubType().add(this.castToCoding(value));
                break;
            }
            case 1548678118: {
                this.ruleset = this.castToCoding(value);
                break;
            }
            case 1089373397: {
                this.originalRuleset = this.castToCoding(value);
                break;
            }
            case 1028554472: {
                this.created = this.castToDateTime(value);
                break;
            }
            case -332066046: {
                this.billablePeriod = this.castToPeriod(value);
                break;
            }
            case 583380919: {
                this.disposition = this.castToString(value);
                break;
            }
            case -987494927: {
                this.provider = (Type)value;
                break;
            }
            case 1178922291: {
                this.organization = (Type)value;
                break;
            }
            case 501116579: {
                this.facility = (Type)value;
                break;
            }
            case 1090493483: {
                this.getRelated().add((RelatedClaimsComponent)value);
                break;
            }
            case 460301338: {
                this.prescription = (Type)value;
                break;
            }
            case -1814015861: {
                this.originalPrescription = (Type)value;
                break;
            }
            case 106443592: {
                this.payee = (PayeeComponent)value;
                break;
            }
            case -722568291: {
                this.referral = (Type)value;
                break;
            }
            case 1721744222: {
                this.getOccurrenceCode().add(this.castToCoding(value));
                break;
            }
            case -556690898: {
                this.getOccurenceSpanCode().add(this.castToCoding(value));
                break;
            }
            case -766209282: {
                this.getValueCode().add(this.castToCoding(value));
                break;
            }
            case 1196993265: {
                this.getDiagnosis().add((DiagnosisComponent)value);
                break;
            }
            case -1095204141: {
                this.getProcedure().add((ProcedureComponent)value);
                break;
            }
            case -481489822: {
                this.getSpecialCondition().add(this.castToCoding(value));
                break;
            }
            case -791418107: {
                this.patient = (Type)value;
                break;
            }
            case 159695370: {
                this.precedence = this.castToPositiveInt(value);
                break;
            }
            case -351767064: {
                this.coverage = (CoverageComponent)value;
                break;
            }
            case -63170979: {
                this.accidentDate = this.castToDate(value);
                break;
            }
            case -62671383: {
                this.accidentType = this.castToCoding(value);
                break;
            }
            case -1074014492: {
                this.accidentLocation = (Type)value;
                break;
            }
            case 1753076536: {
                this.getInterventionException().add(this.castToCoding(value));
                break;
            }
            case 105901603: {
                this.getOnset().add((OnsetComponent)value);
                break;
            }
            case 1051487345: {
                this.employmentImpacted = this.castToPeriod(value);
                break;
            }
            case 1057894634: {
                this.hospitalization = this.castToPeriod(value);
                break;
            }
            case 3242771: {
                this.getItem().add((ItemsComponent)value);
                break;
            }
            case -1148899500: {
                this.getAddItem().add((AddedItemComponent)value);
                break;
            }
            case -1157130302: {
                this.getMissingTeeth().add((MissingTeethComponent)value);
                break;
            }
            case -577782479: {
                this.totalCost = this.castToMoney(value);
                break;
            }
            case 2096309753: {
                this.unallocDeductable = this.castToMoney(value);
                break;
            }
            case 332332211: {
                this.totalBenefit = this.castToMoney(value);
                break;
            }
            case 856402963: {
                this.paymentAdjustment = this.castToMoney(value);
                break;
            }
            case -1386508233: {
                this.paymentAdjustmentReason = this.castToCoding(value);
                break;
            }
            case -1540873516: {
                this.paymentDate = this.castToDate(value);
                break;
            }
            case 909332990: {
                this.paymentAmount = this.castToMoney(value);
                break;
            }
            case 1612875949: {
                this.paymentRef = this.castToIdentifier(value);
                break;
            }
            case -350385368: {
                this.reserved = this.castToCoding(value);
                break;
            }
            case 3148996: {
                this.form = this.castToCoding(value);
                break;
            }
            case 3387378: {
                this.getNote().add((NotesComponent)value);
                break;
            }
            case 596003397: {
                this.getBenefitBalance().add((BenefitBalanceComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("claim[x]")) {
            this.claim = (Type)value;
        } else if (name.equals("claimResponse[x]")) {
            this.claimResponse = (Type)value;
        } else if (name.equals("subType")) {
            this.getSubType().add(this.castToCoding(value));
        } else if (name.equals("ruleset")) {
            this.ruleset = this.castToCoding(value);
        } else if (name.equals("originalRuleset")) {
            this.originalRuleset = this.castToCoding(value);
        } else if (name.equals(SP_CREATED)) {
            this.created = this.castToDateTime(value);
        } else if (name.equals("billablePeriod")) {
            this.billablePeriod = this.castToPeriod(value);
        } else if (name.equals(SP_DISPOSITION)) {
            this.disposition = this.castToString(value);
        } else if (name.equals("provider[x]")) {
            this.provider = (Type)value;
        } else if (name.equals("organization[x]")) {
            this.organization = (Type)value;
        } else if (name.equals("facility[x]")) {
            this.facility = (Type)value;
        } else if (name.equals("related")) {
            this.getRelated().add((RelatedClaimsComponent)value);
        } else if (name.equals("prescription[x]")) {
            this.prescription = (Type)value;
        } else if (name.equals("originalPrescription[x]")) {
            this.originalPrescription = (Type)value;
        } else if (name.equals("payee")) {
            this.payee = (PayeeComponent)value;
        } else if (name.equals("referral[x]")) {
            this.referral = (Type)value;
        } else if (name.equals("occurrenceCode")) {
            this.getOccurrenceCode().add(this.castToCoding(value));
        } else if (name.equals("occurenceSpanCode")) {
            this.getOccurenceSpanCode().add(this.castToCoding(value));
        } else if (name.equals("valueCode")) {
            this.getValueCode().add(this.castToCoding(value));
        } else if (name.equals("diagnosis")) {
            this.getDiagnosis().add((DiagnosisComponent)value);
        } else if (name.equals("procedure")) {
            this.getProcedure().add((ProcedureComponent)value);
        } else if (name.equals("specialCondition")) {
            this.getSpecialCondition().add(this.castToCoding(value));
        } else if (name.equals("patient[x]")) {
            this.patient = (Type)value;
        } else if (name.equals("precedence")) {
            this.precedence = this.castToPositiveInt(value);
        } else if (name.equals("coverage")) {
            this.coverage = (CoverageComponent)value;
        } else if (name.equals("accidentDate")) {
            this.accidentDate = this.castToDate(value);
        } else if (name.equals("accidentType")) {
            this.accidentType = this.castToCoding(value);
        } else if (name.equals("accidentLocation[x]")) {
            this.accidentLocation = (Type)value;
        } else if (name.equals("interventionException")) {
            this.getInterventionException().add(this.castToCoding(value));
        } else if (name.equals("onset")) {
            this.getOnset().add((OnsetComponent)value);
        } else if (name.equals("employmentImpacted")) {
            this.employmentImpacted = this.castToPeriod(value);
        } else if (name.equals("hospitalization")) {
            this.hospitalization = this.castToPeriod(value);
        } else if (name.equals("item")) {
            this.getItem().add((ItemsComponent)value);
        } else if (name.equals("addItem")) {
            this.getAddItem().add((AddedItemComponent)value);
        } else if (name.equals("missingTeeth")) {
            this.getMissingTeeth().add((MissingTeethComponent)value);
        } else if (name.equals("totalCost")) {
            this.totalCost = this.castToMoney(value);
        } else if (name.equals("unallocDeductable")) {
            this.unallocDeductable = this.castToMoney(value);
        } else if (name.equals("totalBenefit")) {
            this.totalBenefit = this.castToMoney(value);
        } else if (name.equals("paymentAdjustment")) {
            this.paymentAdjustment = this.castToMoney(value);
        } else if (name.equals("paymentAdjustmentReason")) {
            this.paymentAdjustmentReason = this.castToCoding(value);
        } else if (name.equals("paymentDate")) {
            this.paymentDate = this.castToDate(value);
        } else if (name.equals("paymentAmount")) {
            this.paymentAmount = this.castToMoney(value);
        } else if (name.equals("paymentRef")) {
            this.paymentRef = this.castToIdentifier(value);
        } else if (name.equals("reserved")) {
            this.reserved = this.castToCoding(value);
        } else if (name.equals("form")) {
            this.form = this.castToCoding(value);
        } else if (name.equals("note")) {
            this.getNote().add((NotesComponent)value);
        } else if (name.equals("benefitBalance")) {
            this.getBenefitBalance().add((BenefitBalanceComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 683016900: {
                return this.getClaim();
            }
            case -1527963965: {
                return this.getClaimResponse();
            }
            case -1868521062: {
                return this.addSubType();
            }
            case 1548678118: {
                return this.getRuleset();
            }
            case 1089373397: {
                return this.getOriginalRuleset();
            }
            case 1028554472: {
                throw new FHIRException("Cannot make property created as it is not a complex type");
            }
            case -332066046: {
                return this.getBillablePeriod();
            }
            case 583380919: {
                throw new FHIRException("Cannot make property disposition as it is not a complex type");
            }
            case 2064698607: {
                return this.getProvider();
            }
            case 1326483053: {
                return this.getOrganization();
            }
            case -542224643: {
                return this.getFacility();
            }
            case 1090493483: {
                return this.addRelated();
            }
            case -993324506: {
                return this.getPrescription();
            }
            case -2067905515: {
                return this.getOriginalPrescription();
            }
            case 106443592: {
                return this.getPayee();
            }
            case 344221635: {
                return this.getReferral();
            }
            case 1721744222: {
                return this.addOccurrenceCode();
            }
            case -556690898: {
                return this.addOccurenceSpanCode();
            }
            case -766209282: {
                return this.addValueCode();
            }
            case 1196993265: {
                return this.addDiagnosis();
            }
            case -1095204141: {
                return this.addProcedure();
            }
            case -481489822: {
                return this.addSpecialCondition();
            }
            case -2061246629: {
                return this.getPatient();
            }
            case 159695370: {
                throw new FHIRException("Cannot make property precedence as it is not a complex type");
            }
            case -351767064: {
                return this.getCoverage();
            }
            case -63170979: {
                throw new FHIRException("Cannot make property accidentDate as it is not a complex type");
            }
            case -62671383: {
                return this.getAccidentType();
            }
            case 1540715292: {
                return this.getAccidentLocation();
            }
            case 1753076536: {
                return this.addInterventionException();
            }
            case 105901603: {
                return this.addOnset();
            }
            case 1051487345: {
                return this.getEmploymentImpacted();
            }
            case 1057894634: {
                return this.getHospitalization();
            }
            case 3242771: {
                return this.addItem();
            }
            case -1148899500: {
                return this.addAddItem();
            }
            case -1157130302: {
                return this.addMissingTeeth();
            }
            case -577782479: {
                return this.getTotalCost();
            }
            case 2096309753: {
                return this.getUnallocDeductable();
            }
            case 332332211: {
                return this.getTotalBenefit();
            }
            case 856402963: {
                return this.getPaymentAdjustment();
            }
            case -1386508233: {
                return this.getPaymentAdjustmentReason();
            }
            case -1540873516: {
                throw new FHIRException("Cannot make property paymentDate as it is not a complex type");
            }
            case 909332990: {
                return this.getPaymentAmount();
            }
            case 1612875949: {
                return this.getPaymentRef();
            }
            case -350385368: {
                return this.getReserved();
            }
            case 3148996: {
                return this.getForm();
            }
            case 3387378: {
                return this.addNote();
            }
            case 596003397: {
                return this.addBenefitBalance();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("claimIdentifier")) {
            this.claim = new Identifier();
            return this.claim;
        }
        if (name.equals("claimReference")) {
            this.claim = new Reference();
            return this.claim;
        }
        if (name.equals("claimResponseIdentifier")) {
            this.claimResponse = new Identifier();
            return this.claimResponse;
        }
        if (name.equals("claimResponseReference")) {
            this.claimResponse = new Reference();
            return this.claimResponse;
        }
        if (name.equals("subType")) {
            return this.addSubType();
        }
        if (name.equals("ruleset")) {
            this.ruleset = new Coding();
            return this.ruleset;
        }
        if (name.equals("originalRuleset")) {
            this.originalRuleset = new Coding();
            return this.originalRuleset;
        }
        if (name.equals(SP_CREATED)) {
            throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.created");
        }
        if (name.equals("billablePeriod")) {
            this.billablePeriod = new Period();
            return this.billablePeriod;
        }
        if (name.equals(SP_DISPOSITION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.disposition");
        }
        if (name.equals("providerIdentifier")) {
            this.provider = new Identifier();
            return this.provider;
        }
        if (name.equals("providerReference")) {
            this.provider = new Reference();
            return this.provider;
        }
        if (name.equals("organizationIdentifier")) {
            this.organization = new Identifier();
            return this.organization;
        }
        if (name.equals("organizationReference")) {
            this.organization = new Reference();
            return this.organization;
        }
        if (name.equals("facilityIdentifier")) {
            this.facility = new Identifier();
            return this.facility;
        }
        if (name.equals("facilityReference")) {
            this.facility = new Reference();
            return this.facility;
        }
        if (name.equals("related")) {
            return this.addRelated();
        }
        if (name.equals("prescriptionIdentifier")) {
            this.prescription = new Identifier();
            return this.prescription;
        }
        if (name.equals("prescriptionReference")) {
            this.prescription = new Reference();
            return this.prescription;
        }
        if (name.equals("originalPrescriptionIdentifier")) {
            this.originalPrescription = new Identifier();
            return this.originalPrescription;
        }
        if (name.equals("originalPrescriptionReference")) {
            this.originalPrescription = new Reference();
            return this.originalPrescription;
        }
        if (name.equals("payee")) {
            this.payee = new PayeeComponent();
            return this.payee;
        }
        if (name.equals("referralIdentifier")) {
            this.referral = new Identifier();
            return this.referral;
        }
        if (name.equals("referralReference")) {
            this.referral = new Reference();
            return this.referral;
        }
        if (name.equals("occurrenceCode")) {
            return this.addOccurrenceCode();
        }
        if (name.equals("occurenceSpanCode")) {
            return this.addOccurenceSpanCode();
        }
        if (name.equals("valueCode")) {
            return this.addValueCode();
        }
        if (name.equals("diagnosis")) {
            return this.addDiagnosis();
        }
        if (name.equals("procedure")) {
            return this.addProcedure();
        }
        if (name.equals("specialCondition")) {
            return this.addSpecialCondition();
        }
        if (name.equals("patientIdentifier")) {
            this.patient = new Identifier();
            return this.patient;
        }
        if (name.equals("patientReference")) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("precedence")) {
            throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.precedence");
        }
        if (name.equals("coverage")) {
            this.coverage = new CoverageComponent();
            return this.coverage;
        }
        if (name.equals("accidentDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.accidentDate");
        }
        if (name.equals("accidentType")) {
            this.accidentType = new Coding();
            return this.accidentType;
        }
        if (name.equals("accidentLocationAddress")) {
            this.accidentLocation = new Address();
            return this.accidentLocation;
        }
        if (name.equals("accidentLocationReference")) {
            this.accidentLocation = new Reference();
            return this.accidentLocation;
        }
        if (name.equals("interventionException")) {
            return this.addInterventionException();
        }
        if (name.equals("onset")) {
            return this.addOnset();
        }
        if (name.equals("employmentImpacted")) {
            this.employmentImpacted = new Period();
            return this.employmentImpacted;
        }
        if (name.equals("hospitalization")) {
            this.hospitalization = new Period();
            return this.hospitalization;
        }
        if (name.equals("item")) {
            return this.addItem();
        }
        if (name.equals("addItem")) {
            return this.addAddItem();
        }
        if (name.equals("missingTeeth")) {
            return this.addMissingTeeth();
        }
        if (name.equals("totalCost")) {
            this.totalCost = new Money();
            return this.totalCost;
        }
        if (name.equals("unallocDeductable")) {
            this.unallocDeductable = new Money();
            return this.unallocDeductable;
        }
        if (name.equals("totalBenefit")) {
            this.totalBenefit = new Money();
            return this.totalBenefit;
        }
        if (name.equals("paymentAdjustment")) {
            this.paymentAdjustment = new Money();
            return this.paymentAdjustment;
        }
        if (name.equals("paymentAdjustmentReason")) {
            this.paymentAdjustmentReason = new Coding();
            return this.paymentAdjustmentReason;
        }
        if (name.equals("paymentDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.paymentDate");
        }
        if (name.equals("paymentAmount")) {
            this.paymentAmount = new Money();
            return this.paymentAmount;
        }
        if (name.equals("paymentRef")) {
            this.paymentRef = new Identifier();
            return this.paymentRef;
        }
        if (name.equals("reserved")) {
            this.reserved = new Coding();
            return this.reserved;
        }
        if (name.equals("form")) {
            this.form = new Coding();
            return this.form;
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("benefitBalance")) {
            return this.addBenefitBalance();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ExplanationOfBenefit";
    }

    @Override
    public ExplanationOfBenefit copy() {
        ExplanationOfBenefit dst = new ExplanationOfBenefit();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.claim = this.claim == null ? null : this.claim.copy();
        Type type = dst.claimResponse = this.claimResponse == null ? null : this.claimResponse.copy();
        if (this.subType != null) {
            dst.subType = new ArrayList<Coding>();
            for (Coding coding : this.subType) {
                dst.subType.add(coding.copy());
            }
        }
        dst.ruleset = this.ruleset == null ? null : this.ruleset.copy();
        dst.originalRuleset = this.originalRuleset == null ? null : this.originalRuleset.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.billablePeriod = this.billablePeriod == null ? null : this.billablePeriod.copy();
        dst.disposition = this.disposition == null ? null : this.disposition.copy();
        dst.provider = this.provider == null ? null : this.provider.copy();
        dst.organization = this.organization == null ? null : this.organization.copy();
        Type type2 = dst.facility = this.facility == null ? null : this.facility.copy();
        if (this.related != null) {
            dst.related = new ArrayList<RelatedClaimsComponent>();
            for (RelatedClaimsComponent relatedClaimsComponent : this.related) {
                dst.related.add(relatedClaimsComponent.copy());
            }
        }
        dst.prescription = this.prescription == null ? null : this.prescription.copy();
        dst.originalPrescription = this.originalPrescription == null ? null : this.originalPrescription.copy();
        dst.payee = this.payee == null ? null : this.payee.copy();
        Type type3 = dst.referral = this.referral == null ? null : this.referral.copy();
        if (this.occurrenceCode != null) {
            dst.occurrenceCode = new ArrayList<Coding>();
            for (Coding coding : this.occurrenceCode) {
                dst.occurrenceCode.add(coding.copy());
            }
        }
        if (this.occurenceSpanCode != null) {
            dst.occurenceSpanCode = new ArrayList<Coding>();
            for (Coding coding : this.occurenceSpanCode) {
                dst.occurenceSpanCode.add(coding.copy());
            }
        }
        if (this.valueCode != null) {
            dst.valueCode = new ArrayList<Coding>();
            for (Coding coding : this.valueCode) {
                dst.valueCode.add(coding.copy());
            }
        }
        if (this.diagnosis != null) {
            dst.diagnosis = new ArrayList<DiagnosisComponent>();
            for (DiagnosisComponent diagnosisComponent : this.diagnosis) {
                dst.diagnosis.add(diagnosisComponent.copy());
            }
        }
        if (this.procedure != null) {
            dst.procedure = new ArrayList<ProcedureComponent>();
            for (ProcedureComponent procedureComponent : this.procedure) {
                dst.procedure.add(procedureComponent.copy());
            }
        }
        if (this.specialCondition != null) {
            dst.specialCondition = new ArrayList<Coding>();
            for (Coding coding : this.specialCondition) {
                dst.specialCondition.add(coding.copy());
            }
        }
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.precedence = this.precedence == null ? null : this.precedence.copy();
        dst.coverage = this.coverage == null ? null : this.coverage.copy();
        dst.accidentDate = this.accidentDate == null ? null : this.accidentDate.copy();
        dst.accidentType = this.accidentType == null ? null : this.accidentType.copy();
        Type type4 = dst.accidentLocation = this.accidentLocation == null ? null : this.accidentLocation.copy();
        if (this.interventionException != null) {
            dst.interventionException = new ArrayList<Coding>();
            for (Coding coding : this.interventionException) {
                dst.interventionException.add(coding.copy());
            }
        }
        if (this.onset != null) {
            dst.onset = new ArrayList<OnsetComponent>();
            for (OnsetComponent onsetComponent : this.onset) {
                dst.onset.add(onsetComponent.copy());
            }
        }
        dst.employmentImpacted = this.employmentImpacted == null ? null : this.employmentImpacted.copy();
        Period period = dst.hospitalization = this.hospitalization == null ? null : this.hospitalization.copy();
        if (this.item != null) {
            dst.item = new ArrayList<ItemsComponent>();
            for (ItemsComponent itemsComponent : this.item) {
                dst.item.add(itemsComponent.copy());
            }
        }
        if (this.addItem != null) {
            dst.addItem = new ArrayList<AddedItemComponent>();
            for (AddedItemComponent addedItemComponent : this.addItem) {
                dst.addItem.add(addedItemComponent.copy());
            }
        }
        if (this.missingTeeth != null) {
            dst.missingTeeth = new ArrayList<MissingTeethComponent>();
            for (MissingTeethComponent missingTeethComponent : this.missingTeeth) {
                dst.missingTeeth.add(missingTeethComponent.copy());
            }
        }
        dst.totalCost = this.totalCost == null ? null : this.totalCost.copy();
        dst.unallocDeductable = this.unallocDeductable == null ? null : this.unallocDeductable.copy();
        dst.totalBenefit = this.totalBenefit == null ? null : this.totalBenefit.copy();
        dst.paymentAdjustment = this.paymentAdjustment == null ? null : this.paymentAdjustment.copy();
        dst.paymentAdjustmentReason = this.paymentAdjustmentReason == null ? null : this.paymentAdjustmentReason.copy();
        dst.paymentDate = this.paymentDate == null ? null : this.paymentDate.copy();
        dst.paymentAmount = this.paymentAmount == null ? null : this.paymentAmount.copy();
        dst.paymentRef = this.paymentRef == null ? null : this.paymentRef.copy();
        dst.reserved = this.reserved == null ? null : this.reserved.copy();
        Coding coding = dst.form = this.form == null ? null : this.form.copy();
        if (this.note != null) {
            dst.note = new ArrayList<NotesComponent>();
            for (NotesComponent notesComponent : this.note) {
                dst.note.add(notesComponent.copy());
            }
        }
        if (this.benefitBalance != null) {
            dst.benefitBalance = new ArrayList<BenefitBalanceComponent>();
            for (BenefitBalanceComponent benefitBalanceComponent : this.benefitBalance) {
                dst.benefitBalance.add(benefitBalanceComponent.copy());
            }
        }
        return dst;
    }

    protected ExplanationOfBenefit typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof ExplanationOfBenefit)) {
            return false;
        }
        ExplanationOfBenefit o = (ExplanationOfBenefit)other;
        return ExplanationOfBenefit.compareDeep(this.identifier, o.identifier, true) && ExplanationOfBenefit.compareDeep(this.claim, o.claim, true) && ExplanationOfBenefit.compareDeep(this.claimResponse, o.claimResponse, true) && ExplanationOfBenefit.compareDeep(this.subType, o.subType, true) && ExplanationOfBenefit.compareDeep(this.ruleset, o.ruleset, true) && ExplanationOfBenefit.compareDeep(this.originalRuleset, o.originalRuleset, true) && ExplanationOfBenefit.compareDeep(this.created, o.created, true) && ExplanationOfBenefit.compareDeep(this.billablePeriod, o.billablePeriod, true) && ExplanationOfBenefit.compareDeep(this.disposition, o.disposition, true) && ExplanationOfBenefit.compareDeep(this.provider, o.provider, true) && ExplanationOfBenefit.compareDeep(this.organization, o.organization, true) && ExplanationOfBenefit.compareDeep(this.facility, o.facility, true) && ExplanationOfBenefit.compareDeep(this.related, o.related, true) && ExplanationOfBenefit.compareDeep(this.prescription, o.prescription, true) && ExplanationOfBenefit.compareDeep(this.originalPrescription, o.originalPrescription, true) && ExplanationOfBenefit.compareDeep(this.payee, o.payee, true) && ExplanationOfBenefit.compareDeep(this.referral, o.referral, true) && ExplanationOfBenefit.compareDeep(this.occurrenceCode, o.occurrenceCode, true) && ExplanationOfBenefit.compareDeep(this.occurenceSpanCode, o.occurenceSpanCode, true) && ExplanationOfBenefit.compareDeep(this.valueCode, o.valueCode, true) && ExplanationOfBenefit.compareDeep(this.diagnosis, o.diagnosis, true) && ExplanationOfBenefit.compareDeep(this.procedure, o.procedure, true) && ExplanationOfBenefit.compareDeep(this.specialCondition, o.specialCondition, true) && ExplanationOfBenefit.compareDeep(this.patient, o.patient, true) && ExplanationOfBenefit.compareDeep(this.precedence, o.precedence, true) && ExplanationOfBenefit.compareDeep(this.coverage, o.coverage, true) && ExplanationOfBenefit.compareDeep(this.accidentDate, o.accidentDate, true) && ExplanationOfBenefit.compareDeep(this.accidentType, o.accidentType, true) && ExplanationOfBenefit.compareDeep(this.accidentLocation, o.accidentLocation, true) && ExplanationOfBenefit.compareDeep(this.interventionException, o.interventionException, true) && ExplanationOfBenefit.compareDeep(this.onset, o.onset, true) && ExplanationOfBenefit.compareDeep(this.employmentImpacted, o.employmentImpacted, true) && ExplanationOfBenefit.compareDeep(this.hospitalization, o.hospitalization, true) && ExplanationOfBenefit.compareDeep(this.item, o.item, true) && ExplanationOfBenefit.compareDeep(this.addItem, o.addItem, true) && ExplanationOfBenefit.compareDeep(this.missingTeeth, o.missingTeeth, true) && ExplanationOfBenefit.compareDeep(this.totalCost, o.totalCost, true) && ExplanationOfBenefit.compareDeep(this.unallocDeductable, o.unallocDeductable, true) && ExplanationOfBenefit.compareDeep(this.totalBenefit, o.totalBenefit, true) && ExplanationOfBenefit.compareDeep(this.paymentAdjustment, o.paymentAdjustment, true) && ExplanationOfBenefit.compareDeep(this.paymentAdjustmentReason, o.paymentAdjustmentReason, true) && ExplanationOfBenefit.compareDeep(this.paymentDate, o.paymentDate, true) && ExplanationOfBenefit.compareDeep(this.paymentAmount, o.paymentAmount, true) && ExplanationOfBenefit.compareDeep(this.paymentRef, o.paymentRef, true) && ExplanationOfBenefit.compareDeep(this.reserved, o.reserved, true) && ExplanationOfBenefit.compareDeep(this.form, o.form, true) && ExplanationOfBenefit.compareDeep(this.note, o.note, true) && ExplanationOfBenefit.compareDeep(this.benefitBalance, o.benefitBalance, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof ExplanationOfBenefit)) {
            return false;
        }
        ExplanationOfBenefit o = (ExplanationOfBenefit)other;
        return ExplanationOfBenefit.compareValues(this.created, o.created, true) && ExplanationOfBenefit.compareValues(this.disposition, o.disposition, true) && ExplanationOfBenefit.compareValues(this.precedence, o.precedence, true) && ExplanationOfBenefit.compareValues(this.accidentDate, o.accidentDate, true) && ExplanationOfBenefit.compareValues(this.paymentDate, o.paymentDate, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.claim != null && !this.claim.isEmpty() || this.claimResponse != null && !this.claimResponse.isEmpty() || this.subType != null && !this.subType.isEmpty() || this.ruleset != null && !this.ruleset.isEmpty() || this.originalRuleset != null && !this.originalRuleset.isEmpty() || this.created != null && !this.created.isEmpty() || this.billablePeriod != null && !this.billablePeriod.isEmpty() || this.disposition != null && !this.disposition.isEmpty() || this.provider != null && !this.provider.isEmpty() || this.organization != null && !this.organization.isEmpty() || this.facility != null && !this.facility.isEmpty() || this.related != null && !this.related.isEmpty() || this.prescription != null && !this.prescription.isEmpty() || this.originalPrescription != null && !this.originalPrescription.isEmpty() || this.payee != null && !this.payee.isEmpty() || this.referral != null && !this.referral.isEmpty() || this.occurrenceCode != null && !this.occurrenceCode.isEmpty() || this.occurenceSpanCode != null && !this.occurenceSpanCode.isEmpty() || this.valueCode != null && !this.valueCode.isEmpty() || this.diagnosis != null && !this.diagnosis.isEmpty() || this.procedure != null && !this.procedure.isEmpty() || this.specialCondition != null && !this.specialCondition.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.precedence != null && !this.precedence.isEmpty() || this.coverage != null && !this.coverage.isEmpty() || this.accidentDate != null && !this.accidentDate.isEmpty() || this.accidentType != null && !this.accidentType.isEmpty() || this.accidentLocation != null && !this.accidentLocation.isEmpty() || this.interventionException != null && !this.interventionException.isEmpty() || this.onset != null && !this.onset.isEmpty() || this.employmentImpacted != null && !this.employmentImpacted.isEmpty() || this.hospitalization != null && !this.hospitalization.isEmpty() || this.item != null && !this.item.isEmpty() || this.addItem != null && !this.addItem.isEmpty() || this.missingTeeth != null && !this.missingTeeth.isEmpty() || this.totalCost != null && !this.totalCost.isEmpty() || this.unallocDeductable != null && !this.unallocDeductable.isEmpty() || this.totalBenefit != null && !this.totalBenefit.isEmpty() || this.paymentAdjustment != null && !this.paymentAdjustment.isEmpty() || this.paymentAdjustmentReason != null && !this.paymentAdjustmentReason.isEmpty() || this.paymentDate != null && !this.paymentDate.isEmpty() || this.paymentAmount != null && !this.paymentAmount.isEmpty() || this.paymentRef != null && !this.paymentRef.isEmpty() || this.reserved != null && !this.reserved.isEmpty() || this.form != null && !this.form.isEmpty() || this.note != null && !this.note.isEmpty() || this.benefitBalance != null && !this.benefitBalance.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ExplanationOfBenefit;
    }

    @Block
    public static class BenefitComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Deductable, visits, benefit amount", formalDefinition="Deductable, visits, benefit amount.")
        protected Coding type;
        @Child(name="benefit", type={UnsignedIntType.class, Money.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Benefits allowed", formalDefinition="Benefits allowed.")
        protected Type benefit;
        @Child(name="benefitUsed", type={UnsignedIntType.class, Money.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Benefits used", formalDefinition="Benefits used.")
        protected Type benefitUsed;
        private static final long serialVersionUID = 1742418909L;

        public BenefitComponent() {
        }

        public BenefitComponent(Coding type) {
            this.type = type;
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public BenefitComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public Type getBenefit() {
            return this.benefit;
        }

        public UnsignedIntType getBenefitUnsignedIntType() throws FHIRException {
            if (!(this.benefit instanceof UnsignedIntType)) {
                throw new FHIRException("Type mismatch: the type UnsignedIntType was expected, but " + this.benefit.getClass().getName() + " was encountered");
            }
            return (UnsignedIntType)this.benefit;
        }

        public boolean hasBenefitUnsignedIntType() {
            return this.benefit instanceof UnsignedIntType;
        }

        public Money getBenefitMoney() throws FHIRException {
            if (!(this.benefit instanceof Money)) {
                throw new FHIRException("Type mismatch: the type Money was expected, but " + this.benefit.getClass().getName() + " was encountered");
            }
            return (Money)this.benefit;
        }

        public boolean hasBenefitMoney() {
            return this.benefit instanceof Money;
        }

        public boolean hasBenefit() {
            return this.benefit != null && !this.benefit.isEmpty();
        }

        public BenefitComponent setBenefit(Type value) {
            this.benefit = value;
            return this;
        }

        public Type getBenefitUsed() {
            return this.benefitUsed;
        }

        public UnsignedIntType getBenefitUsedUnsignedIntType() throws FHIRException {
            if (!(this.benefitUsed instanceof UnsignedIntType)) {
                throw new FHIRException("Type mismatch: the type UnsignedIntType was expected, but " + this.benefitUsed.getClass().getName() + " was encountered");
            }
            return (UnsignedIntType)this.benefitUsed;
        }

        public boolean hasBenefitUsedUnsignedIntType() {
            return this.benefitUsed instanceof UnsignedIntType;
        }

        public Money getBenefitUsedMoney() throws FHIRException {
            if (!(this.benefitUsed instanceof Money)) {
                throw new FHIRException("Type mismatch: the type Money was expected, but " + this.benefitUsed.getClass().getName() + " was encountered");
            }
            return (Money)this.benefitUsed;
        }

        public boolean hasBenefitUsedMoney() {
            return this.benefitUsed instanceof Money;
        }

        public boolean hasBenefitUsed() {
            return this.benefitUsed != null && !this.benefitUsed.isEmpty();
        }

        public BenefitComponent setBenefitUsed(Type value) {
            this.benefitUsed = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "Coding", "Deductable, visits, benefit amount.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("benefit[x]", "unsignedInt|Money", "Benefits allowed.", 0, Integer.MAX_VALUE, this.benefit));
            childrenList.add(new Property("benefitUsed[x]", "unsignedInt|Money", "Benefits used.", 0, Integer.MAX_VALUE, this.benefitUsed));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -222710633: {
                    Base[] baseArray;
                    if (this.benefit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.benefit;
                    }
                    return baseArray;
                }
                case -549981964: {
                    Base[] baseArray;
                    if (this.benefitUsed == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.benefitUsed;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCoding(value);
                    break;
                }
                case -222710633: {
                    this.benefit = (Type)value;
                    break;
                }
                case -549981964: {
                    this.benefitUsed = (Type)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals("benefit[x]")) {
                this.benefit = (Type)value;
            } else if (name.equals("benefitUsed[x]")) {
                this.benefitUsed = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 952095881: {
                    return this.getBenefit();
                }
                case 787635980: {
                    return this.getBenefitUsed();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("benefitUnsignedInt")) {
                this.benefit = new UnsignedIntType();
                return this.benefit;
            }
            if (name.equals("benefitMoney")) {
                this.benefit = new Money();
                return this.benefit;
            }
            if (name.equals("benefitUsedUnsignedInt")) {
                this.benefitUsed = new UnsignedIntType();
                return this.benefitUsed;
            }
            if (name.equals("benefitUsedMoney")) {
                this.benefitUsed = new Money();
                return this.benefitUsed;
            }
            return super.addChild(name);
        }

        @Override
        public BenefitComponent copy() {
            BenefitComponent dst = new BenefitComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.benefit = this.benefit == null ? null : this.benefit.copy();
            dst.benefitUsed = this.benefitUsed == null ? null : this.benefitUsed.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof BenefitComponent)) {
                return false;
            }
            BenefitComponent o = (BenefitComponent)other;
            return BenefitComponent.compareDeep(this.type, o.type, true) && BenefitComponent.compareDeep(this.benefit, o.benefit, true) && BenefitComponent.compareDeep(this.benefitUsed, o.benefitUsed, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof BenefitComponent)) {
                return false;
            }
            BenefitComponent o = (BenefitComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.benefit != null && !this.benefit.isEmpty() || this.benefitUsed != null && !this.benefitUsed.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.benefitBalance.financial";
        }
    }

    @Block
    public static class BenefitBalanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Benefit Category", formalDefinition="Dental, Vision, Medical, Pharmacy, Rehab etc.")
        protected Coding category;
        @Child(name="subCategory", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Benefit SubCategory", formalDefinition="Dental: basic, major, ortho; Vision exam, glasses, contacts; etc.")
        protected Coding subCategory;
        @Child(name="network", type={Coding.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="In or out of network", formalDefinition="Network designation.")
        protected Coding network;
        @Child(name="unit", type={Coding.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Individual or family", formalDefinition="Unit designation: individual or family.")
        protected Coding unit;
        @Child(name="term", type={Coding.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Annual or lifetime", formalDefinition="The term or period of the values such as 'maximum lifetime benefit' or 'maximum annual vistis'.")
        protected Coding term;
        @Child(name="financial", type={}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Benefit Summary", formalDefinition="Benefits Used to date.")
        protected List<BenefitComponent> financial;
        private static final long serialVersionUID = 1708176773L;

        public BenefitBalanceComponent() {
        }

        public BenefitBalanceComponent(Coding category) {
            this.category = category;
        }

        public Coding getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitBalanceComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new Coding();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public BenefitBalanceComponent setCategory(Coding value) {
            this.category = value;
            return this;
        }

        public Coding getSubCategory() {
            if (this.subCategory == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitBalanceComponent.subCategory");
                }
                if (Configuration.doAutoCreate()) {
                    this.subCategory = new Coding();
                }
            }
            return this.subCategory;
        }

        public boolean hasSubCategory() {
            return this.subCategory != null && !this.subCategory.isEmpty();
        }

        public BenefitBalanceComponent setSubCategory(Coding value) {
            this.subCategory = value;
            return this;
        }

        public Coding getNetwork() {
            if (this.network == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitBalanceComponent.network");
                }
                if (Configuration.doAutoCreate()) {
                    this.network = new Coding();
                }
            }
            return this.network;
        }

        public boolean hasNetwork() {
            return this.network != null && !this.network.isEmpty();
        }

        public BenefitBalanceComponent setNetwork(Coding value) {
            this.network = value;
            return this;
        }

        public Coding getUnit() {
            if (this.unit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitBalanceComponent.unit");
                }
                if (Configuration.doAutoCreate()) {
                    this.unit = new Coding();
                }
            }
            return this.unit;
        }

        public boolean hasUnit() {
            return this.unit != null && !this.unit.isEmpty();
        }

        public BenefitBalanceComponent setUnit(Coding value) {
            this.unit = value;
            return this;
        }

        public Coding getTerm() {
            if (this.term == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitBalanceComponent.term");
                }
                if (Configuration.doAutoCreate()) {
                    this.term = new Coding();
                }
            }
            return this.term;
        }

        public boolean hasTerm() {
            return this.term != null && !this.term.isEmpty();
        }

        public BenefitBalanceComponent setTerm(Coding value) {
            this.term = value;
            return this;
        }

        public List<BenefitComponent> getFinancial() {
            if (this.financial == null) {
                this.financial = new ArrayList<BenefitComponent>();
            }
            return this.financial;
        }

        public boolean hasFinancial() {
            if (this.financial == null) {
                return false;
            }
            for (BenefitComponent item : this.financial) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public BenefitComponent addFinancial() {
            BenefitComponent t = new BenefitComponent();
            if (this.financial == null) {
                this.financial = new ArrayList<BenefitComponent>();
            }
            this.financial.add(t);
            return t;
        }

        public BenefitBalanceComponent addFinancial(BenefitComponent t) {
            if (t == null) {
                return this;
            }
            if (this.financial == null) {
                this.financial = new ArrayList<BenefitComponent>();
            }
            this.financial.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("category", "Coding", "Dental, Vision, Medical, Pharmacy, Rehab etc.", 0, Integer.MAX_VALUE, this.category));
            childrenList.add(new Property("subCategory", "Coding", "Dental: basic, major, ortho; Vision exam, glasses, contacts; etc.", 0, Integer.MAX_VALUE, this.subCategory));
            childrenList.add(new Property("network", "Coding", "Network designation.", 0, Integer.MAX_VALUE, this.network));
            childrenList.add(new Property("unit", "Coding", "Unit designation: individual or family.", 0, Integer.MAX_VALUE, this.unit));
            childrenList.add(new Property("term", "Coding", "The term or period of the values such as 'maximum lifetime benefit' or 'maximum annual vistis'.", 0, Integer.MAX_VALUE, this.term));
            childrenList.add(new Property("financial", "", "Benefits Used to date.", 0, Integer.MAX_VALUE, this.financial));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case 1365024606: {
                    Base[] baseArray;
                    if (this.subCategory == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.subCategory;
                    }
                    return baseArray;
                }
                case 1843485230: {
                    Base[] baseArray;
                    if (this.network == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.network;
                    }
                    return baseArray;
                }
                case 3594628: {
                    Base[] baseArray;
                    if (this.unit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.unit;
                    }
                    return baseArray;
                }
                case 3556460: {
                    Base[] baseArray;
                    if (this.term == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.term;
                    }
                    return baseArray;
                }
                case 357555337: {
                    return this.financial == null ? new Base[]{} : this.financial.toArray(new Base[this.financial.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = this.castToCoding(value);
                    break;
                }
                case 1365024606: {
                    this.subCategory = this.castToCoding(value);
                    break;
                }
                case 1843485230: {
                    this.network = this.castToCoding(value);
                    break;
                }
                case 3594628: {
                    this.unit = this.castToCoding(value);
                    break;
                }
                case 3556460: {
                    this.term = this.castToCoding(value);
                    break;
                }
                case 357555337: {
                    this.getFinancial().add((BenefitComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = this.castToCoding(value);
            } else if (name.equals("subCategory")) {
                this.subCategory = this.castToCoding(value);
            } else if (name.equals("network")) {
                this.network = this.castToCoding(value);
            } else if (name.equals("unit")) {
                this.unit = this.castToCoding(value);
            } else if (name.equals("term")) {
                this.term = this.castToCoding(value);
            } else if (name.equals("financial")) {
                this.getFinancial().add((BenefitComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case 1365024606: {
                    return this.getSubCategory();
                }
                case 1843485230: {
                    return this.getNetwork();
                }
                case 3594628: {
                    return this.getUnit();
                }
                case 3556460: {
                    return this.getTerm();
                }
                case 357555337: {
                    return this.addFinancial();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new Coding();
                return this.category;
            }
            if (name.equals("subCategory")) {
                this.subCategory = new Coding();
                return this.subCategory;
            }
            if (name.equals("network")) {
                this.network = new Coding();
                return this.network;
            }
            if (name.equals("unit")) {
                this.unit = new Coding();
                return this.unit;
            }
            if (name.equals("term")) {
                this.term = new Coding();
                return this.term;
            }
            if (name.equals("financial")) {
                return this.addFinancial();
            }
            return super.addChild(name);
        }

        @Override
        public BenefitBalanceComponent copy() {
            BenefitBalanceComponent dst = new BenefitBalanceComponent();
            this.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.subCategory = this.subCategory == null ? null : this.subCategory.copy();
            dst.network = this.network == null ? null : this.network.copy();
            dst.unit = this.unit == null ? null : this.unit.copy();
            Coding coding = dst.term = this.term == null ? null : this.term.copy();
            if (this.financial != null) {
                dst.financial = new ArrayList<BenefitComponent>();
                for (BenefitComponent i : this.financial) {
                    dst.financial.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof BenefitBalanceComponent)) {
                return false;
            }
            BenefitBalanceComponent o = (BenefitBalanceComponent)other;
            return BenefitBalanceComponent.compareDeep(this.category, o.category, true) && BenefitBalanceComponent.compareDeep(this.subCategory, o.subCategory, true) && BenefitBalanceComponent.compareDeep(this.network, o.network, true) && BenefitBalanceComponent.compareDeep(this.unit, o.unit, true) && BenefitBalanceComponent.compareDeep(this.term, o.term, true) && BenefitBalanceComponent.compareDeep(this.financial, o.financial, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof BenefitBalanceComponent)) {
                return false;
            }
            BenefitBalanceComponent o = (BenefitBalanceComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.category != null && !this.category.isEmpty() || this.subCategory != null && !this.subCategory.isEmpty() || this.network != null && !this.network.isEmpty() || this.unit != null && !this.unit.isEmpty() || this.term != null && !this.term.isEmpty() || this.financial != null && !this.financial.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.benefitBalance";
        }
    }

    @Block
    public static class NotesComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="number", type={PositiveIntType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Note Number for this note", formalDefinition="An integer associated with each note which may be referred to from each service line item.")
        protected PositiveIntType number;
        @Child(name="type", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="display | print | printoper", formalDefinition="The note purpose: Print/Display.")
        protected Coding type;
        @Child(name="text", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Note explanitory text", formalDefinition="The note text.")
        protected StringType text;
        private static final long serialVersionUID = 1768923951L;

        public PositiveIntType getNumberElement() {
            if (this.number == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NotesComponent.number");
                }
                if (Configuration.doAutoCreate()) {
                    this.number = new PositiveIntType();
                }
            }
            return this.number;
        }

        public boolean hasNumberElement() {
            return this.number != null && !this.number.isEmpty();
        }

        public boolean hasNumber() {
            return this.number != null && !this.number.isEmpty();
        }

        public NotesComponent setNumberElement(PositiveIntType value) {
            this.number = value;
            return this;
        }

        public int getNumber() {
            return this.number == null || this.number.isEmpty() ? 0 : (Integer)this.number.getValue();
        }

        public NotesComponent setNumber(int value) {
            if (this.number == null) {
                this.number = new PositiveIntType();
            }
            this.number.setValue((Object)value);
            return this;
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NotesComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public NotesComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NotesComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public NotesComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public NotesComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("number", "positiveInt", "An integer associated with each note which may be referred to from each service line item.", 0, Integer.MAX_VALUE, this.number));
            childrenList.add(new Property("type", "Coding", "The note purpose: Print/Display.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("text", "string", "The note text.", 0, Integer.MAX_VALUE, this.text));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    Base[] baseArray;
                    if (this.number == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.number;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.text;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    this.number = this.castToPositiveInt(value);
                    break;
                }
                case 3575610: {
                    this.type = this.castToCoding(value);
                    break;
                }
                case 3556653: {
                    this.text = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("number")) {
                this.number = this.castToPositiveInt(value);
            } else if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals("text")) {
                this.text = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    throw new FHIRException("Cannot make property number as it is not a complex type");
                }
                case 3575610: {
                    return this.getType();
                }
                case 3556653: {
                    throw new FHIRException("Cannot make property text as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("number")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.number");
            }
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.text");
            }
            return super.addChild(name);
        }

        @Override
        public NotesComponent copy() {
            NotesComponent dst = new NotesComponent();
            this.copyValues(dst);
            dst.number = this.number == null ? null : this.number.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.text = this.text == null ? null : this.text.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof NotesComponent)) {
                return false;
            }
            NotesComponent o = (NotesComponent)other;
            return NotesComponent.compareDeep(this.number, o.number, true) && NotesComponent.compareDeep(this.type, o.type, true) && NotesComponent.compareDeep(this.text, o.text, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof NotesComponent)) {
                return false;
            }
            NotesComponent o = (NotesComponent)other;
            return NotesComponent.compareValues(this.number, o.number, true) && NotesComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.number != null && !this.number.isEmpty() || this.type != null && !this.type.isEmpty() || this.text != null && !this.text.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.note";
        }
    }

    @Block
    public static class MissingTeethComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="tooth", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Tooth Code", formalDefinition="The code identifying which tooth is missing.")
        protected Coding tooth;
        @Child(name="reason", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reason for missing", formalDefinition="Missing reason may be: E-extraction, O-other.")
        protected Coding reason;
        @Child(name="extractionDate", type={DateType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Date of Extraction", formalDefinition="The date of the extraction either known from records or patient reported estimate.")
        protected DateType extractionDate;
        private static final long serialVersionUID = 352913313L;

        public MissingTeethComponent() {
        }

        public MissingTeethComponent(Coding tooth) {
            this.tooth = tooth;
        }

        public Coding getTooth() {
            if (this.tooth == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MissingTeethComponent.tooth");
                }
                if (Configuration.doAutoCreate()) {
                    this.tooth = new Coding();
                }
            }
            return this.tooth;
        }

        public boolean hasTooth() {
            return this.tooth != null && !this.tooth.isEmpty();
        }

        public MissingTeethComponent setTooth(Coding value) {
            this.tooth = value;
            return this;
        }

        public Coding getReason() {
            if (this.reason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MissingTeethComponent.reason");
                }
                if (Configuration.doAutoCreate()) {
                    this.reason = new Coding();
                }
            }
            return this.reason;
        }

        public boolean hasReason() {
            return this.reason != null && !this.reason.isEmpty();
        }

        public MissingTeethComponent setReason(Coding value) {
            this.reason = value;
            return this;
        }

        public DateType getExtractionDateElement() {
            if (this.extractionDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MissingTeethComponent.extractionDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.extractionDate = new DateType();
                }
            }
            return this.extractionDate;
        }

        public boolean hasExtractionDateElement() {
            return this.extractionDate != null && !this.extractionDate.isEmpty();
        }

        public boolean hasExtractionDate() {
            return this.extractionDate != null && !this.extractionDate.isEmpty();
        }

        public MissingTeethComponent setExtractionDateElement(DateType value) {
            this.extractionDate = value;
            return this;
        }

        public Date getExtractionDate() {
            return this.extractionDate == null ? null : (Date)this.extractionDate.getValue();
        }

        public MissingTeethComponent setExtractionDate(Date value) {
            if (value == null) {
                this.extractionDate = null;
            } else {
                if (this.extractionDate == null) {
                    this.extractionDate = new DateType();
                }
                this.extractionDate.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("tooth", "Coding", "The code identifying which tooth is missing.", 0, Integer.MAX_VALUE, this.tooth));
            childrenList.add(new Property("reason", "Coding", "Missing reason may be: E-extraction, O-other.", 0, Integer.MAX_VALUE, this.reason));
            childrenList.add(new Property("extractionDate", "date", "The date of the extraction either known from records or patient reported estimate.", 0, Integer.MAX_VALUE, this.extractionDate));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 110545608: {
                    Base[] baseArray;
                    if (this.tooth == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.tooth;
                    }
                    return baseArray;
                }
                case -934964668: {
                    Base[] baseArray;
                    if (this.reason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reason;
                    }
                    return baseArray;
                }
                case 580646965: {
                    Base[] baseArray;
                    if (this.extractionDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.extractionDate;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 110545608: {
                    this.tooth = this.castToCoding(value);
                    break;
                }
                case -934964668: {
                    this.reason = this.castToCoding(value);
                    break;
                }
                case 580646965: {
                    this.extractionDate = this.castToDate(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("tooth")) {
                this.tooth = this.castToCoding(value);
            } else if (name.equals("reason")) {
                this.reason = this.castToCoding(value);
            } else if (name.equals("extractionDate")) {
                this.extractionDate = this.castToDate(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110545608: {
                    return this.getTooth();
                }
                case -934964668: {
                    return this.getReason();
                }
                case 580646965: {
                    throw new FHIRException("Cannot make property extractionDate as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("tooth")) {
                this.tooth = new Coding();
                return this.tooth;
            }
            if (name.equals("reason")) {
                this.reason = new Coding();
                return this.reason;
            }
            if (name.equals("extractionDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.extractionDate");
            }
            return super.addChild(name);
        }

        @Override
        public MissingTeethComponent copy() {
            MissingTeethComponent dst = new MissingTeethComponent();
            this.copyValues(dst);
            dst.tooth = this.tooth == null ? null : this.tooth.copy();
            dst.reason = this.reason == null ? null : this.reason.copy();
            dst.extractionDate = this.extractionDate == null ? null : this.extractionDate.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MissingTeethComponent)) {
                return false;
            }
            MissingTeethComponent o = (MissingTeethComponent)other;
            return MissingTeethComponent.compareDeep(this.tooth, o.tooth, true) && MissingTeethComponent.compareDeep(this.reason, o.reason, true) && MissingTeethComponent.compareDeep(this.extractionDate, o.extractionDate, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MissingTeethComponent)) {
                return false;
            }
            MissingTeethComponent o = (MissingTeethComponent)other;
            return MissingTeethComponent.compareValues(this.extractionDate, o.extractionDate, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.tooth != null && !this.tooth.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.extractionDate != null && !this.extractionDate.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.missingTeeth";
        }
    }

    @Block
    public static class AddedItemDetailAdjudicationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Adjudication category such as co-pay, eligible, benefit, etc.", formalDefinition="Code indicating: Co-Pay, deductable, elegible, benefit, tax, etc.")
        protected Coding category;
        @Child(name="reason", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Adjudication reason", formalDefinition="Adjudication reason such as limit reached.")
        protected Coding reason;
        @Child(name="amount", type={Money.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Monetary amount", formalDefinition="Monitory amount associated with the code.")
        protected Money amount;
        @Child(name="value", type={DecimalType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Non-monitory value", formalDefinition="A non-monetary value for example a percentage. Mutually exclusive to the amount element above.")
        protected DecimalType value;
        private static final long serialVersionUID = -1926987562L;

        public AddedItemDetailAdjudicationComponent() {
        }

        public AddedItemDetailAdjudicationComponent(Coding category) {
            this.category = category;
        }

        public Coding getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailAdjudicationComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new Coding();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public AddedItemDetailAdjudicationComponent setCategory(Coding value) {
            this.category = value;
            return this;
        }

        public Coding getReason() {
            if (this.reason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailAdjudicationComponent.reason");
                }
                if (Configuration.doAutoCreate()) {
                    this.reason = new Coding();
                }
            }
            return this.reason;
        }

        public boolean hasReason() {
            return this.reason != null && !this.reason.isEmpty();
        }

        public AddedItemDetailAdjudicationComponent setReason(Coding value) {
            this.reason = value;
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailAdjudicationComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public AddedItemDetailAdjudicationComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        public DecimalType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailAdjudicationComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new DecimalType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public AddedItemDetailAdjudicationComponent setValueElement(DecimalType value) {
            this.value = value;
            return this;
        }

        public BigDecimal getValue() {
            return this.value == null ? null : (BigDecimal)this.value.getValue();
        }

        public AddedItemDetailAdjudicationComponent setValue(BigDecimal value) {
            if (value == null) {
                this.value = null;
            } else {
                if (this.value == null) {
                    this.value = new DecimalType();
                }
                this.value.setValue(value);
            }
            return this;
        }

        public AddedItemDetailAdjudicationComponent setValue(long value) {
            this.value = new DecimalType();
            this.value.setValue(value);
            return this;
        }

        public AddedItemDetailAdjudicationComponent setValue(double value) {
            this.value = new DecimalType();
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("category", "Coding", "Code indicating: Co-Pay, deductable, elegible, benefit, tax, etc.", 0, Integer.MAX_VALUE, this.category));
            childrenList.add(new Property("reason", "Coding", "Adjudication reason such as limit reached.", 0, Integer.MAX_VALUE, this.reason));
            childrenList.add(new Property("amount", "Money", "Monitory amount associated with the code.", 0, Integer.MAX_VALUE, this.amount));
            childrenList.add(new Property("value", "decimal", "A non-monetary value for example a percentage. Mutually exclusive to the amount element above.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case -934964668: {
                    Base[] baseArray;
                    if (this.reason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reason;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.amount;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = this.castToCoding(value);
                    break;
                }
                case -934964668: {
                    this.reason = this.castToCoding(value);
                    break;
                }
                case -1413853096: {
                    this.amount = this.castToMoney(value);
                    break;
                }
                case 111972721: {
                    this.value = this.castToDecimal(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = this.castToCoding(value);
            } else if (name.equals("reason")) {
                this.reason = this.castToCoding(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToMoney(value);
            } else if (name.equals("value")) {
                this.value = this.castToDecimal(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case -934964668: {
                    return this.getReason();
                }
                case -1413853096: {
                    return this.getAmount();
                }
                case 111972721: {
                    throw new FHIRException("Cannot make property value as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new Coding();
                return this.category;
            }
            if (name.equals("reason")) {
                this.reason = new Coding();
                return this.reason;
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.value");
            }
            return super.addChild(name);
        }

        @Override
        public AddedItemDetailAdjudicationComponent copy() {
            AddedItemDetailAdjudicationComponent dst = new AddedItemDetailAdjudicationComponent();
            this.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.reason = this.reason == null ? null : this.reason.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof AddedItemDetailAdjudicationComponent)) {
                return false;
            }
            AddedItemDetailAdjudicationComponent o = (AddedItemDetailAdjudicationComponent)other;
            return AddedItemDetailAdjudicationComponent.compareDeep(this.category, o.category, true) && AddedItemDetailAdjudicationComponent.compareDeep(this.reason, o.reason, true) && AddedItemDetailAdjudicationComponent.compareDeep(this.amount, o.amount, true) && AddedItemDetailAdjudicationComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof AddedItemDetailAdjudicationComponent)) {
                return false;
            }
            AddedItemDetailAdjudicationComponent o = (AddedItemDetailAdjudicationComponent)other;
            return AddedItemDetailAdjudicationComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.category != null && !this.category.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.amount != null && !this.amount.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.addItem.detail.adjudication";
        }
    }

    @Block
    public static class AddedItemsDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="service", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Service or Product", formalDefinition="A code to indicate the Professional Service or Product supplied.")
        protected Coding service;
        @Child(name="fee", type={Money.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Professional fee or Product charge", formalDefinition="The fee charged for the professional service or product..")
        protected Money fee;
        @Child(name="adjudication", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Added items detail adjudication", formalDefinition="The adjudications results.")
        protected List<AddedItemDetailAdjudicationComponent> adjudication;
        private static final long serialVersionUID = -2104242020L;

        public AddedItemsDetailComponent() {
        }

        public AddedItemsDetailComponent(Coding service) {
            this.service = service;
        }

        public Coding getService() {
            if (this.service == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemsDetailComponent.service");
                }
                if (Configuration.doAutoCreate()) {
                    this.service = new Coding();
                }
            }
            return this.service;
        }

        public boolean hasService() {
            return this.service != null && !this.service.isEmpty();
        }

        public AddedItemsDetailComponent setService(Coding value) {
            this.service = value;
            return this;
        }

        public Money getFee() {
            if (this.fee == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemsDetailComponent.fee");
                }
                if (Configuration.doAutoCreate()) {
                    this.fee = new Money();
                }
            }
            return this.fee;
        }

        public boolean hasFee() {
            return this.fee != null && !this.fee.isEmpty();
        }

        public AddedItemsDetailComponent setFee(Money value) {
            this.fee = value;
            return this;
        }

        public List<AddedItemDetailAdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AddedItemDetailAdjudicationComponent>();
            }
            return this.adjudication;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AddedItemDetailAdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AddedItemDetailAdjudicationComponent addAdjudication() {
            AddedItemDetailAdjudicationComponent t = new AddedItemDetailAdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AddedItemDetailAdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public AddedItemsDetailComponent addAdjudication(AddedItemDetailAdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AddedItemDetailAdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("service", "Coding", "A code to indicate the Professional Service or Product supplied.", 0, Integer.MAX_VALUE, this.service));
            childrenList.add(new Property("fee", "Money", "The fee charged for the professional service or product..", 0, Integer.MAX_VALUE, this.fee));
            childrenList.add(new Property("adjudication", "", "The adjudications results.", 0, Integer.MAX_VALUE, this.adjudication));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1984153269: {
                    Base[] baseArray;
                    if (this.service == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.service;
                    }
                    return baseArray;
                }
                case 101254: {
                    Base[] baseArray;
                    if (this.fee == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.fee;
                    }
                    return baseArray;
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1984153269: {
                    this.service = this.castToCoding(value);
                    break;
                }
                case 101254: {
                    this.fee = this.castToMoney(value);
                    break;
                }
                case -231349275: {
                    this.getAdjudication().add((AddedItemDetailAdjudicationComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("service")) {
                this.service = this.castToCoding(value);
            } else if (name.equals("fee")) {
                this.fee = this.castToMoney(value);
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AddedItemDetailAdjudicationComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1984153269: {
                    return this.getService();
                }
                case 101254: {
                    return this.getFee();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("service")) {
                this.service = new Coding();
                return this.service;
            }
            if (name.equals("fee")) {
                this.fee = new Money();
                return this.fee;
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            return super.addChild(name);
        }

        @Override
        public AddedItemsDetailComponent copy() {
            AddedItemsDetailComponent dst = new AddedItemsDetailComponent();
            this.copyValues(dst);
            dst.service = this.service == null ? null : this.service.copy();
            Money money = dst.fee = this.fee == null ? null : this.fee.copy();
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AddedItemDetailAdjudicationComponent>();
                for (AddedItemDetailAdjudicationComponent i : this.adjudication) {
                    dst.adjudication.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof AddedItemsDetailComponent)) {
                return false;
            }
            AddedItemsDetailComponent o = (AddedItemsDetailComponent)other;
            return AddedItemsDetailComponent.compareDeep(this.service, o.service, true) && AddedItemsDetailComponent.compareDeep(this.fee, o.fee, true) && AddedItemsDetailComponent.compareDeep(this.adjudication, o.adjudication, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof AddedItemsDetailComponent)) {
                return false;
            }
            AddedItemsDetailComponent o = (AddedItemsDetailComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.service != null && !this.service.isEmpty() || this.fee != null && !this.fee.isEmpty() || this.adjudication != null && !this.adjudication.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.addItem.detail";
        }
    }

    @Block
    public static class AddedItemAdjudicationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Adjudication category such as co-pay, eligible, benefit, etc.", formalDefinition="Code indicating: Co-Pay, deductable, elegible, benefit, tax, etc.")
        protected Coding category;
        @Child(name="reason", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Adjudication reason", formalDefinition="Adjudication reason such as limit reached.")
        protected Coding reason;
        @Child(name="amount", type={Money.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Monetary amount", formalDefinition="Monitory amount associated with the code.")
        protected Money amount;
        @Child(name="value", type={DecimalType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Non-monitory value", formalDefinition="A non-monetary value for example a percentage. Mutually exclusive to the amount element above.")
        protected DecimalType value;
        private static final long serialVersionUID = -1926987562L;

        public AddedItemAdjudicationComponent() {
        }

        public AddedItemAdjudicationComponent(Coding category) {
            this.category = category;
        }

        public Coding getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemAdjudicationComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new Coding();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public AddedItemAdjudicationComponent setCategory(Coding value) {
            this.category = value;
            return this;
        }

        public Coding getReason() {
            if (this.reason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemAdjudicationComponent.reason");
                }
                if (Configuration.doAutoCreate()) {
                    this.reason = new Coding();
                }
            }
            return this.reason;
        }

        public boolean hasReason() {
            return this.reason != null && !this.reason.isEmpty();
        }

        public AddedItemAdjudicationComponent setReason(Coding value) {
            this.reason = value;
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemAdjudicationComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public AddedItemAdjudicationComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        public DecimalType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemAdjudicationComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new DecimalType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public AddedItemAdjudicationComponent setValueElement(DecimalType value) {
            this.value = value;
            return this;
        }

        public BigDecimal getValue() {
            return this.value == null ? null : (BigDecimal)this.value.getValue();
        }

        public AddedItemAdjudicationComponent setValue(BigDecimal value) {
            if (value == null) {
                this.value = null;
            } else {
                if (this.value == null) {
                    this.value = new DecimalType();
                }
                this.value.setValue(value);
            }
            return this;
        }

        public AddedItemAdjudicationComponent setValue(long value) {
            this.value = new DecimalType();
            this.value.setValue(value);
            return this;
        }

        public AddedItemAdjudicationComponent setValue(double value) {
            this.value = new DecimalType();
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("category", "Coding", "Code indicating: Co-Pay, deductable, elegible, benefit, tax, etc.", 0, Integer.MAX_VALUE, this.category));
            childrenList.add(new Property("reason", "Coding", "Adjudication reason such as limit reached.", 0, Integer.MAX_VALUE, this.reason));
            childrenList.add(new Property("amount", "Money", "Monitory amount associated with the code.", 0, Integer.MAX_VALUE, this.amount));
            childrenList.add(new Property("value", "decimal", "A non-monetary value for example a percentage. Mutually exclusive to the amount element above.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case -934964668: {
                    Base[] baseArray;
                    if (this.reason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reason;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.amount;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = this.castToCoding(value);
                    break;
                }
                case -934964668: {
                    this.reason = this.castToCoding(value);
                    break;
                }
                case -1413853096: {
                    this.amount = this.castToMoney(value);
                    break;
                }
                case 111972721: {
                    this.value = this.castToDecimal(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = this.castToCoding(value);
            } else if (name.equals("reason")) {
                this.reason = this.castToCoding(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToMoney(value);
            } else if (name.equals("value")) {
                this.value = this.castToDecimal(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case -934964668: {
                    return this.getReason();
                }
                case -1413853096: {
                    return this.getAmount();
                }
                case 111972721: {
                    throw new FHIRException("Cannot make property value as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new Coding();
                return this.category;
            }
            if (name.equals("reason")) {
                this.reason = new Coding();
                return this.reason;
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.value");
            }
            return super.addChild(name);
        }

        @Override
        public AddedItemAdjudicationComponent copy() {
            AddedItemAdjudicationComponent dst = new AddedItemAdjudicationComponent();
            this.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.reason = this.reason == null ? null : this.reason.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof AddedItemAdjudicationComponent)) {
                return false;
            }
            AddedItemAdjudicationComponent o = (AddedItemAdjudicationComponent)other;
            return AddedItemAdjudicationComponent.compareDeep(this.category, o.category, true) && AddedItemAdjudicationComponent.compareDeep(this.reason, o.reason, true) && AddedItemAdjudicationComponent.compareDeep(this.amount, o.amount, true) && AddedItemAdjudicationComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof AddedItemAdjudicationComponent)) {
                return false;
            }
            AddedItemAdjudicationComponent o = (AddedItemAdjudicationComponent)other;
            return AddedItemAdjudicationComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.category != null && !this.category.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.amount != null && !this.amount.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.addItem.adjudication";
        }
    }

    @Block
    public static class AddedItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequenceLinkId", type={PositiveIntType.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Service instances", formalDefinition="List of input service items which this service line is intended to replace.")
        protected List<PositiveIntType> sequenceLinkId;
        @Child(name="service", type={Coding.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Group, Service or Product", formalDefinition="A code to indicate the Professional Service or Product supplied.")
        protected Coding service;
        @Child(name="fee", type={Money.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Professional fee or Product charge", formalDefinition="The fee charged for the professional service or product..")
        protected Money fee;
        @Child(name="noteNumberLinkId", type={PositiveIntType.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="List of note numbers which apply", formalDefinition="A list of note references to the notes provided below.")
        protected List<PositiveIntType> noteNumberLinkId;
        @Child(name="adjudication", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Added items adjudication", formalDefinition="The adjudications results.")
        protected List<AddedItemAdjudicationComponent> adjudication;
        @Child(name="detail", type={}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Added items details", formalDefinition="The second tier service adjudications for payor added services.")
        protected List<AddedItemsDetailComponent> detail;
        private static final long serialVersionUID = -1675935854L;

        public AddedItemComponent() {
        }

        public AddedItemComponent(Coding service) {
            this.service = service;
        }

        public List<PositiveIntType> getSequenceLinkId() {
            if (this.sequenceLinkId == null) {
                this.sequenceLinkId = new ArrayList<PositiveIntType>();
            }
            return this.sequenceLinkId;
        }

        public boolean hasSequenceLinkId() {
            if (this.sequenceLinkId == null) {
                return false;
            }
            for (PositiveIntType item : this.sequenceLinkId) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addSequenceLinkIdElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.sequenceLinkId == null) {
                this.sequenceLinkId = new ArrayList<PositiveIntType>();
            }
            this.sequenceLinkId.add(t);
            return t;
        }

        public AddedItemComponent addSequenceLinkId(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.sequenceLinkId == null) {
                this.sequenceLinkId = new ArrayList<PositiveIntType>();
            }
            this.sequenceLinkId.add(t);
            return this;
        }

        public boolean hasSequenceLinkId(int value) {
            if (this.sequenceLinkId == null) {
                return false;
            }
            for (PositiveIntType v : this.sequenceLinkId) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public Coding getService() {
            if (this.service == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.service");
                }
                if (Configuration.doAutoCreate()) {
                    this.service = new Coding();
                }
            }
            return this.service;
        }

        public boolean hasService() {
            return this.service != null && !this.service.isEmpty();
        }

        public AddedItemComponent setService(Coding value) {
            this.service = value;
            return this;
        }

        public Money getFee() {
            if (this.fee == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.fee");
                }
                if (Configuration.doAutoCreate()) {
                    this.fee = new Money();
                }
            }
            return this.fee;
        }

        public boolean hasFee() {
            return this.fee != null && !this.fee.isEmpty();
        }

        public AddedItemComponent setFee(Money value) {
            this.fee = value;
            return this;
        }

        public List<PositiveIntType> getNoteNumberLinkId() {
            if (this.noteNumberLinkId == null) {
                this.noteNumberLinkId = new ArrayList<PositiveIntType>();
            }
            return this.noteNumberLinkId;
        }

        public boolean hasNoteNumberLinkId() {
            if (this.noteNumberLinkId == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumberLinkId) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberLinkIdElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumberLinkId == null) {
                this.noteNumberLinkId = new ArrayList<PositiveIntType>();
            }
            this.noteNumberLinkId.add(t);
            return t;
        }

        public AddedItemComponent addNoteNumberLinkId(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumberLinkId == null) {
                this.noteNumberLinkId = new ArrayList<PositiveIntType>();
            }
            this.noteNumberLinkId.add(t);
            return this;
        }

        public boolean hasNoteNumberLinkId(int value) {
            if (this.noteNumberLinkId == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumberLinkId) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<AddedItemAdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AddedItemAdjudicationComponent>();
            }
            return this.adjudication;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AddedItemAdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AddedItemAdjudicationComponent addAdjudication() {
            AddedItemAdjudicationComponent t = new AddedItemAdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AddedItemAdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public AddedItemComponent addAdjudication(AddedItemAdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AddedItemAdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public List<AddedItemsDetailComponent> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<AddedItemsDetailComponent>();
            }
            return this.detail;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (AddedItemsDetailComponent item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AddedItemsDetailComponent addDetail() {
            AddedItemsDetailComponent t = new AddedItemsDetailComponent();
            if (this.detail == null) {
                this.detail = new ArrayList<AddedItemsDetailComponent>();
            }
            this.detail.add(t);
            return t;
        }

        public AddedItemComponent addDetail(AddedItemsDetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<AddedItemsDetailComponent>();
            }
            this.detail.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("sequenceLinkId", "positiveInt", "List of input service items which this service line is intended to replace.", 0, Integer.MAX_VALUE, this.sequenceLinkId));
            childrenList.add(new Property("service", "Coding", "A code to indicate the Professional Service or Product supplied.", 0, Integer.MAX_VALUE, this.service));
            childrenList.add(new Property("fee", "Money", "The fee charged for the professional service or product..", 0, Integer.MAX_VALUE, this.fee));
            childrenList.add(new Property("noteNumberLinkId", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumberLinkId));
            childrenList.add(new Property("adjudication", "", "The adjudications results.", 0, Integer.MAX_VALUE, this.adjudication));
            childrenList.add(new Property("detail", "", "The second tier service adjudications for payor added services.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1422298666: {
                    return this.sequenceLinkId == null ? new Base[]{} : this.sequenceLinkId.toArray(new Base[this.sequenceLinkId.size()]);
                }
                case 1984153269: {
                    Base[] baseArray;
                    if (this.service == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.service;
                    }
                    return baseArray;
                }
                case 101254: {
                    Base[] baseArray;
                    if (this.fee == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.fee;
                    }
                    return baseArray;
                }
                case -1859667856: {
                    return this.noteNumberLinkId == null ? new Base[]{} : this.noteNumberLinkId.toArray(new Base[this.noteNumberLinkId.size()]);
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
                case -1335224239: {
                    return this.detail == null ? new Base[]{} : this.detail.toArray(new Base[this.detail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1422298666: {
                    this.getSequenceLinkId().add(this.castToPositiveInt(value));
                    break;
                }
                case 1984153269: {
                    this.service = this.castToCoding(value);
                    break;
                }
                case 101254: {
                    this.fee = this.castToMoney(value);
                    break;
                }
                case -1859667856: {
                    this.getNoteNumberLinkId().add(this.castToPositiveInt(value));
                    break;
                }
                case -231349275: {
                    this.getAdjudication().add((AddedItemAdjudicationComponent)value);
                    break;
                }
                case -1335224239: {
                    this.getDetail().add((AddedItemsDetailComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequenceLinkId")) {
                this.getSequenceLinkId().add(this.castToPositiveInt(value));
            } else if (name.equals("service")) {
                this.service = this.castToCoding(value);
            } else if (name.equals("fee")) {
                this.fee = this.castToMoney(value);
            } else if (name.equals("noteNumberLinkId")) {
                this.getNoteNumberLinkId().add(this.castToPositiveInt(value));
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AddedItemAdjudicationComponent)value);
            } else if (name.equals("detail")) {
                this.getDetail().add((AddedItemsDetailComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422298666: {
                    throw new FHIRException("Cannot make property sequenceLinkId as it is not a complex type");
                }
                case 1984153269: {
                    return this.getService();
                }
                case 101254: {
                    return this.getFee();
                }
                case -1859667856: {
                    throw new FHIRException("Cannot make property noteNumberLinkId as it is not a complex type");
                }
                case -231349275: {
                    return this.addAdjudication();
                }
                case -1335224239: {
                    return this.addDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequenceLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.sequenceLinkId");
            }
            if (name.equals("service")) {
                this.service = new Coding();
                return this.service;
            }
            if (name.equals("fee")) {
                this.fee = new Money();
                return this.fee;
            }
            if (name.equals("noteNumberLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.noteNumberLinkId");
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            return super.addChild(name);
        }

        @Override
        public AddedItemComponent copy() {
            AddedItemComponent dst = new AddedItemComponent();
            this.copyValues(dst);
            if (this.sequenceLinkId != null) {
                dst.sequenceLinkId = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.sequenceLinkId) {
                    dst.sequenceLinkId.add(positiveIntType.copy());
                }
            }
            dst.service = this.service == null ? null : this.service.copy();
            Money money = dst.fee = this.fee == null ? null : this.fee.copy();
            if (this.noteNumberLinkId != null) {
                dst.noteNumberLinkId = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.noteNumberLinkId) {
                    dst.noteNumberLinkId.add(positiveIntType.copy());
                }
            }
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AddedItemAdjudicationComponent>();
                for (AddedItemAdjudicationComponent addedItemAdjudicationComponent : this.adjudication) {
                    dst.adjudication.add(addedItemAdjudicationComponent.copy());
                }
            }
            if (this.detail != null) {
                dst.detail = new ArrayList<AddedItemsDetailComponent>();
                for (AddedItemsDetailComponent addedItemsDetailComponent : this.detail) {
                    dst.detail.add(addedItemsDetailComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof AddedItemComponent)) {
                return false;
            }
            AddedItemComponent o = (AddedItemComponent)other;
            return AddedItemComponent.compareDeep(this.sequenceLinkId, o.sequenceLinkId, true) && AddedItemComponent.compareDeep(this.service, o.service, true) && AddedItemComponent.compareDeep(this.fee, o.fee, true) && AddedItemComponent.compareDeep(this.noteNumberLinkId, o.noteNumberLinkId, true) && AddedItemComponent.compareDeep(this.adjudication, o.adjudication, true) && AddedItemComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof AddedItemComponent)) {
                return false;
            }
            AddedItemComponent o = (AddedItemComponent)other;
            return AddedItemComponent.compareValues(this.sequenceLinkId, o.sequenceLinkId, true) && AddedItemComponent.compareValues(this.noteNumberLinkId, o.noteNumberLinkId, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.sequenceLinkId != null && !this.sequenceLinkId.isEmpty() || this.service != null && !this.service.isEmpty() || this.fee != null && !this.fee.isEmpty() || this.noteNumberLinkId != null && !this.noteNumberLinkId.isEmpty() || this.adjudication != null && !this.adjudication.isEmpty() || this.detail != null && !this.detail.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.addItem";
        }
    }

    @Block
    public static class ProsthesisComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="initial", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Is this the initial service", formalDefinition="Indicates whether this is the initial placement of a fixed prosthesis.")
        protected BooleanType initial;
        @Child(name="priorDate", type={DateType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Initial service Date", formalDefinition="Date of the initial placement.")
        protected DateType priorDate;
        @Child(name="priorMaterial", type={Coding.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Prosthetic Material", formalDefinition="Material of the prior denture or bridge prosthesis. (Oral).")
        protected Coding priorMaterial;
        private static final long serialVersionUID = 1739349641L;

        public BooleanType getInitialElement() {
            if (this.initial == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProsthesisComponent.initial");
                }
                if (Configuration.doAutoCreate()) {
                    this.initial = new BooleanType();
                }
            }
            return this.initial;
        }

        public boolean hasInitialElement() {
            return this.initial != null && !this.initial.isEmpty();
        }

        public boolean hasInitial() {
            return this.initial != null && !this.initial.isEmpty();
        }

        public ProsthesisComponent setInitialElement(BooleanType value) {
            this.initial = value;
            return this;
        }

        public boolean getInitial() {
            return this.initial == null || this.initial.isEmpty() ? false : (Boolean)this.initial.getValue();
        }

        public ProsthesisComponent setInitial(boolean value) {
            if (this.initial == null) {
                this.initial = new BooleanType();
            }
            this.initial.setValue((Object)value);
            return this;
        }

        public DateType getPriorDateElement() {
            if (this.priorDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProsthesisComponent.priorDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.priorDate = new DateType();
                }
            }
            return this.priorDate;
        }

        public boolean hasPriorDateElement() {
            return this.priorDate != null && !this.priorDate.isEmpty();
        }

        public boolean hasPriorDate() {
            return this.priorDate != null && !this.priorDate.isEmpty();
        }

        public ProsthesisComponent setPriorDateElement(DateType value) {
            this.priorDate = value;
            return this;
        }

        public Date getPriorDate() {
            return this.priorDate == null ? null : (Date)this.priorDate.getValue();
        }

        public ProsthesisComponent setPriorDate(Date value) {
            if (value == null) {
                this.priorDate = null;
            } else {
                if (this.priorDate == null) {
                    this.priorDate = new DateType();
                }
                this.priorDate.setValue(value);
            }
            return this;
        }

        public Coding getPriorMaterial() {
            if (this.priorMaterial == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProsthesisComponent.priorMaterial");
                }
                if (Configuration.doAutoCreate()) {
                    this.priorMaterial = new Coding();
                }
            }
            return this.priorMaterial;
        }

        public boolean hasPriorMaterial() {
            return this.priorMaterial != null && !this.priorMaterial.isEmpty();
        }

        public ProsthesisComponent setPriorMaterial(Coding value) {
            this.priorMaterial = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("initial", "boolean", "Indicates whether this is the initial placement of a fixed prosthesis.", 0, Integer.MAX_VALUE, this.initial));
            childrenList.add(new Property("priorDate", "date", "Date of the initial placement.", 0, Integer.MAX_VALUE, this.priorDate));
            childrenList.add(new Property("priorMaterial", "Coding", "Material of the prior denture or bridge prosthesis. (Oral).", 0, Integer.MAX_VALUE, this.priorMaterial));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1948342084: {
                    Base[] baseArray;
                    if (this.initial == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.initial;
                    }
                    return baseArray;
                }
                case -1770675816: {
                    Base[] baseArray;
                    if (this.priorDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.priorDate;
                    }
                    return baseArray;
                }
                case -532999663: {
                    Base[] baseArray;
                    if (this.priorMaterial == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.priorMaterial;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1948342084: {
                    this.initial = this.castToBoolean(value);
                    break;
                }
                case -1770675816: {
                    this.priorDate = this.castToDate(value);
                    break;
                }
                case -532999663: {
                    this.priorMaterial = this.castToCoding(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("initial")) {
                this.initial = this.castToBoolean(value);
            } else if (name.equals("priorDate")) {
                this.priorDate = this.castToDate(value);
            } else if (name.equals("priorMaterial")) {
                this.priorMaterial = this.castToCoding(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1948342084: {
                    throw new FHIRException("Cannot make property initial as it is not a complex type");
                }
                case -1770675816: {
                    throw new FHIRException("Cannot make property priorDate as it is not a complex type");
                }
                case -532999663: {
                    return this.getPriorMaterial();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("initial")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.initial");
            }
            if (name.equals("priorDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.priorDate");
            }
            if (name.equals("priorMaterial")) {
                this.priorMaterial = new Coding();
                return this.priorMaterial;
            }
            return super.addChild(name);
        }

        @Override
        public ProsthesisComponent copy() {
            ProsthesisComponent dst = new ProsthesisComponent();
            this.copyValues(dst);
            dst.initial = this.initial == null ? null : this.initial.copy();
            dst.priorDate = this.priorDate == null ? null : this.priorDate.copy();
            dst.priorMaterial = this.priorMaterial == null ? null : this.priorMaterial.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ProsthesisComponent)) {
                return false;
            }
            ProsthesisComponent o = (ProsthesisComponent)other;
            return ProsthesisComponent.compareDeep(this.initial, o.initial, true) && ProsthesisComponent.compareDeep(this.priorDate, o.priorDate, true) && ProsthesisComponent.compareDeep(this.priorMaterial, o.priorMaterial, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ProsthesisComponent)) {
                return false;
            }
            ProsthesisComponent o = (ProsthesisComponent)other;
            return ProsthesisComponent.compareValues(this.initial, o.initial, true) && ProsthesisComponent.compareValues(this.priorDate, o.priorDate, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.initial != null && !this.initial.isEmpty() || this.priorDate != null && !this.priorDate.isEmpty() || this.priorMaterial != null && !this.priorMaterial.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.item.prosthesis";
        }
    }

    @Block
    public static class SubDetailAdjudicationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Adjudication category such as co-pay, eligible, benefit, etc.", formalDefinition="Code indicating: Co-Pay, deductable, elegible, benefit, tax, etc.")
        protected Coding category;
        @Child(name="reason", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Adjudication reason", formalDefinition="Adjudication reason such as limit reached.")
        protected Coding reason;
        @Child(name="amount", type={Money.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Monetary amount", formalDefinition="Monitory amount associated with the code.")
        protected Money amount;
        @Child(name="value", type={DecimalType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Non-monitory value", formalDefinition="A non-monetary value for example a percentage. Mutually exclusive to the amount element above.")
        protected DecimalType value;
        private static final long serialVersionUID = -1926987562L;

        public SubDetailAdjudicationComponent() {
        }

        public SubDetailAdjudicationComponent(Coding category) {
            this.category = category;
        }

        public Coding getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailAdjudicationComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new Coding();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public SubDetailAdjudicationComponent setCategory(Coding value) {
            this.category = value;
            return this;
        }

        public Coding getReason() {
            if (this.reason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailAdjudicationComponent.reason");
                }
                if (Configuration.doAutoCreate()) {
                    this.reason = new Coding();
                }
            }
            return this.reason;
        }

        public boolean hasReason() {
            return this.reason != null && !this.reason.isEmpty();
        }

        public SubDetailAdjudicationComponent setReason(Coding value) {
            this.reason = value;
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailAdjudicationComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public SubDetailAdjudicationComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        public DecimalType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailAdjudicationComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new DecimalType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public SubDetailAdjudicationComponent setValueElement(DecimalType value) {
            this.value = value;
            return this;
        }

        public BigDecimal getValue() {
            return this.value == null ? null : (BigDecimal)this.value.getValue();
        }

        public SubDetailAdjudicationComponent setValue(BigDecimal value) {
            if (value == null) {
                this.value = null;
            } else {
                if (this.value == null) {
                    this.value = new DecimalType();
                }
                this.value.setValue(value);
            }
            return this;
        }

        public SubDetailAdjudicationComponent setValue(long value) {
            this.value = new DecimalType();
            this.value.setValue(value);
            return this;
        }

        public SubDetailAdjudicationComponent setValue(double value) {
            this.value = new DecimalType();
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("category", "Coding", "Code indicating: Co-Pay, deductable, elegible, benefit, tax, etc.", 0, Integer.MAX_VALUE, this.category));
            childrenList.add(new Property("reason", "Coding", "Adjudication reason such as limit reached.", 0, Integer.MAX_VALUE, this.reason));
            childrenList.add(new Property("amount", "Money", "Monitory amount associated with the code.", 0, Integer.MAX_VALUE, this.amount));
            childrenList.add(new Property("value", "decimal", "A non-monetary value for example a percentage. Mutually exclusive to the amount element above.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case -934964668: {
                    Base[] baseArray;
                    if (this.reason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reason;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.amount;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = this.castToCoding(value);
                    break;
                }
                case -934964668: {
                    this.reason = this.castToCoding(value);
                    break;
                }
                case -1413853096: {
                    this.amount = this.castToMoney(value);
                    break;
                }
                case 111972721: {
                    this.value = this.castToDecimal(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = this.castToCoding(value);
            } else if (name.equals("reason")) {
                this.reason = this.castToCoding(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToMoney(value);
            } else if (name.equals("value")) {
                this.value = this.castToDecimal(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case -934964668: {
                    return this.getReason();
                }
                case -1413853096: {
                    return this.getAmount();
                }
                case 111972721: {
                    throw new FHIRException("Cannot make property value as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new Coding();
                return this.category;
            }
            if (name.equals("reason")) {
                this.reason = new Coding();
                return this.reason;
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.value");
            }
            return super.addChild(name);
        }

        @Override
        public SubDetailAdjudicationComponent copy() {
            SubDetailAdjudicationComponent dst = new SubDetailAdjudicationComponent();
            this.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.reason = this.reason == null ? null : this.reason.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SubDetailAdjudicationComponent)) {
                return false;
            }
            SubDetailAdjudicationComponent o = (SubDetailAdjudicationComponent)other;
            return SubDetailAdjudicationComponent.compareDeep(this.category, o.category, true) && SubDetailAdjudicationComponent.compareDeep(this.reason, o.reason, true) && SubDetailAdjudicationComponent.compareDeep(this.amount, o.amount, true) && SubDetailAdjudicationComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SubDetailAdjudicationComponent)) {
                return false;
            }
            SubDetailAdjudicationComponent o = (SubDetailAdjudicationComponent)other;
            return SubDetailAdjudicationComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.category != null && !this.category.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.amount != null && !this.amount.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.item.detail.subDetail.adjudication";
        }
    }

    @Block
    public static class SubDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Service instance", formalDefinition="A service line number.")
        protected PositiveIntType sequence;
        @Child(name="type", type={Coding.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of product or service", formalDefinition="The type of product or service.")
        protected Coding type;
        @Child(name="service", type={Coding.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Additional item codes", formalDefinition="The fee for an addittional service or product or charge.")
        protected Coding service;
        @Child(name="programCode", type={Coding.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Program specific reason for item inclusion", formalDefinition="For programs which require reson codes for the inclusion, covering, of this billed item under the program or sub-program.")
        protected List<Coding> programCode;
        @Child(name="quantity", type={SimpleQuantity.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Count of Products or Services", formalDefinition="The number of repetitions of a service or product.")
        protected SimpleQuantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Fee, charge or cost per point", formalDefinition="The fee for an addittional service or product or charge.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Price scaling factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="points", type={DecimalType.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Difficulty scaling factor", formalDefinition="An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the good or service delivered. The concept of Points allows for assignment of point values for services and/or goods, such that a monetary amount can be assigned to each point.")
        protected DecimalType points;
        @Child(name="net", type={Money.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Net additional item cost", formalDefinition="The quantity times the unit price for an addittional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        protected Money net;
        @Child(name="udi", type={Device.class}, order=10, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Unique Device Identifier", formalDefinition="List of Unique Device Identifiers associated with this line item.")
        protected List<Reference> udi;
        protected List<Device> udiTarget;
        @Child(name="adjudication", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="SubDetail adjudication", formalDefinition="The adjudications results.")
        protected List<SubDetailAdjudicationComponent> adjudication;
        private static final long serialVersionUID = -1690477905L;

        public SubDetailComponent() {
        }

        public SubDetailComponent(PositiveIntType sequence, Coding type, Coding service) {
            this.sequence = sequence;
            this.type = type;
            this.service = service;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public SubDetailComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public SubDetailComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SubDetailComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public Coding getService() {
            if (this.service == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.service");
                }
                if (Configuration.doAutoCreate()) {
                    this.service = new Coding();
                }
            }
            return this.service;
        }

        public boolean hasService() {
            return this.service != null && !this.service.isEmpty();
        }

        public SubDetailComponent setService(Coding value) {
            this.service = value;
            return this;
        }

        public List<Coding> getProgramCode() {
            if (this.programCode == null) {
                this.programCode = new ArrayList<Coding>();
            }
            return this.programCode;
        }

        public boolean hasProgramCode() {
            if (this.programCode == null) {
                return false;
            }
            for (Coding item : this.programCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addProgramCode() {
            Coding t = new Coding();
            if (this.programCode == null) {
                this.programCode = new ArrayList<Coding>();
            }
            this.programCode.add(t);
            return t;
        }

        public SubDetailComponent addProgramCode(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.programCode == null) {
                this.programCode = new ArrayList<Coding>();
            }
            this.programCode.add(t);
            return this;
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public SubDetailComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public SubDetailComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public SubDetailComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public SubDetailComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public SubDetailComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public SubDetailComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public DecimalType getPointsElement() {
            if (this.points == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.points");
                }
                if (Configuration.doAutoCreate()) {
                    this.points = new DecimalType();
                }
            }
            return this.points;
        }

        public boolean hasPointsElement() {
            return this.points != null && !this.points.isEmpty();
        }

        public boolean hasPoints() {
            return this.points != null && !this.points.isEmpty();
        }

        public SubDetailComponent setPointsElement(DecimalType value) {
            this.points = value;
            return this;
        }

        public BigDecimal getPoints() {
            return this.points == null ? null : (BigDecimal)this.points.getValue();
        }

        public SubDetailComponent setPoints(BigDecimal value) {
            if (value == null) {
                this.points = null;
            } else {
                if (this.points == null) {
                    this.points = new DecimalType();
                }
                this.points.setValue(value);
            }
            return this;
        }

        public SubDetailComponent setPoints(long value) {
            this.points = new DecimalType();
            this.points.setValue(value);
            return this;
        }

        public SubDetailComponent setPoints(double value) {
            this.points = new DecimalType();
            this.points.setValue(value);
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public SubDetailComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public List<Reference> getUdi() {
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            return this.udi;
        }

        public boolean hasUdi() {
            if (this.udi == null) {
                return false;
            }
            for (Reference item : this.udi) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addUdi() {
            Reference t = new Reference();
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return t;
        }

        public SubDetailComponent addUdi(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return this;
        }

        public List<Device> getUdiTarget() {
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            return this.udiTarget;
        }

        public Device addUdiTarget() {
            Device r = new Device();
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            this.udiTarget.add(r);
            return r;
        }

        public List<SubDetailAdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<SubDetailAdjudicationComponent>();
            }
            return this.adjudication;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (SubDetailAdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubDetailAdjudicationComponent addAdjudication() {
            SubDetailAdjudicationComponent t = new SubDetailAdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<SubDetailAdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public SubDetailComponent addAdjudication(SubDetailAdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<SubDetailAdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("sequence", "positiveInt", "A service line number.", 0, Integer.MAX_VALUE, this.sequence));
            childrenList.add(new Property("type", "Coding", "The type of product or service.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("service", "Coding", "The fee for an addittional service or product or charge.", 0, Integer.MAX_VALUE, this.service));
            childrenList.add(new Property("programCode", "Coding", "For programs which require reson codes for the inclusion, covering, of this billed item under the program or sub-program.", 0, Integer.MAX_VALUE, this.programCode));
            childrenList.add(new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, Integer.MAX_VALUE, this.quantity));
            childrenList.add(new Property("unitPrice", "Money", "The fee for an addittional service or product or charge.", 0, Integer.MAX_VALUE, this.unitPrice));
            childrenList.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, Integer.MAX_VALUE, this.factor));
            childrenList.add(new Property("points", "decimal", "An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the good or service delivered. The concept of Points allows for assignment of point values for services and/or goods, such that a monetary amount can be assigned to each point.", 0, Integer.MAX_VALUE, this.points));
            childrenList.add(new Property("net", "Money", "The quantity times the unit price for an addittional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, Integer.MAX_VALUE, this.net));
            childrenList.add(new Property("udi", "Reference(Device)", "List of Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi));
            childrenList.add(new Property("adjudication", "", "The adjudications results.", 0, Integer.MAX_VALUE, this.adjudication));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 1984153269: {
                    Base[] baseArray;
                    if (this.service == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.service;
                    }
                    return baseArray;
                }
                case 1010065041: {
                    return this.programCode == null ? new Base[]{} : this.programCode.toArray(new Base[this.programCode.size()]);
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.factor;
                    }
                    return baseArray;
                }
                case -982754077: {
                    Base[] baseArray;
                    if (this.points == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.points;
                    }
                    return baseArray;
                }
                case 108957: {
                    Base[] baseArray;
                    if (this.net == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.net;
                    }
                    return baseArray;
                }
                case 115642: {
                    return this.udi == null ? new Base[]{} : this.udi.toArray(new Base[this.udi.size()]);
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    break;
                }
                case 3575610: {
                    this.type = this.castToCoding(value);
                    break;
                }
                case 1984153269: {
                    this.service = this.castToCoding(value);
                    break;
                }
                case 1010065041: {
                    this.getProgramCode().add(this.castToCoding(value));
                    break;
                }
                case -1285004149: {
                    this.quantity = this.castToSimpleQuantity(value);
                    break;
                }
                case -486196699: {
                    this.unitPrice = this.castToMoney(value);
                    break;
                }
                case -1282148017: {
                    this.factor = this.castToDecimal(value);
                    break;
                }
                case -982754077: {
                    this.points = this.castToDecimal(value);
                    break;
                }
                case 108957: {
                    this.net = this.castToMoney(value);
                    break;
                }
                case 115642: {
                    this.getUdi().add(this.castToReference(value));
                    break;
                }
                case -231349275: {
                    this.getAdjudication().add((SubDetailAdjudicationComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals("service")) {
                this.service = this.castToCoding(value);
            } else if (name.equals("programCode")) {
                this.getProgramCode().add(this.castToCoding(value));
            } else if (name.equals("quantity")) {
                this.quantity = this.castToSimpleQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("points")) {
                this.points = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else if (name.equals("udi")) {
                this.getUdi().add(this.castToReference(value));
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((SubDetailAdjudicationComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    throw new FHIRException("Cannot make property sequence as it is not a complex type");
                }
                case 3575610: {
                    return this.getType();
                }
                case 1984153269: {
                    return this.getService();
                }
                case 1010065041: {
                    return this.addProgramCode();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case -1282148017: {
                    throw new FHIRException("Cannot make property factor as it is not a complex type");
                }
                case -982754077: {
                    throw new FHIRException("Cannot make property points as it is not a complex type");
                }
                case 108957: {
                    return this.getNet();
                }
                case 115642: {
                    return this.addUdi();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.sequence");
            }
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("service")) {
                this.service = new Coding();
                return this.service;
            }
            if (name.equals("programCode")) {
                return this.addProgramCode();
            }
            if (name.equals("quantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.factor");
            }
            if (name.equals("points")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.points");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("udi")) {
                return this.addUdi();
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            return super.addChild(name);
        }

        @Override
        public SubDetailComponent copy() {
            SubDetailComponent dst = new SubDetailComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.type = this.type == null ? null : this.type.copy();
            Coding coding = dst.service = this.service == null ? null : this.service.copy();
            if (this.programCode != null) {
                dst.programCode = new ArrayList<Coding>();
                for (Coding coding2 : this.programCode) {
                    dst.programCode.add(coding2.copy());
                }
            }
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            dst.points = this.points == null ? null : this.points.copy();
            Money money = dst.net = this.net == null ? null : this.net.copy();
            if (this.udi != null) {
                dst.udi = new ArrayList<Reference>();
                for (Reference reference : this.udi) {
                    dst.udi.add(reference.copy());
                }
            }
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<SubDetailAdjudicationComponent>();
                for (SubDetailAdjudicationComponent subDetailAdjudicationComponent : this.adjudication) {
                    dst.adjudication.add(subDetailAdjudicationComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SubDetailComponent)) {
                return false;
            }
            SubDetailComponent o = (SubDetailComponent)other;
            return SubDetailComponent.compareDeep(this.sequence, o.sequence, true) && SubDetailComponent.compareDeep(this.type, o.type, true) && SubDetailComponent.compareDeep(this.service, o.service, true) && SubDetailComponent.compareDeep(this.programCode, o.programCode, true) && SubDetailComponent.compareDeep(this.quantity, o.quantity, true) && SubDetailComponent.compareDeep(this.unitPrice, o.unitPrice, true) && SubDetailComponent.compareDeep(this.factor, o.factor, true) && SubDetailComponent.compareDeep(this.points, o.points, true) && SubDetailComponent.compareDeep(this.net, o.net, true) && SubDetailComponent.compareDeep(this.udi, o.udi, true) && SubDetailComponent.compareDeep(this.adjudication, o.adjudication, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SubDetailComponent)) {
                return false;
            }
            SubDetailComponent o = (SubDetailComponent)other;
            return SubDetailComponent.compareValues(this.sequence, o.sequence, true) && SubDetailComponent.compareValues(this.factor, o.factor, true) && SubDetailComponent.compareValues(this.points, o.points, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.sequence != null && !this.sequence.isEmpty() || this.type != null && !this.type.isEmpty() || this.service != null && !this.service.isEmpty() || this.programCode != null && !this.programCode.isEmpty() || this.quantity != null && !this.quantity.isEmpty() || this.unitPrice != null && !this.unitPrice.isEmpty() || this.factor != null && !this.factor.isEmpty() || this.points != null && !this.points.isEmpty() || this.net != null && !this.net.isEmpty() || this.udi != null && !this.udi.isEmpty() || this.adjudication != null && !this.adjudication.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.item.detail.subDetail";
        }
    }

    @Block
    public static class DetailAdjudicationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Adjudication category such as co-pay, eligible, benefit, etc.", formalDefinition="Code indicating: Co-Pay, deductable, elegible, benefit, tax, etc.")
        protected Coding category;
        @Child(name="reason", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Adjudication reason", formalDefinition="Adjudication reason such as limit reached.")
        protected Coding reason;
        @Child(name="amount", type={Money.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Monetary amount", formalDefinition="Monitory amount associated with the code.")
        protected Money amount;
        @Child(name="value", type={DecimalType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Non-monitory value", formalDefinition="A non-monetary value for example a percentage. Mutually exclusive to the amount element above.")
        protected DecimalType value;
        private static final long serialVersionUID = -1926987562L;

        public DetailAdjudicationComponent() {
        }

        public DetailAdjudicationComponent(Coding category) {
            this.category = category;
        }

        public Coding getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailAdjudicationComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new Coding();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public DetailAdjudicationComponent setCategory(Coding value) {
            this.category = value;
            return this;
        }

        public Coding getReason() {
            if (this.reason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailAdjudicationComponent.reason");
                }
                if (Configuration.doAutoCreate()) {
                    this.reason = new Coding();
                }
            }
            return this.reason;
        }

        public boolean hasReason() {
            return this.reason != null && !this.reason.isEmpty();
        }

        public DetailAdjudicationComponent setReason(Coding value) {
            this.reason = value;
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailAdjudicationComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public DetailAdjudicationComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        public DecimalType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailAdjudicationComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new DecimalType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public DetailAdjudicationComponent setValueElement(DecimalType value) {
            this.value = value;
            return this;
        }

        public BigDecimal getValue() {
            return this.value == null ? null : (BigDecimal)this.value.getValue();
        }

        public DetailAdjudicationComponent setValue(BigDecimal value) {
            if (value == null) {
                this.value = null;
            } else {
                if (this.value == null) {
                    this.value = new DecimalType();
                }
                this.value.setValue(value);
            }
            return this;
        }

        public DetailAdjudicationComponent setValue(long value) {
            this.value = new DecimalType();
            this.value.setValue(value);
            return this;
        }

        public DetailAdjudicationComponent setValue(double value) {
            this.value = new DecimalType();
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("category", "Coding", "Code indicating: Co-Pay, deductable, elegible, benefit, tax, etc.", 0, Integer.MAX_VALUE, this.category));
            childrenList.add(new Property("reason", "Coding", "Adjudication reason such as limit reached.", 0, Integer.MAX_VALUE, this.reason));
            childrenList.add(new Property("amount", "Money", "Monitory amount associated with the code.", 0, Integer.MAX_VALUE, this.amount));
            childrenList.add(new Property("value", "decimal", "A non-monetary value for example a percentage. Mutually exclusive to the amount element above.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case -934964668: {
                    Base[] baseArray;
                    if (this.reason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reason;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.amount;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = this.castToCoding(value);
                    break;
                }
                case -934964668: {
                    this.reason = this.castToCoding(value);
                    break;
                }
                case -1413853096: {
                    this.amount = this.castToMoney(value);
                    break;
                }
                case 111972721: {
                    this.value = this.castToDecimal(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = this.castToCoding(value);
            } else if (name.equals("reason")) {
                this.reason = this.castToCoding(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToMoney(value);
            } else if (name.equals("value")) {
                this.value = this.castToDecimal(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case -934964668: {
                    return this.getReason();
                }
                case -1413853096: {
                    return this.getAmount();
                }
                case 111972721: {
                    throw new FHIRException("Cannot make property value as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new Coding();
                return this.category;
            }
            if (name.equals("reason")) {
                this.reason = new Coding();
                return this.reason;
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.value");
            }
            return super.addChild(name);
        }

        @Override
        public DetailAdjudicationComponent copy() {
            DetailAdjudicationComponent dst = new DetailAdjudicationComponent();
            this.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.reason = this.reason == null ? null : this.reason.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DetailAdjudicationComponent)) {
                return false;
            }
            DetailAdjudicationComponent o = (DetailAdjudicationComponent)other;
            return DetailAdjudicationComponent.compareDeep(this.category, o.category, true) && DetailAdjudicationComponent.compareDeep(this.reason, o.reason, true) && DetailAdjudicationComponent.compareDeep(this.amount, o.amount, true) && DetailAdjudicationComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DetailAdjudicationComponent)) {
                return false;
            }
            DetailAdjudicationComponent o = (DetailAdjudicationComponent)other;
            return DetailAdjudicationComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.category != null && !this.category.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.amount != null && !this.amount.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.item.detail.adjudication";
        }
    }

    @Block
    public static class DetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Service instance", formalDefinition="A service line number.")
        protected PositiveIntType sequence;
        @Child(name="type", type={Coding.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Group or type of product or service", formalDefinition="The type of product or service.")
        protected Coding type;
        @Child(name="service", type={Coding.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Additional item codes", formalDefinition="If a grouping item then 'GROUP' otherwise it is a node therefore a code to indicate the Professional Service or Product supplied.")
        protected Coding service;
        @Child(name="programCode", type={Coding.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Program specific reason for item inclusion", formalDefinition="For programs which require reson codes for the inclusion, covering, of this billed item under the program or sub-program.")
        protected List<Coding> programCode;
        @Child(name="quantity", type={SimpleQuantity.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Count of Products or Services", formalDefinition="The number of repetitions of a service or product.")
        protected SimpleQuantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Fee, charge or cost per point", formalDefinition="If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Price scaling factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="points", type={DecimalType.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Difficulty scaling factor", formalDefinition="An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the good or service delivered. The concept of Points allows for assignment of point values for services and/or goods, such that a monetary amount can be assigned to each point.")
        protected DecimalType points;
        @Child(name="net", type={Money.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Total additional item cost", formalDefinition="The quantity times the unit price for an addittional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        protected Money net;
        @Child(name="udi", type={Device.class}, order=10, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Unique Device Identifier", formalDefinition="List of Unique Device Identifiers associated with this line item.")
        protected List<Reference> udi;
        protected List<Device> udiTarget;
        @Child(name="adjudication", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Detail adjudication", formalDefinition="The adjudications results.")
        protected List<DetailAdjudicationComponent> adjudication;
        @Child(name="subDetail", type={}, order=12, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Additional items", formalDefinition="Third tier of goods and services.")
        protected List<SubDetailComponent> subDetail;
        private static final long serialVersionUID = -240637412L;

        public DetailComponent() {
        }

        public DetailComponent(PositiveIntType sequence, Coding type, Coding service) {
            this.sequence = sequence;
            this.type = type;
            this.service = service;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public DetailComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public DetailComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DetailComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public Coding getService() {
            if (this.service == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.service");
                }
                if (Configuration.doAutoCreate()) {
                    this.service = new Coding();
                }
            }
            return this.service;
        }

        public boolean hasService() {
            return this.service != null && !this.service.isEmpty();
        }

        public DetailComponent setService(Coding value) {
            this.service = value;
            return this;
        }

        public List<Coding> getProgramCode() {
            if (this.programCode == null) {
                this.programCode = new ArrayList<Coding>();
            }
            return this.programCode;
        }

        public boolean hasProgramCode() {
            if (this.programCode == null) {
                return false;
            }
            for (Coding item : this.programCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addProgramCode() {
            Coding t = new Coding();
            if (this.programCode == null) {
                this.programCode = new ArrayList<Coding>();
            }
            this.programCode.add(t);
            return t;
        }

        public DetailComponent addProgramCode(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.programCode == null) {
                this.programCode = new ArrayList<Coding>();
            }
            this.programCode.add(t);
            return this;
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public DetailComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public DetailComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public DetailComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public DetailComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public DetailComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public DetailComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public DecimalType getPointsElement() {
            if (this.points == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.points");
                }
                if (Configuration.doAutoCreate()) {
                    this.points = new DecimalType();
                }
            }
            return this.points;
        }

        public boolean hasPointsElement() {
            return this.points != null && !this.points.isEmpty();
        }

        public boolean hasPoints() {
            return this.points != null && !this.points.isEmpty();
        }

        public DetailComponent setPointsElement(DecimalType value) {
            this.points = value;
            return this;
        }

        public BigDecimal getPoints() {
            return this.points == null ? null : (BigDecimal)this.points.getValue();
        }

        public DetailComponent setPoints(BigDecimal value) {
            if (value == null) {
                this.points = null;
            } else {
                if (this.points == null) {
                    this.points = new DecimalType();
                }
                this.points.setValue(value);
            }
            return this;
        }

        public DetailComponent setPoints(long value) {
            this.points = new DecimalType();
            this.points.setValue(value);
            return this;
        }

        public DetailComponent setPoints(double value) {
            this.points = new DecimalType();
            this.points.setValue(value);
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public DetailComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public List<Reference> getUdi() {
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            return this.udi;
        }

        public boolean hasUdi() {
            if (this.udi == null) {
                return false;
            }
            for (Reference item : this.udi) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addUdi() {
            Reference t = new Reference();
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return t;
        }

        public DetailComponent addUdi(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return this;
        }

        public List<Device> getUdiTarget() {
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            return this.udiTarget;
        }

        public Device addUdiTarget() {
            Device r = new Device();
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            this.udiTarget.add(r);
            return r;
        }

        public List<DetailAdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<DetailAdjudicationComponent>();
            }
            return this.adjudication;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (DetailAdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DetailAdjudicationComponent addAdjudication() {
            DetailAdjudicationComponent t = new DetailAdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<DetailAdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public DetailComponent addAdjudication(DetailAdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<DetailAdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public List<SubDetailComponent> getSubDetail() {
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            return this.subDetail;
        }

        public boolean hasSubDetail() {
            if (this.subDetail == null) {
                return false;
            }
            for (SubDetailComponent item : this.subDetail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubDetailComponent addSubDetail() {
            SubDetailComponent t = new SubDetailComponent();
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            this.subDetail.add(t);
            return t;
        }

        public DetailComponent addSubDetail(SubDetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            this.subDetail.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("sequence", "positiveInt", "A service line number.", 0, Integer.MAX_VALUE, this.sequence));
            childrenList.add(new Property("type", "Coding", "The type of product or service.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("service", "Coding", "If a grouping item then 'GROUP' otherwise it is a node therefore a code to indicate the Professional Service or Product supplied.", 0, Integer.MAX_VALUE, this.service));
            childrenList.add(new Property("programCode", "Coding", "For programs which require reson codes for the inclusion, covering, of this billed item under the program or sub-program.", 0, Integer.MAX_VALUE, this.programCode));
            childrenList.add(new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, Integer.MAX_VALUE, this.quantity));
            childrenList.add(new Property("unitPrice", "Money", "If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.", 0, Integer.MAX_VALUE, this.unitPrice));
            childrenList.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, Integer.MAX_VALUE, this.factor));
            childrenList.add(new Property("points", "decimal", "An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the good or service delivered. The concept of Points allows for assignment of point values for services and/or goods, such that a monetary amount can be assigned to each point.", 0, Integer.MAX_VALUE, this.points));
            childrenList.add(new Property("net", "Money", "The quantity times the unit price for an addittional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, Integer.MAX_VALUE, this.net));
            childrenList.add(new Property("udi", "Reference(Device)", "List of Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi));
            childrenList.add(new Property("adjudication", "", "The adjudications results.", 0, Integer.MAX_VALUE, this.adjudication));
            childrenList.add(new Property("subDetail", "", "Third tier of goods and services.", 0, Integer.MAX_VALUE, this.subDetail));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 1984153269: {
                    Base[] baseArray;
                    if (this.service == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.service;
                    }
                    return baseArray;
                }
                case 1010065041: {
                    return this.programCode == null ? new Base[]{} : this.programCode.toArray(new Base[this.programCode.size()]);
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.factor;
                    }
                    return baseArray;
                }
                case -982754077: {
                    Base[] baseArray;
                    if (this.points == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.points;
                    }
                    return baseArray;
                }
                case 108957: {
                    Base[] baseArray;
                    if (this.net == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.net;
                    }
                    return baseArray;
                }
                case 115642: {
                    return this.udi == null ? new Base[]{} : this.udi.toArray(new Base[this.udi.size()]);
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
                case -828829007: {
                    return this.subDetail == null ? new Base[]{} : this.subDetail.toArray(new Base[this.subDetail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    break;
                }
                case 3575610: {
                    this.type = this.castToCoding(value);
                    break;
                }
                case 1984153269: {
                    this.service = this.castToCoding(value);
                    break;
                }
                case 1010065041: {
                    this.getProgramCode().add(this.castToCoding(value));
                    break;
                }
                case -1285004149: {
                    this.quantity = this.castToSimpleQuantity(value);
                    break;
                }
                case -486196699: {
                    this.unitPrice = this.castToMoney(value);
                    break;
                }
                case -1282148017: {
                    this.factor = this.castToDecimal(value);
                    break;
                }
                case -982754077: {
                    this.points = this.castToDecimal(value);
                    break;
                }
                case 108957: {
                    this.net = this.castToMoney(value);
                    break;
                }
                case 115642: {
                    this.getUdi().add(this.castToReference(value));
                    break;
                }
                case -231349275: {
                    this.getAdjudication().add((DetailAdjudicationComponent)value);
                    break;
                }
                case -828829007: {
                    this.getSubDetail().add((SubDetailComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals("service")) {
                this.service = this.castToCoding(value);
            } else if (name.equals("programCode")) {
                this.getProgramCode().add(this.castToCoding(value));
            } else if (name.equals("quantity")) {
                this.quantity = this.castToSimpleQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("points")) {
                this.points = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else if (name.equals("udi")) {
                this.getUdi().add(this.castToReference(value));
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((DetailAdjudicationComponent)value);
            } else if (name.equals("subDetail")) {
                this.getSubDetail().add((SubDetailComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    throw new FHIRException("Cannot make property sequence as it is not a complex type");
                }
                case 3575610: {
                    return this.getType();
                }
                case 1984153269: {
                    return this.getService();
                }
                case 1010065041: {
                    return this.addProgramCode();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case -1282148017: {
                    throw new FHIRException("Cannot make property factor as it is not a complex type");
                }
                case -982754077: {
                    throw new FHIRException("Cannot make property points as it is not a complex type");
                }
                case 108957: {
                    return this.getNet();
                }
                case 115642: {
                    return this.addUdi();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
                case -828829007: {
                    return this.addSubDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.sequence");
            }
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("service")) {
                this.service = new Coding();
                return this.service;
            }
            if (name.equals("programCode")) {
                return this.addProgramCode();
            }
            if (name.equals("quantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.factor");
            }
            if (name.equals("points")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.points");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("udi")) {
                return this.addUdi();
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            if (name.equals("subDetail")) {
                return this.addSubDetail();
            }
            return super.addChild(name);
        }

        @Override
        public DetailComponent copy() {
            DetailComponent dst = new DetailComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.type = this.type == null ? null : this.type.copy();
            Coding coding = dst.service = this.service == null ? null : this.service.copy();
            if (this.programCode != null) {
                dst.programCode = new ArrayList<Coding>();
                for (Coding coding2 : this.programCode) {
                    dst.programCode.add(coding2.copy());
                }
            }
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            dst.points = this.points == null ? null : this.points.copy();
            Money money = dst.net = this.net == null ? null : this.net.copy();
            if (this.udi != null) {
                dst.udi = new ArrayList<Reference>();
                for (Reference reference : this.udi) {
                    dst.udi.add(reference.copy());
                }
            }
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<DetailAdjudicationComponent>();
                for (DetailAdjudicationComponent detailAdjudicationComponent : this.adjudication) {
                    dst.adjudication.add(detailAdjudicationComponent.copy());
                }
            }
            if (this.subDetail != null) {
                dst.subDetail = new ArrayList<SubDetailComponent>();
                for (SubDetailComponent subDetailComponent : this.subDetail) {
                    dst.subDetail.add(subDetailComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DetailComponent)) {
                return false;
            }
            DetailComponent o = (DetailComponent)other;
            return DetailComponent.compareDeep(this.sequence, o.sequence, true) && DetailComponent.compareDeep(this.type, o.type, true) && DetailComponent.compareDeep(this.service, o.service, true) && DetailComponent.compareDeep(this.programCode, o.programCode, true) && DetailComponent.compareDeep(this.quantity, o.quantity, true) && DetailComponent.compareDeep(this.unitPrice, o.unitPrice, true) && DetailComponent.compareDeep(this.factor, o.factor, true) && DetailComponent.compareDeep(this.points, o.points, true) && DetailComponent.compareDeep(this.net, o.net, true) && DetailComponent.compareDeep(this.udi, o.udi, true) && DetailComponent.compareDeep(this.adjudication, o.adjudication, true) && DetailComponent.compareDeep(this.subDetail, o.subDetail, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DetailComponent)) {
                return false;
            }
            DetailComponent o = (DetailComponent)other;
            return DetailComponent.compareValues(this.sequence, o.sequence, true) && DetailComponent.compareValues(this.factor, o.factor, true) && DetailComponent.compareValues(this.points, o.points, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.sequence != null && !this.sequence.isEmpty() || this.type != null && !this.type.isEmpty() || this.service != null && !this.service.isEmpty() || this.programCode != null && !this.programCode.isEmpty() || this.quantity != null && !this.quantity.isEmpty() || this.unitPrice != null && !this.unitPrice.isEmpty() || this.factor != null && !this.factor.isEmpty() || this.points != null && !this.points.isEmpty() || this.net != null && !this.net.isEmpty() || this.udi != null && !this.udi.isEmpty() || this.adjudication != null && !this.adjudication.isEmpty() || this.subDetail != null && !this.subDetail.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.item.detail";
        }
    }

    @Block
    public static class ItemAdjudicationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Adjudication category such as co-pay, eligible, benefit, etc.", formalDefinition="Code indicating: Co-Pay, deductable, elegible, benefit, tax, etc.")
        protected Coding category;
        @Child(name="reason", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Adjudication reason", formalDefinition="Adjudication reason such as limit reached.")
        protected Coding reason;
        @Child(name="amount", type={Money.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Monetary amount", formalDefinition="Monitory amount associated with the code.")
        protected Money amount;
        @Child(name="value", type={DecimalType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Non-monitory value", formalDefinition="A non-monetary value for example a percentage. Mutually exclusive to the amount element above.")
        protected DecimalType value;
        private static final long serialVersionUID = -1926987562L;

        public ItemAdjudicationComponent() {
        }

        public ItemAdjudicationComponent(Coding category) {
            this.category = category;
        }

        public Coding getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemAdjudicationComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new Coding();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public ItemAdjudicationComponent setCategory(Coding value) {
            this.category = value;
            return this;
        }

        public Coding getReason() {
            if (this.reason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemAdjudicationComponent.reason");
                }
                if (Configuration.doAutoCreate()) {
                    this.reason = new Coding();
                }
            }
            return this.reason;
        }

        public boolean hasReason() {
            return this.reason != null && !this.reason.isEmpty();
        }

        public ItemAdjudicationComponent setReason(Coding value) {
            this.reason = value;
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemAdjudicationComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public ItemAdjudicationComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        public DecimalType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemAdjudicationComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new DecimalType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ItemAdjudicationComponent setValueElement(DecimalType value) {
            this.value = value;
            return this;
        }

        public BigDecimal getValue() {
            return this.value == null ? null : (BigDecimal)this.value.getValue();
        }

        public ItemAdjudicationComponent setValue(BigDecimal value) {
            if (value == null) {
                this.value = null;
            } else {
                if (this.value == null) {
                    this.value = new DecimalType();
                }
                this.value.setValue(value);
            }
            return this;
        }

        public ItemAdjudicationComponent setValue(long value) {
            this.value = new DecimalType();
            this.value.setValue(value);
            return this;
        }

        public ItemAdjudicationComponent setValue(double value) {
            this.value = new DecimalType();
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("category", "Coding", "Code indicating: Co-Pay, deductable, elegible, benefit, tax, etc.", 0, Integer.MAX_VALUE, this.category));
            childrenList.add(new Property("reason", "Coding", "Adjudication reason such as limit reached.", 0, Integer.MAX_VALUE, this.reason));
            childrenList.add(new Property("amount", "Money", "Monitory amount associated with the code.", 0, Integer.MAX_VALUE, this.amount));
            childrenList.add(new Property("value", "decimal", "A non-monetary value for example a percentage. Mutually exclusive to the amount element above.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case -934964668: {
                    Base[] baseArray;
                    if (this.reason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reason;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.amount;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = this.castToCoding(value);
                    break;
                }
                case -934964668: {
                    this.reason = this.castToCoding(value);
                    break;
                }
                case -1413853096: {
                    this.amount = this.castToMoney(value);
                    break;
                }
                case 111972721: {
                    this.value = this.castToDecimal(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = this.castToCoding(value);
            } else if (name.equals("reason")) {
                this.reason = this.castToCoding(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToMoney(value);
            } else if (name.equals("value")) {
                this.value = this.castToDecimal(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case -934964668: {
                    return this.getReason();
                }
                case -1413853096: {
                    return this.getAmount();
                }
                case 111972721: {
                    throw new FHIRException("Cannot make property value as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new Coding();
                return this.category;
            }
            if (name.equals("reason")) {
                this.reason = new Coding();
                return this.reason;
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.value");
            }
            return super.addChild(name);
        }

        @Override
        public ItemAdjudicationComponent copy() {
            ItemAdjudicationComponent dst = new ItemAdjudicationComponent();
            this.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.reason = this.reason == null ? null : this.reason.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ItemAdjudicationComponent)) {
                return false;
            }
            ItemAdjudicationComponent o = (ItemAdjudicationComponent)other;
            return ItemAdjudicationComponent.compareDeep(this.category, o.category, true) && ItemAdjudicationComponent.compareDeep(this.reason, o.reason, true) && ItemAdjudicationComponent.compareDeep(this.amount, o.amount, true) && ItemAdjudicationComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ItemAdjudicationComponent)) {
                return false;
            }
            ItemAdjudicationComponent o = (ItemAdjudicationComponent)other;
            return ItemAdjudicationComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.category != null && !this.category.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.amount != null && !this.amount.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.item.adjudication";
        }
    }

    @Block
    public static class ItemsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Service instance", formalDefinition="A service line number.")
        protected PositiveIntType sequence;
        @Child(name="type", type={Coding.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Group or type of product or service", formalDefinition="The type of product or service.")
        protected Coding type;
        @Child(name="provider", type={Identifier.class, Practitioner.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Responsible practitioner", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
        protected Type provider;
        @Child(name="supervisor", type={Identifier.class, Practitioner.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Supervising Practitioner", formalDefinition="The practitioner who is supervising the work of the servicing provider(s).")
        protected Type supervisor;
        @Child(name="providerQualification", type={Coding.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type, classification or Specialization", formalDefinition="The qualification which is applicable for this service.")
        protected Coding providerQualification;
        @Child(name="diagnosisLinkId", type={PositiveIntType.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Applicable diagnoses", formalDefinition="Diagnosis applicable for this service or product line.")
        protected List<PositiveIntType> diagnosisLinkId;
        @Child(name="service", type={Coding.class}, order=7, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Item Code", formalDefinition="If a grouping item then 'GROUP' otherwise it is a node therefore a code to indicate the Professional Service or Product supplied.")
        protected Coding service;
        @Child(name="serviceModifier", type={Coding.class}, order=8, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Service/Product modifiers", formalDefinition="Unusual circumstances which may influence adjudication.")
        protected List<Coding> serviceModifier;
        @Child(name="modifier", type={Coding.class}, order=9, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Service/Product billing modifiers", formalDefinition="Item typification or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or an appliance was lost or stolen.")
        protected List<Coding> modifier;
        @Child(name="programCode", type={Coding.class}, order=10, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Program specific reason for item inclusion", formalDefinition="For programs which require reson codes for the inclusion, covering, of this billed item under the program or sub-program.")
        protected List<Coding> programCode;
        @Child(name="serviced", type={DateType.class, Period.class}, order=11, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Date or dates of Service", formalDefinition="The date or dates when the enclosed suite of services were performed or completed.")
        protected Type serviced;
        @Child(name="place", type={Coding.class}, order=12, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Place of service", formalDefinition="Where the service was provided.")
        protected Coding place;
        @Child(name="quantity", type={SimpleQuantity.class}, order=13, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Count of Products or Services", formalDefinition="The number of repetitions of a service or product.")
        protected SimpleQuantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=14, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Fee, charge or cost per point", formalDefinition="If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=15, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Price scaling factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="points", type={DecimalType.class}, order=16, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Difficulty scaling factor", formalDefinition="An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the good or service delivered. The concept of Points allows for assignment of point values for services and/or goods, such that a monetary amount can be assigned to each point.")
        protected DecimalType points;
        @Child(name="net", type={Money.class}, order=17, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Total item cost", formalDefinition="The quantity times the unit price for an addittional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        protected Money net;
        @Child(name="udi", type={Device.class}, order=18, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Unique Device Identifier", formalDefinition="List of Unique Device Identifiers associated with this line item.")
        protected List<Reference> udi;
        protected List<Device> udiTarget;
        @Child(name="bodySite", type={Coding.class}, order=19, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Service Location", formalDefinition="Physical service site on the patient (limb, tooth, etc).")
        protected Coding bodySite;
        @Child(name="subSite", type={Coding.class}, order=20, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Service Sub-location", formalDefinition="A region or surface of the site, eg. limb region or tooth surface(s).")
        protected List<Coding> subSite;
        @Child(name="noteNumber", type={PositiveIntType.class}, order=21, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="List of note numbers which apply", formalDefinition="A list of note references to the notes provided below.")
        protected List<PositiveIntType> noteNumber;
        @Child(name="adjudication", type={}, order=22, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Adjudication details", formalDefinition="The adjudications results.")
        protected List<ItemAdjudicationComponent> adjudication;
        @Child(name="detail", type={}, order=23, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Additional items", formalDefinition="Second tier of goods and services.")
        protected List<DetailComponent> detail;
        @Child(name="prosthesis", type={}, order=24, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Prosthetic details", formalDefinition="The materials and placement date of prior fixed prosthesis.")
        protected ProsthesisComponent prosthesis;
        private static final long serialVersionUID = 2037926144L;

        public ItemsComponent() {
        }

        public ItemsComponent(PositiveIntType sequence, Coding type, Coding service) {
            this.sequence = sequence;
            this.type = type;
            this.service = service;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public ItemsComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public ItemsComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ItemsComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public Type getProvider() {
            return this.provider;
        }

        public Identifier getProviderIdentifier() throws FHIRException {
            if (!(this.provider instanceof Identifier)) {
                throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.provider.getClass().getName() + " was encountered");
            }
            return (Identifier)this.provider;
        }

        public boolean hasProviderIdentifier() {
            return this.provider instanceof Identifier;
        }

        public Reference getProviderReference() throws FHIRException {
            if (!(this.provider instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.provider.getClass().getName() + " was encountered");
            }
            return (Reference)this.provider;
        }

        public boolean hasProviderReference() {
            return this.provider instanceof Reference;
        }

        public boolean hasProvider() {
            return this.provider != null && !this.provider.isEmpty();
        }

        public ItemsComponent setProvider(Type value) {
            this.provider = value;
            return this;
        }

        public Type getSupervisor() {
            return this.supervisor;
        }

        public Identifier getSupervisorIdentifier() throws FHIRException {
            if (!(this.supervisor instanceof Identifier)) {
                throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.supervisor.getClass().getName() + " was encountered");
            }
            return (Identifier)this.supervisor;
        }

        public boolean hasSupervisorIdentifier() {
            return this.supervisor instanceof Identifier;
        }

        public Reference getSupervisorReference() throws FHIRException {
            if (!(this.supervisor instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.supervisor.getClass().getName() + " was encountered");
            }
            return (Reference)this.supervisor;
        }

        public boolean hasSupervisorReference() {
            return this.supervisor instanceof Reference;
        }

        public boolean hasSupervisor() {
            return this.supervisor != null && !this.supervisor.isEmpty();
        }

        public ItemsComponent setSupervisor(Type value) {
            this.supervisor = value;
            return this;
        }

        public Coding getProviderQualification() {
            if (this.providerQualification == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.providerQualification");
                }
                if (Configuration.doAutoCreate()) {
                    this.providerQualification = new Coding();
                }
            }
            return this.providerQualification;
        }

        public boolean hasProviderQualification() {
            return this.providerQualification != null && !this.providerQualification.isEmpty();
        }

        public ItemsComponent setProviderQualification(Coding value) {
            this.providerQualification = value;
            return this;
        }

        public List<PositiveIntType> getDiagnosisLinkId() {
            if (this.diagnosisLinkId == null) {
                this.diagnosisLinkId = new ArrayList<PositiveIntType>();
            }
            return this.diagnosisLinkId;
        }

        public boolean hasDiagnosisLinkId() {
            if (this.diagnosisLinkId == null) {
                return false;
            }
            for (PositiveIntType item : this.diagnosisLinkId) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addDiagnosisLinkIdElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.diagnosisLinkId == null) {
                this.diagnosisLinkId = new ArrayList<PositiveIntType>();
            }
            this.diagnosisLinkId.add(t);
            return t;
        }

        public ItemsComponent addDiagnosisLinkId(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.diagnosisLinkId == null) {
                this.diagnosisLinkId = new ArrayList<PositiveIntType>();
            }
            this.diagnosisLinkId.add(t);
            return this;
        }

        public boolean hasDiagnosisLinkId(int value) {
            if (this.diagnosisLinkId == null) {
                return false;
            }
            for (PositiveIntType v : this.diagnosisLinkId) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public Coding getService() {
            if (this.service == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.service");
                }
                if (Configuration.doAutoCreate()) {
                    this.service = new Coding();
                }
            }
            return this.service;
        }

        public boolean hasService() {
            return this.service != null && !this.service.isEmpty();
        }

        public ItemsComponent setService(Coding value) {
            this.service = value;
            return this;
        }

        public List<Coding> getServiceModifier() {
            if (this.serviceModifier == null) {
                this.serviceModifier = new ArrayList<Coding>();
            }
            return this.serviceModifier;
        }

        public boolean hasServiceModifier() {
            if (this.serviceModifier == null) {
                return false;
            }
            for (Coding item : this.serviceModifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addServiceModifier() {
            Coding t = new Coding();
            if (this.serviceModifier == null) {
                this.serviceModifier = new ArrayList<Coding>();
            }
            this.serviceModifier.add(t);
            return t;
        }

        public ItemsComponent addServiceModifier(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.serviceModifier == null) {
                this.serviceModifier = new ArrayList<Coding>();
            }
            this.serviceModifier.add(t);
            return this;
        }

        public List<Coding> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<Coding>();
            }
            return this.modifier;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (Coding item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addModifier() {
            Coding t = new Coding();
            if (this.modifier == null) {
                this.modifier = new ArrayList<Coding>();
            }
            this.modifier.add(t);
            return t;
        }

        public ItemsComponent addModifier(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.modifier == null) {
                this.modifier = new ArrayList<Coding>();
            }
            this.modifier.add(t);
            return this;
        }

        public List<Coding> getProgramCode() {
            if (this.programCode == null) {
                this.programCode = new ArrayList<Coding>();
            }
            return this.programCode;
        }

        public boolean hasProgramCode() {
            if (this.programCode == null) {
                return false;
            }
            for (Coding item : this.programCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addProgramCode() {
            Coding t = new Coding();
            if (this.programCode == null) {
                this.programCode = new ArrayList<Coding>();
            }
            this.programCode.add(t);
            return t;
        }

        public ItemsComponent addProgramCode(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.programCode == null) {
                this.programCode = new ArrayList<Coding>();
            }
            this.programCode.add(t);
            return this;
        }

        public Type getServiced() {
            return this.serviced;
        }

        public DateType getServicedDateType() throws FHIRException {
            if (!(this.serviced instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.serviced.getClass().getName() + " was encountered");
            }
            return (DateType)this.serviced;
        }

        public boolean hasServicedDateType() {
            return this.serviced instanceof DateType;
        }

        public Period getServicedPeriod() throws FHIRException {
            if (!(this.serviced instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.serviced.getClass().getName() + " was encountered");
            }
            return (Period)this.serviced;
        }

        public boolean hasServicedPeriod() {
            return this.serviced instanceof Period;
        }

        public boolean hasServiced() {
            return this.serviced != null && !this.serviced.isEmpty();
        }

        public ItemsComponent setServiced(Type value) {
            this.serviced = value;
            return this;
        }

        public Coding getPlace() {
            if (this.place == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.place");
                }
                if (Configuration.doAutoCreate()) {
                    this.place = new Coding();
                }
            }
            return this.place;
        }

        public boolean hasPlace() {
            return this.place != null && !this.place.isEmpty();
        }

        public ItemsComponent setPlace(Coding value) {
            this.place = value;
            return this;
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public ItemsComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public ItemsComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public ItemsComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public ItemsComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public ItemsComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public ItemsComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public DecimalType getPointsElement() {
            if (this.points == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.points");
                }
                if (Configuration.doAutoCreate()) {
                    this.points = new DecimalType();
                }
            }
            return this.points;
        }

        public boolean hasPointsElement() {
            return this.points != null && !this.points.isEmpty();
        }

        public boolean hasPoints() {
            return this.points != null && !this.points.isEmpty();
        }

        public ItemsComponent setPointsElement(DecimalType value) {
            this.points = value;
            return this;
        }

        public BigDecimal getPoints() {
            return this.points == null ? null : (BigDecimal)this.points.getValue();
        }

        public ItemsComponent setPoints(BigDecimal value) {
            if (value == null) {
                this.points = null;
            } else {
                if (this.points == null) {
                    this.points = new DecimalType();
                }
                this.points.setValue(value);
            }
            return this;
        }

        public ItemsComponent setPoints(long value) {
            this.points = new DecimalType();
            this.points.setValue(value);
            return this;
        }

        public ItemsComponent setPoints(double value) {
            this.points = new DecimalType();
            this.points.setValue(value);
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public ItemsComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public List<Reference> getUdi() {
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            return this.udi;
        }

        public boolean hasUdi() {
            if (this.udi == null) {
                return false;
            }
            for (Reference item : this.udi) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addUdi() {
            Reference t = new Reference();
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return t;
        }

        public ItemsComponent addUdi(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return this;
        }

        public List<Device> getUdiTarget() {
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            return this.udiTarget;
        }

        public Device addUdiTarget() {
            Device r = new Device();
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            this.udiTarget.add(r);
            return r;
        }

        public Coding getBodySite() {
            if (this.bodySite == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.bodySite");
                }
                if (Configuration.doAutoCreate()) {
                    this.bodySite = new Coding();
                }
            }
            return this.bodySite;
        }

        public boolean hasBodySite() {
            return this.bodySite != null && !this.bodySite.isEmpty();
        }

        public ItemsComponent setBodySite(Coding value) {
            this.bodySite = value;
            return this;
        }

        public List<Coding> getSubSite() {
            if (this.subSite == null) {
                this.subSite = new ArrayList<Coding>();
            }
            return this.subSite;
        }

        public boolean hasSubSite() {
            if (this.subSite == null) {
                return false;
            }
            for (Coding item : this.subSite) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addSubSite() {
            Coding t = new Coding();
            if (this.subSite == null) {
                this.subSite = new ArrayList<Coding>();
            }
            this.subSite.add(t);
            return t;
        }

        public ItemsComponent addSubSite(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.subSite == null) {
                this.subSite = new ArrayList<Coding>();
            }
            this.subSite.add(t);
            return this;
        }

        public List<PositiveIntType> getNoteNumber() {
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            return this.noteNumber;
        }

        public boolean hasNoteNumber() {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return t;
        }

        public ItemsComponent addNoteNumber(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return this;
        }

        public boolean hasNoteNumber(int value) {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumber) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<ItemAdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<ItemAdjudicationComponent>();
            }
            return this.adjudication;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (ItemAdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ItemAdjudicationComponent addAdjudication() {
            ItemAdjudicationComponent t = new ItemAdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<ItemAdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public ItemsComponent addAdjudication(ItemAdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<ItemAdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public List<DetailComponent> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<DetailComponent>();
            }
            return this.detail;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (DetailComponent item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DetailComponent addDetail() {
            DetailComponent t = new DetailComponent();
            if (this.detail == null) {
                this.detail = new ArrayList<DetailComponent>();
            }
            this.detail.add(t);
            return t;
        }

        public ItemsComponent addDetail(DetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<DetailComponent>();
            }
            this.detail.add(t);
            return this;
        }

        public ProsthesisComponent getProsthesis() {
            if (this.prosthesis == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.prosthesis");
                }
                if (Configuration.doAutoCreate()) {
                    this.prosthesis = new ProsthesisComponent();
                }
            }
            return this.prosthesis;
        }

        public boolean hasProsthesis() {
            return this.prosthesis != null && !this.prosthesis.isEmpty();
        }

        public ItemsComponent setProsthesis(ProsthesisComponent value) {
            this.prosthesis = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("sequence", "positiveInt", "A service line number.", 0, Integer.MAX_VALUE, this.sequence));
            childrenList.add(new Property("type", "Coding", "The type of product or service.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("provider[x]", "Identifier|Reference(Practitioner)", "The practitioner who is responsible for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.provider));
            childrenList.add(new Property("supervisor[x]", "Identifier|Reference(Practitioner)", "The practitioner who is supervising the work of the servicing provider(s).", 0, Integer.MAX_VALUE, this.supervisor));
            childrenList.add(new Property("providerQualification", "Coding", "The qualification which is applicable for this service.", 0, Integer.MAX_VALUE, this.providerQualification));
            childrenList.add(new Property("diagnosisLinkId", "positiveInt", "Diagnosis applicable for this service or product line.", 0, Integer.MAX_VALUE, this.diagnosisLinkId));
            childrenList.add(new Property("service", "Coding", "If a grouping item then 'GROUP' otherwise it is a node therefore a code to indicate the Professional Service or Product supplied.", 0, Integer.MAX_VALUE, this.service));
            childrenList.add(new Property("serviceModifier", "Coding", "Unusual circumstances which may influence adjudication.", 0, Integer.MAX_VALUE, this.serviceModifier));
            childrenList.add(new Property("modifier", "Coding", "Item typification or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or an appliance was lost or stolen.", 0, Integer.MAX_VALUE, this.modifier));
            childrenList.add(new Property("programCode", "Coding", "For programs which require reson codes for the inclusion, covering, of this billed item under the program or sub-program.", 0, Integer.MAX_VALUE, this.programCode));
            childrenList.add(new Property("serviced[x]", "date|Period", "The date or dates when the enclosed suite of services were performed or completed.", 0, Integer.MAX_VALUE, this.serviced));
            childrenList.add(new Property("place", "Coding", "Where the service was provided.", 0, Integer.MAX_VALUE, this.place));
            childrenList.add(new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, Integer.MAX_VALUE, this.quantity));
            childrenList.add(new Property("unitPrice", "Money", "If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.", 0, Integer.MAX_VALUE, this.unitPrice));
            childrenList.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, Integer.MAX_VALUE, this.factor));
            childrenList.add(new Property("points", "decimal", "An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the good or service delivered. The concept of Points allows for assignment of point values for services and/or goods, such that a monetary amount can be assigned to each point.", 0, Integer.MAX_VALUE, this.points));
            childrenList.add(new Property("net", "Money", "The quantity times the unit price for an addittional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, Integer.MAX_VALUE, this.net));
            childrenList.add(new Property("udi", "Reference(Device)", "List of Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi));
            childrenList.add(new Property("bodySite", "Coding", "Physical service site on the patient (limb, tooth, etc).", 0, Integer.MAX_VALUE, this.bodySite));
            childrenList.add(new Property("subSite", "Coding", "A region or surface of the site, eg. limb region or tooth surface(s).", 0, Integer.MAX_VALUE, this.subSite));
            childrenList.add(new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber));
            childrenList.add(new Property("adjudication", "", "The adjudications results.", 0, Integer.MAX_VALUE, this.adjudication));
            childrenList.add(new Property("detail", "", "Second tier of goods and services.", 0, Integer.MAX_VALUE, this.detail));
            childrenList.add(new Property("prosthesis", "", "The materials and placement date of prior fixed prosthesis.", 0, Integer.MAX_VALUE, this.prosthesis));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -987494927: {
                    Base[] baseArray;
                    if (this.provider == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.provider;
                    }
                    return baseArray;
                }
                case -1697229976: {
                    Base[] baseArray;
                    if (this.supervisor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.supervisor;
                    }
                    return baseArray;
                }
                case -1240156290: {
                    Base[] baseArray;
                    if (this.providerQualification == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.providerQualification;
                    }
                    return baseArray;
                }
                case -1659207418: {
                    return this.diagnosisLinkId == null ? new Base[]{} : this.diagnosisLinkId.toArray(new Base[this.diagnosisLinkId.size()]);
                }
                case 1984153269: {
                    Base[] baseArray;
                    if (this.service == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.service;
                    }
                    return baseArray;
                }
                case 615164076: {
                    return this.serviceModifier == null ? new Base[]{} : this.serviceModifier.toArray(new Base[this.serviceModifier.size()]);
                }
                case -615513385: {
                    return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
                }
                case 1010065041: {
                    return this.programCode == null ? new Base[]{} : this.programCode.toArray(new Base[this.programCode.size()]);
                }
                case 1379209295: {
                    Base[] baseArray;
                    if (this.serviced == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.serviced;
                    }
                    return baseArray;
                }
                case 106748167: {
                    Base[] baseArray;
                    if (this.place == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.place;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.factor;
                    }
                    return baseArray;
                }
                case -982754077: {
                    Base[] baseArray;
                    if (this.points == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray13 = new Base[1];
                        baseArray = baseArray13;
                        baseArray13[0] = this.points;
                    }
                    return baseArray;
                }
                case 108957: {
                    Base[] baseArray;
                    if (this.net == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray14 = new Base[1];
                        baseArray = baseArray14;
                        baseArray14[0] = this.net;
                    }
                    return baseArray;
                }
                case 115642: {
                    return this.udi == null ? new Base[]{} : this.udi.toArray(new Base[this.udi.size()]);
                }
                case 1702620169: {
                    Base[] baseArray;
                    if (this.bodySite == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray15 = new Base[1];
                        baseArray = baseArray15;
                        baseArray15[0] = this.bodySite;
                    }
                    return baseArray;
                }
                case -1868566105: {
                    return this.subSite == null ? new Base[]{} : this.subSite.toArray(new Base[this.subSite.size()]);
                }
                case -1110033957: {
                    return this.noteNumber == null ? new Base[]{} : this.noteNumber.toArray(new Base[this.noteNumber.size()]);
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
                case -1335224239: {
                    return this.detail == null ? new Base[]{} : this.detail.toArray(new Base[this.detail.size()]);
                }
                case -2138744398: {
                    Base[] baseArray;
                    if (this.prosthesis == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray16 = new Base[1];
                        baseArray = baseArray16;
                        baseArray16[0] = this.prosthesis;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    break;
                }
                case 3575610: {
                    this.type = this.castToCoding(value);
                    break;
                }
                case -987494927: {
                    this.provider = (Type)value;
                    break;
                }
                case -1697229976: {
                    this.supervisor = (Type)value;
                    break;
                }
                case -1240156290: {
                    this.providerQualification = this.castToCoding(value);
                    break;
                }
                case -1659207418: {
                    this.getDiagnosisLinkId().add(this.castToPositiveInt(value));
                    break;
                }
                case 1984153269: {
                    this.service = this.castToCoding(value);
                    break;
                }
                case 615164076: {
                    this.getServiceModifier().add(this.castToCoding(value));
                    break;
                }
                case -615513385: {
                    this.getModifier().add(this.castToCoding(value));
                    break;
                }
                case 1010065041: {
                    this.getProgramCode().add(this.castToCoding(value));
                    break;
                }
                case 1379209295: {
                    this.serviced = (Type)value;
                    break;
                }
                case 106748167: {
                    this.place = this.castToCoding(value);
                    break;
                }
                case -1285004149: {
                    this.quantity = this.castToSimpleQuantity(value);
                    break;
                }
                case -486196699: {
                    this.unitPrice = this.castToMoney(value);
                    break;
                }
                case -1282148017: {
                    this.factor = this.castToDecimal(value);
                    break;
                }
                case -982754077: {
                    this.points = this.castToDecimal(value);
                    break;
                }
                case 108957: {
                    this.net = this.castToMoney(value);
                    break;
                }
                case 115642: {
                    this.getUdi().add(this.castToReference(value));
                    break;
                }
                case 1702620169: {
                    this.bodySite = this.castToCoding(value);
                    break;
                }
                case -1868566105: {
                    this.getSubSite().add(this.castToCoding(value));
                    break;
                }
                case -1110033957: {
                    this.getNoteNumber().add(this.castToPositiveInt(value));
                    break;
                }
                case -231349275: {
                    this.getAdjudication().add((ItemAdjudicationComponent)value);
                    break;
                }
                case -1335224239: {
                    this.getDetail().add((DetailComponent)value);
                    break;
                }
                case -2138744398: {
                    this.prosthesis = (ProsthesisComponent)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals("provider[x]")) {
                this.provider = (Type)value;
            } else if (name.equals("supervisor[x]")) {
                this.supervisor = (Type)value;
            } else if (name.equals("providerQualification")) {
                this.providerQualification = this.castToCoding(value);
            } else if (name.equals("diagnosisLinkId")) {
                this.getDiagnosisLinkId().add(this.castToPositiveInt(value));
            } else if (name.equals("service")) {
                this.service = this.castToCoding(value);
            } else if (name.equals("serviceModifier")) {
                this.getServiceModifier().add(this.castToCoding(value));
            } else if (name.equals("modifier")) {
                this.getModifier().add(this.castToCoding(value));
            } else if (name.equals("programCode")) {
                this.getProgramCode().add(this.castToCoding(value));
            } else if (name.equals("serviced[x]")) {
                this.serviced = (Type)value;
            } else if (name.equals("place")) {
                this.place = this.castToCoding(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToSimpleQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("points")) {
                this.points = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else if (name.equals("udi")) {
                this.getUdi().add(this.castToReference(value));
            } else if (name.equals("bodySite")) {
                this.bodySite = this.castToCoding(value);
            } else if (name.equals("subSite")) {
                this.getSubSite().add(this.castToCoding(value));
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().add(this.castToPositiveInt(value));
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((ItemAdjudicationComponent)value);
            } else if (name.equals("detail")) {
                this.getDetail().add((DetailComponent)value);
            } else if (name.equals("prosthesis")) {
                this.prosthesis = (ProsthesisComponent)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    throw new FHIRException("Cannot make property sequence as it is not a complex type");
                }
                case 3575610: {
                    return this.getType();
                }
                case 2064698607: {
                    return this.getProvider();
                }
                case -1823115240: {
                    return this.getSupervisor();
                }
                case -1240156290: {
                    return this.getProviderQualification();
                }
                case -1659207418: {
                    throw new FHIRException("Cannot make property diagnosisLinkId as it is not a complex type");
                }
                case 1984153269: {
                    return this.getService();
                }
                case 615164076: {
                    return this.addServiceModifier();
                }
                case -615513385: {
                    return this.addModifier();
                }
                case 1010065041: {
                    return this.addProgramCode();
                }
                case -1927922223: {
                    return this.getServiced();
                }
                case 106748167: {
                    return this.getPlace();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case -1282148017: {
                    throw new FHIRException("Cannot make property factor as it is not a complex type");
                }
                case -982754077: {
                    throw new FHIRException("Cannot make property points as it is not a complex type");
                }
                case 108957: {
                    return this.getNet();
                }
                case 115642: {
                    return this.addUdi();
                }
                case 1702620169: {
                    return this.getBodySite();
                }
                case -1868566105: {
                    return this.addSubSite();
                }
                case -1110033957: {
                    throw new FHIRException("Cannot make property noteNumber as it is not a complex type");
                }
                case -231349275: {
                    return this.addAdjudication();
                }
                case -1335224239: {
                    return this.addDetail();
                }
                case -2138744398: {
                    return this.getProsthesis();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.sequence");
            }
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("providerIdentifier")) {
                this.provider = new Identifier();
                return this.provider;
            }
            if (name.equals("providerReference")) {
                this.provider = new Reference();
                return this.provider;
            }
            if (name.equals("supervisorIdentifier")) {
                this.supervisor = new Identifier();
                return this.supervisor;
            }
            if (name.equals("supervisorReference")) {
                this.supervisor = new Reference();
                return this.supervisor;
            }
            if (name.equals("providerQualification")) {
                this.providerQualification = new Coding();
                return this.providerQualification;
            }
            if (name.equals("diagnosisLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.diagnosisLinkId");
            }
            if (name.equals("service")) {
                this.service = new Coding();
                return this.service;
            }
            if (name.equals("serviceModifier")) {
                return this.addServiceModifier();
            }
            if (name.equals("modifier")) {
                return this.addModifier();
            }
            if (name.equals("programCode")) {
                return this.addProgramCode();
            }
            if (name.equals("servicedDate")) {
                this.serviced = new DateType();
                return this.serviced;
            }
            if (name.equals("servicedPeriod")) {
                this.serviced = new Period();
                return this.serviced;
            }
            if (name.equals("place")) {
                this.place = new Coding();
                return this.place;
            }
            if (name.equals("quantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.factor");
            }
            if (name.equals("points")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.points");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("udi")) {
                return this.addUdi();
            }
            if (name.equals("bodySite")) {
                this.bodySite = new Coding();
                return this.bodySite;
            }
            if (name.equals("subSite")) {
                return this.addSubSite();
            }
            if (name.equals("noteNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.noteNumber");
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            if (name.equals("prosthesis")) {
                this.prosthesis = new ProsthesisComponent();
                return this.prosthesis;
            }
            return super.addChild(name);
        }

        @Override
        public ItemsComponent copy() {
            ItemsComponent dst = new ItemsComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.provider = this.provider == null ? null : this.provider.copy();
            dst.supervisor = this.supervisor == null ? null : this.supervisor.copy();
            Coding coding = dst.providerQualification = this.providerQualification == null ? null : this.providerQualification.copy();
            if (this.diagnosisLinkId != null) {
                dst.diagnosisLinkId = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.diagnosisLinkId) {
                    dst.diagnosisLinkId.add(positiveIntType.copy());
                }
            }
            Coding coding2 = dst.service = this.service == null ? null : this.service.copy();
            if (this.serviceModifier != null) {
                dst.serviceModifier = new ArrayList<Coding>();
                for (Coding coding3 : this.serviceModifier) {
                    dst.serviceModifier.add(coding3.copy());
                }
            }
            if (this.modifier != null) {
                dst.modifier = new ArrayList<Coding>();
                for (Coding coding4 : this.modifier) {
                    dst.modifier.add(coding4.copy());
                }
            }
            if (this.programCode != null) {
                dst.programCode = new ArrayList<Coding>();
                for (Coding coding5 : this.programCode) {
                    dst.programCode.add(coding5.copy());
                }
            }
            dst.serviced = this.serviced == null ? null : this.serviced.copy();
            dst.place = this.place == null ? null : this.place.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            dst.points = this.points == null ? null : this.points.copy();
            Money money = dst.net = this.net == null ? null : this.net.copy();
            if (this.udi != null) {
                dst.udi = new ArrayList<Reference>();
                for (Reference reference : this.udi) {
                    dst.udi.add(reference.copy());
                }
            }
            Coding coding6 = dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
            if (this.subSite != null) {
                dst.subSite = new ArrayList<Coding>();
                for (Coding coding7 : this.subSite) {
                    dst.subSite.add(coding7.copy());
                }
            }
            if (this.noteNumber != null) {
                dst.noteNumber = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.noteNumber) {
                    dst.noteNumber.add(positiveIntType.copy());
                }
            }
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<ItemAdjudicationComponent>();
                for (ItemAdjudicationComponent itemAdjudicationComponent : this.adjudication) {
                    dst.adjudication.add(itemAdjudicationComponent.copy());
                }
            }
            if (this.detail != null) {
                dst.detail = new ArrayList<DetailComponent>();
                for (DetailComponent detailComponent : this.detail) {
                    dst.detail.add(detailComponent.copy());
                }
            }
            dst.prosthesis = this.prosthesis == null ? null : this.prosthesis.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ItemsComponent)) {
                return false;
            }
            ItemsComponent o = (ItemsComponent)other;
            return ItemsComponent.compareDeep(this.sequence, o.sequence, true) && ItemsComponent.compareDeep(this.type, o.type, true) && ItemsComponent.compareDeep(this.provider, o.provider, true) && ItemsComponent.compareDeep(this.supervisor, o.supervisor, true) && ItemsComponent.compareDeep(this.providerQualification, o.providerQualification, true) && ItemsComponent.compareDeep(this.diagnosisLinkId, o.diagnosisLinkId, true) && ItemsComponent.compareDeep(this.service, o.service, true) && ItemsComponent.compareDeep(this.serviceModifier, o.serviceModifier, true) && ItemsComponent.compareDeep(this.modifier, o.modifier, true) && ItemsComponent.compareDeep(this.programCode, o.programCode, true) && ItemsComponent.compareDeep(this.serviced, o.serviced, true) && ItemsComponent.compareDeep(this.place, o.place, true) && ItemsComponent.compareDeep(this.quantity, o.quantity, true) && ItemsComponent.compareDeep(this.unitPrice, o.unitPrice, true) && ItemsComponent.compareDeep(this.factor, o.factor, true) && ItemsComponent.compareDeep(this.points, o.points, true) && ItemsComponent.compareDeep(this.net, o.net, true) && ItemsComponent.compareDeep(this.udi, o.udi, true) && ItemsComponent.compareDeep(this.bodySite, o.bodySite, true) && ItemsComponent.compareDeep(this.subSite, o.subSite, true) && ItemsComponent.compareDeep(this.noteNumber, o.noteNumber, true) && ItemsComponent.compareDeep(this.adjudication, o.adjudication, true) && ItemsComponent.compareDeep(this.detail, o.detail, true) && ItemsComponent.compareDeep(this.prosthesis, o.prosthesis, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ItemsComponent)) {
                return false;
            }
            ItemsComponent o = (ItemsComponent)other;
            return ItemsComponent.compareValues(this.sequence, o.sequence, true) && ItemsComponent.compareValues(this.diagnosisLinkId, o.diagnosisLinkId, true) && ItemsComponent.compareValues(this.factor, o.factor, true) && ItemsComponent.compareValues(this.points, o.points, true) && ItemsComponent.compareValues(this.noteNumber, o.noteNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.sequence != null && !this.sequence.isEmpty() || this.type != null && !this.type.isEmpty() || this.provider != null && !this.provider.isEmpty() || this.supervisor != null && !this.supervisor.isEmpty() || this.providerQualification != null && !this.providerQualification.isEmpty() || this.diagnosisLinkId != null && !this.diagnosisLinkId.isEmpty() || this.service != null && !this.service.isEmpty() || this.serviceModifier != null && !this.serviceModifier.isEmpty() || this.modifier != null && !this.modifier.isEmpty() || this.programCode != null && !this.programCode.isEmpty() || this.serviced != null && !this.serviced.isEmpty() || this.place != null && !this.place.isEmpty() || this.quantity != null && !this.quantity.isEmpty() || this.unitPrice != null && !this.unitPrice.isEmpty() || this.factor != null && !this.factor.isEmpty() || this.points != null && !this.points.isEmpty() || this.net != null && !this.net.isEmpty() || this.udi != null && !this.udi.isEmpty() || this.bodySite != null && !this.bodySite.isEmpty() || this.subSite != null && !this.subSite.isEmpty() || this.noteNumber != null && !this.noteNumber.isEmpty() || this.adjudication != null && !this.adjudication.isEmpty() || this.detail != null && !this.detail.isEmpty() || this.prosthesis != null && !this.prosthesis.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.item";
        }
    }

    @Block
    public static class OnsetComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="time", type={DateType.class, Period.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Illness, injury or treatable condition date", formalDefinition="The start or start and end dates for the treatable condition.")
        protected Type time;
        @Child(name="type", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Onset of what", formalDefinition="Onset typifications eg. Start of pregnancy, start of illnes, etc.")
        protected Coding type;
        private static final long serialVersionUID = -560173231L;

        public Type getTime() {
            return this.time;
        }

        public DateType getTimeDateType() throws FHIRException {
            if (!(this.time instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.time.getClass().getName() + " was encountered");
            }
            return (DateType)this.time;
        }

        public boolean hasTimeDateType() {
            return this.time instanceof DateType;
        }

        public Period getTimePeriod() throws FHIRException {
            if (!(this.time instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.time.getClass().getName() + " was encountered");
            }
            return (Period)this.time;
        }

        public boolean hasTimePeriod() {
            return this.time instanceof Period;
        }

        public boolean hasTime() {
            return this.time != null && !this.time.isEmpty();
        }

        public OnsetComponent setTime(Type value) {
            this.time = value;
            return this;
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OnsetComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public OnsetComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("time[x]", "date|Period", "The start or start and end dates for the treatable condition.", 0, Integer.MAX_VALUE, this.time));
            childrenList.add(new Property("type", "Coding", "Onset typifications eg. Start of pregnancy, start of illnes, etc.", 0, Integer.MAX_VALUE, this.type));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3560141: {
                    Base[] baseArray;
                    if (this.time == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.time;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3560141: {
                    this.time = (Type)value;
                    break;
                }
                case 3575610: {
                    this.type = this.castToCoding(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("time[x]")) {
                this.time = (Type)value;
            } else if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1313930605: {
                    return this.getTime();
                }
                case 3575610: {
                    return this.getType();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("timeDate")) {
                this.time = new DateType();
                return this.time;
            }
            if (name.equals("timePeriod")) {
                this.time = new Period();
                return this.time;
            }
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            return super.addChild(name);
        }

        @Override
        public OnsetComponent copy() {
            OnsetComponent dst = new OnsetComponent();
            this.copyValues(dst);
            dst.time = this.time == null ? null : this.time.copy();
            dst.type = this.type == null ? null : this.type.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof OnsetComponent)) {
                return false;
            }
            OnsetComponent o = (OnsetComponent)other;
            return OnsetComponent.compareDeep(this.time, o.time, true) && OnsetComponent.compareDeep(this.type, o.type, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof OnsetComponent)) {
                return false;
            }
            OnsetComponent o = (OnsetComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.time != null && !this.time.isEmpty() || this.type != null && !this.type.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.onset";
        }
    }

    @Block
    public static class CoverageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="coverage", type={Identifier.class, Coverage.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Insurance information", formalDefinition="Reference to the program or plan identification, underwriter or payor.")
        protected Type coverage;
        @Child(name="preAuthRef", type={StringType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Pre-Authorization/Determination Reference", formalDefinition="A list of references from the Insurer to which these services pertain.")
        protected List<StringType> preAuthRef;
        private static final long serialVersionUID = -21571213L;

        public CoverageComponent() {
        }

        public CoverageComponent(Type coverage) {
            this.coverage = coverage;
        }

        public Type getCoverage() {
            return this.coverage;
        }

        public Identifier getCoverageIdentifier() throws FHIRException {
            if (!(this.coverage instanceof Identifier)) {
                throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.coverage.getClass().getName() + " was encountered");
            }
            return (Identifier)this.coverage;
        }

        public boolean hasCoverageIdentifier() {
            return this.coverage instanceof Identifier;
        }

        public Reference getCoverageReference() throws FHIRException {
            if (!(this.coverage instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.coverage.getClass().getName() + " was encountered");
            }
            return (Reference)this.coverage;
        }

        public boolean hasCoverageReference() {
            return this.coverage instanceof Reference;
        }

        public boolean hasCoverage() {
            return this.coverage != null && !this.coverage.isEmpty();
        }

        public CoverageComponent setCoverage(Type value) {
            this.coverage = value;
            return this;
        }

        public List<StringType> getPreAuthRef() {
            if (this.preAuthRef == null) {
                this.preAuthRef = new ArrayList<StringType>();
            }
            return this.preAuthRef;
        }

        public boolean hasPreAuthRef() {
            if (this.preAuthRef == null) {
                return false;
            }
            for (StringType item : this.preAuthRef) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addPreAuthRefElement() {
            StringType t = new StringType();
            if (this.preAuthRef == null) {
                this.preAuthRef = new ArrayList<StringType>();
            }
            this.preAuthRef.add(t);
            return t;
        }

        public CoverageComponent addPreAuthRef(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.preAuthRef == null) {
                this.preAuthRef = new ArrayList<StringType>();
            }
            this.preAuthRef.add(t);
            return this;
        }

        public boolean hasPreAuthRef(String value) {
            if (this.preAuthRef == null) {
                return false;
            }
            for (StringType v : this.preAuthRef) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("coverage[x]", "Identifier|Reference(Coverage)", "Reference to the program or plan identification, underwriter or payor.", 0, Integer.MAX_VALUE, this.coverage));
            childrenList.add(new Property("preAuthRef", "string", "A list of references from the Insurer to which these services pertain.", 0, Integer.MAX_VALUE, this.preAuthRef));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -351767064: {
                    Base[] baseArray;
                    if (this.coverage == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.coverage;
                    }
                    return baseArray;
                }
                case 522246568: {
                    return this.preAuthRef == null ? new Base[]{} : this.preAuthRef.toArray(new Base[this.preAuthRef.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -351767064: {
                    this.coverage = (Type)value;
                    break;
                }
                case 522246568: {
                    this.getPreAuthRef().add(this.castToString(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("coverage[x]")) {
                this.coverage = (Type)value;
            } else if (name.equals("preAuthRef")) {
                this.getPreAuthRef().add(this.castToString(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 227689880: {
                    return this.getCoverage();
                }
                case 522246568: {
                    throw new FHIRException("Cannot make property preAuthRef as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("coverageIdentifier")) {
                this.coverage = new Identifier();
                return this.coverage;
            }
            if (name.equals("coverageReference")) {
                this.coverage = new Reference();
                return this.coverage;
            }
            if (name.equals("preAuthRef")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.preAuthRef");
            }
            return super.addChild(name);
        }

        @Override
        public CoverageComponent copy() {
            CoverageComponent dst = new CoverageComponent();
            this.copyValues(dst);
            Type type = dst.coverage = this.coverage == null ? null : this.coverage.copy();
            if (this.preAuthRef != null) {
                dst.preAuthRef = new ArrayList<StringType>();
                for (StringType i : this.preAuthRef) {
                    dst.preAuthRef.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof CoverageComponent)) {
                return false;
            }
            CoverageComponent o = (CoverageComponent)other;
            return CoverageComponent.compareDeep(this.coverage, o.coverage, true) && CoverageComponent.compareDeep(this.preAuthRef, o.preAuthRef, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof CoverageComponent)) {
                return false;
            }
            CoverageComponent o = (CoverageComponent)other;
            return CoverageComponent.compareValues(this.preAuthRef, o.preAuthRef, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.coverage != null && !this.coverage.isEmpty() || this.preAuthRef != null && !this.preAuthRef.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.coverage";
        }
    }

    @Block
    public static class ProcedureComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Procedure sequence for reference", formalDefinition="Sequence of procedures which serves to order and provide a link.")
        protected PositiveIntType sequence;
        @Child(name="date", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="When the procedure was performed", formalDefinition="Date and optionally time the procedure was performed .")
        protected DateTimeType date;
        @Child(name="procedure", type={Coding.class, Procedure.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Patient's list of procedures performed", formalDefinition="The procedure code.")
        protected Type procedure;
        private static final long serialVersionUID = 864307347L;

        public ProcedureComponent() {
        }

        public ProcedureComponent(PositiveIntType sequence, Type procedure) {
            this.sequence = sequence;
            this.procedure = procedure;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedureComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public ProcedureComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public ProcedureComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public DateTimeType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedureComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateTimeType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public ProcedureComponent setDateElement(DateTimeType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public ProcedureComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateTimeType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        public Type getProcedure() {
            return this.procedure;
        }

        public Coding getProcedureCoding() throws FHIRException {
            if (!(this.procedure instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.procedure.getClass().getName() + " was encountered");
            }
            return (Coding)this.procedure;
        }

        public boolean hasProcedureCoding() {
            return this.procedure instanceof Coding;
        }

        public Reference getProcedureReference() throws FHIRException {
            if (!(this.procedure instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.procedure.getClass().getName() + " was encountered");
            }
            return (Reference)this.procedure;
        }

        public boolean hasProcedureReference() {
            return this.procedure instanceof Reference;
        }

        public boolean hasProcedure() {
            return this.procedure != null && !this.procedure.isEmpty();
        }

        public ProcedureComponent setProcedure(Type value) {
            this.procedure = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("sequence", "positiveInt", "Sequence of procedures which serves to order and provide a link.", 0, Integer.MAX_VALUE, this.sequence));
            childrenList.add(new Property("date", "dateTime", "Date and optionally time the procedure was performed .", 0, Integer.MAX_VALUE, this.date));
            childrenList.add(new Property("procedure[x]", "Coding|Reference(Procedure)", "The procedure code.", 0, Integer.MAX_VALUE, this.procedure));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.date;
                    }
                    return baseArray;
                }
                case -1095204141: {
                    Base[] baseArray;
                    if (this.procedure == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.procedure;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    break;
                }
                case 3076014: {
                    this.date = this.castToDateTime(value);
                    break;
                }
                case -1095204141: {
                    this.procedure = (Type)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("date")) {
                this.date = this.castToDateTime(value);
            } else if (name.equals("procedure[x]")) {
                this.procedure = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    throw new FHIRException("Cannot make property sequence as it is not a complex type");
                }
                case 3076014: {
                    throw new FHIRException("Cannot make property date as it is not a complex type");
                }
                case 1640074445: {
                    return this.getProcedure();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.sequence");
            }
            if (name.equals("date")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.date");
            }
            if (name.equals("procedureCoding")) {
                this.procedure = new Coding();
                return this.procedure;
            }
            if (name.equals("procedureReference")) {
                this.procedure = new Reference();
                return this.procedure;
            }
            return super.addChild(name);
        }

        @Override
        public ProcedureComponent copy() {
            ProcedureComponent dst = new ProcedureComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.date = this.date == null ? null : this.date.copy();
            dst.procedure = this.procedure == null ? null : this.procedure.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ProcedureComponent)) {
                return false;
            }
            ProcedureComponent o = (ProcedureComponent)other;
            return ProcedureComponent.compareDeep(this.sequence, o.sequence, true) && ProcedureComponent.compareDeep(this.date, o.date, true) && ProcedureComponent.compareDeep(this.procedure, o.procedure, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ProcedureComponent)) {
                return false;
            }
            ProcedureComponent o = (ProcedureComponent)other;
            return ProcedureComponent.compareValues(this.sequence, o.sequence, true) && ProcedureComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.sequence != null && !this.sequence.isEmpty() || this.date != null && !this.date.isEmpty() || this.procedure != null && !this.procedure.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.procedure";
        }
    }

    @Block
    public static class DiagnosisComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Number to covey order of diagnosis", formalDefinition="Sequence of diagnosis which serves to order and provide a link.")
        protected PositiveIntType sequence;
        @Child(name="diagnosis", type={Coding.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Patient's list of diagnosis", formalDefinition="The diagnosis.")
        protected Coding diagnosis;
        private static final long serialVersionUID = -795010186L;

        public DiagnosisComponent() {
        }

        public DiagnosisComponent(PositiveIntType sequence, Coding diagnosis) {
            this.sequence = sequence;
            this.diagnosis = diagnosis;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosisComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public DiagnosisComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public DiagnosisComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public Coding getDiagnosis() {
            if (this.diagnosis == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosisComponent.diagnosis");
                }
                if (Configuration.doAutoCreate()) {
                    this.diagnosis = new Coding();
                }
            }
            return this.diagnosis;
        }

        public boolean hasDiagnosis() {
            return this.diagnosis != null && !this.diagnosis.isEmpty();
        }

        public DiagnosisComponent setDiagnosis(Coding value) {
            this.diagnosis = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("sequence", "positiveInt", "Sequence of diagnosis which serves to order and provide a link.", 0, Integer.MAX_VALUE, this.sequence));
            childrenList.add(new Property("diagnosis", "Coding", "The diagnosis.", 0, Integer.MAX_VALUE, this.diagnosis));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 1196993265: {
                    Base[] baseArray;
                    if (this.diagnosis == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.diagnosis;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    break;
                }
                case 1196993265: {
                    this.diagnosis = this.castToCoding(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("diagnosis")) {
                this.diagnosis = this.castToCoding(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    throw new FHIRException("Cannot make property sequence as it is not a complex type");
                }
                case 1196993265: {
                    return this.getDiagnosis();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.sequence");
            }
            if (name.equals("diagnosis")) {
                this.diagnosis = new Coding();
                return this.diagnosis;
            }
            return super.addChild(name);
        }

        @Override
        public DiagnosisComponent copy() {
            DiagnosisComponent dst = new DiagnosisComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.diagnosis = this.diagnosis == null ? null : this.diagnosis.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DiagnosisComponent)) {
                return false;
            }
            DiagnosisComponent o = (DiagnosisComponent)other;
            return DiagnosisComponent.compareDeep(this.sequence, o.sequence, true) && DiagnosisComponent.compareDeep(this.diagnosis, o.diagnosis, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DiagnosisComponent)) {
                return false;
            }
            DiagnosisComponent o = (DiagnosisComponent)other;
            return DiagnosisComponent.compareValues(this.sequence, o.sequence, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.sequence != null && !this.sequence.isEmpty() || this.diagnosis != null && !this.diagnosis.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.diagnosis";
        }
    }

    @Block
    public static class PayeeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={Coding.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of party: Subscriber, Provider, other", formalDefinition="Type of Party to be reimbursed: Subscriber, provider, other.")
        protected Coding type;
        @Child(name="party", type={Identifier.class, Practitioner.class, Organization.class, Patient.class, RelatedPerson.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Party to receive the payable", formalDefinition="Party to be reimbursed: Subscriber, provider, other.")
        protected Type party;
        private static final long serialVersionUID = 1304353420L;

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PayeeComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PayeeComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public Type getParty() {
            return this.party;
        }

        public Identifier getPartyIdentifier() throws FHIRException {
            if (!(this.party instanceof Identifier)) {
                throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.party.getClass().getName() + " was encountered");
            }
            return (Identifier)this.party;
        }

        public boolean hasPartyIdentifier() {
            return this.party instanceof Identifier;
        }

        public Reference getPartyReference() throws FHIRException {
            if (!(this.party instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.party.getClass().getName() + " was encountered");
            }
            return (Reference)this.party;
        }

        public boolean hasPartyReference() {
            return this.party instanceof Reference;
        }

        public boolean hasParty() {
            return this.party != null && !this.party.isEmpty();
        }

        public PayeeComponent setParty(Type value) {
            this.party = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "Coding", "Type of Party to be reimbursed: Subscriber, provider, other.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("party[x]", "Identifier|Reference(Practitioner|Organization|Patient|RelatedPerson)", "Party to be reimbursed: Subscriber, provider, other.", 0, Integer.MAX_VALUE, this.party));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 106437350: {
                    Base[] baseArray;
                    if (this.party == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.party;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCoding(value);
                    break;
                }
                case 106437350: {
                    this.party = (Type)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals("party[x]")) {
                this.party = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 1189320666: {
                    return this.getParty();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("partyIdentifier")) {
                this.party = new Identifier();
                return this.party;
            }
            if (name.equals("partyReference")) {
                this.party = new Reference();
                return this.party;
            }
            return super.addChild(name);
        }

        @Override
        public PayeeComponent copy() {
            PayeeComponent dst = new PayeeComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.party = this.party == null ? null : this.party.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof PayeeComponent)) {
                return false;
            }
            PayeeComponent o = (PayeeComponent)other;
            return PayeeComponent.compareDeep(this.type, o.type, true) && PayeeComponent.compareDeep(this.party, o.party, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof PayeeComponent)) {
                return false;
            }
            PayeeComponent o = (PayeeComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.party != null && !this.party.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.payee";
        }
    }

    @Block
    public static class RelatedClaimsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="claim", type={Identifier.class, Claim.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference to the related claim", formalDefinition="Other claims which are related to this claim such as prior claim versions or for related services.")
        protected Type claim;
        @Child(name="relationship", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="How the reference claim is related", formalDefinition="For example prior or umbrella.")
        protected Coding relationship;
        @Child(name="reference", type={Identifier.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Related file or case reference", formalDefinition="An alternate organizational reference to the case or file to which this particular claim pertains - eg Property/Casualy insurer claim # or Workers Compensation case # .")
        protected Identifier reference;
        private static final long serialVersionUID = -2033217402L;

        public Type getClaim() {
            return this.claim;
        }

        public Identifier getClaimIdentifier() throws FHIRException {
            if (!(this.claim instanceof Identifier)) {
                throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.claim.getClass().getName() + " was encountered");
            }
            return (Identifier)this.claim;
        }

        public boolean hasClaimIdentifier() {
            return this.claim instanceof Identifier;
        }

        public Reference getClaimReference() throws FHIRException {
            if (!(this.claim instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.claim.getClass().getName() + " was encountered");
            }
            return (Reference)this.claim;
        }

        public boolean hasClaimReference() {
            return this.claim instanceof Reference;
        }

        public boolean hasClaim() {
            return this.claim != null && !this.claim.isEmpty();
        }

        public RelatedClaimsComponent setClaim(Type value) {
            this.claim = value;
            return this;
        }

        public Coding getRelationship() {
            if (this.relationship == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RelatedClaimsComponent.relationship");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationship = new Coding();
                }
            }
            return this.relationship;
        }

        public boolean hasRelationship() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public RelatedClaimsComponent setRelationship(Coding value) {
            this.relationship = value;
            return this;
        }

        public Identifier getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RelatedClaimsComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Identifier();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public RelatedClaimsComponent setReference(Identifier value) {
            this.reference = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("claim[x]", "Identifier|Reference(Claim)", "Other claims which are related to this claim such as prior claim versions or for related services.", 0, Integer.MAX_VALUE, this.claim));
            childrenList.add(new Property("relationship", "Coding", "For example prior or umbrella.", 0, Integer.MAX_VALUE, this.relationship));
            childrenList.add(new Property("reference", "Identifier", "An alternate organizational reference to the case or file to which this particular claim pertains - eg Property/Casualy insurer claim # or Workers Compensation case # .", 0, Integer.MAX_VALUE, this.reference));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 94742588: {
                    Base[] baseArray;
                    if (this.claim == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.claim;
                    }
                    return baseArray;
                }
                case -261851592: {
                    Base[] baseArray;
                    if (this.relationship == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.relationship;
                    }
                    return baseArray;
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.reference;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 94742588: {
                    this.claim = (Type)value;
                    break;
                }
                case -261851592: {
                    this.relationship = this.castToCoding(value);
                    break;
                }
                case -925155509: {
                    this.reference = this.castToIdentifier(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("claim[x]")) {
                this.claim = (Type)value;
            } else if (name.equals("relationship")) {
                this.relationship = this.castToCoding(value);
            } else if (name.equals("reference")) {
                this.reference = this.castToIdentifier(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 683016900: {
                    return this.getClaim();
                }
                case -261851592: {
                    return this.getRelationship();
                }
                case -925155509: {
                    return this.getReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("claimIdentifier")) {
                this.claim = new Identifier();
                return this.claim;
            }
            if (name.equals("claimReference")) {
                this.claim = new Reference();
                return this.claim;
            }
            if (name.equals("relationship")) {
                this.relationship = new Coding();
                return this.relationship;
            }
            if (name.equals("reference")) {
                this.reference = new Identifier();
                return this.reference;
            }
            return super.addChild(name);
        }

        @Override
        public RelatedClaimsComponent copy() {
            RelatedClaimsComponent dst = new RelatedClaimsComponent();
            this.copyValues(dst);
            dst.claim = this.claim == null ? null : this.claim.copy();
            dst.relationship = this.relationship == null ? null : this.relationship.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof RelatedClaimsComponent)) {
                return false;
            }
            RelatedClaimsComponent o = (RelatedClaimsComponent)other;
            return RelatedClaimsComponent.compareDeep(this.claim, o.claim, true) && RelatedClaimsComponent.compareDeep(this.relationship, o.relationship, true) && RelatedClaimsComponent.compareDeep(this.reference, o.reference, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof RelatedClaimsComponent)) {
                return false;
            }
            RelatedClaimsComponent o = (RelatedClaimsComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.claim != null && !this.claim.isEmpty() || this.relationship != null && !this.relationship.isEmpty() || this.reference != null && !this.reference.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.related";
        }
    }
}

