/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.IntegerType;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UnsignedIntType;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="CodeSystem", profile="http://hl7.org/fhir/Profile/CodeSystem")
public class CodeSystem
extends DomainResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Globally unique logical identifier for  code system (Coding.system)", formalDefinition="An absolute URL that is used to identify this code system when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this code system is (or will be) published. This is used in [Coding]{datatypes.html#Coding}.system.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the code system (e.g. HL7 v2 / CDA)", formalDefinition="Formal identifier that is used to identify this code system when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected Identifier identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Logical identifier for this version (Coding.version)", formalDefinition="Used to identify this version of the code system when it is referenced in a specification, model, design or instance (e.g. Coding.version). This is an arbitrary value managed by the profile author manually and the value should be a timestamp. This is used in [Coding]{datatypes.html#Coding}.version.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Informal name for this code system", formalDefinition="A free text natural language name describing the code system.")
    protected StringType name;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired", formalDefinition="The status of the code system.")
    protected Enumeration<Enumerations.ConformanceResourceStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If for testing purposes, not real usage", formalDefinition="This CodeSystem was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="publisher", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (organization or individual)", formalDefinition="The name of the individual or organization that published the code system.")
    protected StringType publisher;
    @Child(name="contact", type={}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details of the publisher", formalDefinition="Contacts to assist a user in finding and communicating with the publisher.")
    protected List<CodeSystemContactComponent> contact;
    @Child(name="date", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date for given status", formalDefinition="The date that the code system status was last changed. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the implementation guide changes (e.g. the 'content logical definition').")
    protected DateTimeType date;
    @Child(name="description", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human language description of the code system", formalDefinition="A free text natural language description of the use of the code system - reason for definition, \"the semantic space\" to be included in the code system, conditions of use, etc. The description may include a list of expected usages for the code system and can also describe the approach taken to build the code system.")
    protected StringType description;
    @Child(name="useContext", type={CodeableConcept.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Content intends to support these contexts", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of code system definitions.")
    protected List<CodeableConcept> useContext;
    @Child(name="requirements", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why needed", formalDefinition="Explains why this code system is needed and why it has been constrained as it has.")
    protected StringType requirements;
    @Child(name="copyright", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the code system and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the code system.")
    protected StringType copyright;
    @Child(name="caseSensitive", type={BooleanType.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If code comparison is case sensitive", formalDefinition="If code comparison is case sensitive when codes within this system are compared to each other.")
    protected BooleanType caseSensitive;
    @Child(name="valueSet", type={UriType.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical URL for value set with entire code system", formalDefinition="Canonical URL of value set that contains the entire code system.")
    protected UriType valueSet;
    @Child(name="compositional", type={BooleanType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If code system defines a post-composition grammar", formalDefinition="True If code system defines a post-composition grammar.")
    protected BooleanType compositional;
    @Child(name="versionNeeded", type={BooleanType.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If definitions are not stable", formalDefinition="This flag is used to signify that the code system has not (or does not) maintain the definitions, and a version must be specified when referencing this code system.")
    protected BooleanType versionNeeded;
    @Child(name="content", type={CodeType.class}, order=17, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="not-present | examplar | fragment | complete", formalDefinition="How much of the content of the code system - the concepts and codes it defines - are represented in this resource.")
    protected Enumeration<CodeSystemContentMode> content;
    @Child(name="count", type={UnsignedIntType.class}, order=18, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Total concepts in the code system", formalDefinition="The total number of concepts defined by the code system. Where the code system has a compositional grammar, the count refers to the number of base (primitive) concepts.")
    protected UnsignedIntType count;
    @Child(name="filter", type={}, order=19, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Filter that can be used in a value set", formalDefinition="A filter that can be used in a value set compose statement when selecting concepts using a filter.")
    protected List<CodeSystemFilterComponent> filter;
    @Child(name="property", type={}, order=20, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional information supplied about each concept", formalDefinition="A property defines an additional slot through which additional information can be provided about a concept.")
    protected List<CodeSystemPropertyComponent> property;
    @Child(name="concept", type={}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Concepts in the code system", formalDefinition="Concepts that are in the code system. The concept definitions are inherently hierarchical, but the definitions must be consulted to determine what the meaning of the hierarchical relationships are.")
    protected List<ConceptDefinitionComponent> concept;
    private static final long serialVersionUID = 1466696062L;
    @SearchParamDefinition(name="content", path="CodeSystem.content", description="not-present | examplar | fragment | complete", type="token")
    public static final String SP_CONTENT = "content";
    public static final TokenClientParam CONTENT = new TokenClientParam("content");
    @SearchParamDefinition(name="system", path="CodeSystem.url", description="The system for any codes defined by this code system (same as 'url')", type="uri")
    public static final String SP_SYSTEM = "system";
    public static final UriClientParam SYSTEM = new UriClientParam("system");
    @SearchParamDefinition(name="status", path="CodeSystem.status", description="The status of the code system", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="description", path="CodeSystem.description", description="Text search in the description of the code system", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="name", path="CodeSystem.name", description="The name of the code system", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="context", path="CodeSystem.useContext", description="A use context assigned to the code system", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="language", path="CodeSystem.concept.designation.language", description="A language in which a designation is provided", type="token")
    public static final String SP_LANGUAGE = "language";
    public static final TokenClientParam LANGUAGE = new TokenClientParam("language");
    @SearchParamDefinition(name="code", path="CodeSystem.concept.code", description="A code defined in the code system", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="date", path="CodeSystem.date", description="The code system publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="CodeSystem.identifier", description="The identifier for the code system", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="url", path="CodeSystem.url", description="The logical URL for the code system", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="publisher", path="CodeSystem.publisher", description="Name of the publisher of the code system", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="version", path="CodeSystem.version", description="The version identifier of the code system", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");

    public CodeSystem() {
    }

    public CodeSystem(Enumeration<Enumerations.ConformanceResourceStatus> status, Enumeration<CodeSystemContentMode> content) {
        this.status = status;
        this.content = content;
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public CodeSystem setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public CodeSystem setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public CodeSystem setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public CodeSystem setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public CodeSystem setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public CodeSystem setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public CodeSystem setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public Enumeration<Enumerations.ConformanceResourceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public CodeSystem setStatusElement(Enumeration<Enumerations.ConformanceResourceStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.ConformanceResourceStatus getStatus() {
        return this.status == null ? null : (Enumerations.ConformanceResourceStatus)((Object)this.status.getValue());
    }

    public CodeSystem setStatus(Enumerations.ConformanceResourceStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public CodeSystem setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    public CodeSystem setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public CodeSystem setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    public CodeSystem setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    public List<CodeSystemContactComponent> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<CodeSystemContactComponent>();
        }
        return this.contact;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (CodeSystemContactComponent item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeSystemContactComponent addContact() {
        CodeSystemContactComponent t = new CodeSystemContactComponent();
        if (this.contact == null) {
            this.contact = new ArrayList<CodeSystemContactComponent>();
        }
        this.contact.add(t);
        return t;
    }

    public CodeSystem addContact(CodeSystemContactComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<CodeSystemContactComponent>();
        }
        this.contact.add(t);
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public CodeSystem setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public CodeSystem setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public CodeSystem setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public CodeSystem setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        return this.useContext;
    }

    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (CodeableConcept item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addUseContext() {
        CodeableConcept t = new CodeableConcept();
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        this.useContext.add(t);
        return t;
    }

    public CodeSystem addUseContext(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        this.useContext.add(t);
        return this;
    }

    public StringType getRequirementsElement() {
        if (this.requirements == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.requirements");
            }
            if (Configuration.doAutoCreate()) {
                this.requirements = new StringType();
            }
        }
        return this.requirements;
    }

    public boolean hasRequirementsElement() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public boolean hasRequirements() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public CodeSystem setRequirementsElement(StringType value) {
        this.requirements = value;
        return this;
    }

    public String getRequirements() {
        return this.requirements == null ? null : (String)this.requirements.getValue();
    }

    public CodeSystem setRequirements(String value) {
        if (Utilities.noString((String)value)) {
            this.requirements = null;
        } else {
            if (this.requirements == null) {
                this.requirements = new StringType();
            }
            this.requirements.setValue(value);
        }
        return this;
    }

    public StringType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new StringType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public CodeSystem setCopyrightElement(StringType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public CodeSystem setCopyright(String value) {
        if (Utilities.noString((String)value)) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new StringType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public BooleanType getCaseSensitiveElement() {
        if (this.caseSensitive == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.caseSensitive");
            }
            if (Configuration.doAutoCreate()) {
                this.caseSensitive = new BooleanType();
            }
        }
        return this.caseSensitive;
    }

    public boolean hasCaseSensitiveElement() {
        return this.caseSensitive != null && !this.caseSensitive.isEmpty();
    }

    public boolean hasCaseSensitive() {
        return this.caseSensitive != null && !this.caseSensitive.isEmpty();
    }

    public CodeSystem setCaseSensitiveElement(BooleanType value) {
        this.caseSensitive = value;
        return this;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive == null || this.caseSensitive.isEmpty() ? false : (Boolean)this.caseSensitive.getValue();
    }

    public CodeSystem setCaseSensitive(boolean value) {
        if (this.caseSensitive == null) {
            this.caseSensitive = new BooleanType();
        }
        this.caseSensitive.setValue((Object)value);
        return this;
    }

    public UriType getValueSetElement() {
        if (this.valueSet == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.valueSet");
            }
            if (Configuration.doAutoCreate()) {
                this.valueSet = new UriType();
            }
        }
        return this.valueSet;
    }

    public boolean hasValueSetElement() {
        return this.valueSet != null && !this.valueSet.isEmpty();
    }

    public boolean hasValueSet() {
        return this.valueSet != null && !this.valueSet.isEmpty();
    }

    public CodeSystem setValueSetElement(UriType value) {
        this.valueSet = value;
        return this;
    }

    public String getValueSet() {
        return this.valueSet == null ? null : (String)this.valueSet.getValue();
    }

    public CodeSystem setValueSet(String value) {
        if (Utilities.noString((String)value)) {
            this.valueSet = null;
        } else {
            if (this.valueSet == null) {
                this.valueSet = new UriType();
            }
            this.valueSet.setValue(value);
        }
        return this;
    }

    public BooleanType getCompositionalElement() {
        if (this.compositional == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.compositional");
            }
            if (Configuration.doAutoCreate()) {
                this.compositional = new BooleanType();
            }
        }
        return this.compositional;
    }

    public boolean hasCompositionalElement() {
        return this.compositional != null && !this.compositional.isEmpty();
    }

    public boolean hasCompositional() {
        return this.compositional != null && !this.compositional.isEmpty();
    }

    public CodeSystem setCompositionalElement(BooleanType value) {
        this.compositional = value;
        return this;
    }

    public boolean getCompositional() {
        return this.compositional == null || this.compositional.isEmpty() ? false : (Boolean)this.compositional.getValue();
    }

    public CodeSystem setCompositional(boolean value) {
        if (this.compositional == null) {
            this.compositional = new BooleanType();
        }
        this.compositional.setValue((Object)value);
        return this;
    }

    public BooleanType getVersionNeededElement() {
        if (this.versionNeeded == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.versionNeeded");
            }
            if (Configuration.doAutoCreate()) {
                this.versionNeeded = new BooleanType();
            }
        }
        return this.versionNeeded;
    }

    public boolean hasVersionNeededElement() {
        return this.versionNeeded != null && !this.versionNeeded.isEmpty();
    }

    public boolean hasVersionNeeded() {
        return this.versionNeeded != null && !this.versionNeeded.isEmpty();
    }

    public CodeSystem setVersionNeededElement(BooleanType value) {
        this.versionNeeded = value;
        return this;
    }

    public boolean getVersionNeeded() {
        return this.versionNeeded == null || this.versionNeeded.isEmpty() ? false : (Boolean)this.versionNeeded.getValue();
    }

    public CodeSystem setVersionNeeded(boolean value) {
        if (this.versionNeeded == null) {
            this.versionNeeded = new BooleanType();
        }
        this.versionNeeded.setValue((Object)value);
        return this;
    }

    public Enumeration<CodeSystemContentMode> getContentElement() {
        if (this.content == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.content");
            }
            if (Configuration.doAutoCreate()) {
                this.content = new Enumeration<CodeSystemContentMode>(new CodeSystemContentModeEnumFactory());
            }
        }
        return this.content;
    }

    public boolean hasContentElement() {
        return this.content != null && !this.content.isEmpty();
    }

    public boolean hasContent() {
        return this.content != null && !this.content.isEmpty();
    }

    public CodeSystem setContentElement(Enumeration<CodeSystemContentMode> value) {
        this.content = value;
        return this;
    }

    public CodeSystemContentMode getContent() {
        return this.content == null ? null : (CodeSystemContentMode)((Object)this.content.getValue());
    }

    public CodeSystem setContent(CodeSystemContentMode value) {
        if (this.content == null) {
            this.content = new Enumeration<CodeSystemContentMode>(new CodeSystemContentModeEnumFactory());
        }
        this.content.setValue((Object)value);
        return this;
    }

    public UnsignedIntType getCountElement() {
        if (this.count == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.count");
            }
            if (Configuration.doAutoCreate()) {
                this.count = new UnsignedIntType();
            }
        }
        return this.count;
    }

    public boolean hasCountElement() {
        return this.count != null && !this.count.isEmpty();
    }

    public boolean hasCount() {
        return this.count != null && !this.count.isEmpty();
    }

    public CodeSystem setCountElement(UnsignedIntType value) {
        this.count = value;
        return this;
    }

    public int getCount() {
        return this.count == null || this.count.isEmpty() ? 0 : (Integer)this.count.getValue();
    }

    public CodeSystem setCount(int value) {
        if (this.count == null) {
            this.count = new UnsignedIntType();
        }
        this.count.setValue((Object)value);
        return this;
    }

    public List<CodeSystemFilterComponent> getFilter() {
        if (this.filter == null) {
            this.filter = new ArrayList<CodeSystemFilterComponent>();
        }
        return this.filter;
    }

    public boolean hasFilter() {
        if (this.filter == null) {
            return false;
        }
        for (CodeSystemFilterComponent item : this.filter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeSystemFilterComponent addFilter() {
        CodeSystemFilterComponent t = new CodeSystemFilterComponent();
        if (this.filter == null) {
            this.filter = new ArrayList<CodeSystemFilterComponent>();
        }
        this.filter.add(t);
        return t;
    }

    public CodeSystem addFilter(CodeSystemFilterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.filter == null) {
            this.filter = new ArrayList<CodeSystemFilterComponent>();
        }
        this.filter.add(t);
        return this;
    }

    public List<CodeSystemPropertyComponent> getProperty() {
        if (this.property == null) {
            this.property = new ArrayList<CodeSystemPropertyComponent>();
        }
        return this.property;
    }

    public boolean hasProperty() {
        if (this.property == null) {
            return false;
        }
        for (CodeSystemPropertyComponent item : this.property) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeSystemPropertyComponent addProperty() {
        CodeSystemPropertyComponent t = new CodeSystemPropertyComponent();
        if (this.property == null) {
            this.property = new ArrayList<CodeSystemPropertyComponent>();
        }
        this.property.add(t);
        return t;
    }

    public CodeSystem addProperty(CodeSystemPropertyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.property == null) {
            this.property = new ArrayList<CodeSystemPropertyComponent>();
        }
        this.property.add(t);
        return this;
    }

    public List<ConceptDefinitionComponent> getConcept() {
        if (this.concept == null) {
            this.concept = new ArrayList<ConceptDefinitionComponent>();
        }
        return this.concept;
    }

    public boolean hasConcept() {
        if (this.concept == null) {
            return false;
        }
        for (ConceptDefinitionComponent item : this.concept) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConceptDefinitionComponent addConcept() {
        ConceptDefinitionComponent t = new ConceptDefinitionComponent();
        if (this.concept == null) {
            this.concept = new ArrayList<ConceptDefinitionComponent>();
        }
        this.concept.add(t);
        return t;
    }

    public CodeSystem addConcept(ConceptDefinitionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.concept == null) {
            this.concept = new ArrayList<ConceptDefinitionComponent>();
        }
        this.concept.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_URL, "uri", "An absolute URL that is used to identify this code system when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this code system is (or will be) published. This is used in [Coding]{datatypes.html#Coding}.system.", 0, Integer.MAX_VALUE, this.url));
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Formal identifier that is used to identify this code system when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_VERSION, "string", "Used to identify this version of the code system when it is referenced in a specification, model, design or instance (e.g. Coding.version). This is an arbitrary value managed by the profile author manually and the value should be a timestamp. This is used in [Coding]{datatypes.html#Coding}.version.", 0, Integer.MAX_VALUE, this.version));
        childrenList.add(new Property(SP_NAME, "string", "A free text natural language name describing the code system.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property(SP_STATUS, SP_CODE, "The status of the code system.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("experimental", "boolean", "This CodeSystem was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, Integer.MAX_VALUE, this.experimental));
        childrenList.add(new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the code system.", 0, Integer.MAX_VALUE, this.publisher));
        childrenList.add(new Property("contact", "", "Contacts to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        childrenList.add(new Property(SP_DATE, "dateTime", "The date that the code system status was last changed. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the implementation guide changes (e.g. the 'content logical definition').", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property(SP_DESCRIPTION, "string", "A free text natural language description of the use of the code system - reason for definition, \"the semantic space\" to be included in the code system, conditions of use, etc. The description may include a list of expected usages for the code system and can also describe the approach taken to build the code system.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("useContext", "CodeableConcept", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of code system definitions.", 0, Integer.MAX_VALUE, this.useContext));
        childrenList.add(new Property("requirements", "string", "Explains why this code system is needed and why it has been constrained as it has.", 0, Integer.MAX_VALUE, this.requirements));
        childrenList.add(new Property("copyright", "string", "A copyright statement relating to the code system and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the code system.", 0, Integer.MAX_VALUE, this.copyright));
        childrenList.add(new Property("caseSensitive", "boolean", "If code comparison is case sensitive when codes within this system are compared to each other.", 0, Integer.MAX_VALUE, this.caseSensitive));
        childrenList.add(new Property("valueSet", "uri", "Canonical URL of value set that contains the entire code system.", 0, Integer.MAX_VALUE, this.valueSet));
        childrenList.add(new Property("compositional", "boolean", "True If code system defines a post-composition grammar.", 0, Integer.MAX_VALUE, this.compositional));
        childrenList.add(new Property("versionNeeded", "boolean", "This flag is used to signify that the code system has not (or does not) maintain the definitions, and a version must be specified when referencing this code system.", 0, Integer.MAX_VALUE, this.versionNeeded));
        childrenList.add(new Property(SP_CONTENT, SP_CODE, "How much of the content of the code system - the concepts and codes it defines - are represented in this resource.", 0, Integer.MAX_VALUE, this.content));
        childrenList.add(new Property("count", "unsignedInt", "The total number of concepts defined by the code system. Where the code system has a compositional grammar, the count refers to the number of base (primitive) concepts.", 0, Integer.MAX_VALUE, this.count));
        childrenList.add(new Property("filter", "", "A filter that can be used in a value set compose statement when selecting concepts using a filter.", 0, Integer.MAX_VALUE, this.filter));
        childrenList.add(new Property("property", "", "A property defines an additional slot through which additional information can be provided about a concept.", 0, Integer.MAX_VALUE, this.property));
        childrenList.add(new Property("concept", "", "Concepts that are in the code system. The concept definitions are inherently hierarchical, but the definitions must be consulted to determine what the meaning of the hierarchical relationships are.", 0, Integer.MAX_VALUE, this.concept));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.identifier;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.name;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.date;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -1619874672: {
                Base[] baseArray;
                if (this.requirements == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.requirements;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.copyright;
                }
                return baseArray;
            }
            case -35616442: {
                Base[] baseArray;
                if (this.caseSensitive == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.caseSensitive;
                }
                return baseArray;
            }
            case -1410174671: {
                Base[] baseArray;
                if (this.valueSet == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.valueSet;
                }
                return baseArray;
            }
            case 1248023381: {
                Base[] baseArray;
                if (this.compositional == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.compositional;
                }
                return baseArray;
            }
            case 617270957: {
                Base[] baseArray;
                if (this.versionNeeded == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.versionNeeded;
                }
                return baseArray;
            }
            case 951530617: {
                Base[] baseArray;
                if (this.content == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.content;
                }
                return baseArray;
            }
            case 94851343: {
                Base[] baseArray;
                if (this.count == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.count;
                }
                return baseArray;
            }
            case -1274492040: {
                return this.filter == null ? new Base[]{} : this.filter.toArray(new Base[this.filter.size()]);
            }
            case -993141291: {
                return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
            }
            case 951024232: {
                return this.concept == null ? new Base[]{} : this.concept.toArray(new Base[this.concept.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                break;
            }
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                break;
            }
            case 351608024: {
                this.version = this.castToString(value);
                break;
            }
            case 3373707: {
                this.name = this.castToString(value);
                break;
            }
            case -892481550: {
                this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
                break;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                break;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                break;
            }
            case 951526432: {
                this.getContact().add((CodeSystemContactComponent)value);
                break;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                break;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                break;
            }
            case -669707736: {
                this.getUseContext().add(this.castToCodeableConcept(value));
                break;
            }
            case -1619874672: {
                this.requirements = this.castToString(value);
                break;
            }
            case 1522889671: {
                this.copyright = this.castToString(value);
                break;
            }
            case -35616442: {
                this.caseSensitive = this.castToBoolean(value);
                break;
            }
            case -1410174671: {
                this.valueSet = this.castToUri(value);
                break;
            }
            case 1248023381: {
                this.compositional = this.castToBoolean(value);
                break;
            }
            case 617270957: {
                this.versionNeeded = this.castToBoolean(value);
                break;
            }
            case 951530617: {
                this.content = new CodeSystemContentModeEnumFactory().fromType(value);
                break;
            }
            case 94851343: {
                this.count = this.castToUnsignedInt(value);
                break;
            }
            case -1274492040: {
                this.getFilter().add((CodeSystemFilterComponent)value);
                break;
            }
            case -993141291: {
                this.getProperty().add((CodeSystemPropertyComponent)value);
                break;
            }
            case 951024232: {
                this.getConcept().add((ConceptDefinitionComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add((CodeSystemContactComponent)value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToString(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToCodeableConcept(value));
        } else if (name.equals("requirements")) {
            this.requirements = this.castToString(value);
        } else if (name.equals("copyright")) {
            this.copyright = this.castToString(value);
        } else if (name.equals("caseSensitive")) {
            this.caseSensitive = this.castToBoolean(value);
        } else if (name.equals("valueSet")) {
            this.valueSet = this.castToUri(value);
        } else if (name.equals("compositional")) {
            this.compositional = this.castToBoolean(value);
        } else if (name.equals("versionNeeded")) {
            this.versionNeeded = this.castToBoolean(value);
        } else if (name.equals(SP_CONTENT)) {
            this.content = new CodeSystemContentModeEnumFactory().fromType(value);
        } else if (name.equals("count")) {
            this.count = this.castToUnsignedInt(value);
        } else if (name.equals("filter")) {
            this.getFilter().add((CodeSystemFilterComponent)value);
        } else if (name.equals("property")) {
            this.getProperty().add((CodeSystemPropertyComponent)value);
        } else if (name.equals("concept")) {
            this.getConcept().add((ConceptDefinitionComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                throw new FHIRException("Cannot make property url as it is not a complex type");
            }
            case -1618432855: {
                return this.getIdentifier();
            }
            case 351608024: {
                throw new FHIRException("Cannot make property version as it is not a complex type");
            }
            case 3373707: {
                throw new FHIRException("Cannot make property name as it is not a complex type");
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case -404562712: {
                throw new FHIRException("Cannot make property experimental as it is not a complex type");
            }
            case 1447404028: {
                throw new FHIRException("Cannot make property publisher as it is not a complex type");
            }
            case 951526432: {
                return this.addContact();
            }
            case 3076014: {
                throw new FHIRException("Cannot make property date as it is not a complex type");
            }
            case -1724546052: {
                throw new FHIRException("Cannot make property description as it is not a complex type");
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -1619874672: {
                throw new FHIRException("Cannot make property requirements as it is not a complex type");
            }
            case 1522889671: {
                throw new FHIRException("Cannot make property copyright as it is not a complex type");
            }
            case -35616442: {
                throw new FHIRException("Cannot make property caseSensitive as it is not a complex type");
            }
            case -1410174671: {
                throw new FHIRException("Cannot make property valueSet as it is not a complex type");
            }
            case 1248023381: {
                throw new FHIRException("Cannot make property compositional as it is not a complex type");
            }
            case 617270957: {
                throw new FHIRException("Cannot make property versionNeeded as it is not a complex type");
            }
            case 951530617: {
                throw new FHIRException("Cannot make property content as it is not a complex type");
            }
            case 94851343: {
                throw new FHIRException("Cannot make property count as it is not a complex type");
            }
            case -1274492040: {
                return this.addFilter();
            }
            case -993141291: {
                return this.addProperty();
            }
            case 951024232: {
                return this.addConcept();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.name");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.experimental");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.date");
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals("requirements")) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.requirements");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.copyright");
        }
        if (name.equals("caseSensitive")) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.caseSensitive");
        }
        if (name.equals("valueSet")) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.valueSet");
        }
        if (name.equals("compositional")) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.compositional");
        }
        if (name.equals("versionNeeded")) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.versionNeeded");
        }
        if (name.equals(SP_CONTENT)) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.content");
        }
        if (name.equals("count")) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.count");
        }
        if (name.equals("filter")) {
            return this.addFilter();
        }
        if (name.equals("property")) {
            return this.addProperty();
        }
        if (name.equals("concept")) {
            return this.addConcept();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CodeSystem";
    }

    @Override
    public CodeSystem copy() {
        CodeSystem dst = new CodeSystem();
        this.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<CodeSystemContactComponent>();
            for (CodeSystemContactComponent codeSystemContactComponent : this.contact) {
                dst.contact.add(codeSystemContactComponent.copy());
            }
        }
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType2 = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.useContext) {
                dst.useContext.add(codeableConcept.copy());
            }
        }
        dst.requirements = this.requirements == null ? null : this.requirements.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.caseSensitive = this.caseSensitive == null ? null : this.caseSensitive.copy();
        dst.valueSet = this.valueSet == null ? null : this.valueSet.copy();
        dst.compositional = this.compositional == null ? null : this.compositional.copy();
        dst.versionNeeded = this.versionNeeded == null ? null : this.versionNeeded.copy();
        dst.content = this.content == null ? null : this.content.copy();
        UnsignedIntType unsignedIntType = dst.count = this.count == null ? null : this.count.copy();
        if (this.filter != null) {
            dst.filter = new ArrayList<CodeSystemFilterComponent>();
            for (CodeSystemFilterComponent codeSystemFilterComponent : this.filter) {
                dst.filter.add(codeSystemFilterComponent.copy());
            }
        }
        if (this.property != null) {
            dst.property = new ArrayList<CodeSystemPropertyComponent>();
            for (CodeSystemPropertyComponent codeSystemPropertyComponent : this.property) {
                dst.property.add(codeSystemPropertyComponent.copy());
            }
        }
        if (this.concept != null) {
            dst.concept = new ArrayList<ConceptDefinitionComponent>();
            for (ConceptDefinitionComponent conceptDefinitionComponent : this.concept) {
                dst.concept.add(conceptDefinitionComponent.copy());
            }
        }
        return dst;
    }

    protected CodeSystem typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof CodeSystem)) {
            return false;
        }
        CodeSystem o = (CodeSystem)other;
        return CodeSystem.compareDeep(this.url, o.url, true) && CodeSystem.compareDeep(this.identifier, o.identifier, true) && CodeSystem.compareDeep(this.version, o.version, true) && CodeSystem.compareDeep(this.name, o.name, true) && CodeSystem.compareDeep(this.status, o.status, true) && CodeSystem.compareDeep(this.experimental, o.experimental, true) && CodeSystem.compareDeep(this.publisher, o.publisher, true) && CodeSystem.compareDeep(this.contact, o.contact, true) && CodeSystem.compareDeep(this.date, o.date, true) && CodeSystem.compareDeep(this.description, o.description, true) && CodeSystem.compareDeep(this.useContext, o.useContext, true) && CodeSystem.compareDeep(this.requirements, o.requirements, true) && CodeSystem.compareDeep(this.copyright, o.copyright, true) && CodeSystem.compareDeep(this.caseSensitive, o.caseSensitive, true) && CodeSystem.compareDeep(this.valueSet, o.valueSet, true) && CodeSystem.compareDeep(this.compositional, o.compositional, true) && CodeSystem.compareDeep(this.versionNeeded, o.versionNeeded, true) && CodeSystem.compareDeep(this.content, o.content, true) && CodeSystem.compareDeep(this.count, o.count, true) && CodeSystem.compareDeep(this.filter, o.filter, true) && CodeSystem.compareDeep(this.property, o.property, true) && CodeSystem.compareDeep(this.concept, o.concept, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof CodeSystem)) {
            return false;
        }
        CodeSystem o = (CodeSystem)other;
        return CodeSystem.compareValues(this.url, o.url, true) && CodeSystem.compareValues(this.version, o.version, true) && CodeSystem.compareValues(this.name, o.name, true) && CodeSystem.compareValues(this.status, o.status, true) && CodeSystem.compareValues(this.experimental, o.experimental, true) && CodeSystem.compareValues(this.publisher, o.publisher, true) && CodeSystem.compareValues(this.date, o.date, true) && CodeSystem.compareValues(this.description, o.description, true) && CodeSystem.compareValues(this.requirements, o.requirements, true) && CodeSystem.compareValues(this.copyright, o.copyright, true) && CodeSystem.compareValues(this.caseSensitive, o.caseSensitive, true) && CodeSystem.compareValues(this.valueSet, o.valueSet, true) && CodeSystem.compareValues(this.compositional, o.compositional, true) && CodeSystem.compareValues(this.versionNeeded, o.versionNeeded, true) && CodeSystem.compareValues(this.content, o.content, true) && CodeSystem.compareValues(this.count, o.count, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.url != null && !this.url.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.version != null && !this.version.isEmpty() || this.name != null && !this.name.isEmpty() || this.status != null && !this.status.isEmpty() || this.experimental != null && !this.experimental.isEmpty() || this.publisher != null && !this.publisher.isEmpty() || this.contact != null && !this.contact.isEmpty() || this.date != null && !this.date.isEmpty() || this.description != null && !this.description.isEmpty() || this.useContext != null && !this.useContext.isEmpty() || this.requirements != null && !this.requirements.isEmpty() || this.copyright != null && !this.copyright.isEmpty() || this.caseSensitive != null && !this.caseSensitive.isEmpty() || this.valueSet != null && !this.valueSet.isEmpty() || this.compositional != null && !this.compositional.isEmpty() || this.versionNeeded != null && !this.versionNeeded.isEmpty() || this.content != null && !this.content.isEmpty() || this.count != null && !this.count.isEmpty() || this.filter != null && !this.filter.isEmpty() || this.property != null && !this.property.isEmpty() || this.concept != null && !this.concept.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.CodeSystem;
    }

    @Block
    public static class ConceptDefinitionPropertyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference to CodeSystem.property.code", formalDefinition="A code that is a reference to CodeSystem.property.code.")
        protected CodeType code;
        @Child(name="value", type={CodeType.class, Coding.class, StringType.class, IntegerType.class, BooleanType.class, DateTimeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value of the property for this concept", formalDefinition="The value of this property.")
        protected Type value;
        private static final long serialVersionUID = 1742812311L;

        public ConceptDefinitionPropertyComponent() {
        }

        public ConceptDefinitionPropertyComponent(CodeType code, Type value) {
            this.code = code;
            this.value = value;
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptDefinitionPropertyComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ConceptDefinitionPropertyComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public ConceptDefinitionPropertyComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public CodeType getValueCodeType() throws FHIRException {
            if (!(this.value instanceof CodeType)) {
                throw new FHIRException("Type mismatch: the type CodeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeType)this.value;
        }

        public boolean hasValueCodeType() {
            return this.value instanceof CodeType;
        }

        public Coding getValueCoding() throws FHIRException {
            if (!(this.value instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Coding)this.value;
        }

        public boolean hasValueCoding() {
            return this.value instanceof Coding;
        }

        public StringType getValueStringType() throws FHIRException {
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this.value instanceof StringType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this.value instanceof IntegerType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this.value instanceof BooleanType;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this.value instanceof DateTimeType;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ConceptDefinitionPropertyComponent setValue(Type value) {
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(CodeSystem.SP_CODE, CodeSystem.SP_CODE, "A code that is a reference to CodeSystem.property.code.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("value[x]", "code|Coding|string|integer|boolean|dateTime", "The value of this property.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCode(value);
                    break;
                }
                case 111972721: {
                    this.value = (Type)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CodeSystem.SP_CODE)) {
                this.code = this.castToCode(value);
            } else if (name.equals("value[x]")) {
                this.value = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    throw new FHIRException("Cannot make property code as it is not a complex type");
                }
                case -1410166417: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CodeSystem.SP_CODE)) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.code");
            }
            if (name.equals("valueCode")) {
                this.value = new CodeType();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public ConceptDefinitionPropertyComponent copy() {
            ConceptDefinitionPropertyComponent dst = new ConceptDefinitionPropertyComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ConceptDefinitionPropertyComponent)) {
                return false;
            }
            ConceptDefinitionPropertyComponent o = (ConceptDefinitionPropertyComponent)other;
            return ConceptDefinitionPropertyComponent.compareDeep(this.code, o.code, true) && ConceptDefinitionPropertyComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ConceptDefinitionPropertyComponent)) {
                return false;
            }
            ConceptDefinitionPropertyComponent o = (ConceptDefinitionPropertyComponent)other;
            return ConceptDefinitionPropertyComponent.compareValues(this.code, o.code, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "CodeSystem.concept.property";
        }
    }

    @Block
    public static class ConceptDefinitionDesignationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="language", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human language of the designation", formalDefinition="The language this designation is defined for.")
        protected CodeType language;
        @Child(name="use", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Details how this designation would be used", formalDefinition="A code that details how this designation would be used.")
        protected Coding use;
        @Child(name="value", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The text value for this designation", formalDefinition="The text value for this designation.")
        protected StringType value;
        private static final long serialVersionUID = 1515662414L;

        public ConceptDefinitionDesignationComponent() {
        }

        public ConceptDefinitionDesignationComponent(StringType value) {
            this.value = value;
        }

        public CodeType getLanguageElement() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptDefinitionDesignationComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeType();
                }
            }
            return this.language;
        }

        public boolean hasLanguageElement() {
            return this.language != null && !this.language.isEmpty();
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public ConceptDefinitionDesignationComponent setLanguageElement(CodeType value) {
            this.language = value;
            return this;
        }

        public String getLanguage() {
            return this.language == null ? null : (String)this.language.getValue();
        }

        public ConceptDefinitionDesignationComponent setLanguage(String value) {
            if (Utilities.noString((String)value)) {
                this.language = null;
            } else {
                if (this.language == null) {
                    this.language = new CodeType();
                }
                this.language.setValue(value);
            }
            return this;
        }

        public Coding getUse() {
            if (this.use == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptDefinitionDesignationComponent.use");
                }
                if (Configuration.doAutoCreate()) {
                    this.use = new Coding();
                }
            }
            return this.use;
        }

        public boolean hasUse() {
            return this.use != null && !this.use.isEmpty();
        }

        public ConceptDefinitionDesignationComponent setUse(Coding value) {
            this.use = value;
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptDefinitionDesignationComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ConceptDefinitionDesignationComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public ConceptDefinitionDesignationComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(CodeSystem.SP_LANGUAGE, CodeSystem.SP_CODE, "The language this designation is defined for.", 0, Integer.MAX_VALUE, this.language));
            childrenList.add(new Property("use", "Coding", "A code that details how this designation would be used.", 0, Integer.MAX_VALUE, this.use));
            childrenList.add(new Property("value", "string", "The text value for this designation.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.language;
                    }
                    return baseArray;
                }
                case 116103: {
                    Base[] baseArray;
                    if (this.use == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.use;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    this.language = this.castToCode(value);
                    break;
                }
                case 116103: {
                    this.use = this.castToCoding(value);
                    break;
                }
                case 111972721: {
                    this.value = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CodeSystem.SP_LANGUAGE)) {
                this.language = this.castToCode(value);
            } else if (name.equals("use")) {
                this.use = this.castToCoding(value);
            } else if (name.equals("value")) {
                this.value = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    throw new FHIRException("Cannot make property language as it is not a complex type");
                }
                case 116103: {
                    return this.getUse();
                }
                case 111972721: {
                    throw new FHIRException("Cannot make property value as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CodeSystem.SP_LANGUAGE)) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.language");
            }
            if (name.equals("use")) {
                this.use = new Coding();
                return this.use;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.value");
            }
            return super.addChild(name);
        }

        @Override
        public ConceptDefinitionDesignationComponent copy() {
            ConceptDefinitionDesignationComponent dst = new ConceptDefinitionDesignationComponent();
            this.copyValues(dst);
            dst.language = this.language == null ? null : this.language.copy();
            dst.use = this.use == null ? null : this.use.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ConceptDefinitionDesignationComponent)) {
                return false;
            }
            ConceptDefinitionDesignationComponent o = (ConceptDefinitionDesignationComponent)other;
            return ConceptDefinitionDesignationComponent.compareDeep(this.language, o.language, true) && ConceptDefinitionDesignationComponent.compareDeep(this.use, o.use, true) && ConceptDefinitionDesignationComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ConceptDefinitionDesignationComponent)) {
                return false;
            }
            ConceptDefinitionDesignationComponent o = (ConceptDefinitionDesignationComponent)other;
            return ConceptDefinitionDesignationComponent.compareValues(this.language, o.language, true) && ConceptDefinitionDesignationComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.language != null && !this.language.isEmpty() || this.use != null && !this.use.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "CodeSystem.concept.designation";
        }
    }

    @Block
    public static class ConceptDefinitionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code that identifies concept", formalDefinition="A code - a text symbol - that uniquely identifies the concept within the code system.")
        protected CodeType code;
        @Child(name="display", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Text to display to the user", formalDefinition="A human readable string that is the recommended default way to present this concept to a user.")
        protected StringType display;
        @Child(name="definition", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Formal definition", formalDefinition="The formal definition of the concept. The code system resource does not make formal definitions required, because of the prevalence of legacy systems. However, they are highly recommended, as without them there is no formal meaning associated with the concept.")
        protected StringType definition;
        @Child(name="designation", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional representations for the concept", formalDefinition="Additional representations for the concept - other languages, aliases, specialized purposes, used for particular purposes, etc.")
        protected List<ConceptDefinitionDesignationComponent> designation;
        @Child(name="property", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Property value for the concept", formalDefinition="A property value for this concept.")
        protected List<ConceptDefinitionPropertyComponent> property;
        @Child(name="concept", type={ConceptDefinitionComponent.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Child Concepts (is-a/contains/categorizes)", formalDefinition="Defines children of a concept to produce a hierarchy of concepts. The nature of the relationships is variable (is-a/contains/categorizes) and can only be determined by examining the definitions of the concepts.")
        protected List<ConceptDefinitionComponent> concept;
        private static final long serialVersionUID = 1495076297L;

        public ConceptDefinitionComponent() {
        }

        public ConceptDefinitionComponent(CodeType code) {
            this.code = code;
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptDefinitionComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ConceptDefinitionComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public ConceptDefinitionComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptDefinitionComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public ConceptDefinitionComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public ConceptDefinitionComponent setDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        public StringType getDefinitionElement() {
            if (this.definition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptDefinitionComponent.definition");
                }
                if (Configuration.doAutoCreate()) {
                    this.definition = new StringType();
                }
            }
            return this.definition;
        }

        public boolean hasDefinitionElement() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public boolean hasDefinition() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public ConceptDefinitionComponent setDefinitionElement(StringType value) {
            this.definition = value;
            return this;
        }

        public String getDefinition() {
            return this.definition == null ? null : (String)this.definition.getValue();
        }

        public ConceptDefinitionComponent setDefinition(String value) {
            if (Utilities.noString((String)value)) {
                this.definition = null;
            } else {
                if (this.definition == null) {
                    this.definition = new StringType();
                }
                this.definition.setValue(value);
            }
            return this;
        }

        public List<ConceptDefinitionDesignationComponent> getDesignation() {
            if (this.designation == null) {
                this.designation = new ArrayList<ConceptDefinitionDesignationComponent>();
            }
            return this.designation;
        }

        public boolean hasDesignation() {
            if (this.designation == null) {
                return false;
            }
            for (ConceptDefinitionDesignationComponent item : this.designation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptDefinitionDesignationComponent addDesignation() {
            ConceptDefinitionDesignationComponent t = new ConceptDefinitionDesignationComponent();
            if (this.designation == null) {
                this.designation = new ArrayList<ConceptDefinitionDesignationComponent>();
            }
            this.designation.add(t);
            return t;
        }

        public ConceptDefinitionComponent addDesignation(ConceptDefinitionDesignationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.designation == null) {
                this.designation = new ArrayList<ConceptDefinitionDesignationComponent>();
            }
            this.designation.add(t);
            return this;
        }

        public List<ConceptDefinitionPropertyComponent> getProperty() {
            if (this.property == null) {
                this.property = new ArrayList<ConceptDefinitionPropertyComponent>();
            }
            return this.property;
        }

        public boolean hasProperty() {
            if (this.property == null) {
                return false;
            }
            for (ConceptDefinitionPropertyComponent item : this.property) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptDefinitionPropertyComponent addProperty() {
            ConceptDefinitionPropertyComponent t = new ConceptDefinitionPropertyComponent();
            if (this.property == null) {
                this.property = new ArrayList<ConceptDefinitionPropertyComponent>();
            }
            this.property.add(t);
            return t;
        }

        public ConceptDefinitionComponent addProperty(ConceptDefinitionPropertyComponent t) {
            if (t == null) {
                return this;
            }
            if (this.property == null) {
                this.property = new ArrayList<ConceptDefinitionPropertyComponent>();
            }
            this.property.add(t);
            return this;
        }

        public List<ConceptDefinitionComponent> getConcept() {
            if (this.concept == null) {
                this.concept = new ArrayList<ConceptDefinitionComponent>();
            }
            return this.concept;
        }

        public boolean hasConcept() {
            if (this.concept == null) {
                return false;
            }
            for (ConceptDefinitionComponent item : this.concept) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptDefinitionComponent addConcept() {
            ConceptDefinitionComponent t = new ConceptDefinitionComponent();
            if (this.concept == null) {
                this.concept = new ArrayList<ConceptDefinitionComponent>();
            }
            this.concept.add(t);
            return t;
        }

        public ConceptDefinitionComponent addConcept(ConceptDefinitionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.concept == null) {
                this.concept = new ArrayList<ConceptDefinitionComponent>();
            }
            this.concept.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(CodeSystem.SP_CODE, CodeSystem.SP_CODE, "A code - a text symbol - that uniquely identifies the concept within the code system.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("display", "string", "A human readable string that is the recommended default way to present this concept to a user.", 0, Integer.MAX_VALUE, this.display));
            childrenList.add(new Property("definition", "string", "The formal definition of the concept. The code system resource does not make formal definitions required, because of the prevalence of legacy systems. However, they are highly recommended, as without them there is no formal meaning associated with the concept.", 0, Integer.MAX_VALUE, this.definition));
            childrenList.add(new Property("designation", "", "Additional representations for the concept - other languages, aliases, specialized purposes, used for particular purposes, etc.", 0, Integer.MAX_VALUE, this.designation));
            childrenList.add(new Property("property", "", "A property value for this concept.", 0, Integer.MAX_VALUE, this.property));
            childrenList.add(new Property("concept", "@CodeSystem.concept", "Defines children of a concept to produce a hierarchy of concepts. The nature of the relationships is variable (is-a/contains/categorizes) and can only be determined by examining the definitions of the concepts.", 0, Integer.MAX_VALUE, this.concept));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 1671764162: {
                    Base[] baseArray;
                    if (this.display == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.display;
                    }
                    return baseArray;
                }
                case -1014418093: {
                    Base[] baseArray;
                    if (this.definition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.definition;
                    }
                    return baseArray;
                }
                case -900931593: {
                    return this.designation == null ? new Base[]{} : this.designation.toArray(new Base[this.designation.size()]);
                }
                case -993141291: {
                    return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
                }
                case 951024232: {
                    return this.concept == null ? new Base[]{} : this.concept.toArray(new Base[this.concept.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCode(value);
                    break;
                }
                case 1671764162: {
                    this.display = this.castToString(value);
                    break;
                }
                case -1014418093: {
                    this.definition = this.castToString(value);
                    break;
                }
                case -900931593: {
                    this.getDesignation().add((ConceptDefinitionDesignationComponent)value);
                    break;
                }
                case -993141291: {
                    this.getProperty().add((ConceptDefinitionPropertyComponent)value);
                    break;
                }
                case 951024232: {
                    this.getConcept().add((ConceptDefinitionComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CodeSystem.SP_CODE)) {
                this.code = this.castToCode(value);
            } else if (name.equals("display")) {
                this.display = this.castToString(value);
            } else if (name.equals("definition")) {
                this.definition = this.castToString(value);
            } else if (name.equals("designation")) {
                this.getDesignation().add((ConceptDefinitionDesignationComponent)value);
            } else if (name.equals("property")) {
                this.getProperty().add((ConceptDefinitionPropertyComponent)value);
            } else if (name.equals("concept")) {
                this.getConcept().add((ConceptDefinitionComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    throw new FHIRException("Cannot make property code as it is not a complex type");
                }
                case 1671764162: {
                    throw new FHIRException("Cannot make property display as it is not a complex type");
                }
                case -1014418093: {
                    throw new FHIRException("Cannot make property definition as it is not a complex type");
                }
                case -900931593: {
                    return this.addDesignation();
                }
                case -993141291: {
                    return this.addProperty();
                }
                case 951024232: {
                    return this.addConcept();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CodeSystem.SP_CODE)) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.code");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.display");
            }
            if (name.equals("definition")) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.definition");
            }
            if (name.equals("designation")) {
                return this.addDesignation();
            }
            if (name.equals("property")) {
                return this.addProperty();
            }
            if (name.equals("concept")) {
                return this.addConcept();
            }
            return super.addChild(name);
        }

        @Override
        public ConceptDefinitionComponent copy() {
            ConceptDefinitionComponent dst = new ConceptDefinitionComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.display = this.display == null ? null : this.display.copy();
            StringType stringType = dst.definition = this.definition == null ? null : this.definition.copy();
            if (this.designation != null) {
                dst.designation = new ArrayList<ConceptDefinitionDesignationComponent>();
                for (ConceptDefinitionDesignationComponent conceptDefinitionDesignationComponent : this.designation) {
                    dst.designation.add(conceptDefinitionDesignationComponent.copy());
                }
            }
            if (this.property != null) {
                dst.property = new ArrayList<ConceptDefinitionPropertyComponent>();
                for (ConceptDefinitionPropertyComponent conceptDefinitionPropertyComponent : this.property) {
                    dst.property.add(conceptDefinitionPropertyComponent.copy());
                }
            }
            if (this.concept != null) {
                dst.concept = new ArrayList<ConceptDefinitionComponent>();
                for (ConceptDefinitionComponent conceptDefinitionComponent : this.concept) {
                    dst.concept.add(conceptDefinitionComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ConceptDefinitionComponent)) {
                return false;
            }
            ConceptDefinitionComponent o = (ConceptDefinitionComponent)other;
            return ConceptDefinitionComponent.compareDeep(this.code, o.code, true) && ConceptDefinitionComponent.compareDeep(this.display, o.display, true) && ConceptDefinitionComponent.compareDeep(this.definition, o.definition, true) && ConceptDefinitionComponent.compareDeep(this.designation, o.designation, true) && ConceptDefinitionComponent.compareDeep(this.property, o.property, true) && ConceptDefinitionComponent.compareDeep(this.concept, o.concept, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ConceptDefinitionComponent)) {
                return false;
            }
            ConceptDefinitionComponent o = (ConceptDefinitionComponent)other;
            return ConceptDefinitionComponent.compareValues(this.code, o.code, true) && ConceptDefinitionComponent.compareValues(this.display, o.display, true) && ConceptDefinitionComponent.compareValues(this.definition, o.definition, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.display != null && !this.display.isEmpty() || this.definition != null && !this.definition.isEmpty() || this.designation != null && !this.designation.isEmpty() || this.property != null && !this.property.isEmpty() || this.concept != null && !this.concept.isEmpty());
        }

        @Override
        public String fhirType() {
            return "CodeSystem.concept";
        }
    }

    @Block
    public static class CodeSystemPropertyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identifies the property, both internally and externally", formalDefinition="A code that is used to identify the property. The code is used internally (in CodeSystem.concept.property.code) and also externally, such as in property filters.")
        protected CodeType code;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Why the property is defined, and/or what it conveys", formalDefinition="A description of the property- why it is defined, and how it's value might be used.")
        protected StringType description;
        @Child(name="type", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="code | Coding | string | integer | boolean | dateTime", formalDefinition="The type of the property value.")
        protected Enumeration<PropertyType> type;
        private static final long serialVersionUID = -1346176181L;

        public CodeSystemPropertyComponent() {
        }

        public CodeSystemPropertyComponent(CodeType code, Enumeration<PropertyType> type) {
            this.code = code;
            this.type = type;
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CodeSystemPropertyComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public CodeSystemPropertyComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public CodeSystemPropertyComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CodeSystemPropertyComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public CodeSystemPropertyComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public CodeSystemPropertyComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Enumeration<PropertyType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CodeSystemPropertyComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<PropertyType>(new PropertyTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CodeSystemPropertyComponent setTypeElement(Enumeration<PropertyType> value) {
            this.type = value;
            return this;
        }

        public PropertyType getType() {
            return this.type == null ? null : (PropertyType)((Object)this.type.getValue());
        }

        public CodeSystemPropertyComponent setType(PropertyType value) {
            if (this.type == null) {
                this.type = new Enumeration<PropertyType>(new PropertyTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(CodeSystem.SP_CODE, CodeSystem.SP_CODE, "A code that is used to identify the property. The code is used internally (in CodeSystem.concept.property.code) and also externally, such as in property filters.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property(CodeSystem.SP_DESCRIPTION, "string", "A description of the property- why it is defined, and how it's value might be used.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property("type", CodeSystem.SP_CODE, "The type of the property value.", 0, Integer.MAX_VALUE, this.type));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.type;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCode(value);
                    break;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    break;
                }
                case 3575610: {
                    this.type = new PropertyTypeEnumFactory().fromType(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CodeSystem.SP_CODE)) {
                this.code = this.castToCode(value);
            } else if (name.equals(CodeSystem.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("type")) {
                this.type = new PropertyTypeEnumFactory().fromType(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    throw new FHIRException("Cannot make property code as it is not a complex type");
                }
                case -1724546052: {
                    throw new FHIRException("Cannot make property description as it is not a complex type");
                }
                case 3575610: {
                    throw new FHIRException("Cannot make property type as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CodeSystem.SP_CODE)) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.code");
            }
            if (name.equals(CodeSystem.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.description");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.type");
            }
            return super.addChild(name);
        }

        @Override
        public CodeSystemPropertyComponent copy() {
            CodeSystemPropertyComponent dst = new CodeSystemPropertyComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.type = this.type == null ? null : this.type.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof CodeSystemPropertyComponent)) {
                return false;
            }
            CodeSystemPropertyComponent o = (CodeSystemPropertyComponent)other;
            return CodeSystemPropertyComponent.compareDeep(this.code, o.code, true) && CodeSystemPropertyComponent.compareDeep(this.description, o.description, true) && CodeSystemPropertyComponent.compareDeep(this.type, o.type, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof CodeSystemPropertyComponent)) {
                return false;
            }
            CodeSystemPropertyComponent o = (CodeSystemPropertyComponent)other;
            return CodeSystemPropertyComponent.compareValues(this.code, o.code, true) && CodeSystemPropertyComponent.compareValues(this.description, o.description, true) && CodeSystemPropertyComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.description != null && !this.description.isEmpty() || this.type != null && !this.type.isEmpty());
        }

        @Override
        public String fhirType() {
            return "CodeSystem.property";
        }
    }

    @Block
    public static class CodeSystemFilterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Code that identifies the filter", formalDefinition="The code that identifies thise filter when it is used in the instance.")
        protected CodeType code;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="How or why the filter is used", formalDefinition="A description of how or why the filter is used.")
        protected StringType description;
        @Child(name="operator", type={CodeType.class}, order=3, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Operators that can be used with filter", formalDefinition="A list of operators that can be used with the filter.")
        protected List<CodeType> operator;
        @Child(name="value", type={StringType.class}, order=4, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="What to use for the value", formalDefinition="A description of what the value for the filter should be.")
        protected StringType value;
        private static final long serialVersionUID = 20272432L;

        public CodeSystemFilterComponent() {
        }

        public CodeSystemFilterComponent(CodeType code, StringType value) {
            this.code = code;
            this.value = value;
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CodeSystemFilterComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public CodeSystemFilterComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public CodeSystemFilterComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CodeSystemFilterComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public CodeSystemFilterComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public CodeSystemFilterComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<CodeType> getOperator() {
            if (this.operator == null) {
                this.operator = new ArrayList<CodeType>();
            }
            return this.operator;
        }

        public boolean hasOperator() {
            if (this.operator == null) {
                return false;
            }
            for (CodeType item : this.operator) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeType addOperatorElement() {
            CodeType t = new CodeType();
            if (this.operator == null) {
                this.operator = new ArrayList<CodeType>();
            }
            this.operator.add(t);
            return t;
        }

        public CodeSystemFilterComponent addOperator(String value) {
            CodeType t = new CodeType();
            t.setValue(value);
            if (this.operator == null) {
                this.operator = new ArrayList<CodeType>();
            }
            this.operator.add(t);
            return this;
        }

        public boolean hasOperator(String value) {
            if (this.operator == null) {
                return false;
            }
            for (CodeType v : this.operator) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CodeSystemFilterComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public CodeSystemFilterComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public CodeSystemFilterComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(CodeSystem.SP_CODE, CodeSystem.SP_CODE, "The code that identifies thise filter when it is used in the instance.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property(CodeSystem.SP_DESCRIPTION, "string", "A description of how or why the filter is used.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property("operator", CodeSystem.SP_CODE, "A list of operators that can be used with the filter.", 0, Integer.MAX_VALUE, this.operator));
            childrenList.add(new Property("value", "string", "A description of what the value for the filter should be.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case -500553564: {
                    return this.operator == null ? new Base[]{} : this.operator.toArray(new Base[this.operator.size()]);
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCode(value);
                    break;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    break;
                }
                case -500553564: {
                    this.getOperator().add(this.castToCode(value));
                    break;
                }
                case 111972721: {
                    this.value = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CodeSystem.SP_CODE)) {
                this.code = this.castToCode(value);
            } else if (name.equals(CodeSystem.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("operator")) {
                this.getOperator().add(this.castToCode(value));
            } else if (name.equals("value")) {
                this.value = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    throw new FHIRException("Cannot make property code as it is not a complex type");
                }
                case -1724546052: {
                    throw new FHIRException("Cannot make property description as it is not a complex type");
                }
                case -500553564: {
                    throw new FHIRException("Cannot make property operator as it is not a complex type");
                }
                case 111972721: {
                    throw new FHIRException("Cannot make property value as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CodeSystem.SP_CODE)) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.code");
            }
            if (name.equals(CodeSystem.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.description");
            }
            if (name.equals("operator")) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.operator");
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.value");
            }
            return super.addChild(name);
        }

        @Override
        public CodeSystemFilterComponent copy() {
            CodeSystemFilterComponent dst = new CodeSystemFilterComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            StringType stringType = dst.description = this.description == null ? null : this.description.copy();
            if (this.operator != null) {
                dst.operator = new ArrayList<CodeType>();
                for (CodeType i : this.operator) {
                    dst.operator.add(i.copy());
                }
            }
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof CodeSystemFilterComponent)) {
                return false;
            }
            CodeSystemFilterComponent o = (CodeSystemFilterComponent)other;
            return CodeSystemFilterComponent.compareDeep(this.code, o.code, true) && CodeSystemFilterComponent.compareDeep(this.description, o.description, true) && CodeSystemFilterComponent.compareDeep(this.operator, o.operator, true) && CodeSystemFilterComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof CodeSystemFilterComponent)) {
                return false;
            }
            CodeSystemFilterComponent o = (CodeSystemFilterComponent)other;
            return CodeSystemFilterComponent.compareValues(this.code, o.code, true) && CodeSystemFilterComponent.compareValues(this.description, o.description, true) && CodeSystemFilterComponent.compareValues(this.operator, o.operator, true) && CodeSystemFilterComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.description != null && !this.description.isEmpty() || this.operator != null && !this.operator.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "CodeSystem.filter";
        }
    }

    @Block
    public static class CodeSystemContactComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of an individual to contact", formalDefinition="The name of an individual to contact regarding the code system.")
        protected StringType name;
        @Child(name="telecom", type={ContactPoint.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Contact details for individual or publisher", formalDefinition="Contact details for individual (if a name was provided) or the publisher.")
        protected List<ContactPoint> telecom;
        private static final long serialVersionUID = -1179697803L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CodeSystemContactComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public CodeSystemContactComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public CodeSystemContactComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public CodeSystemContactComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(CodeSystem.SP_NAME, "string", "The name of an individual to contact regarding the code system.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("telecom", "ContactPoint", "Contact details for individual (if a name was provided) or the publisher.", 0, Integer.MAX_VALUE, this.telecom));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1429363305: {
                    return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1429363305: {
                    this.getTelecom().add(this.castToContactPoint(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CodeSystem.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("telecom")) {
                this.getTelecom().add(this.castToContactPoint(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1429363305: {
                    return this.addTelecom();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CodeSystem.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.name");
            }
            if (name.equals("telecom")) {
                return this.addTelecom();
            }
            return super.addChild(name);
        }

        @Override
        public CodeSystemContactComponent copy() {
            CodeSystemContactComponent dst = new CodeSystemContactComponent();
            this.copyValues(dst);
            StringType stringType = dst.name = this.name == null ? null : this.name.copy();
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint i : this.telecom) {
                    dst.telecom.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof CodeSystemContactComponent)) {
                return false;
            }
            CodeSystemContactComponent o = (CodeSystemContactComponent)other;
            return CodeSystemContactComponent.compareDeep(this.name, o.name, true) && CodeSystemContactComponent.compareDeep(this.telecom, o.telecom, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof CodeSystemContactComponent)) {
                return false;
            }
            CodeSystemContactComponent o = (CodeSystemContactComponent)other;
            return CodeSystemContactComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.telecom != null && !this.telecom.isEmpty());
        }

        @Override
        public String fhirType() {
            return "CodeSystem.contact";
        }
    }

    public static class PropertyTypeEnumFactory
    implements EnumFactory<PropertyType> {
        @Override
        public PropertyType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if (CodeSystem.SP_CODE.equals(codeString)) {
                return PropertyType.CODE;
            }
            if ("Coding".equals(codeString)) {
                return PropertyType.CODING;
            }
            if ("string".equals(codeString)) {
                return PropertyType.STRING;
            }
            if ("integer".equals(codeString)) {
                return PropertyType.INTEGER;
            }
            if ("boolean".equals(codeString)) {
                return PropertyType.BOOLEAN;
            }
            if ("dateTime".equals(codeString)) {
                return PropertyType.DATETIME;
            }
            throw new IllegalArgumentException("Unknown PropertyType code '" + codeString + "'");
        }

        public Enumeration<PropertyType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if (CodeSystem.SP_CODE.equals(codeString)) {
                return new Enumeration<PropertyType>(this, PropertyType.CODE);
            }
            if ("Coding".equals(codeString)) {
                return new Enumeration<PropertyType>(this, PropertyType.CODING);
            }
            if ("string".equals(codeString)) {
                return new Enumeration<PropertyType>(this, PropertyType.STRING);
            }
            if ("integer".equals(codeString)) {
                return new Enumeration<PropertyType>(this, PropertyType.INTEGER);
            }
            if ("boolean".equals(codeString)) {
                return new Enumeration<PropertyType>(this, PropertyType.BOOLEAN);
            }
            if ("dateTime".equals(codeString)) {
                return new Enumeration<PropertyType>(this, PropertyType.DATETIME);
            }
            throw new FHIRException("Unknown PropertyType code '" + codeString + "'");
        }

        @Override
        public String toCode(PropertyType code) {
            if (code == PropertyType.CODE) {
                return CodeSystem.SP_CODE;
            }
            if (code == PropertyType.CODING) {
                return "Coding";
            }
            if (code == PropertyType.STRING) {
                return "string";
            }
            if (code == PropertyType.INTEGER) {
                return "integer";
            }
            if (code == PropertyType.BOOLEAN) {
                return "boolean";
            }
            if (code == PropertyType.DATETIME) {
                return "dateTime";
            }
            return "?";
        }

        @Override
        public String toSystem(PropertyType code) {
            return code.getSystem();
        }
    }

    public static enum PropertyType {
        CODE,
        CODING,
        STRING,
        INTEGER,
        BOOLEAN,
        DATETIME,
        NULL;


        public static PropertyType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if (CodeSystem.SP_CODE.equals(codeString)) {
                return CODE;
            }
            if ("Coding".equals(codeString)) {
                return CODING;
            }
            if ("string".equals(codeString)) {
                return STRING;
            }
            if ("integer".equals(codeString)) {
                return INTEGER;
            }
            if ("boolean".equals(codeString)) {
                return BOOLEAN;
            }
            if ("dateTime".equals(codeString)) {
                return DATETIME;
            }
            throw new FHIRException("Unknown PropertyType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CODE: {
                    return CodeSystem.SP_CODE;
                }
                case CODING: {
                    return "Coding";
                }
                case STRING: {
                    return "string";
                }
                case INTEGER: {
                    return "integer";
                }
                case BOOLEAN: {
                    return "boolean";
                }
                case DATETIME: {
                    return "dateTime";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CODE: {
                    return "http://hl7.org/fhir/concept-property-type";
                }
                case CODING: {
                    return "http://hl7.org/fhir/concept-property-type";
                }
                case STRING: {
                    return "http://hl7.org/fhir/concept-property-type";
                }
                case INTEGER: {
                    return "http://hl7.org/fhir/concept-property-type";
                }
                case BOOLEAN: {
                    return "http://hl7.org/fhir/concept-property-type";
                }
                case DATETIME: {
                    return "http://hl7.org/fhir/concept-property-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CODE: {
                    return "The property value is a code that identifies a concept defined in the code system";
                }
                case CODING: {
                    return "The property  value is a code defined in an external code system. This may be used for translations, but is not the intent";
                }
                case STRING: {
                    return "The property value is a string";
                }
                case INTEGER: {
                    return "The property value is a string (often used to assign ranking values to concepts for supporting score assessments)";
                }
                case BOOLEAN: {
                    return "The property value is a boolean true | false";
                }
                case DATETIME: {
                    return "The property is a date or a date + time";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CODE: {
                    return "code (internal reference)";
                }
                case CODING: {
                    return "Coding (external reference)";
                }
                case STRING: {
                    return "string";
                }
                case INTEGER: {
                    return "integer";
                }
                case BOOLEAN: {
                    return "boolean";
                }
                case DATETIME: {
                    return "dateTime";
                }
            }
            return "?";
        }
    }

    public static class CodeSystemContentModeEnumFactory
    implements EnumFactory<CodeSystemContentMode> {
        @Override
        public CodeSystemContentMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("not-present".equals(codeString)) {
                return CodeSystemContentMode.NOTPRESENT;
            }
            if ("examplar".equals(codeString)) {
                return CodeSystemContentMode.EXAMPLAR;
            }
            if ("fragment".equals(codeString)) {
                return CodeSystemContentMode.FRAGMENT;
            }
            if ("complete".equals(codeString)) {
                return CodeSystemContentMode.COMPLETE;
            }
            throw new IllegalArgumentException("Unknown CodeSystemContentMode code '" + codeString + "'");
        }

        public Enumeration<CodeSystemContentMode> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("not-present".equals(codeString)) {
                return new Enumeration<CodeSystemContentMode>(this, CodeSystemContentMode.NOTPRESENT);
            }
            if ("examplar".equals(codeString)) {
                return new Enumeration<CodeSystemContentMode>(this, CodeSystemContentMode.EXAMPLAR);
            }
            if ("fragment".equals(codeString)) {
                return new Enumeration<CodeSystemContentMode>(this, CodeSystemContentMode.FRAGMENT);
            }
            if ("complete".equals(codeString)) {
                return new Enumeration<CodeSystemContentMode>(this, CodeSystemContentMode.COMPLETE);
            }
            throw new FHIRException("Unknown CodeSystemContentMode code '" + codeString + "'");
        }

        @Override
        public String toCode(CodeSystemContentMode code) {
            if (code == CodeSystemContentMode.NOTPRESENT) {
                return "not-present";
            }
            if (code == CodeSystemContentMode.EXAMPLAR) {
                return "examplar";
            }
            if (code == CodeSystemContentMode.FRAGMENT) {
                return "fragment";
            }
            if (code == CodeSystemContentMode.COMPLETE) {
                return "complete";
            }
            return "?";
        }

        @Override
        public String toSystem(CodeSystemContentMode code) {
            return code.getSystem();
        }
    }

    public static enum CodeSystemContentMode {
        NOTPRESENT,
        EXAMPLAR,
        FRAGMENT,
        COMPLETE,
        NULL;


        public static CodeSystemContentMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("not-present".equals(codeString)) {
                return NOTPRESENT;
            }
            if ("examplar".equals(codeString)) {
                return EXAMPLAR;
            }
            if ("fragment".equals(codeString)) {
                return FRAGMENT;
            }
            if ("complete".equals(codeString)) {
                return COMPLETE;
            }
            throw new FHIRException("Unknown CodeSystemContentMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case NOTPRESENT: {
                    return "not-present";
                }
                case EXAMPLAR: {
                    return "examplar";
                }
                case FRAGMENT: {
                    return "fragment";
                }
                case COMPLETE: {
                    return "complete";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case NOTPRESENT: {
                    return "http://hl7.org/fhir/codesystem-content-mode";
                }
                case EXAMPLAR: {
                    return "http://hl7.org/fhir/codesystem-content-mode";
                }
                case FRAGMENT: {
                    return "http://hl7.org/fhir/codesystem-content-mode";
                }
                case COMPLETE: {
                    return "http://hl7.org/fhir/codesystem-content-mode";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case NOTPRESENT: {
                    return "None of the concepts defined by the code system are included in the code system resource";
                }
                case EXAMPLAR: {
                    return "A few representative concepts are included in the code system resource";
                }
                case FRAGMENT: {
                    return "A subset of the code system concepts are included in the code system resource";
                }
                case COMPLETE: {
                    return "All the concepts defined by the code system are included in the code system resource";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case NOTPRESENT: {
                    return "Not Present";
                }
                case EXAMPLAR: {
                    return "Examplar";
                }
                case FRAGMENT: {
                    return "Fragment";
                }
                case COMPLETE: {
                    return "Complete";
                }
            }
            return "?";
        }
    }
}

