/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.metamodel;

import java.io.InputStream;
import java.io.OutputStream;
import org.hl7.fhir.dstu2016may.formats.IParser;
import org.hl7.fhir.dstu2016may.metamodel.Element;
import org.hl7.fhir.dstu2016may.metamodel.JsonLDParser;
import org.hl7.fhir.dstu2016may.metamodel.JsonParser;
import org.hl7.fhir.dstu2016may.metamodel.ParserBase;
import org.hl7.fhir.dstu2016may.metamodel.TurtleParser;
import org.hl7.fhir.dstu2016may.metamodel.XmlParser;
import org.hl7.fhir.dstu2016may.utils.IWorkerContext;

public class Manager {
    public static Element parse(IWorkerContext context, InputStream source, FhirFormat inputFormat) throws Exception {
        return Manager.makeParser(context, inputFormat).parse(source);
    }

    public static void compose(IWorkerContext context, Element e, OutputStream destination, FhirFormat outputFormat, IParser.OutputStyle style, String base) throws Exception {
        Manager.makeParser(context, outputFormat).compose(e, destination, style, base);
    }

    public static ParserBase makeParser(IWorkerContext context, FhirFormat format) {
        switch (format) {
            case JSON: {
                return new JsonParser(context);
            }
            case JSONLD: {
                return new JsonLDParser(context);
            }
            case XML: {
                return new XmlParser(context);
            }
            case TURTLE: {
                return new TurtleParser(context);
            }
        }
        return null;
    }

    public static enum FhirFormat {
        XML,
        JSON,
        JSONLD,
        TURTLE;

    }
}

