/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir.api;

import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.ITransactionTyped;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.fhir.api.ExtraParameters;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class FhirTransaction {
    private final IGenericClient client;

    public FhirTransaction(IGenericClient client) {
        this.client = client;
    }

    public List<IBaseResource> withResources(List<IBaseResource> resources, Map<ExtraParameters, Object> extraParameters) {
        ITransactionTyped transactionTyped = this.client.transaction().withResources(resources);
        ExtraParameters.process(extraParameters, transactionTyped);
        return (List)transactionTyped.execute();
    }

    public IBaseBundle withBundle(IBaseBundle bundle, Map<ExtraParameters, Object> extraParameters) {
        ITransactionTyped transactionTyped = this.client.transaction().withBundle(bundle);
        ExtraParameters.process(extraParameters, transactionTyped);
        return (IBaseBundle)transactionTyped.execute();
    }

    public String withBundle(String stringBundle, Map<ExtraParameters, Object> extraParameters) {
        ITransactionTyped transactionTyped = this.client.transaction().withBundle(stringBundle);
        ExtraParameters.process(extraParameters, transactionTyped);
        return (String)transactionTyped.execute();
    }
}

