/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies;

import java.net.URISyntaxException;
import java.util.Map;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.TerminologyClient;
import org.hl7.fhir.r5.utils.client.FHIRToolingClient;
import org.hl7.fhir.r5.utils.client.ToolingClientLogger;

public class TerminologyClientR5
implements TerminologyClient {
    private FHIRToolingClient client;

    public TerminologyClientR5(String address) throws URISyntaxException {
        this.client = new FHIRToolingClient(address);
    }

    @Override
    public TerminologyCapabilities getTerminologyCapabilities() {
        return this.client.getTerminologyCapabilities();
    }

    @Override
    public String getAddress() {
        return this.client.getAddress();
    }

    @Override
    public ValueSet expandValueset(ValueSet vs, Parameters p, Map<String, String> params) {
        return this.client.expandValueset(vs, p, params);
    }

    @Override
    public Parameters validateCS(Parameters pin) {
        return this.client.operateType(CodeSystem.class, "validate-code", pin);
    }

    @Override
    public Parameters validateVS(Parameters pin) {
        return this.client.operateType(ValueSet.class, "validate-code", pin);
    }

    @Override
    public void setTimeout(int i) {
        this.client.setTimeout(i);
    }

    @Override
    public void setLogger(ToolingClientLogger txLog) {
        this.client.setLogger(txLog);
    }

    @Override
    public CapabilityStatement getCapabilitiesStatementQuick() {
        return this.client.getCapabilitiesStatementQuick();
    }

    @Override
    public Parameters lookupCode(Map<String, String> params) {
        return this.client.lookupCode(params);
    }
}

