/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;

@ResourceDef(name="ManufacturedItemDefinition", profile="http://hl7.org/fhir/StructureDefinition/ManufacturedItemDefinition")
public class ManufacturedItemDefinition
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifier", formalDefinition="Unique identifier.")
    protected List<Identifier> identifier;
    @Child(name="manufacturedDoseForm", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Dose form as manufactured and before any transformation into the pharmaceutical product", formalDefinition="Dose form as manufactured and before any transformation into the pharmaceutical product.")
    protected CodeableConcept manufacturedDoseForm;
    @Child(name="unitOfPresentation", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The \u201creal world\u201d units in which the quantity of the manufactured item is described", formalDefinition="The \u201creal world\u201d units in which the quantity of the manufactured item is described.")
    protected CodeableConcept unitOfPresentation;
    @Child(name="manufacturer", type={Organization.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Manufacturer of the item (Note that this should be named \"manufacturer\" but it currently causes technical issues)", formalDefinition="Manufacturer of the item (Note that this should be named \"manufacturer\" but it currently causes technical issues).")
    protected List<Reference> manufacturer;
    @Child(name="ingredient", type={Ingredient.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The ingredients that make up this manufactured item", formalDefinition="The ingredients that make up this manufactured item.")
    protected List<Reference> ingredient;
    @Child(name="characteristic", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="General characteristics of this item", formalDefinition="General characteristics of this item.")
    protected List<ManufacturedItemDefinitionCharacteristicComponent> characteristic;
    private static final long serialVersionUID = -2112474361L;
    @SearchParamDefinition(name="dose-form", path="ManufacturedItemDefinition.manufacturedDoseForm", description="Dose form as manufactured and before any transformation into the pharmaceutical product", type="token")
    public static final String SP_DOSE_FORM = "dose-form";
    public static final TokenClientParam DOSE_FORM = new TokenClientParam("dose-form");
    @SearchParamDefinition(name="identifier", path="ManufacturedItemDefinition.identifier", description="Unique identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");

    public ManufacturedItemDefinition() {
    }

    public ManufacturedItemDefinition(CodeableConcept manufacturedDoseForm) {
        this.setManufacturedDoseForm(manufacturedDoseForm);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ManufacturedItemDefinition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ManufacturedItemDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodeableConcept getManufacturedDoseForm() {
        if (this.manufacturedDoseForm == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ManufacturedItemDefinition.manufacturedDoseForm");
            }
            if (Configuration.doAutoCreate()) {
                this.manufacturedDoseForm = new CodeableConcept();
            }
        }
        return this.manufacturedDoseForm;
    }

    public boolean hasManufacturedDoseForm() {
        return this.manufacturedDoseForm != null && !this.manufacturedDoseForm.isEmpty();
    }

    public ManufacturedItemDefinition setManufacturedDoseForm(CodeableConcept value) {
        this.manufacturedDoseForm = value;
        return this;
    }

    public CodeableConcept getUnitOfPresentation() {
        if (this.unitOfPresentation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ManufacturedItemDefinition.unitOfPresentation");
            }
            if (Configuration.doAutoCreate()) {
                this.unitOfPresentation = new CodeableConcept();
            }
        }
        return this.unitOfPresentation;
    }

    public boolean hasUnitOfPresentation() {
        return this.unitOfPresentation != null && !this.unitOfPresentation.isEmpty();
    }

    public ManufacturedItemDefinition setUnitOfPresentation(CodeableConcept value) {
        this.unitOfPresentation = value;
        return this;
    }

    public List<Reference> getManufacturer() {
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        return this.manufacturer;
    }

    public ManufacturedItemDefinition setManufacturer(List<Reference> theManufacturer) {
        this.manufacturer = theManufacturer;
        return this;
    }

    public boolean hasManufacturer() {
        if (this.manufacturer == null) {
            return false;
        }
        for (Reference item : this.manufacturer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addManufacturer() {
        Reference t = new Reference();
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return t;
    }

    public ManufacturedItemDefinition addManufacturer(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return this;
    }

    public Reference getManufacturerFirstRep() {
        if (this.getManufacturer().isEmpty()) {
            this.addManufacturer();
        }
        return this.getManufacturer().get(0);
    }

    public List<Reference> getIngredient() {
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<Reference>();
        }
        return this.ingredient;
    }

    public ManufacturedItemDefinition setIngredient(List<Reference> theIngredient) {
        this.ingredient = theIngredient;
        return this;
    }

    public boolean hasIngredient() {
        if (this.ingredient == null) {
            return false;
        }
        for (Reference item : this.ingredient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addIngredient() {
        Reference t = new Reference();
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<Reference>();
        }
        this.ingredient.add(t);
        return t;
    }

    public ManufacturedItemDefinition addIngredient(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<Reference>();
        }
        this.ingredient.add(t);
        return this;
    }

    public Reference getIngredientFirstRep() {
        if (this.getIngredient().isEmpty()) {
            this.addIngredient();
        }
        return this.getIngredient().get(0);
    }

    public List<ManufacturedItemDefinitionCharacteristicComponent> getCharacteristic() {
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<ManufacturedItemDefinitionCharacteristicComponent>();
        }
        return this.characteristic;
    }

    public ManufacturedItemDefinition setCharacteristic(List<ManufacturedItemDefinitionCharacteristicComponent> theCharacteristic) {
        this.characteristic = theCharacteristic;
        return this;
    }

    public boolean hasCharacteristic() {
        if (this.characteristic == null) {
            return false;
        }
        for (ManufacturedItemDefinitionCharacteristicComponent item : this.characteristic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ManufacturedItemDefinitionCharacteristicComponent addCharacteristic() {
        ManufacturedItemDefinitionCharacteristicComponent t = new ManufacturedItemDefinitionCharacteristicComponent();
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<ManufacturedItemDefinitionCharacteristicComponent>();
        }
        this.characteristic.add(t);
        return t;
    }

    public ManufacturedItemDefinition addCharacteristic(ManufacturedItemDefinitionCharacteristicComponent t) {
        if (t == null) {
            return this;
        }
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<ManufacturedItemDefinitionCharacteristicComponent>();
        }
        this.characteristic.add(t);
        return this;
    }

    public ManufacturedItemDefinitionCharacteristicComponent getCharacteristicFirstRep() {
        if (this.getCharacteristic().isEmpty()) {
            this.addCharacteristic();
        }
        return this.getCharacteristic().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique identifier.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("manufacturedDoseForm", "CodeableConcept", "Dose form as manufactured and before any transformation into the pharmaceutical product.", 0, 1, this.manufacturedDoseForm));
        children.add(new Property("unitOfPresentation", "CodeableConcept", "The \u201creal world\u201d units in which the quantity of the manufactured item is described.", 0, 1, this.unitOfPresentation));
        children.add(new Property("manufacturer", "Reference(Organization)", "Manufacturer of the item (Note that this should be named \"manufacturer\" but it currently causes technical issues).", 0, Integer.MAX_VALUE, this.manufacturer));
        children.add(new Property("ingredient", "Reference(Ingredient)", "The ingredients that make up this manufactured item.", 0, Integer.MAX_VALUE, this.ingredient));
        children.add(new Property("characteristic", "", "General characteristics of this item.", 0, Integer.MAX_VALUE, this.characteristic));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique identifier.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1451400348: {
                return new Property("manufacturedDoseForm", "CodeableConcept", "Dose form as manufactured and before any transformation into the pharmaceutical product.", 0, 1, this.manufacturedDoseForm);
            }
            case -1427765963: {
                return new Property("unitOfPresentation", "CodeableConcept", "The \u201creal world\u201d units in which the quantity of the manufactured item is described.", 0, 1, this.unitOfPresentation);
            }
            case -1969347631: {
                return new Property("manufacturer", "Reference(Organization)", "Manufacturer of the item (Note that this should be named \"manufacturer\" but it currently causes technical issues).", 0, Integer.MAX_VALUE, this.manufacturer);
            }
            case -206409263: {
                return new Property("ingredient", "Reference(Ingredient)", "The ingredients that make up this manufactured item.", 0, Integer.MAX_VALUE, this.ingredient);
            }
            case 366313883: {
                return new Property("characteristic", "", "General characteristics of this item.", 0, Integer.MAX_VALUE, this.characteristic);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1451400348: {
                Base[] baseArray;
                if (this.manufacturedDoseForm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.manufacturedDoseForm;
                }
                return baseArray;
            }
            case -1427765963: {
                Base[] baseArray;
                if (this.unitOfPresentation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.unitOfPresentation;
                }
                return baseArray;
            }
            case -1969347631: {
                return this.manufacturer == null ? new Base[]{} : this.manufacturer.toArray(new Base[this.manufacturer.size()]);
            }
            case -206409263: {
                return this.ingredient == null ? new Base[]{} : this.ingredient.toArray(new Base[this.ingredient.size()]);
            }
            case 366313883: {
                return this.characteristic == null ? new Base[]{} : this.characteristic.toArray(new Base[this.characteristic.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -1451400348: {
                this.manufacturedDoseForm = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1427765963: {
                this.unitOfPresentation = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1969347631: {
                this.getManufacturer().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -206409263: {
                this.getIngredient().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 366313883: {
                this.getCharacteristic().add((ManufacturedItemDefinitionCharacteristicComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("manufacturedDoseForm")) {
            this.manufacturedDoseForm = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("unitOfPresentation")) {
            this.unitOfPresentation = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("manufacturer")) {
            this.getManufacturer().add(TypeConvertor.castToReference(value));
        } else if (name.equals("ingredient")) {
            this.getIngredient().add(TypeConvertor.castToReference(value));
        } else if (name.equals("characteristic")) {
            this.getCharacteristic().add((ManufacturedItemDefinitionCharacteristicComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1451400348: {
                return this.getManufacturedDoseForm();
            }
            case -1427765963: {
                return this.getUnitOfPresentation();
            }
            case -1969347631: {
                return this.addManufacturer();
            }
            case -206409263: {
                return this.addIngredient();
            }
            case 366313883: {
                return this.addCharacteristic();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1451400348: {
                return new String[]{"CodeableConcept"};
            }
            case -1427765963: {
                return new String[]{"CodeableConcept"};
            }
            case -1969347631: {
                return new String[]{"Reference"};
            }
            case -206409263: {
                return new String[]{"Reference"};
            }
            case 366313883: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("manufacturedDoseForm")) {
            this.manufacturedDoseForm = new CodeableConcept();
            return this.manufacturedDoseForm;
        }
        if (name.equals("unitOfPresentation")) {
            this.unitOfPresentation = new CodeableConcept();
            return this.unitOfPresentation;
        }
        if (name.equals("manufacturer")) {
            return this.addManufacturer();
        }
        if (name.equals("ingredient")) {
            return this.addIngredient();
        }
        if (name.equals("characteristic")) {
            return this.addCharacteristic();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ManufacturedItemDefinition";
    }

    @Override
    public ManufacturedItemDefinition copy() {
        ManufacturedItemDefinition dst = new ManufacturedItemDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ManufacturedItemDefinition dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.manufacturedDoseForm = this.manufacturedDoseForm == null ? null : this.manufacturedDoseForm.copy();
        CodeableConcept codeableConcept = dst.unitOfPresentation = this.unitOfPresentation == null ? null : this.unitOfPresentation.copy();
        if (this.manufacturer != null) {
            dst.manufacturer = new ArrayList<Reference>();
            for (Reference reference : this.manufacturer) {
                dst.manufacturer.add(reference.copy());
            }
        }
        if (this.ingredient != null) {
            dst.ingredient = new ArrayList<Reference>();
            for (Reference reference : this.ingredient) {
                dst.ingredient.add(reference.copy());
            }
        }
        if (this.characteristic != null) {
            dst.characteristic = new ArrayList<ManufacturedItemDefinitionCharacteristicComponent>();
            for (ManufacturedItemDefinitionCharacteristicComponent manufacturedItemDefinitionCharacteristicComponent : this.characteristic) {
                dst.characteristic.add(manufacturedItemDefinitionCharacteristicComponent.copy());
            }
        }
    }

    protected ManufacturedItemDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ManufacturedItemDefinition)) {
            return false;
        }
        ManufacturedItemDefinition o = (ManufacturedItemDefinition)other_;
        return ManufacturedItemDefinition.compareDeep(this.identifier, o.identifier, true) && ManufacturedItemDefinition.compareDeep(this.manufacturedDoseForm, o.manufacturedDoseForm, true) && ManufacturedItemDefinition.compareDeep(this.unitOfPresentation, o.unitOfPresentation, true) && ManufacturedItemDefinition.compareDeep(this.manufacturer, o.manufacturer, true) && ManufacturedItemDefinition.compareDeep(this.ingredient, o.ingredient, true) && ManufacturedItemDefinition.compareDeep(this.characteristic, o.characteristic, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ManufacturedItemDefinition)) {
            return false;
        }
        ManufacturedItemDefinition o = (ManufacturedItemDefinition)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.manufacturedDoseForm, this.unitOfPresentation, this.manufacturer, this.ingredient, this.characteristic});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ManufacturedItemDefinition;
    }

    @Block
    public static class ManufacturedItemDefinitionCharacteristicComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A code expressing the type of characteristic", formalDefinition="A code expressing the type of characteristic.")
        protected CodeableConcept code;
        @Child(name="value", type={Coding.class, Quantity.class, StringType.class, DateType.class, BooleanType.class, Attachment.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A value for the characteristic", formalDefinition="A value for the characteristic.")
        protected DataType value;
        private static final long serialVersionUID = -1950789033L;

        public ManufacturedItemDefinitionCharacteristicComponent() {
        }

        public ManufacturedItemDefinitionCharacteristicComponent(CodeableConcept code) {
            this.setCode(code);
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ManufacturedItemDefinitionCharacteristicComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ManufacturedItemDefinitionCharacteristicComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public Coding getValueCoding() throws FHIRException {
            if (this.value == null) {
                this.value = new Coding();
            }
            if (!(this.value instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Coding)this.value;
        }

        public boolean hasValueCoding() {
            return this != null && this.value instanceof Coding;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public DateType getValueDateType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateType();
            }
            if (!(this.value instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateType)this.value;
        }

        public boolean hasValueDateType() {
            return this != null && this.value instanceof DateType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                this.value = new Attachment();
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ManufacturedItemDefinitionCharacteristicComponent setValue(DataType value) {
            if (!(value == null || value instanceof Coding || value instanceof Quantity || value instanceof StringType || value instanceof DateType || value instanceof BooleanType || value instanceof Attachment)) {
                throw new Error("Not the right type for ManufacturedItemDefinition.characteristic.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "A code expressing the type of characteristic.", 0, 1, this.code));
            children.add(new Property("value[x]", "Coding|Quantity|string|date|boolean|Attachment", "A value for the characteristic.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "A code expressing the type of characteristic.", 0, 1, this.code);
                }
                case -1410166417: {
                    return new Property("value[x]", "Coding|Quantity|string|date|boolean|Attachment", "A value for the characteristic.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "Coding|Quantity|string|date|boolean|Attachment", "A value for the characteristic.", 0, 1, this.value);
                }
                case -1887705029: {
                    return new Property("value[x]", "Coding", "A value for the characteristic.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "A value for the characteristic.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "A value for the characteristic.", 0, 1, this.value);
                }
                case -766192449: {
                    return new Property("value[x]", "date", "A value for the characteristic.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "A value for the characteristic.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "Attachment", "A value for the characteristic.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"Coding", "Quantity", "string", "date", "boolean", "Attachment"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public ManufacturedItemDefinitionCharacteristicComponent copy() {
            ManufacturedItemDefinitionCharacteristicComponent dst = new ManufacturedItemDefinitionCharacteristicComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ManufacturedItemDefinitionCharacteristicComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ManufacturedItemDefinitionCharacteristicComponent)) {
                return false;
            }
            ManufacturedItemDefinitionCharacteristicComponent o = (ManufacturedItemDefinitionCharacteristicComponent)other_;
            return ManufacturedItemDefinitionCharacteristicComponent.compareDeep(this.code, o.code, true) && ManufacturedItemDefinitionCharacteristicComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ManufacturedItemDefinitionCharacteristicComponent)) {
                return false;
            }
            ManufacturedItemDefinitionCharacteristicComponent o = (ManufacturedItemDefinitionCharacteristicComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.value});
        }

        @Override
        public String fhirType() {
            return "ManufacturedItemDefinition.characteristic";
        }
    }
}

